/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MaterielEdit;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;
import kd.mmc.mds.common.plandata.MDSHistoryDataHelper;
import kd.mmc.mds.common.plandata.PlanDataFieldsSetter;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.common.util.FastPhotoUtils;
import kd.mmc.mds.common.util.MdsLoadOfferingUtil;
import kd.mmc.mds.common.util.PlanDataToFcDataTranUtil;

public class FCPlanDataColumnentryPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
EntryGridBindDataListener,
BeforeF7SelectListener {
    private static String CO_QTY = "qty";
    private static String CO_RECEIVE = "receive";
    private static int CO_RECEIVECOUNT = 4;
    private static String CO_DATEENTITY = "dateentity";
    private static String CO_MDS_PLANDATA = "mds_plandata";
    private static String CO_ENTRYENTITY = "entryentity";
    private static String CO_FIELDKEY = "fieldkey";
    private static String CO_TARGETDATE = "targetdate";
    private static String CO_SEQ = "seq";
    private static String CO_DELIVERYCOLUMN = "deliverycolumn";
    private static String CO_FCVRNNUM = "fcvrnnum";
    private static String CO_CYTYPE = "cytype";
    private static String CO_PERIODS = "periods";
    private static String CO_PLANDATACALENDAR = "mds_plandatacalendar";
    private static String CO_ADDCOLUMN = "addcolumn";
    private static String CO_DELCOLUMN = "delcolumn";
    private static String CO_NEWCOLUMN = "newcolumn";
    private static DBRoute pur = new DBRoute("pur");
    private static String[] qtycolumns = new String[]{"qty150", "qty149", "qty148", "qty147", "qty146", "qty145", "qty144", "qty143", "qty142", "qty141", "qty140", "qty139", "qty138", "qty137", "qty136", "qty135", "qty134", "qty133", "qty132", "qty131", "qty130", "qty129", "qty128", "qty127", "qty126", "qty125", "qty124", "qty123", "qty122", "qty121", "qty120", "qty119", "qty118", "qty117", "qty116", "qty115", "qty114", "qty113", "qty112", "qty111", "qty110", "qty109", "qty108", "qty107", "qty106", "qty105", "qty104", "qty103", "qty102", "qty101", "qty100", "qty99", "qty98", "qty97", "qty96", "qty95", "qty94", "qty93", "qty92", "qty91", "qty90", "qty89", "qty88", "qty87", "qty86", "qty85", "qty84", "qty83", "qty82", "qty81", "qty80", "qty79", "qty78", "qty77", "qty76", "qty75", "qty74", "qty73", "qty72", "qty71", "qty70", "qty69", "qty68", "qty67", "qty66", "qty65", "qty64", "qty63", "qty62", "qty61", "qty60", "qty59", "qty58", "qty57", "qty56", "qty55", "qty54", "qty53", "qty52", "qty51", "qty50", "qty49", "qty48", "qty47", "qty46", "qty45", "qty44", "qty43", "qty42", "qty41", "qty40", "qty39", "qty38", "qty37", "qty36", "qty35", "qty34", "qty33", "qty32", "qty31", "qty30", "qty29", "qty28", "qty27", "qty26", "qty25", "qty24", "qty23", "qty22", "qty21", "qty20", "qty19", "qty18", "qty17", "qty16", "qty15", "qty14", "qty13", "qty12", "qty11", "qty10", "qty9", "qty8", "qty7", "qty6", "qty5", "qty4", "qty3", "qty2", "qty1"};
    private static Log log = LogFactory.getLog(FCPlanDataColumnentryPlugin.class);
    private static ThreadLocal<Map<String, Object>> nodeSpanListThreadLocal = new ThreadLocal();
    private static ThreadLocal<Map<String, List<BigDecimal>>> nodeHisDataThreadLocal = new ThreadLocal();
    private static ThreadLocal<List<EntityItem<?>>> itemSpanListThreadLocal = new ThreadLocal();

    public void registerListener(EventObject e) {
        BasedataEdit planscope;
        super.registerListener(e);
        BasedataEdit fcvrnnum = (BasedataEdit)this.getView().getControl("fcvrnnum");
        fcvrnnum.addAfterF7SelectListener((AfterF7SelectListener)this);
        EntryGrid entry = (EntryGrid)this.getControl(CO_ENTRYENTITY);
        entry.addDataBindListener((EntryGridBindDataListener)this);
        BasedataEdit configId = (BasedataEdit)this.getControl("configid");
        if (configId != null) {
            configId.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((planscope = (BasedataEdit)this.getControl("planscope")) != null) {
            planscope.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject bos_org;
        Object org = this.getModel().getValue("org");
        long orgid = 0L;
        String orgNumber = "";
        log.info("FCPlanDataColumnentryPlugin afterImportData org:" + org);
        if (org == null) {
            log.info("FCPlanDataColumnentryPlugin:org==null");
            log.info("RequestContext.get().getOrgId()):'" + RequestContext.get().getOrgId() + "'");
            orgid = RequestContext.get().getOrgId();
        } else if (org instanceof DynamicObject) {
            orgid = ((DynamicObject)org).getLong("id");
        }
        if (orgid > 0L && (bos_org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org")) != null) {
            orgNumber = bos_org.getString("number");
        }
        String fromid = ((BillView)this.getView()).getEntityId();
        int checkPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgid, (String)"mds", (String)fromid, (String)"47150e89000000ac");
        if (checkPermission != 1) {
            e.setCancel(true);
            ArrayList<String> msg = new ArrayList<String>(16);
            String errMsg = ResManager.loadKDString((String)"\u5728\u7ec4\u7ec7\u7f16\u7801='%s'\u65f6\uff0c\u65e0\u8be5\u5355\u636e\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u5207\u6362\u5230\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"FCPlanDataColumnentryPlugin_5", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
            msg.add(String.format(errMsg, orgNumber));
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), msg);
        }
        this.setDefaultPlanScope();
        FCPlanDataHelper.setMaterialDefaultConfig((IFormView)this.getView());
    }

    private void setDefaultPlanScope() {
        String fromid = ((BillView)this.getView()).getEntityId();
        if ("mds_mdsplandata".equals(fromid) || "mds_mdsplandatamulti".equals(fromid) || "mds_dpsplandata".equals(fromid)) {
            DynamicObjectCollection detailentry = this.getModel().getEntryEntity(CO_ENTRYENTITY);
            int m = 0;
            for (DynamicObject dyn : detailentry) {
                DynamicObject prodorg;
                DynamicObject planscope = dyn.getDynamicObject("planscope");
                if (planscope == null && (prodorg = dyn.getDynamicObject("prodorg")) != null) {
                    Long defaultPlanScopeId = FCPlanDataHelper.getDefaultPlanScopeId((long)dyn.getLong("prodorg.id"));
                    this.getModel().setValue("planscope", (Object)defaultPlanScopeId, m);
                }
                ++m;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData data;
        int rowIndex;
        String fromid = ((BillView)this.getView()).getFormId();
        IDataEntityProperty prop = e.getProperty();
        if ("material".equals(prop.getName())) {
            QFilter[] qfilters = this.buildCacheMaterialFilter();
            this.buildCacheMaterial(qfilters);
            ChangeData data2 = e.getChangeSet()[0];
            DynamicObject newobj = (DynamicObject)data2.getNewValue();
            if (newobj != null) {
                this.setMaterialLevel(newobj, data2);
            } else {
                this.clearDaynamicObjectEntryData(data2.getDataEntity());
            }
            this.getView().updateView(CO_ENTRYENTITY, data2.getRowIndex());
            this.getModel().setValue("configid", null, data2.getRowIndex());
            this.getModel().setValue("planscope", null, data2.getRowIndex());
        } else if ("prodorg".equals(prop.getName())) {
            ChangeData data3 = e.getChangeSet()[0];
            this.getModel().setValue("planscope", null, data3.getRowIndex());
        } else if (prop.getName().indexOf("qty") >= 0) {
            ChangeData data4 = e.getChangeSet()[0];
            this.getModel().setValue("summary", (Object)this.countEntrySummary(data4.getRowIndex()), data4.getRowIndex());
        } else if ("mds_mdsplandata".equals(fromid) && !"fcvrnnum".equals(prop.getName()) && (rowIndex = (data = e.getChangeSet()[0]).getRowIndex()) > -1) {
            this.getModel().setValue("entrymodifier", (Object)RequestContext.get().getUserId(), data.getRowIndex());
            this.getModel().setValue("editdate", (Object)new Date());
        }
    }

    private void clearDaynamicObjectEntryData(DynamicObject entryObj) {
        int n;
        entryObj.set("baseunit", null);
        entryObj.set("prodorg", null);
        entryObj.set("plangp", null);
        entryObj.set("remark", null);
        entryObj.set("summary", null);
        for (n = 0; n < 5; ++n) {
            entryObj.set("level" + n, null);
        }
        for (n = 1; n <= 150; ++n) {
            entryObj.set("qty" + n, null);
        }
    }

    private BigDecimal countEntrySummary(int index) {
        BigDecimal summary = BigDecimal.ZERO;
        for (String item : qtycolumns) {
            if (item.indexOf("qty") < 0) continue;
            BigDecimal value = (BigDecimal)this.getModel().getValue(item, index);
            summary = summary.add(value);
        }
        return summary;
    }

    private BigDecimal countDynamicSummary(DynamicObject obj) {
        BigDecimal summary = BigDecimal.ZERO;
        for (String item : qtycolumns) {
            if (item.indexOf("qty") < 0) continue;
            BigDecimal value = obj.getBigDecimal(item);
            summary = summary.add(value);
        }
        return summary;
    }

    private Map<String, Object> queryMaterialInfo(Long mid) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        HashMap<Long, DynamicObject> materialMap = new HashMap<Long, DynamicObject>();
        HashMap<String, DynamicObject> materialNumMap = new HashMap<String, DynamicObject>();
        QFilter qfilter = new QFilter("id", "=", (Object)mid);
        DynamicObject dynobj = QueryServiceHelper.queryOne((String)"bd_material", (String)"id,number,baseunit.id,baseunit.name,offeringcode.number,offeringcode.group,offeringcode.name", (QFilter[])new QFilter[]{qfilter});
        String number = dynobj.getString("number");
        Long materialid = dynobj.getLong("id");
        Long baseunitid = dynobj.getLong("baseunit.id");
        String baseunitname = dynobj.getString("baseunit.name");
        DynamicObject tmpObj = ORM.create().newDynamicObject("bd_measureunits");
        tmpObj.set("id", (Object)baseunitid);
        tmpObj.set("name", (Object)baseunitname);
        materialNumMap.put(number, dynobj);
        materialMap.put(materialid, tmpObj);
        valueMap.put("material", materialMap);
        valueMap.put("materialnumber", materialNumMap);
        return valueMap;
    }

    private void setMaterialLevel(DynamicObject material, ChangeData data) {
        this.clearDaynamicObjectEntryData(data.getDataEntity());
        Map<String, Object> mapObj = this.queryMaterialInfo(material.getLong("id"));
        DynamicObject baseunit = (DynamicObject)((Map)mapObj.get("material")).get(material.getPkValue());
        this.getModel().setValue("baseunit", (Object)baseunit, data.getRowIndex());
        String number = material.getString("number");
        HashMap<String, DynamicObject> materialMap = new HashMap<String, DynamicObject>();
        DynamicObject materialrs = (DynamicObject)((Map)mapObj.get("materialnumber")).get(number);
        materialMap.put(number, materialrs);
        Map flmap = MdsLoadOfferingUtil.loadMaterialRelProductGroup(materialMap);
        Stack stack = (Stack)flmap.get(materialrs.getString("offeringcode.group"));
        if (stack != null) {
            int rowsIn = 0;
            int index = stack.size() - 1;
            while (stack != null && stack.size() > rowsIn) {
                String level = (String)stack.get(rowsIn);
                log.info("\u9700\u6c42\u8ba1\u5212\u67e5\u8be2Officing\u5c42\u7ea7" + level);
                if (index < 5) {
                    this.getModel().setValue("level" + index, (Object)level, data.getRowIndex());
                }
                ++rowsIn;
                --index;
            }
        }
    }

    private void setEntryLevel(DynamicObject entry) {
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            return;
        }
        String number = material.getString("number");
        HashMap<String, DynamicObject> materialMap = new HashMap<String, DynamicObject>();
        DynamicObject materialrs = (DynamicObject)((Map)nodeSpanListThreadLocal.get().get("materialnumber")).get(number);
        materialMap.put(number, materialrs);
        Map flmap = MdsLoadOfferingUtil.loadMaterialRelProductGroup(materialMap);
        Stack stack = (Stack)flmap.get(materialrs.getString("offeringcode.group"));
        if (stack != null) {
            int rowsIn = 0;
            int index = stack.size() - 1;
            while (stack != null && stack.size() > rowsIn) {
                String level = (String)stack.get(rowsIn);
                log.info("\u9700\u6c42\u8ba1\u5212\u67e5\u8be2Officing\u5c42\u7ea7" + level);
                if (index < 5) {
                    entry.set("level" + index, (Object)level);
                }
                ++rowsIn;
                --index;
            }
        }
    }

    private void setSummaryQty(DynamicObject entry) {
        entry.set("summary", (Object)this.countDynamicSummary(entry));
    }

    private void buildCacheMaterial(QFilter[] qfilter) {
        try (TXHandle h1 = TX.requiresNew();){
            log.info("mds_plandata\u5f00\u59cb\u7f13\u5b58 nodeSpanListThreadLocal....");
            if (nodeSpanListThreadLocal.get() == null) {
                DynamicObjectCollection colls = QueryServiceHelper.query((String)"bd_material", (String)"id,number,baseunit.id,baseunit.name,offeringcode.number,offeringcode.group,offeringcode.name", (QFilter[])qfilter);
                HashMap valueMap = new HashMap();
                HashMap<Long, DynamicObject> materialMap = new HashMap<Long, DynamicObject>();
                HashMap<String, DynamicObject> materialNumMap = new HashMap<String, DynamicObject>();
                for (DynamicObject obj : colls) {
                    String number = obj.getString("number");
                    Long materialid = obj.getLong("id");
                    Long baseunitid = obj.getLong("baseunit.id");
                    String baseunitname = obj.getString("baseunit.name");
                    DynamicObject tmpObj = this.createobj();
                    tmpObj.set("id", (Object)baseunitid);
                    tmpObj.set("name", (Object)baseunitname);
                    materialNumMap.put(number, obj);
                    materialMap.put(materialid, tmpObj);
                }
                valueMap.put("material", materialMap);
                valueMap.put("materialnumber", materialNumMap);
                nodeSpanListThreadLocal.set(valueMap);
            }
            log.info("mds_plandata\u5f00\u59cb\u7f13\u5b58 nodeSpanListThreadLocal....");
        }
    }

    private DynamicObject createobj() {
        return ORM.create().newDynamicObject("bd_measureunits");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QFilter[] buildCacheMaterialFilter() {
        HashSet<Long> idSet = new HashSet<Long>();
        log.info("mds_plandata\u5f00\u59cb\u7f13\u5b58 nodeSpanListThreadLocal  entryentity\u52a0\u8f7d....");
        if (this.getModel().getDataEntity() != null && this.getModel().getDataEntity().getPkValue() != null) {
            Long pk = this.getModel().getDataEntity().getLong("id");
            String materialidsql = "select fmaterialid from t_mds_fcdatatsentry where fid = ?";
            String fromid = ((BillView)this.getView()).getEntityId();
            if ("mds_mdsplandatahistory".equals(fromid)) {
                materialidsql = "select fmaterialid from t_mds_fcdatatsentry_kz where fid = ?";
            }
            DataSet ds = DB.queryDataSet((String)"queryFcData", (DBRoute)pur, (String)materialidsql, (Object[])new Object[]{pk});
            Iterator iteratorfc = ds.iterator();
            try {
                while (iteratorfc.hasNext()) {
                    Row row = (Row)iteratorfc.next();
                    Long materialid = row.getLong("fmaterialid");
                    idSet.add(materialid);
                }
            }
            finally {
                ds.close();
            }
        }
        log.info("mds_plandata\u5f00\u59cb\u7f13\u5b58 nodeSpanListThreadLocal  entryentity\u52a0\u8f7d\u5b8c\u6bd5  \u957f\u5ea6 ...." + idSet.size());
        if (idSet.size() == 0) {
            idSet.add(new Long(999999999L));
        }
        QFilter filter = new QFilter("id", "in", idSet);
        QFilter[] qfilters = new QFilter[]{filter};
        return qfilters;
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operatekey = source.getOperateKey();
        if (CO_ADDCOLUMN.equals(operatekey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(CO_PLANDATACALENDAR);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), CO_NEWCOLUMN);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else if (CO_DELCOLUMN.equals(operatekey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(CO_PLANDATACALENDAR);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), CO_DELCOLUMN);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)"modify", (CharSequence)operatekey)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            String billstatus = dynamicObject.getString("billstatus");
            if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"C")) {
                dynamicObject.set("billstatus", (Object)"A");
                SaveServiceHelper.update((DynamicObject)dynamicObject);
                this.getView().getFormShowParameter().getCustomParams().remove("fcvrnopen");
                this.getView().invokeOperation("refresh");
            }
            PlanDataToFcDataTranUtil.tranPlanDataToFcDataStatus((String)dynamicObject.getDynamicObject("fcvrnnum").getString("number"));
        } else if (StringUtils.equals((CharSequence)"submit", (CharSequence)operatekey)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            String billstatus = dynamicObject.getString("billstatus");
            if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"C")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify"});
            }
        } else if (StringUtils.equals((CharSequence)"fastphotoset", (CharSequence)operatekey)) {
            FormShowParameter form = new FormShowParameter();
            form.setFormId("mds_fastphotoset");
            form.getOpenStyle().setShowType(ShowType.Modal);
            form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fastphotoset"));
            BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
            form.setCustomParam("entityNumber", (Object)bsp.getFormId());
            DynamicObject fcvrnnum = (DynamicObject)this.getModel().getValue("fcvrnnum");
            if (fcvrnnum != null) {
                form.setCustomParam("fcvrnnumId", (Object)((Long)fcvrnnum.getPkValue()));
            }
            form.setCustomParam("openType", (Object)"edit");
            this.getView().showForm(form);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closed) {
        String actionid = closed.getActionId();
        if ("fastphotoset".equals(actionid)) {
            Map csettings = (Map)closed.getReturnData();
            if (csettings == null || csettings.get("op") == null) {
                return;
            }
            Integer action = (Integer)csettings.get("op");
            switch (action) {
                case 2: {
                    break;
                }
                case 1: {
                    this.runfp(csettings, this.getView());
                    break;
                }
            }
        } else {
            String operate;
            Map csettings;
            String cycle = null;
            String dayOfWeek = "Mon";
            DynamicObject cvrnnum = this.getModel().getDataEntity().getDynamicObject("fcvrnnum");
            if (cvrnnum == null) {
                return;
            }
            cycle = cvrnnum.getString("cytype");
            dayOfWeek = cvrnnum.getString("dayofweek");
            if (CO_NEWCOLUMN.equals(actionid)) {
                String operate2;
                Map csettings2 = (Map)closed.getReturnData();
                if (csettings2 != null && (operate2 = (String)csettings2.get("op")).equals("ok")) {
                    Date start = (Date)csettings2.get("starttime");
                    Date end = (Date)csettings2.get("endtime");
                    List<Date> betweendates = DateUtil.getBetweenDates((Date)start, (Date)end);
                    betweendates = this.getDetailDate(betweendates, cycle, dayOfWeek);
                    this.distributionLocation(betweendates, false, false);
                }
            } else if (CO_DELCOLUMN.equals(actionid) && (csettings = (Map)closed.getReturnData()) != null && (operate = (String)csettings.get("op")).equals("ok")) {
                Date start = (Date)csettings.get("starttime");
                Date end = (Date)csettings.get("endtime");
                List betweendates = DateUtil.getBetweenDates((Date)start, (Date)end);
                this.distributionLocation(betweendates, true, false);
            }
        }
    }

    private String runfp(Map<String, Object> csetting, IFormView fv) {
        String rt = (String)csetting.get("runningtype");
        if ("0".equals(rt)) {
            FastPhotoUtils.runFastPhotoImediatly(csetting);
        } else {
            String jobId = FastPhotoUtils.createJob(csetting);
            String scheduleId = FastPhotoUtils.createPlan((String)jobId, csetting);
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.enableSchedule(scheduleId);
        }
        if (fv != null) {
            fv.showSuccessNotification(ResManager.loadKDString((String)"\u5feb\u7167\u4efb\u52a1\u5df2\u6210\u529f\u5206\u53d1\u3002", (String)"FCPlanDataColumnentryPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        }
        return null;
    }

    public void createNewData(BizDataEventArgs e) {
        this.hideAllQtyColumn();
    }

    private List<EntityItem<?>> getMetaCategoryField() {
        try {
            String entityId = MetadataDao.getIdByNumber((String)CO_MDS_PLANDATA, (MetaCategory)MetaCategory.Entity);
            EntityMetadata xEntityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            List items = xEntityMetadata.getItems();
            return items;
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u5bf9\u8c61\u7684\u5143\u6570\u636e\u5df2\u5931\u6548\u6216\u5f03\u7528\uff0c\u7cfb\u7edf\u65e0\u6cd5\u8bfb\u53d6\u8be5\u5143\u6570\u636e\u3002", (String)"FCPlanDataColumnentryPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        }
    }

    private void hideAllQtyColumn() {
        List<EntityItem<?>> items = this.getMetaCategoryField();
        for (EntityItem<?> item : items) {
            String key = item.getKey();
            if (key.contains(CO_QTY)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{key});
            }
            if (!key.contains(CO_RECEIVE)) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
        }
    }

    public void afterF7Select(AfterF7SelectEvent var1) {
        DynamicObject cvrnnum;
        if (var1.getSource() instanceof MaterielEdit) {
            // empty if block
        }
        if ((cvrnnum = this.getModel().getDataEntity().getDynamicObject(CO_FCVRNNUM)) == null) {
            return;
        }
        this.getModel().getDataEntity().set("billno", (Object)cvrnnum.getString("number"));
        int ordinal = this.getModel().getProperty("billno").getOrdinal();
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
        QFilter filter = new QFilter("fcvrnnum", "=", cvrnnum.getPkValue());
        QFilter[] filters = new QFilter[]{filter};
        this.getModel().deleteEntryData("dateentity");
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"mds_plandata", (String)"id", (QFilter[])filters);
        if (colls.size() > 0) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)colls.get(0)).getLong("id"), (String)"mds_plandata");
            if (this.getView() instanceof BillView) {
                ((BillView)this.getView()).load(obj.getPkValue());
                this.getView().updateView(CO_ENTRYENTITY);
                return;
            }
        } else {
            this.refreshHeadAndEntry();
        }
        List<Date> dates = this.getDateByVersionInfo();
        this.distributionLocation(dates, false, true);
        this.showHisData();
    }

    private void refreshHeadAndEntry() {
        this.getModel().deleteEntryData(CO_ENTRYENTITY);
    }

    private void delDistributionLocation(List<Date> dates) {
        DynamicObjectCollection colls = this.getModel().getEntryEntity(CO_DATEENTITY);
        DynamicObjectCollection collfields = this.getModel().getEntryEntity(CO_ENTRYENTITY);
        ArrayList<Integer> resultInt = new ArrayList<Integer>();
        ArrayList<String> delfield = new ArrayList<String>();
        for (Date date : dates) {
            for (int n = 0; n < colls.size(); ++n) {
                Date targetdate = ((DynamicObject)colls.get(n)).getDate(CO_TARGETDATE);
                String fieldkey = ((DynamicObject)colls.get(n)).getString(CO_FIELDKEY);
                if (date.compareTo(targetdate) != 0) continue;
                resultInt.add(n);
                delfield.add(fieldkey);
            }
        }
        for (String key : delfield) {
            for (DynamicObject obj : collfields) {
                obj.set(key, (Object)BigDecimal.ZERO);
                this.setSummaryQty(obj);
            }
        }
        int[] resultTmp = resultInt.stream().mapToInt(Integer::valueOf).toArray();
        this.getModel().deleteEntryRows(CO_DATEENTITY, resultTmp);
        this.getView().updateView(CO_ENTRYENTITY);
    }

    private void updateDistributionLocation(List<Date> dates) {
        List<EntityItem<?>> items = this.getMetaCategoryField();
        ArrayList<String> metaQtyField = new ArrayList<String>();
        HashMap<Date, Object[]> dateEntityMap = new HashMap<Date, Object[]>();
        ArrayList<Date> resultDate = new ArrayList<Date>();
        for (EntityItem<?> entityItem : items) {
            String key = entityItem.getKey();
            if (!key.contains(CO_QTY)) continue;
            metaQtyField.add(key);
        }
        DynamicObjectCollection colls = this.getModel().getEntryEntity(CO_DATEENTITY);
        for (DynamicObject obj : colls) {
            String fieldkey = obj.getString(CO_FIELDKEY);
            Date targetdate = obj.getDate(CO_TARGETDATE);
            Integer seq = obj.getInt(CO_SEQ);
            Object[] value = new Object[]{fieldkey, seq};
            dateEntityMap.put(targetdate, value);
            metaQtyField.remove(fieldkey);
        }
        Collections.sort(dates, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                return o1.compareTo(o2);
            }
        });
        for (Date date : dates) {
            if (dateEntityMap.containsKey(date)) continue;
            resultDate.add(date);
        }
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        int row = 0;
        for (Date date : resultDate) {
            String fieldkey = (String)metaQtyField.get(0);
            tableValueSetter.set(CO_FIELDKEY, (Object)fieldkey, row);
            tableValueSetter.set(CO_TARGETDATE, (Object)date, row);
            tableValueSetter.set(CO_DELIVERYCOLUMN, (Object)Boolean.FALSE, row);
            metaQtyField.remove(fieldkey);
            ++row;
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(CO_DATEENTITY, tableValueSetter);
    }

    private void createReceiveLocation() {
        Date starttime;
        Date endtime;
        Calendar startcal;
        String cycle = this.getModel().getDataEntity().getDynamicObject("fcvrnnum").getString("cytype");
        int preday = 0;
        List<Date> listdate = new ArrayList();
        if ("0".equals(cycle)) {
            preday = CO_RECEIVECOUNT * -1;
            startcal = Calendar.getInstance();
            startcal.add(6, -1);
            endtime = startcal.getTime();
            startcal.add(6, preday);
            starttime = startcal.getTime();
            listdate = DateUtil.getBetweenDates((Date)starttime, (Date)endtime);
        } else if ("1".equals(cycle)) {
            preday = (CO_RECEIVECOUNT + 1) * -7;
            startcal = Calendar.getInstance();
            endtime = startcal.getTime();
            startcal.add(6, preday);
            starttime = startcal.getTime();
            List historyDate = DateUtil.getBetweenWeeks((Date)starttime, (Date)endtime);
            for (Map map : historyDate) {
                Date startdate = (Date)map.get("startDate");
                Date currWeekMondy = DateUtil.findMondayCurrentWeek((Date)endtime);
                if (currWeekMondy.compareTo(startdate) == 0) continue;
                listdate.add(startdate);
            }
        }
        List<EntityItem<?>> items = this.getMetaCategoryField();
        ArrayList<String> metaQtyField = new ArrayList<String>();
        HashMap<Date, Object[]> dateEntityMap = new HashMap<Date, Object[]>();
        ArrayList<Date> resultDate = new ArrayList<Date>();
        for (EntityItem<?> entityItem : items) {
            String key = entityItem.getKey();
            if (!key.contains(CO_RECEIVE)) continue;
            metaQtyField.add(key);
        }
        DynamicObjectCollection colls = this.getModel().getEntryEntity(CO_DATEENTITY);
        for (DynamicObject obj : colls) {
            String fieldkey = obj.getString(CO_FIELDKEY);
            Date targetdate = obj.getDate(CO_TARGETDATE);
            Integer seq = obj.getInt(CO_SEQ);
            Object[] value = new Object[]{fieldkey, seq};
            dateEntityMap.put(targetdate, value);
            metaQtyField.remove(fieldkey);
        }
        Collections.sort(listdate, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                return o1.compareTo(o2);
            }
        });
        for (Date date : listdate) {
            if (dateEntityMap.containsKey(date)) continue;
            resultDate.add(date);
        }
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        int row = 0;
        for (Date date : resultDate) {
            if (metaQtyField.size() <= 0) continue;
            String fieldkey = (String)metaQtyField.get(0);
            tableValueSetter.set(CO_FIELDKEY, (Object)fieldkey, row);
            tableValueSetter.set(CO_TARGETDATE, (Object)date, row);
            tableValueSetter.set(CO_DELIVERYCOLUMN, (Object)Boolean.TRUE, row);
            metaQtyField.remove(fieldkey);
            ++row;
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(CO_DATEENTITY, tableValueSetter);
    }

    private void distributionLocation(List<Date> dates, boolean isDel, boolean isAuto) {
        if (isDel) {
            this.delDistributionLocation(dates);
        } else {
            this.updateDistributionLocation(dates);
            if (isAuto) {
                this.createReceiveLocation();
            }
        }
        ((AbstractFormDataModel)this.getModel()).updateCache();
        this.sortDateCompartTable();
        this.showHisData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int checkPermission;
        String billstatus;
        String fromid = ((BillView)this.getView()).getEntityId();
        FormOperate operate = (FormOperate)args.getSource();
        if (("mds_mdsplandata".equals(fromid) || "mds_dpsplandata".equals(fromid)) && ("save".equals(operate.getOperateKey()) || "submit".equals(operate.getOperateKey()))) {
            DynamicObject version = (DynamicObject)this.getModel().getValue("fcvrnnum");
            if (version == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7248\u672c\u53f7\u201d\u4e3a\u7a7a\uff0c\u8bf7\u7ed9\u5176\u8d4b\u503c\u3002", (String)"FCPlanDataColumnentryPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection detailentry = this.getModel().getEntryEntity(CO_ENTRYENTITY);
            if (detailentry == null) {
                return;
            }
            Iterator detailentryIts = detailentry.iterator();
            int m = 0;
            while (detailentryIts.hasNext()) {
                DynamicObject dyn = (DynamicObject)detailentryIts.next();
                if (version.get("defaultorg") != null && dyn.get("prodorg") == null) {
                    this.getModel().setValue("prodorg", (Object)version.getLong("defaultorg.id"), m);
                } else if (dyn.get("prodorg") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u6c42\u660e\u7ec6\u4e2d\u5b58\u5728\u201c\u4f9b\u5e94\u7ec4\u7ec7\u201d\u4e3a\u7a7a\uff0c\u8bf7\u7ed9\u5176\u8d4b\u503c\u3002", (String)"FCPlanDataColumnentryPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ++m;
            }
            this.setDefaultPlanScope();
        } else if ("modify".equals(operate.getOperateKey()) && StringUtils.equals((CharSequence)(billstatus = String.valueOf(this.getModel().getValue("billstatus"))), (CharSequence)"B")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u3002", (String)"FCPlanDataColumnentryPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if ("submit".equals(operate.getOperateKey())) {
            this.afterSubmit(args);
        }
        if ("save".equals(operate.getOperateKey())) {
            FCPlanDataHelper.setMaterialDefaultConfig((IFormView)this.getView());
        }
        if (("save".equals(operate.getOperateKey()) || "submit".equals(operate.getOperateKey())) && (checkPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)"mds", (String)fromid, (String)"47150e89000000ac")) != 1) {
            args.setCancel(true);
            String orgNumber = "";
            DynamicObject bos_org = BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getOrgId(), (String)"bos_org");
            if (bos_org != null) {
                orgNumber = bos_org.getString("number");
            }
            String errMsg = ResManager.loadKDString((String)"\u5728\u7ec4\u7ec7\u7f16\u7801='%s'\u65f6\uff0c\u65e0\u8be5\u5355\u636e\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u5207\u6362\u5230\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"FCPlanDataColumnentryPlugin_5", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(errMsg, orgNumber));
        }
    }

    private void afterSubmit(BeforeDoOperationEventArgs args) {
        if (this.getModel().getDataChanged()) {
            OperationResult re = this.getView().invokeOperation("save");
            if (!re.isSuccess()) {
                args.setCancel(true);
            } else {
                args.setCancel(true);
                OperateOption saveOption = OperateOption.create();
                saveOption.setVariableValue("ignoreValidation", String.valueOf(true));
                this.getView().invokeOperation("submit", saveOption);
            }
        }
    }

    private void sortDateCompartTable() {
        this.hideAllQtyColumn();
        DynamicObjectCollection colls = this.getModel().getEntryEntity(CO_DATEENTITY);
        Collections.sort(colls, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject obj1, DynamicObject obj2) {
                Date o1 = obj1.getDate("targetdate");
                Date o2 = obj2.getDate("targetdate");
                return o1.compareTo(o2);
            }
        });
        ArrayList<GridConfigurationRow> coltype = new ArrayList<GridConfigurationRow>();
        coltype.addAll(PlanDataToFcDataTranUtil.getFixColumn((String)this.getView().getFormShowParameter().getFormId()));
        for (DynamicObject obj : colls) {
            GridConfigurationRow gridrow = new GridConfigurationRow();
            gridrow.setFieldKey(obj.getString("fieldkey"));
            gridrow.setFieldName(new LocaleString(obj.getString("targetdate")));
            coltype.add(gridrow);
        }
        GridConfigRenderUtils.renderGridConfig((IFormView)this.getView(), (String)CO_ENTRYENTITY, coltype);
        for (DynamicObject obj : colls) {
            String fieldkey = obj.getString(CO_FIELDKEY);
            Date targetdate = obj.getDate(CO_TARGETDATE);
            QtyEdit qty = (QtyEdit)this.getControl(fieldkey);
            SimpleDateFormat dFormat = new SimpleDateFormat("yyyy-MM-dd");
            String formatDateStr = dFormat.format(targetdate);
            if (fieldkey.indexOf("receive") >= 0) {
                qty.setCaption(new LocaleString(formatDateStr));
                this.getView().setVisible(Boolean.FALSE, new String[]{fieldkey});
                continue;
            }
            qty.setCaption(new LocaleString(formatDateStr));
            this.getView().setVisible(Boolean.TRUE, new String[]{fieldkey});
        }
    }

    private List<Date> getDateByVersionInfo() {
        DynamicObject cvrnnum = this.getModel().getDataEntity().getDynamicObject(CO_FCVRNNUM);
        String cycletype = cvrnnum.getString(CO_CYTYPE);
        String dayofweek = cvrnnum.getString("dayofweek");
        int period = cvrnnum.getInt(CO_PERIODS) == 0 ? 1 : cvrnnum.getInt(CO_PERIODS);
        List workdates = DateUtil.getWorkDates((String)cycletype, (int)period);
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        String startForm = sim.format(Calendar.getInstance().getTime());
        Date start = null;
        try {
            start = sim.parse(startForm);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, new ErrorCode("FCPlanDataColumnentryPlugin", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)), new Object[0]);
        }
        switch (cycletype) {
            case "0": {
                return DateUtil.findCustomStart((Date)start, (List)workdates, (int)period);
            }
            case "1": {
                if (!DateUtil.currentIsMonday((Date)start)) {
                    start = DateUtil.findMondayCurrentWeek((Date)start);
                }
                List mondays = DateUtil.findMonday((Date)start, (List)workdates, (int)period);
                return DateUtil.getMondaysOffset((List)mondays, (String)dayofweek);
            }
            case "3": {
                return DateUtil.getMonthOffset((List)workdates, (String)dayofweek);
            }
        }
        return null;
    }

    private List<Date> getDetailDate(List<Date> workdates, String cycletype, String dayOfWeek) {
        switch (cycletype) {
            case "0": {
                return workdates;
            }
            case "1": {
                List mondaysOffset = DateUtil.getMondaysOffset(workdates, (String)dayOfWeek);
                return workdates.stream().filter(mondaysOffset::contains).collect(Collectors.toList());
            }
            case "3": {
                List monthOffset = DateUtil.getMonthOffset(workdates, (String)dayOfWeek);
                return workdates.stream().filter(monthOffset::contains).collect(Collectors.toList());
            }
        }
        return null;
    }

    public void beforeBindData(EventObject e) {
        this.hideAllQtyColumn();
    }

    public void afterBindData(EventObject e) {
        Object vrn = this.getView().getFormShowParameter().getCustomParam("fcvrnnum");
        if (vrn != null) {
            this.getModel().setValue("fcvrnnum", vrn);
        }
        this.sortDateCompartTable();
        QFilter[] qfilters = this.buildCacheMaterialFilter();
        this.buildCacheMaterial(qfilters);
        DynamicObjectCollection colls = this.getModel().getEntryEntity(CO_ENTRYENTITY);
        for (DynamicObject obj : colls) {
            this.setEntryLevel(obj);
        }
        for (DynamicObject obj : colls) {
            this.setSummaryQty(obj);
        }
        String billstatus = this.getModel().getDataEntity().getString("billstatus");
        if ("A".equals(billstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify"});
        }
        this.showHisData();
        this.getModel().setDataChanged(false);
        this.getView().updateView(CO_ENTRYENTITY);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            String scene = (String)this.getView().getFormShowParameter().getCustomParam("SCENE");
            Container container = (Container)this.getView().getControl("tabpageap");
            if ("AUDITFLOW".equals(scene)) {
                container.getView().setEnable(Boolean.FALSE, new String[]{"newentry"});
                container.getView().setEnable(Boolean.FALSE, new String[]{"delentry"});
            } else {
                container.getView().setVisible(Boolean.FALSE, new String[]{"newentry"});
                container.getView().setVisible(Boolean.FALSE, new String[]{"delentry"});
                container.getView().setVisible(Boolean.FALSE, new String[]{"delcolumn"});
                container.getView().setVisible(Boolean.FALSE, new String[]{"newcolumn"});
            }
        }
    }

    private void setMaterialHisData(DynamicObject entry) {
        DynamicObject dy = this.getModel().getDataEntity(true);
        String vertype = dy.getString("fcvrnnum.vertype");
        List uniqueKeyList = PlanDataFieldsSetter.getHisDataKey((String)vertype);
        String id = MDSHistoryDataHelper.buildHistoryKey((List)uniqueKeyList, (DynamicObject)entry);
        Map<String, List<BigDecimal>> valueMap = nodeHisDataThreadLocal.get();
        List<BigDecimal> valList = null;
        if (valueMap != null) {
            valList = valueMap.get(id);
        }
        if (valList == null || valList.isEmpty()) {
            for (int i = 9; i > 0; --i) {
                entry.set("hisqty" + i, (Object)0.0);
            }
            return;
        }
        Iterator<BigDecimal> it = valList.iterator();
        int index = 9;
        while (it.hasNext()) {
            BigDecimal v = it.next();
            if (v != null && index > 0) {
                entry.set("hisqty" + index, (Object)v);
            }
            --index;
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.sortDateCompartTable();
        this.showHisData();
    }

    private void buildCacheHisData(Object vrnPk, String cytype, String dayofweek) {
        try (TXHandle h1 = TX.requiresNew();){
            log.info("mds_plandata\u5f00\u59cb\u7f13\u5b58 nodeHisDataThreadLocal....");
            if (nodeHisDataThreadLocal.get() == null) {
                Map valueMap = MDSHistoryDataHelper.getHistoryDataByVersionId((Object)vrnPk, (String)cytype, (String)dayofweek);
                nodeHisDataThreadLocal.set(valueMap);
            }
            log.info("mds_plandata\u5f00\u59cb\u7f13\u5b58 nodeHisDataThreadLocal....");
        }
    }

    private void showHisData() {
        String fromid = ((BillView)this.getView()).getFormId();
        if ("mds_forecastplandata".equals(fromid)) {
            DynamicObject dy = this.getModel().getDataEntity(true);
            String cytype = dy.getString("fcvrnnum.cytype");
            Long vrnPk = dy.getLong("fcvrnnum.id");
            String dayofweek = dy.getString("fcvrnnum.dayofweek");
            DynamicObjectCollection colls = this.getModel().getEntryEntity(CO_ENTRYENTITY);
            if (vrnPk != null) {
                this.buildCacheHisData(vrnPk, cytype, dayofweek);
            }
            for (DynamicObject obj : colls) {
                this.setMaterialHisData(obj);
            }
            List hisDateList = MDSHistoryDataHelper.getHistoryDateByCytype((String)cytype, (Date)new Date(), (String)dayofweek);
            Iterator it = hisDateList.iterator();
            int index = hisDateList.size();
            StringBuilder fieldKeySb = new StringBuilder();
            while (it.hasNext()) {
                fieldKeySb.setLength(0);
                fieldKeySb.append("hisqty").append(index);
                Date targetdate = (Date)it.next();
                String fieldkey = fieldKeySb.toString();
                QtyEdit qty = (QtyEdit)this.getControl(fieldkey);
                SimpleDateFormat dFormat = new SimpleDateFormat("yyyy-MM-dd");
                String formatDateStr = dFormat.format(targetdate);
                qty.setCaption(new LocaleString(formatDateStr));
                this.getView().setVisible(Boolean.TRUE, new String[]{fieldkey});
                --index;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        if ("configid".equals(name)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(CO_ENTRYENTITY);
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
            if (material != null) {
                QFilter filter = new QFilter("material", "=", material.getPkValue());
                showParameter.getListFilterParameter().setFilter(filter);
            }
        } else if ("planscope".equals(name)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(CO_ENTRYENTITY);
            DynamicObject prodorg = (DynamicObject)this.getModel().getValue("prodorg", rowIndex);
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
            QFilter filter = new QFilter("1", "=", (Object)2);
            if (prodorg != null && material != null) {
                List planScopeIds = FCPlanDataHelper.getPlanScopeIds((long)prodorg.getLong("id"), (long)material.getLong("id"));
                filter = new QFilter("id", "in", (Object)planScopeIds);
            }
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }
}

