/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.bill.BillView;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;

public class FCPlanDataProductChangePlugin
extends AbstractFormPlugin {
    private String CO_ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        if ("material".equals(prop.getName())) {
            ChangeData data = e.getChangeSet()[0];
            DynamicObject newobj = (DynamicObject)data.getNewValue();
            DynamicObject obj = data.getDataEntity();
            if (newobj != null) {
                Object[] values = FCPlanDataHelper.getMaterialChangeInfo((Long)obj.getLong("id"));
                this.overrideProductChangeField(obj, values);
            }
            this.getView().updateView(this.CO_ENTRYENTITY, data.getRowIndex());
            this.getModel().setValue("configid", null, data.getRowIndex());
            this.getModel().setValue("planscope", null, data.getRowIndex());
        }
    }

    public void beforeBindData(EventObject e) {
        this.showProductChangeData();
    }

    private void showProductChangeData() {
        String fromid = ((BillView)this.getView()).getFormId();
        if ("mds_forecastplandata".equals(fromid) || "mds_plandataadjust".equals(fromid)) {
            DynamicObject dy = this.getModel().getDataEntity(true);
            DynamicObjectCollection colls = dy.getDynamicObjectCollection(this.CO_ENTRYENTITY);
            List materialIds = colls.stream().map(o -> o.getLong("material.id")).distinct().collect(Collectors.toList());
            Map materialChangeInfo = FCPlanDataHelper.getMaterialChangeInfo(materialIds);
            for (DynamicObject obj : colls) {
                Long materialid = obj.getLong("material.id");
                Object[] values = (Object[])materialChangeInfo.get(materialid);
                if (values == null) continue;
                this.overrideProductChangeField(obj, values);
            }
        }
    }

    private void overrideProductChangeField(DynamicObject obj, Object[] values) {
        DynamicObjectCollection oldmaterialColl = obj.getDynamicObjectCollection("oldmaterial");
        oldmaterialColl.clear();
        List oldmaterialList = (List)values[1];
        if (oldmaterialList != null) {
            for (DynamicObject oldmaterial : oldmaterialList) {
                oldmaterialColl.addNew().set("fbasedataid", (Object)oldmaterial);
            }
        }
        DynamicObjectCollection newmaterialColl = obj.getDynamicObjectCollection("newmaterial");
        newmaterialColl.clear();
        List newmaterialList = (List)values[3];
        if (newmaterialList != null) {
            for (DynamicObject newmaterial : newmaterialList) {
                newmaterialColl.addNew().set("fbasedataid", (Object)newmaterial);
            }
        }
        obj.set("prereleasedate", values[0]);
        obj.set("oldmaterial", (Object)oldmaterialColl);
        obj.set("predelistdate", values[2]);
        obj.set("newmaterial", (Object)newmaterialColl);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult() == null) {
            return;
        }
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("addfilter".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(this.CO_ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u52fe\u9009\u4e00\u6761\u8bb0\u5f55\u3002", (String)"FCPlanDataProductChangePlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Object> materialIds = new ArrayList<Long>(16);
            ArrayList<Long> relMaterialIds = new ArrayList<Long>(16);
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", selectRows[i]);
                DynamicObjectCollection oldmaterialColl = (DynamicObjectCollection)this.getModel().getValue("oldmaterial", selectRows[i]);
                if (material != null) {
                    materialIds.add(material.getLong("id"));
                }
                if (oldmaterialColl == null) continue;
                for (DynamicObject oldmaterial : oldmaterialColl) {
                    relMaterialIds.add(oldmaterial.getLong("fbasedataid.id"));
                }
            }
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(this.CO_ENTRYENTITY);
            if (!entryentity.stream().anyMatch(o -> relMaterialIds.contains(o.getLong("material.id")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u7f16\u7801\u5bf9\u5e94\u7684\u8001\u54c1\u65e0\u9884\u6d4b\u3002", (String)"FCPlanDataProductChangePlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return;
            }
            materialIds.addAll(relMaterialIds);
            materialIds = materialIds.stream().distinct().collect(Collectors.toList());
            EntryQueryParam entryQueryParam = new EntryQueryParam();
            ArrayList<EntryFilterItemInfo> filterItems = new ArrayList<EntryFilterItemInfo>();
            filterItems.add(new EntryFilterItemInfo("material.id", materialIds.stream().map(o -> o + "").collect(Collectors.toList()), "17"));
            entryQueryParam.setFilterItems(filterItems);
            this.getModel().filterEntry(this.CO_ENTRYENTITY, entryQueryParam);
            this.getView().updateView(this.CO_ENTRYENTITY);
        } else if ("removefilter".equals(operateKey)) {
            EntryQueryParam entryQueryParam = new EntryQueryParam();
            ArrayList filterItems = new ArrayList();
            entryQueryParam.setFilterItems(filterItems);
            this.getModel().filterEntry(this.CO_ENTRYENTITY, entryQueryParam);
            this.getView().updateView(this.CO_ENTRYENTITY);
        }
    }
}

