/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.common.util.ForecastCalUtil;

public class ForecastCalEditPlugin
extends AbstractBillPlugIn
implements ProgresssListener {
    public static final String CO_FCALPLAN = "fcalplan";
    public static final String CO_PREDVERSION = "predversion";
    public static final String CO_BILLNO = "billno";
    public static final String CO_NUMBER = "number";
    public static final String MDS_FORECASTCAL = "mds_forecastcal";
    public static final String MDS_FORECASTCALSET = "mds_forecastcalset";
    public static final String MDS_FORECASTCALPLAN = "mds_forecastcalplan";
    public static final String CO_RUNNINGTYPE = "runningtype";
    public static final String CO_PREDTIME = "predtime";
    public static final String CO_LOSEDATE = "losedate";
    public static final String CO_REPEATTYPE = "repeattype";
    public static final String CO_REPEAT = "repeat";
    public static final String CO_DAYSOFWEEK = "daysofweek";
    public static final String CO_DAYSOFMON = "daysofmon";
    public static final String OP = "op";
    public static final String OPCALCULATESETTING = "calculatesetting";
    public static final String OPCALCULATING = "calculating";
    public static final String OPTERMINATION = "tblstop";
    public static final String RMONTH = "1";
    public static final String RTDELAY = "1";
    public static final String RTIMD = "0";
    public static final int RUNNING = 1;
    public static final String RWEEK = "0";
    public static final int SAVE = 0;
    public static final int CANCEL = 2;
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("forecastcalnumber");
    private static final Long zeroLong = 0L;
    private static final int stepCount = 4;
    private static final int MaxCount = 20;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
        Toolbar tb = (Toolbar)this.getView().getControl("tbmain");
        tb.addItemClickListener((ItemClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(CO_FCALPLAN);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail);
        }
    }

    public void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        event.setCancel(true);
        this.showPlanForm();
    }

    private void showPlanForm() {
        DynamicObject fcalplan = (DynamicObject)this.getModel().getValue(CO_FCALPLAN);
        if (fcalplan != null) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(MDS_FORECASTCALPLAN);
            showParameter.setPkId(fcalplan.getPkValue());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject fcalplan;
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (CO_FCALPLAN.equals(propertyName) && (fcalplan = (DynamicObject)newValue) != null) {
            this.getModel().setValue(CO_PREDVERSION, fcalplan.get(CO_PREDVERSION));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DefaultEntityOperate operate;
        String operatekey;
        if (args.getSource() instanceof DefaultEntityOperate && OPCALCULATING.equals(operatekey = (operate = (DefaultEntityOperate)args.getSource()).getOperateKey())) {
            long id = (Long)this.getModel().getValue("id");
            if (id == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u8fd0\u7b97\u3002", (String)"ForecastCalEditPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject destobj = this.getModel().getDataEntity();
            DynamicObject scheme = destobj.getDynamicObject(CO_FCALPLAN);
            if (scheme == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u6d4b\u8ba1\u7b97\u65b9\u6848\u3002", (String)"ForecastCalEditPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject createorg = destobj.getDynamicObject("createorg");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"ForecastCalEditPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean createLock = ForecastCalUtil.createLock((String)MDS_FORECASTCALPLAN, (String)"modify", (String)String.valueOf(scheme.getPkValue()));
            if (!createLock) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u9884\u6d4b\u8ba1\u7b97\u65b9\u6848\u6b63\u5728\u88ab\u5176\u4ed6\u9884\u6d4b\u8fd0\u7b97\u4f7f\u7528\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ForecastCalEditPlugin_12", (String)"mmc-mds-formplugin", (Object[])new Object[0]), scheme.getString(CO_BILLNO)));
                args.setCancel(true);
                return;
            }
            String enable = this.getModel().getDataEntity().getString("calstatus");
            if (!"".equals(enable) && !"A".equals(enable)) {
                ORM orm = ORM.create();
                DynamicObject targetobj = orm.newDynamicObject(MDS_FORECASTCAL);
                targetobj.set(CO_FCALPLAN, destobj.get(CO_FCALPLAN));
                targetobj.set(CO_PREDVERSION, scheme.get(CO_PREDVERSION));
                targetobj.set("createorg", destobj.get("createorg"));
                targetobj.set(CO_NUMBER, (Object)this.getUnRepeatNumber(targetobj));
                targetobj.set("calculatepro", (Object)0);
                targetobj.set("creator", (Object)RequestContext.get().getCurrUserId());
                targetobj.set("createtime", (Object)Calendar.getInstance().getTime());
                targetobj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                targetobj.set("modifytime", (Object)Calendar.getInstance().getTime());
                this.getModel().createNewData((Object)targetobj);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{targetobj});
            } else {
                DynamicObject obj = this.getModel().getDataEntity();
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().getDataEntity().set(CO_PREDTIME, (Object)-1);
        long createorg = RequestContext.get().getOrgId();
        this.getModel().setValue("createorg", (Object)createorg);
        this.getModel().setValue("useorg", (Object)createorg);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        String operatekey = args.getOperateKey();
        if (OPCALCULATING.equals(operatekey)) {
            progressBar.setPercent(0);
            progressBar.start();
            this.getPageCache().put("count", "0");
            Toolbar tbar = (Toolbar)this.getView().getControl("tbmain");
            tbar.itemClick("refresh", "refresh");
        } else if (OPCALCULATESETTING.equals(operatekey)) {
            this.runSet();
        } else if ("suspend".equals(operatekey)) {
            this.termination();
        }
    }

    public synchronized String getUnRepeatNumber(DynamicObject targetobj) {
        String entityNum = MDS_FORECASTCAL;
        DynamicObject dataInfo = targetobj;
        Long orgId = RequestContext.get().getOrgId();
        String newNum = CodeRuleServiceHelper.getNumber((String)entityNum, (DynamicObject)dataInfo, null);
        while (this.getCacheString(newNum) != null) {
            newNum = CodeRuleServiceHelper.readNumber((String)entityNum, (DynamicObject)dataInfo, (String)String.valueOf(orgId));
        }
        cache.put(newNum, (Object)newNum);
        return newNum;
    }

    private String getCacheString(String newNum) {
        return (String)cache.get(newNum);
    }

    private void runSet() {
        DynamicObject obj = this.getModel().getDataEntity();
        if (obj.getPkValue() == null || obj.getLong("id") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u8fd0\u7b97\u65b9\u6848\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ForecastCalEditPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject forecastcal = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)MDS_FORECASTCAL);
        this.showForm((IFormPlugin)this, this.getView(), ForecastCalUtil.getSetParamsByScheme((DynamicObject)forecastcal, (String)"1"));
    }

    public void showForm(IFormPlugin plugin, IFormView view, Map<String, Object> params) {
        FormShowParameter form = new FormShowParameter();
        form.setFormId(MDS_FORECASTCALSET);
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCloseCallBack(new CloseCallBack(plugin, "closedcallback"));
        form.setCustomParams(params);
        view.showForm(form);
    }

    private void termination() {
        DynamicObject obj = this.getModel().getDataEntity();
        if (obj.getPkValue() == null || obj.getLong("id") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u8fd0\u7b97\u65b9\u6848\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ForecastCalEditPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] objs = new DynamicObject[]{obj};
        if (ForecastCalUtil.isEmpty((Object[])objs)) {
            return;
        }
        ArrayList<Map<String, String>> operations = new ArrayList<Map<String, String>>(10);
        Map<String, String> tip = this.disableSingleJob(obj);
        if (tip != null) {
            operations.add(tip);
        }
        ForecastCalUtil.showStopTip((IFormView)this.getView(), operations, (DynamicObject[])objs);
    }

    private Map<String, String> disableSingleJob(DynamicObject dynamicObject) {
        String pkValue;
        boolean createLock;
        if (dynamicObject == null) {
            return null;
        }
        String billstatus = dynamicObject.getString("status");
        String calcstatus = dynamicObject.getString("calstatus");
        String number = dynamicObject.getString(CO_NUMBER);
        HashMap<String, String> dytip = new HashMap<String, String>(1);
        if (dynamicObject.getPkValue() == null || dynamicObject.getLong("id") == 0L) {
            dytip.put("", ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u8fd0\u7b97\u65b9\u6848\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ForecastCalEditPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        }
        if (!(createLock = ForecastCalUtil.createLock((String)MDS_FORECASTCALPLAN, (String)OPTERMINATION, (String)(pkValue = dynamicObject.getPkValue().toString())))) {
            dytip.put(number, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ForecastCalEditPlugin_5", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return dytip;
        }
        if (!ForecastCalUtil.Billstatus.PLAN.getCode().equals(billstatus)) {
            dytip.put(number, ResManager.loadKDString((String)"\u975e\u8ba1\u5212\u72b6\u6001\u4e0d\u80fd\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"ForecastCalEditPlugin_6", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCALPLAN, (String)OPTERMINATION, (String)pkValue);
            return dytip;
        }
        if (ForecastCalUtil.CalcStatus.STOP.getCode().equals(calcstatus)) {
            dytip.put(number, ResManager.loadKDString((String)"\u8ba1\u7b97\u72b6\u6001\u4e3a\u7ec8\u6b62\u65f6\u4e0d\u80fd\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"ForecastCalEditPlugin_7", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCALPLAN, (String)OPTERMINATION, (String)pkValue);
            return dytip;
        }
        if (ForecastCalUtil.CalcStatus.ERROR.getCode().equals(calcstatus)) {
            dytip.put(number, ResManager.loadKDString((String)"\u8ba1\u7b97\u72b6\u6001\u4e3a\u9519\u8bef\u65f6\u4e0d\u80fd\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"ForecastCalEditPlugin_8", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCALPLAN, (String)OPTERMINATION, (String)pkValue);
            return dytip;
        }
        dynamicObject.set("calstatus", (Object)ForecastCalUtil.CalcStatus.STOP.getCode());
        SaveServiceHelper.update((DynamicObject)dynamicObject);
        ForecastCalUtil.releaseLock((String)MDS_FORECASTCALPLAN, (String)OPTERMINATION, (String)pkValue);
        this.getView().updateView();
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closed) {
        Map csettings = (Map)closed.getReturnData();
        String pkValue = this.getView().getModel().getDataEntity().getPkValue().toString();
        if (csettings == null) {
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCALPLAN, (String)OPTERMINATION, (String)pkValue);
            return;
        }
        Integer action = (Integer)csettings.get(OP);
        switch (action) {
            case 2: {
                break;
            }
            case 0: {
                this.save(csettings);
                break;
            }
            case 1: {
                this.save(csettings);
                this.run(null);
                break;
            }
        }
        ForecastCalUtil.releaseLock((String)MDS_FORECASTCALPLAN, (String)OPTERMINATION, (String)pkValue);
    }

    private void save(Map<String, Object> csetting) {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dynamicObject : dynamicObjects = new DynamicObject[]{this.getModel().getDataEntity(true)}) {
            dynamicObject.set(CO_RUNNINGTYPE, csetting.get(CO_RUNNINGTYPE));
            dynamicObject.set(CO_PREDTIME, csetting.get(CO_PREDTIME));
            dynamicObject.set(CO_LOSEDATE, csetting.get(CO_LOSEDATE));
            dynamicObject.set(CO_REPEATTYPE, csetting.get(CO_REPEATTYPE));
            dynamicObject.set(CO_REPEAT, csetting.get(CO_REPEAT));
            if (ForecastCalUtil.isWeek(csetting)) {
                dynamicObject.set(CO_DAYSOFWEEK, (Object)ForecastCalUtil.createExp((String)CO_DAYSOFWEEK, csetting));
                dynamicObject.set(CO_DAYSOFMON, (Object)"");
            } else {
                dynamicObject.set(CO_DAYSOFMON, (Object)ForecastCalUtil.createExp((String)CO_DAYSOFMON, csetting));
                dynamicObject.set(CO_DAYSOFWEEK, (Object)"");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private void run(Map<String, Object> csettings) {
        Object[] selData = new DynamicObject[]{this.getModel().getDataEntity()};
        if (ForecastCalUtil.isEmpty((Object[])selData)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ForecastCalEditPlugin_9", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean saved = false;
        if (csettings == null) {
            saved = true;
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        for (Object t : selData) {
            String runSgl = this.runSgl(saved, (DynamicObject)t, csettings);
            if ("".equals(runSgl)) continue;
            errors.put(t.getString(CO_NUMBER), runSgl);
        }
        ForecastCalUtil.showCalcErr((IFormView)this.getView(), errors, (int)selData.length);
    }

    private String runSgl(boolean saved, DynamicObject task, Map<String, Object> csettings) {
        if (!saved) {
            this.save(csettings);
        }
        String pkValue = task.getPkValue().toString();
        String rt = task.getString(CO_RUNNINGTYPE);
        if (rt == null || "".equals(rt)) {
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCALPLAN, (String)OPCALCULATING, (String)pkValue);
            return ResManager.loadKDString((String)"\u8ba1\u7b97\u8bf7\u6c42\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u5148\u8fdb\u884c\u8fd0\u7b97\u8bbe\u7f6e\u3002", (String)"ForecastCalEditPlugin_10", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        }
        Date losedate = task.getDate(CO_LOSEDATE);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        if (losedate != null && DateUtil.comp((Date)c.getTime(), (Date)losedate)) {
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCALPLAN, (String)OPCALCULATING, (String)pkValue);
            return ResManager.loadKDString((String)"\u8ba1\u7b97\u8bf7\u6c42\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ForecastCalEditPlugin_11", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        }
        JobDispatcherProxy jdp = new JobDispatcherProxy();
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        ScheduleDao sdao = ExecutorService.getInstance().getObjectFactory().getScheduleDao();
        TaskDao tdao = ExecutorService.getInstance().getObjectFactory().getTaskDao();
        String planId = task.getString("planid");
        if (!planId.isEmpty()) {
            tdao.deleteTaskByScheduleId(planId);
            sdao.disableSchedule(planId);
            jdp.deletePlan(planId);
        }
        JobInfo jobInfo = ForecastCalUtil.initJobInfo((DynamicObject)task, (int)0, (String)CO_NUMBER);
        jdp.deleteJob(jobInfo.getId());
        String jobId = jdp.createJob(jobInfo);
        task.set("jobid", (Object)jobId);
        PlanInfo planInfo = ForecastCalUtil.initPlanInfo((String)jobId, (DynamicObject)task);
        planId = jdp.createPlan(planInfo);
        boolean isSuccess = sdao.existed(planId);
        while (!isSuccess) {
            planId = jdp.createPlan(planInfo);
            isSuccess = sdao.existed(planId);
        }
        task.set("planid", (Object)planId);
        task.set("status", (Object)ForecastCalUtil.Billstatus.PLAN.getCode());
        if (!"0".equals(rt)) {
            task.set("calstatus", (Object)ForecastCalUtil.CalcStatus.WAIT.getCode());
        } else {
            task.set("calstatus", (Object)ForecastCalUtil.CalcStatus.RUNNING.getCode());
        }
        if ("0".equals(rt)) {
            JobClient.dispatch((JobInfo)jobInfo);
        } else {
            scheduleManager.enableSchedule(planId);
            scheduleManager.enableJob(jobId);
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{task});
        ForecastCalUtil.releaseLock((String)MDS_FORECASTCALPLAN, (String)OPCALCULATING, (String)pkValue);
        return "";
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.sortEntryByResultSeq();
    }

    public void onProgress(ProgressEvent arg0) {
        int precent = this.sortEntryByResultSeq();
        arg0.setProgress(precent);
    }

    private int sortEntryByResultSeq() {
        DynamicObject tcount;
        Object id = this.getModel().getValue("id");
        if (id == null || zeroLong.compareTo((Long)id) == 0) {
            return 0;
        }
        QFilter qfilter = new QFilter("id", "=", this.getModel().getValue("id"));
        String orderSeq = "execlogeentry.entrystepseq asc";
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)MDS_FORECASTCAL, (String)"startdate, enddate, summin, status, calculatepro, execlogeentry.*", (QFilter[])new QFilter[]{qfilter}, (String)orderSeq);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        int count = dyn.size();
        if (count == 1 && (tcount = (DynamicObject)dyn.get(0)).getDate("startdate") == null) {
            count = 0;
        }
        ArrayList list = new ArrayList(16);
        Iterator lits = dyn.iterator();
        while (lits.hasNext()) {
            list.add(lits.next());
        }
        Collections.sort(list, new MdsEntrySeqComparotor());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("execlogeentry");
        model.endInit();
        this.getView().updateView("execlogeentry");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (DynamicObject it : list) {
            vs.addField("seq", new Object[0]);
            vs.addField("entryresult", new Object[0]);
            vs.addField("entrystepseq", new Object[0]);
            vs.addField("entrystepname", new Object[0]);
            vs.addField("entryoperatmin", new Object[0]);
            vs.addField("entrydetailmsg", new Object[0]);
            vs.addRow(new Object[]{it.get("execlogeentry.seq"), it.get("execlogeentry.entryresult"), it.get("execlogeentry.entrystepseq"), it.get("execlogeentry.entrystepname"), it.get("execlogeentry.entryoperatmin"), it.get("execlogeentry.entrydetailmsg")});
        }
        model.batchCreateNewEntryRow("execlogeentry", vs);
        model.setValue("startdate", (Object)((DynamicObject)dyn.get(0)).getString("startdate"));
        model.setValue("enddate", (Object)((DynamicObject)dyn.get(0)).getString("enddate"));
        model.setValue("summin", (Object)((DynamicObject)dyn.get(0)).getString("summin"));
        model.endInit();
        this.getView().updateView("execlogeentry");
        this.getView().updateView("startdate");
        this.getView().updateView("enddate");
        this.getView().updateView("summin");
        double tmpcount = (double)count / 4.0;
        BigDecimal doublePre = BigDecimal.valueOf(tmpcount);
        doublePre = doublePre.multiply(new BigDecimal(100));
        Long pre = doublePre.setScale(0, 1).longValue();
        this.getModel().setValue("calculatepro", (Object)pre);
        progressBar.setPercent(pre.intValue());
        this.getView().updateView("progressBar");
        Integer tmpCount = Integer.valueOf(this.getPageCache().get("count") == null ? "0" : this.getPageCache().get("count"));
        for (int n = 0; n < dyn.size(); ++n) {
            String status = ((DynamicObject)dyn.get(n)).getString("status");
            if (!"C".equals(status) && !"D".equals(status) && !"E".equals(status) || pre != 100L && tmpCount < 20) continue;
            progressBar.stop();
            this.getView().setEnable(Boolean.TRUE, new String[]{OPCALCULATING});
            break;
        }
        Integer n = tmpCount;
        Integer n2 = tmpCount = Integer.valueOf(tmpCount + 1);
        this.getPageCache().put("count", String.valueOf(tmpCount));
        this.getModel().setDataChanged(false);
        return pre.intValue();
    }

    public static class MdsEntrySeqComparotor
    implements Comparator<DynamicObject> {
        @Override
        public int compare(DynamicObject dys, DynamicObject dyn) {
            String dysSeq = dys.getString("execlogeentry.entrystepseq");
            String dynSeq = dyn.getString("execlogeentry.entrystepseq");
            if (!dysSeq.contains("-") && !dynSeq.contains("-")) {
                int dysi = Integer.parseInt(dysSeq);
                int dyni = Integer.parseInt(dynSeq);
                return dysi - dyni;
            }
            if (dysSeq.contains("-") && !dynSeq.contains("-")) {
                int dysi = Integer.parseInt(dysSeq.split("-")[0]);
                int dyni = Integer.parseInt(dynSeq);
                return dysi - dyni;
            }
            if (!dysSeq.contains("-") && dynSeq.contains("-")) {
                int dyni = Integer.parseInt(dynSeq.split("-")[0]);
                int dysi = Integer.parseInt(dysSeq);
                return dysi - dyni;
            }
            return dysSeq.compareTo(dynSeq);
        }
    }
}

