/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.common.util.ForecastCalUtil;

public class ForecastCalListPlugin
extends AbstractListPlugin {
    public static final String CO_TOOLBAR = "toolbarap";
    public static final String CO_DAYSOFMON = "daysofmon";
    public static final String CO_DAYSOFWEEK = "daysofweek";
    public static final String CO_JOBID = "jobid";
    public static final String CO_LOSEDATE = "losedate";
    public static final String CO_NUMBER = "number";
    public static final String CO_BILLNO = "billno";
    public static final String CO_PLANID = "planid";
    public static final String CO_PREDTIME = "predtime";
    public static final String CO_REPEAT = "repeat";
    public static final String CO_REPEATTYPE = "repeattype";
    public static final String CO_RUNNINGTYPE = "runningtype";
    public static final String OPCALCULATING = "calculating";
    public static final String OPTERMINATION = "tblstop";
    public static final String OPCALCULATESETTING = "calculatesetting";
    public static final String MDS_FORECASTCAL = "mds_forecastcal";
    public static final String MDS_FORECASTCALSET = "mds_forecastcalset";
    public static final String OP = "op";
    public static final String RTIMD = "0";
    public static final int RUNNING = 1;
    public static final int SAVE = 0;
    public static final int CANCEL = 2;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{CO_TOOLBAR});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operatekey = afterDoOperationEventArgs.getOperateKey();
        if ("calculatlistsing".equals(operatekey)) {
            this.getView().updateView();
        } else if (OPCALCULATESETTING.equals(operatekey)) {
            this.setCalculatesetting();
        } else if ("suspend".equals(operatekey)) {
            ScheduleDao scheduleDao = ExecutorService.getInstance().getObjectFactory().getScheduleDao();
            TaskDao tdao = ExecutorService.getInstance().getObjectFactory().getTaskDao();
            this.termination(scheduleDao, tdao);
        }
    }

    private void setCalculatesetting() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection srows = list.getSelectedRows();
        if (srows == null || srows.isEmpty()) {
            return;
        }
        if (srows.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"ForecastCalListPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        Object pk = srows.get(0).getPrimaryKeyValue();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)MDS_FORECASTCAL);
        boolean runlock = ForecastCalUtil.createLock((String)MDS_FORECASTCAL, (String)OPCALCULATESETTING, (String)pk.toString());
        if (runlock) {
            this.showForm((IFormPlugin)this, this.getView(), ForecastCalUtil.getSetParamsByScheme((DynamicObject)obj, (String)"1"));
        }
    }

    public void showForm(IFormPlugin plugin, IFormView view, Map<String, Object> params) {
        FormShowParameter form = new FormShowParameter();
        form.setFormId(MDS_FORECASTCALSET);
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCloseCallBack(new CloseCallBack(plugin, "closedcallback"));
        form.setCustomParams(params);
        view.showForm(form);
    }

    private void termination(ScheduleDao scheduleDao, TaskDao tdao) {
        this.disableJobAndPlan(ForecastCalListPlugin.selectedData(this.getView()), scheduleDao, tdao);
    }

    private void disableJobAndPlan(DynamicObject[] query, ScheduleDao scheduleDao, TaskDao tdao) {
        if (ForecastCalUtil.isEmpty((Object[])query)) {
            return;
        }
        ArrayList<Map<String, String>> operations = new ArrayList<Map<String, String>>(10);
        for (DynamicObject o : query) {
            Map<String, String> tip = this.disableSingleJob(o, scheduleDao, tdao);
            if (tip == null) continue;
            operations.add(tip);
        }
        ForecastCalUtil.showStopTip((IFormView)this.getView(), operations, (DynamicObject[])query);
    }

    private Map<String, String> disableSingleJob(DynamicObject sig, ScheduleDao sdao, TaskDao tdao) {
        if (sig == null) {
            return null;
        }
        String billstatus = sig.getString("status");
        String calcstatus = sig.getString("calstatus");
        String number = sig.getString(CO_NUMBER);
        HashMap<String, String> sigtip = new HashMap<String, String>(1);
        String pkValue = sig.getPkValue().toString();
        boolean createLock = ForecastCalUtil.createLock((String)MDS_FORECASTCAL, (String)OPTERMINATION, (String)pkValue);
        if (!createLock) {
            sigtip.put(number, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ForecastCalListPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return sigtip;
        }
        if (!ForecastCalUtil.Billstatus.PLAN.getCode().equals(billstatus)) {
            sigtip.put(number, ResManager.loadKDString((String)"\u975e\u8ba1\u5212\u72b6\u6001\u4e0d\u80fd\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"ForecastCalListPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCAL, (String)OPTERMINATION, (String)pkValue);
            return sigtip;
        }
        if (ForecastCalUtil.CalcStatus.STOP.getCode().equals(calcstatus)) {
            sigtip.put(number, ResManager.loadKDString((String)"\u8ba1\u7b97\u72b6\u6001\u4e3a\u7ec8\u6b62\u65f6\u4e0d\u80fd\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"ForecastCalListPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCAL, (String)OPTERMINATION, (String)pkValue);
            return sigtip;
        }
        if (ForecastCalUtil.CalcStatus.ERROR.getCode().equals(calcstatus)) {
            sigtip.put(number, ResManager.loadKDString((String)"\u8ba1\u7b97\u72b6\u6001\u4e3a\u9519\u8bef\u65f6\u4e0d\u80fd\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"ForecastCalListPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCAL, (String)OPTERMINATION, (String)pkValue);
            return sigtip;
        }
        sig.set("calstatus", (Object)ForecastCalUtil.CalcStatus.STOP.getCode());
        SaveServiceHelper.update((DynamicObject)sig);
        ForecastCalUtil.releaseLock((String)MDS_FORECASTCAL, (String)OPTERMINATION, (String)pkValue);
        BillList list = (BillList)this.getView().getControl("billlistap");
        list.refresh();
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closed) {
        Map csettings = (Map)closed.getReturnData();
        BillList list = (BillList)this.getView().getControl("billlistap");
        if (csettings == null || csettings.isEmpty()) {
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCAL, (String)OPCALCULATESETTING, (String)list.getSelectedRows().get(0).getPrimaryKeyValue().toString());
            return;
        }
        Integer action = (Integer)csettings.get(OP);
        switch (action) {
            case 2: {
                break;
            }
            case 0: {
                this.save(csettings);
                break;
            }
            case 1: {
                this.save(csettings);
                this.run(null);
                break;
            }
        }
        ForecastCalUtil.releaseLock((String)MDS_FORECASTCAL, (String)OPCALCULATESETTING, (String)list.getSelectedRows().get(0).getPrimaryKeyValue().toString());
        this.getView().updateView();
    }

    private void save(Map<String, Object> csetting) {
        DynamicObject[] selectedData;
        for (DynamicObject o : selectedData = ForecastCalListPlugin.selectedData(this.getView())) {
            o.set(CO_RUNNINGTYPE, csetting.get(CO_RUNNINGTYPE));
            o.set(CO_PREDTIME, csetting.get(CO_PREDTIME));
            o.set(CO_LOSEDATE, csetting.get(CO_LOSEDATE));
            o.set(CO_REPEATTYPE, csetting.get(CO_REPEATTYPE));
            o.set(CO_REPEAT, csetting.get(CO_REPEAT));
            if (ForecastCalUtil.isWeek(csetting)) {
                o.set(CO_DAYSOFWEEK, (Object)ForecastCalUtil.createExp((String)CO_DAYSOFWEEK, csetting));
                o.set(CO_DAYSOFMON, (Object)"");
            } else {
                o.set(CO_DAYSOFMON, (Object)ForecastCalUtil.createExp((String)CO_DAYSOFMON, csetting));
                o.set(CO_DAYSOFWEEK, (Object)"");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{o});
        }
    }

    private void run(Map<String, Object> csettings) {
        Object[] selData = ForecastCalListPlugin.selectedData(this.getView());
        if (ForecastCalUtil.isEmpty((Object[])selData)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ForecastCalListPlugin_5", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean saved = false;
        if (csettings == null) {
            saved = true;
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        for (Object t : selData) {
            String runSgl = this.runSgl(saved, (DynamicObject)t, csettings);
            if ("".equals(runSgl)) continue;
            errors.put(t.getString(CO_NUMBER), runSgl);
        }
        ForecastCalUtil.showCalcErr((IFormView)this.getView(), errors, (int)selData.length);
    }

    private String runSgl(boolean saved, DynamicObject task, Map<String, Object> csettings) {
        String rt;
        boolean createLock = ForecastCalUtil.createLock((String)MDS_FORECASTCAL, (String)OPCALCULATING, (String)task.getPkValue().toString());
        if (!createLock) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ForecastCalListPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        }
        if (!saved) {
            this.save(csettings);
        }
        if ((rt = task.getString(CO_RUNNINGTYPE)) == null || "".equals(rt)) {
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCAL, (String)OPCALCULATING, (String)task.getPkValue().toString());
            return ResManager.loadKDString((String)"\u8ba1\u7b97\u8bf7\u6c42\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u5148\u8fdb\u884c\u8fd0\u7b97\u8bbe\u7f6e\u3002", (String)"ForecastCalListPlugin_6", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        }
        Date losedate = task.getDate(CO_LOSEDATE);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        if (losedate != null && DateUtil.comp((Date)c.getTime(), (Date)losedate)) {
            ForecastCalUtil.releaseLock((String)MDS_FORECASTCAL, (String)OPCALCULATING, (String)task.getPkValue().toString());
            return ResManager.loadKDString((String)"\u8ba1\u7b97\u8bf7\u6c42\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"ForecastCalListPlugin_7", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        }
        JobDispatcherProxy jdp = new JobDispatcherProxy();
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        ScheduleDao sdao = ExecutorService.getInstance().getObjectFactory().getScheduleDao();
        TaskDao tdao = ExecutorService.getInstance().getObjectFactory().getTaskDao();
        String planId = task.getString(CO_PLANID);
        if (!planId.isEmpty()) {
            tdao.deleteTaskByScheduleId(planId);
            sdao.disableSchedule(planId);
            jdp.deletePlan(planId);
        }
        JobInfo jobInfo = ForecastCalUtil.initJobInfo((DynamicObject)task, (int)0, (String)CO_NUMBER);
        String jobId = jdp.createJob(jobInfo);
        task.set(CO_JOBID, (Object)jobId);
        PlanInfo planInfo = ForecastCalUtil.initPlanInfo((String)jobId, (DynamicObject)task);
        planId = jdp.createPlan(planInfo);
        boolean isSuccess = sdao.existed(planId);
        while (!isSuccess) {
            planId = jdp.createPlan(planInfo);
            isSuccess = sdao.existed(planId);
        }
        task.set(CO_PLANID, (Object)planId);
        task.set("status", (Object)ForecastCalUtil.Billstatus.PLAN.getCode());
        if (!RTIMD.equals(rt)) {
            task.set("calstatus", (Object)ForecastCalUtil.CalcStatus.WAIT.getCode());
        } else {
            task.set("calstatus", (Object)ForecastCalUtil.CalcStatus.RUNNING.getCode());
        }
        if (RTIMD.equals(rt)) {
            JobClient.dispatch((JobInfo)jobInfo);
        } else {
            scheduleManager.enableSchedule(planId);
            scheduleManager.enableJob(jobId);
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{task});
        ForecastCalUtil.releaseLock((String)MDS_FORECASTCAL, (String)OPCALCULATING, (String)task.getPkValue().toString());
        return "";
    }

    public static DynamicObject[] selectedData(IFormView view) {
        BillList list = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection rows = list.getSelectedRows();
        String entityName = list.getEntityType().getName();
        if (!rows.isEmpty()) {
            DynamicObject[] cc = new DynamicObject[rows.size()];
            for (int i = 0; i < rows.size(); ++i) {
                Object pk = rows.get(i).getPrimaryKeyValue();
                cc[i] = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
            }
            return cc;
        }
        return new DynamicObject[0];
    }
}

