/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;

public class MdsPlanDataEditPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = bsp.getStatus();
        if (status.equals((Object)OperationStatus.VIEW)) {
            this.setVisble(bsp, "bar_adminupdate", "1GW3227G5+6G");
            this.setVisble(bsp, "bar_inputupdate", "1GW33NF++SX6");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_adminupdate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_inputupdate"});
        }
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String billstatus = dynamicObject.getString("billstatus");
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"B")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_adminupdate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_inputupdate"});
        }
    }

    private void setVisble(BillShowParameter bsp, String button, String itemPermission) {
        int checkPermission = PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)RequestContext.get().getOrgId(), (String)bsp.getAppId(), (String)this.getView().getEntityId(), (String)itemPermission);
        if (checkPermission == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{button});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{button});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Map customParams = billShowParameter.getCustomParams();
        Object fcvrnnum = customParams.get("fcvrnnum");
        if (fcvrnnum == null) {
            return;
        }
        this.getModel().setValue("fcvrnnum", fcvrnnum);
    }

    public void setBillStatus(BillOperationStatus value) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.removeAction("setFormStatus");
        clientViewProxy.addAction("setFormStatus", (Object)value.getValue());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemkey = evt.getOperationKey();
        Long id = (Long)this.getModel().getDataEntity().getPkValue();
        switch (itemkey) {
            case "adminupdate": {
                List<Object> childPlanDataIds = this.getChildPlanDataId(id, itemkey, OperationStatus.EDIT);
                FCPlanDataHelper.changeConfirmationStatus((Object)id, (IFormView)this.getView());
                ArrayList<Object> ids = new ArrayList<Object>();
                ids.add(id);
                boolean isLocked = this.checkMutexLocked(itemkey, "mds_mdsplandata", ids, new StringBuilder());
                if (isLocked) {
                    return;
                }
                isLocked = this.checkMutexLocked(itemkey, "mds_mdsplandatamulti", childPlanDataIds, new StringBuilder());
                if (isLocked) {
                    return;
                }
                BillOperationStatus curOptStatus = BillOperationStatus.EDIT;
                this.setBillStatus(curOptStatus);
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_adminupdate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_inputupdate"});
                this.showform(itemkey, id, OperationStatus.EDIT, ShowType.InCurrentForm);
                break;
            }
            case "inputupdate": {
                this.showform(itemkey, id, OperationStatus.EDIT, ShowType.InCurrentForm);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("new".equalsIgnoreCase(operate.getOperateKey())) {
            this.newData(args);
        }
    }

    private void newData(BeforeDoOperationEventArgs args) {
        this.showform("inputupdate", null, OperationStatus.ADDNEW, ShowType.MainNewTabPage);
        args.setCancel(true);
    }

    private void showform(String itemkey, Object dataId, OperationStatus operationStatus, ShowType showType) {
        BillShowParameter bsp = new BillShowParameter();
        HashMap<String, String> params = new HashMap<String, String>(1);
        String entityNumber = "mds_mdsplandata";
        if (itemkey.equals("inputupdate")) {
            entityNumber = "mds_mdsplandatamulti";
        }
        if (StringUtils.isNotBlank((Object)dataId)) {
            List<Object> childPlanDataIds = this.getChildPlanDataId(dataId, itemkey, operationStatus);
            FCPlanDataHelper.changeConfirmationStatus((Object)dataId, (IFormView)this.getView());
            StringBuilder errMsg = new StringBuilder();
            params.put("fcvrnnum", this.getPageCache().get("fcvrnnum"));
            ArrayList<Object> dataIds = new ArrayList<Object>(1);
            dataIds.add(dataId);
            boolean Locked = this.checkMutexLocked(itemkey, "mds_mdsplandata", dataIds, errMsg);
            if (Locked) {
                return;
            }
            Locked = this.checkMutexLocked(itemkey, "mds_mdsplandatamulti", childPlanDataIds, errMsg);
            if (Locked) {
                return;
            }
            if (itemkey.equals("inputupdate")) {
                if (childPlanDataIds != null && childPlanDataIds.size() > 0) {
                    bsp.setPkId(childPlanDataIds.get(0));
                }
            } else if (StringUtils.isNotBlank((Object)dataId)) {
                bsp.setPkId(dataId);
            }
        }
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        bsp.setAppId(billShowParameter.getAppId());
        bsp.setFormId(entityNumber);
        bsp.getOpenStyle().setShowType(showType);
        bsp.setCustomParams(params);
        bsp.setStatus(operationStatus);
        bsp.setCaption(ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u5904\u7406", (String)"MdsPlanDataEditPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)bsp);
    }

    private List<Object> getChildPlanDataId(Object dataId, String itemkey, OperationStatus operationStatus) {
        if (StringUtils.isBlank((Object)dataId)) {
            return null;
        }
        ArrayList<Object> childPlanDataIds = new ArrayList<Object>();
        Map mdsplandatas = BusinessDataServiceHelper.loadFromCache((String)"mds_mdsplandata", (String)"id,fcvrnnum,creator", (QFilter[])new QFilter[]{new QFilter("id", "=", dataId)});
        if (mdsplandatas == null || mdsplandatas.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u3002", (String)"MdsPlanDataEditPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return null;
        }
        for (DynamicObject mdsplandata : mdsplandatas.values()) {
            DynamicObject fcvrnnum = mdsplandata.getDynamicObject("fcvrnnum");
            this.getPageCache().put("fcvrnnum", fcvrnnum.getPkValue().toString());
            ArrayList<QFilter> qfFilters = new ArrayList<QFilter>(1);
            if ("inputupdate".equals(itemkey)) {
                qfFilters = new ArrayList(2);
                qfFilters.add(new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
            }
            qfFilters.add(new QFilter("fcvrnnum", "=", fcvrnnum.getPkValue()));
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"mds_mdsplandatamulti", (String)"id", (QFilter[])qfFilters.toArray(new QFilter[0]));
            if ((load == null || load.length <= 0) && itemkey.equals("inputupdate")) {
                Object childPlanDataId = FCPlanDataHelper.createChildPlanData((Object)fcvrnnum.getPkValue(), (Object)RequestContext.get().getUserId());
                childPlanDataIds.add(childPlanDataId);
                continue;
            }
            for (DynamicObject data : load) {
                Object childPlanDataId = data.getPkValue();
                childPlanDataIds.add(childPlanDataId);
            }
        }
        return childPlanDataIds;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            MutexHelper.require((IFormView)this.getView(), (String)this.getView().getEntityId(), (Object)this.getModel().getDataEntity().getPkValue(), (String)"modify", (StringBuilder)new StringBuilder());
        }
    }

    private boolean checkMutexLocked(String itemkey, String entityNumber, List<Object> dataIds, StringBuilder errMsg) {
        boolean isLocked = false;
        if (dataIds == null || dataIds.size() <= 0) {
            return isLocked;
        }
        DynamicObject[] loads = FCPlanDataHelper.getDatasLocks(dataIds, (String)entityNumber, (String)"modify");
        if (loads == null || loads.length <= 0) {
            return isLocked;
        }
        String errInfo = "";
        String handler = "";
        if ("mds_mdsplandata".equals(entityNumber)) {
            handler = ResManager.loadKDString((String)"\u7ba1\u7406\u5458", (String)"MdsPlanDataEditPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        } else if ("mds_mdsplandatamulti".equals(entityNumber)) {
            handler = ResManager.loadKDString((String)"\u5f55\u5165\u4eba", (String)"MdsPlanDataEditPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        }
        for (DynamicObject load : loads) {
            DynamicObject user = load.getDynamicObject("user");
            errInfo = String.format(ResManager.loadKDString((String)"%1$s%2$s \u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"MdsPlanDataEditPlugin_5", (String)"mmc-mds-formplugin", (Object[])new Object[0]), handler, user.getLocaleString("name").getLocaleValue());
        }
        if (StringUtils.isNotBlank((CharSequence)errInfo)) {
            this.getView().showTipNotification(errInfo, Integer.valueOf(2000));
            return true;
        }
        return isLocked;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            MutexHelper.release((String)this.getView().getEntityId(), (String)this.getModel().getDataEntity().getPkValue().toString(), (String)"modify");
        }
    }
}

