/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;
import kd.mmc.mds.common.util.ClearMdsPlanDataUtils;

public class MdsPlanDataListPlugin
extends AbstractListPlugin {
    protected static final String PAGECACHE_DATAID = "dataId";
    protected static final String PAGECACHE_ENTITYNUMBER = "entityNumber";
    protected static final String PAGECACHE_EXPORTTYPE = "exporttype";
    protected static final String EXPORTTYPE_MDS_MDSPLANDATA = "mds_mdsplandata";
    protected static final String EXPORTTYPE_MDS_MDSPLANDATAMULTI = "mds_mdsplandatamulti";
    protected static final String EXPORTTYPE_MDS_MDSPLANDATAMULTI_ALL = "mds_mdsplandatamulti-all";
    protected static final String CONFIRMCALLBACK_EXPORT = "ccb_exportData";
    protected static final String CLOSEDCALLBACK_CLEARSET = "closedcallback_clearset";
    private static final String OP_CLEAR_SET_LOG = "clearsetlog";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        this.setVisble(lsp, "adminupdate", "1GW3227G5+6G");
        this.setVisble(lsp, "adminimport", "1GW3E74=L7KZ");
        this.setVisble(lsp, "inputupdate", "1GW33NF++SX6");
        this.setVisble(lsp, "inputimport", "1GW3GN1RD4RH");
        this.setVisble(lsp, "adminexport", "1HGW9TY+HZ1L");
        this.setVisble(lsp, "inputexport", "1HGWA6UEYS5/");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemkey = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (itemkey) {
            case "adminupdate": 
            case "inputupdate": {
                if (rows.size() <= 0) {
                    return;
                }
                if (rows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"MdsPlanDataListPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long id = (Long)rows.get(0).getPrimaryKeyValue();
                if (!this.checkBillStatus(id)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u3002", (String)"MdsPlanDataListPlugin_13", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                    return;
                }
                FCPlanDataHelper.changeConfirmationStatus((Object)id, (IFormView)this.getView());
                this.showform(itemkey, id, OperationStatus.EDIT, evt.getOperationKey());
                break;
            }
            case "inputimport": {
                ConfirmCallBackListener inputImportConfirm = new ConfirmCallBackListener("inputimport", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f55\u5165\u4eba\u5bfc\u5165\u4f1a\u8986\u76d6\u5f53\u524d\u5f55\u5165\u4eba\u7684\u6240\u6709\u6570\u636e\u3002", (String)"MdsPlanDataListPlugin_11", (String)"mmc-mds-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, inputImportConfirm);
                break;
            }
            case "adminimport": {
                ConfirmCallBackListener adminImportConfirm = new ConfirmCallBackListener("adminimport", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5bfc\u5165\u4f1a\u8986\u76d6\u6240\u6709\u5f55\u5165\u4eba\u7684\u6570\u636e\u3002", (String)"MdsPlanDataListPlugin_10", (String)"mmc-mds-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, adminImportConfirm);
                break;
            }
            case "inputexport": {
                this.exportData(itemkey);
                break;
            }
            case "barclearset": {
                if (rows.size() > 0) break;
                return;
            }
        }
    }

    private void showClearSetting() {
        FormShowParameter form = new FormShowParameter();
        form.setFormId("mds_clear_set");
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSEDCALLBACK_CLEARSET));
        this.getView().showForm(form);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map csettings = (Map)closedCallBackEvent.getReturnData();
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection srows = list.getSelectedRows();
        if (srows == null || srows.isEmpty()) {
            return;
        }
        ArrayList<Object> ids = new ArrayList<Object>(srows.size());
        for (ListSelectedRow srow : srows) {
            ids.add(srow.getPrimaryKeyValue());
        }
        if (csettings == null || csettings.isEmpty()) {
            return;
        }
        Integer action = (Integer)csettings.get("op");
        switch (action) {
            case 2: {
                break;
            }
            case 1: {
                this.runclear(csettings, ids);
                break;
            }
        }
    }

    private void runclear(Map<String, Object> csetting, List<Object> ids) {
        String rt = (String)csetting.get("runningtype");
        if ("0".equals(rt)) {
            ClearMdsPlanDataUtils.runClearImediatly(csetting, ids, (String)EXPORTTYPE_MDS_MDSPLANDATA);
        } else {
            JobInfo job = ClearMdsPlanDataUtils.createJob(csetting, ids, (String)EXPORTTYPE_MDS_MDSPLANDATA);
            String scheduleId = ClearMdsPlanDataUtils.createPlan(csetting, (JobInfo)job);
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.enableSchedule(scheduleId);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u7a7a\u4efb\u52a1\u5206\u53d1\u6210\u529f\u3002", (String)"MdsPlanDataListPlugin_12", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void exportData(String itemkey) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMCALLBACK_EXPORT, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u5f55\u5165\u4eba", (String)"MdsPlanDataListPlugin_6", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u5168\u90e8\u5f55\u5165\u4eba", (String)"MdsPlanDataListPlugin_7", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4ec5\u5bfc\u51fa\u5f53\u524d\u5f55\u5165\u4eba\u7684\u6570\u636e\u8fd8\u662f\u5bfc\u51fa\u5168\u90e8\u5f55\u5165\u4eba\u7684\u6570\u636e\uff1f", (String)"MdsPlanDataListPlugin_8", (String)"mmc-mds-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("new".equalsIgnoreCase(operate.getOperateKey())) {
            this.newData(args);
        } else if ("exportlist".equalsIgnoreCase(operate.getOperateKey())) {
            this.getPageCache().put(PAGECACHE_EXPORTTYPE, EXPORTTYPE_MDS_MDSPLANDATA);
        } else if ("clearset".equalsIgnoreCase(operate.getOperateKey())) {
            this.showClearSetting();
        }
    }

    private void newData(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        this.showform("inputupdate", null, OperationStatus.ADDNEW, operateKey);
        args.setCancel(true);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        evt.setCancel(true);
        this.getView().invokeOperation("view");
    }

    private void showform(String itemkey, Object dataId, OperationStatus operationStatus, String operationKey) {
        BillShowParameter bsp = new BillShowParameter();
        String entityNumber = EXPORTTYPE_MDS_MDSPLANDATA;
        ArrayList<Object> childPlanDataIds = new ArrayList<Object>();
        if (itemkey.equals("inputupdate")) {
            entityNumber = EXPORTTYPE_MDS_MDSPLANDATAMULTI;
        }
        if (StringUtils.isNotBlank((Object)dataId)) {
            DynamicObject[] mdsplandatas = BusinessDataServiceHelper.load((String)EXPORTTYPE_MDS_MDSPLANDATA, (String)"id,fcvrnnum", (QFilter[])new QFilter[]{new QFilter("id", "=", dataId)});
            if (mdsplandatas == null || mdsplandatas.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u3002", (String)"MdsPlanDataListPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject mdsplandata : mdsplandatas) {
                DynamicObject fcvrnnum = mdsplandata.getDynamicObject("fcvrnnum");
                ArrayList<QFilter> qfFilters = new ArrayList<QFilter>(1);
                if ("inputupdate".equals(itemkey)) {
                    qfFilters = new ArrayList(2);
                    qfFilters.add(new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())));
                }
                qfFilters.add(new QFilter("fcvrnnum", "=", fcvrnnum.getPkValue()));
                DynamicObject[] load = BusinessDataServiceHelper.load((String)EXPORTTYPE_MDS_MDSPLANDATAMULTI, (String)"id", (QFilter[])qfFilters.toArray(new QFilter[0]));
                if (load == null || load.length <= 0) {
                    Object childPlanDataId = FCPlanDataHelper.createChildPlanData((Object)fcvrnnum.getPkValue(), (Object)RequestContext.get().getUserId());
                    childPlanDataIds.add(childPlanDataId);
                    continue;
                }
                for (DynamicObject data : load) {
                    childPlanDataIds.add(data.getPkValue());
                }
            }
            StringBuilder errMsg = new StringBuilder();
            if (itemkey.equals("inputupdate")) {
                if (childPlanDataIds.size() > 0) {
                    bsp.setPkId(childPlanDataIds.get(0));
                }
            } else if (StringUtils.isNotBlank((Object)dataId)) {
                bsp.setPkId(dataId);
            }
            this.getPageCache().put(PAGECACHE_DATAID, bsp.getPkId().toString());
            this.getPageCache().put(PAGECACHE_ENTITYNUMBER, entityNumber);
            ArrayList<Object> dataIds = new ArrayList<Object>(1);
            dataIds.add(dataId);
            boolean isLocked = this.checkMutexLocked(itemkey, EXPORTTYPE_MDS_MDSPLANDATA, dataIds, errMsg);
            if (isLocked) {
                return;
            }
            isLocked = this.checkMutexLocked(itemkey, EXPORTTYPE_MDS_MDSPLANDATAMULTI, childPlanDataIds, errMsg);
            if (isLocked) {
                return;
            }
        }
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String orgIdStr = this.getPageCache().get("org.id");
        bsp.setCustomParam("org.id", (Object)orgIdStr);
        bsp.setAppId(listShowParameter.getAppId());
        bsp.setFormId(entityNumber);
        bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        bsp.setStatus(operationStatus);
        bsp.setCaption(ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u5904\u7406", (String)"MdsPlanDataListPlugin_9", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)bsp);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (args.getFilterValue("org.id") instanceof Long) {
            Long createOrg = (Long)args.getFilterValue("org.id");
            this.getPageCache().put("org.id", String.valueOf(createOrg));
        } else {
            this.getPageCache().remove("org.id");
        }
    }

    private boolean checkMutexLocked(String itemkey, String entityNumber, List<Object> dataIds, StringBuilder errMsg) {
        boolean isLocked = false;
        if (dataIds == null || dataIds.size() <= 0) {
            return isLocked;
        }
        DynamicObject[] loads = FCPlanDataHelper.getDatasLocks(dataIds, (String)entityNumber, (String)"modify");
        if (loads == null || loads.length <= 0) {
            return isLocked;
        }
        String errInfo = "";
        String handler = "";
        if (EXPORTTYPE_MDS_MDSPLANDATA.equals(entityNumber)) {
            handler = ResManager.loadKDString((String)"\u7ba1\u7406\u5458", (String)"MdsPlanDataListPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        } else if (EXPORTTYPE_MDS_MDSPLANDATAMULTI.equals(entityNumber)) {
            handler = ResManager.loadKDString((String)"\u5f55\u5165\u4eba", (String)"MdsPlanDataListPlugin_5", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        }
        for (DynamicObject load : loads) {
            DynamicObject user = load.getDynamicObject("user");
            errInfo = String.format(ResManager.loadKDString((String)"%1$s%2$s\u8be5\u8bb0\u5f55\u6b63\u5728\u88abPC\u7aef\u7f16\u8f91\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002\u662f\u5426\u8fdb\u5165\u67e5\u770b\u754c\u9762\uff1f", (String)"MdsPlanDataListPlugin_14", (String)"mmc-mds-formplugin", (Object[])new Object[0]), handler, user.getLocaleString("name").getLocaleValue());
        }
        if (StringUtils.isNotBlank((CharSequence)errInfo)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(entityNumber, (IFormPlugin)this);
            this.getView().showConfirm(errInfo, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            return true;
        }
        return isLocked;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if (EXPORTTYPE_MDS_MDSPLANDATA.equals(callBackId) || EXPORTTYPE_MDS_MDSPLANDATAMULTI.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getView().invokeOperation("view");
            }
        } else if (CONFIRMCALLBACK_EXPORT.equals(callBackId)) {
            if (MessageBoxResult.No.equals((Object)result)) {
                this.getPageCache().put(PAGECACHE_EXPORTTYPE, EXPORTTYPE_MDS_MDSPLANDATAMULTI_ALL);
            } else if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getPageCache().put(PAGECACHE_EXPORTTYPE, EXPORTTYPE_MDS_MDSPLANDATAMULTI);
            } else {
                return;
            }
            this.getView().invokeOperation("inputexportnew");
        } else if ("adminimport".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.getView().invokeOperation("importdata");
        } else if ("inputimport".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.importData("importdata");
        }
    }

    private void importData(String itemkey) {
        FormShowParameter paramGroups = new FormShowParameter();
        paramGroups.setFormId("bos_importstart");
        String entityNumber = EXPORTTYPE_MDS_MDSPLANDATAMULTI;
        paramGroups.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> customParam = new HashMap<String, String>(3);
        customParam.put("BillFormId", entityNumber);
        customParam.put("ImportPlugin", "kd.mmc.mds.opplugin.FCPlanDataColumnentryMDSMultiImportPlugin");
        customParam.put("ServiceAppId", "mds");
        customParam.put("ListName", ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u5904\u7406", (String)"MdsPlanDataListPlugin_9", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        paramGroups.setCustomParams(customParam);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listoperation");
        paramGroups.setCloseCallBack(closeCallBack);
        this.getView().showForm(paramGroups);
    }

    private void setVisble(ListShowParameter lsp, String button, String itemPermission) {
        int checkPermission = PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)RequestContext.get().getOrgId(), (String)lsp.getAppId(), (String)lsp.getBillFormId(), (String)itemPermission);
        if (checkPermission == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{button});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{button});
        }
    }

    private boolean checkBillStatus(Object id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mds_plandata");
        String billstatus = dynamicObject.getString("billstatus");
        return !StringUtils.equals((CharSequence)billstatus, (CharSequence)"B");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (OP_CLEAR_SET_LOG.equals(operateKey) && operationResult.isSuccess()) {
            this.showClearSetLog();
        }
    }

    private void showClearSetLog() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("mds_clearsetlog");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

