/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.mmc.mds.common.util.DateUtil;

public class PlanDataCalendarPlugin
extends AbstractFormPlugin {
    private static final String OK = "ok";
    private static final String CANCEL = "cancel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        CloseCallBack closeCallBack = showParam.getCloseCallBack();
        String actionId = closeCallBack.getActionId();
        boolean isAdd = "newcolumn".equals(actionId);
        switch (itemKey) {
            case "ok": {
                IDataModel model = this.getModel();
                if (isAdd && this.checkColumnOverflow()) break;
                Map param = showParam.getCustomParams();
                param.put("starttime", model.getValue("starttime"));
                param.put("endtime", model.getValue("endtime"));
                param.put("op", OK);
                view.returnDataToParent((Object)param);
                view.close();
                break;
            }
            case "cancel": {
                HashMap<String, String> cancel = new HashMap<String, String>();
                cancel.put("op", CANCEL);
                view.returnDataToParent(cancel);
                view.close();
            }
        }
    }

    private boolean checkColumnOverflow() {
        int size;
        boolean overflow;
        IDataModel model = this.getModel();
        IDataModel parentModel = this.getView().getParentView().getModel();
        Object starttime = model.getValue("starttime");
        Object endtime = model.getValue("endtime");
        if (starttime == null || endtime == null) {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setFieldKey("daterangefield");
            fieldTip.setTip(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65f6\u95f4\u8303\u56f4\u3002", (String)"PlanDataCalendarPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            this.getView().showFieldTip(fieldTip);
            return true;
        }
        DynamicObject obj = parentModel.getDataEntity(true);
        Object fcvrnnum = parentModel.getValue("fcvrnnum");
        String cytype = "0";
        HashSet<Date> existDate = new HashSet<Date>();
        if (obj != null && fcvrnnum instanceof DynamicObject) {
            DynamicObjectCollection dateList = obj.getDynamicObjectCollection("dateentity");
            cytype = ((DynamicObject)fcvrnnum).getString("cytype");
            for (DynamicObject dateentity : dateList) {
                boolean deliverycolumn = dateentity.getBoolean("deliverycolumn");
                Date targetdate = dateentity.getDate("targetdate");
                if (deliverycolumn) continue;
                existDate.add(targetdate);
            }
        }
        if (starttime != null && endtime != null) {
            Date start = (Date)starttime;
            Date end = (Date)endtime;
            List<Date> betweendates = DateUtil.getBetweenDates((Date)start, (Date)end);
            betweendates = this.getDetailDate(betweendates, cytype + "");
            for (Date date : betweendates) {
                existDate.add(date);
            }
        }
        boolean bl = overflow = (size = existDate.size()) > 150;
        if (overflow) {
            String suffix = ResManager.loadKDString((String)"\u5929", (String)"PlanDataCalendarPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
            if ("1".equals(cytype)) {
                ResManager.loadKDString((String)"\u5468", (String)"PlanDataCalendarPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
            } else if ("3".equals(cytype)) {
                ResManager.loadKDString((String)"\u6708", (String)"PlanDataCalendarPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
            }
            FieldTip fieldTip = new FieldTip();
            fieldTip.setFieldKey("daterangefield");
            fieldTip.setTip(String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u5217\u8d85\u957f\uff0c\u8bf7\u51cf\u5c11%d%s\u3002", (String)"PlanDataCalendarPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]), size - 150, suffix));
            this.getView().showFieldTip(fieldTip);
        }
        return overflow;
    }

    private List<Date> getDetailDate(List<Date> workdates, String cycletype) {
        switch (cycletype) {
            case "0": {
                return workdates;
            }
            case "1": {
                ArrayList<Date> mondays = new ArrayList<Date>();
                for (Date date : workdates) {
                    if (!DateUtil.currentIsMonday((Date)date)) continue;
                    mondays.add(date);
                }
                return mondays;
            }
            case "3": {
                ArrayList<Date> mondays = new ArrayList<Date>();
                for (Date date : workdates) {
                    if (!DateUtil.currentIsMonthFirst((Date)date)) continue;
                    mondays.add(date);
                }
                return mondays;
            }
        }
        return workdates;
    }
}

