/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.util.CalcuColumns;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.common.util.PlanExecCommonUtil;

public class PlanExecListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operatekey = afterDoOperationEventArgs.getOperateKey();
        if ("calculatlistsing".equals(operatekey)) {
            this.getView().updateView();
        } else if ("calculatesetting".equals(operatekey)) {
            this.setCalculatesetting();
        } else if ("suspend".equals(operatekey)) {
            ScheduleDao scheduleDao = ExecutorService.getInstance().getObjectFactory().getScheduleDao();
            TaskDao tdao = ExecutorService.getInstance().getObjectFactory().getTaskDao();
            this.termination(scheduleDao, tdao);
        }
    }

    private void setCalculatesetting() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection srows = list.getSelectedRows();
        if (srows == null || srows.isEmpty()) {
            return;
        }
        if (srows.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"PlanExecListPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        Object pk = srows.get(0).getPrimaryKeyValue();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"mds_planexec");
        boolean runlock = CalcuColumns.createLock((String)"mds_planexec", (String)"calculatesetting", (String)pk.toString());
        if (runlock) {
            CalcuColumns.showForm((IFormPlugin)this, (IFormView)this.getView(), (Map)PlanExecCommonUtil.getSetParamsByScheme((DynamicObject)obj, (String)"1"));
        }
    }

    private void termination(ScheduleDao scheduleDao, TaskDao tdao) {
        this.disableJobAndPlan(CalcuColumns.selectedData((IFormView)this.getView()), scheduleDao, tdao);
    }

    private void disableJobAndPlan(DynamicObject[] query, ScheduleDao scheduleDao, TaskDao tdao) {
        if (CalcuColumns.isEmpty((Object[])query)) {
            return;
        }
        ArrayList<Map<String, String>> operations = new ArrayList<Map<String, String>>(10);
        for (DynamicObject o : query) {
            Map<String, String> tip = this.disableSingleJob(o, scheduleDao, tdao);
            if (tip == null) continue;
            operations.add(tip);
        }
        CalcuColumns.showStopTip((IFormView)this.getView(), operations, (DynamicObject[])query);
    }

    private Map<String, String> disableSingleJob(DynamicObject sig, ScheduleDao sdao, TaskDao tdao) {
        String billstatus = sig.getString("status");
        String calcstatus = sig.getString("enable");
        String planId = sig.getString("planid");
        String billno = sig.getString("number");
        HashMap<String, String> sigtip = new HashMap<String, String>(1);
        boolean createLock = CalcuColumns.createLock((String)"mds_planexec", (String)"tblstop", (String)sig.getPkValue().toString());
        if (!createLock) {
            sigtip.put(billno, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PlanExecListPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return sigtip;
        }
        if (!CalcuColumns.Billstatus.PLAN.getCode().equals(billstatus)) {
            sigtip.put(billno, ResManager.loadKDString((String)"\u975e\u8ba1\u5212\u72b6\u6001\u4e0d\u80fd\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"PlanExecListPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            CalcuColumns.releaseLock((String)"mds_planexec", (String)"tblstop", (String)sig.getPkValue().toString());
            return sigtip;
        }
        if (CalcuColumns.CalcStatus.STOP.getCode().equals(calcstatus)) {
            sigtip.put(billno, ResManager.loadKDString((String)"\u8ba1\u7b97\u72b6\u6001\u4e3a\u7ec8\u6b62\u65f6\u4e0d\u80fd\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"PlanExecListPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            CalcuColumns.releaseLock((String)"mds_planexec", (String)"tblstop", (String)sig.getPkValue().toString());
            return sigtip;
        }
        if (CalcuColumns.CalcStatus.ERROR.getCode().equals(calcstatus)) {
            sigtip.put(billno, ResManager.loadKDString((String)"\u8ba1\u7b97\u72b6\u6001\u4e3a\u9519\u8bef\u65f6\u4e0d\u80fd\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\u3002", (String)"PlanExecListPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            CalcuColumns.releaseLock((String)"mds_planexec", (String)"tblstop", (String)sig.getPkValue().toString());
            return sigtip;
        }
        sig.set("enable", (Object)CalcuColumns.CalcStatus.STOP.getCode());
        SaveServiceHelper.update((DynamicObject)sig);
        CalcuColumns.releaseLock((String)"mds_planexec", (String)"tblstop", (String)sig.getPkValue().toString());
        BillList list = (BillList)this.getView().getControl("billlistap");
        list.refresh();
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closed) {
        Map csettings = (Map)closed.getReturnData();
        BillList list = (BillList)this.getView().getControl("billlistap");
        if (csettings == null || csettings.isEmpty()) {
            CalcuColumns.releaseLock((String)"mds_planexec", (String)"calculatesetting", (String)list.getSelectedRows().get(0).getPrimaryKeyValue().toString());
            return;
        }
        Integer action = (Integer)csettings.get("op");
        switch (action) {
            case 2: {
                break;
            }
            case 0: {
                this.save(csettings);
                break;
            }
            case 1: {
                this.save(csettings);
                this.run(null);
                break;
            }
        }
        CalcuColumns.releaseLock((String)"mds_planexec", (String)"calculatesetting", (String)list.getSelectedRows().get(0).getPrimaryKeyValue().toString());
        this.getView().updateView();
    }

    private void save(Map<String, Object> csetting) {
        DynamicObject[] selectedData;
        for (DynamicObject o : selectedData = CalcuColumns.selectedData((IFormView)this.getView())) {
            o.set("runningtype", csetting.get("runningtype"));
            o.set("predtime", csetting.get("predtime"));
            o.set("losedate", csetting.get("losedate"));
            o.set("repeattype", csetting.get("repeattype"));
            o.set("repeat", csetting.get("repeat"));
            if (CalcuColumns.isWeek(csetting)) {
                o.set("daysofweek", (Object)CalcuColumns.createExp((String)"daysofweek", csetting));
                o.set("daysofmon", (Object)"");
            } else {
                o.set("daysofmon", (Object)CalcuColumns.createExp((String)"daysofmon", csetting));
                o.set("daysofweek", (Object)"");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{o});
        }
    }

    private void run(Map<String, Object> csettings) {
        Object[] selData = CalcuColumns.selectedData((IFormView)this.getView());
        if (CalcuColumns.isEmpty((Object[])selData)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlanExecListPlugin_5", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean saved = false;
        if (csettings == null) {
            saved = true;
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        for (Object t : selData) {
            String runSgl = this.runSgl(saved, (DynamicObject)t, csettings);
            if ("".equals(runSgl)) continue;
            errors.put(t.getString("billno"), runSgl);
        }
        CalcuColumns.showCalcErr((IFormView)this.getView(), errors, (int)selData.length);
    }

    private String runSgl(boolean saved, DynamicObject task, Map<String, Object> csettings) {
        String rt;
        boolean createLock = CalcuColumns.createLock((String)"mds_planexec", (String)"calculating", (String)task.getPkValue().toString());
        if (!createLock) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PlanExecListPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        }
        if (!saved) {
            this.save(csettings);
        }
        if ((rt = task.getString("runningtype")) == null || "".equals(rt)) {
            CalcuColumns.releaseLock((String)"mds_planexec", (String)"calculating", (String)task.getPkValue().toString());
            return ResManager.loadKDString((String)"\u8ba1\u7b97\u8bf7\u6c42\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u5148\u8fdb\u884c\u8fd0\u7b97\u8bbe\u7f6e\u3002", (String)"PlanExecListPlugin_6", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        }
        Date losedate = task.getDate("losedate");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        if (losedate != null && DateUtil.comp((Date)c.getTime(), (Date)losedate)) {
            CalcuColumns.releaseLock((String)"mds_rplancal", (String)"calculating", (String)task.getPkValue().toString());
            return ResManager.loadKDString((String)"\u8ba1\u7b97\u8bf7\u6c42\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"PlanExecListPlugin_7", (String)"mmc-mds-formplugin", (Object[])new Object[0]);
        }
        JobDispatcherProxy jdp = new JobDispatcherProxy();
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        ScheduleDao sdao = ExecutorService.getInstance().getObjectFactory().getScheduleDao();
        TaskDao tdao = ExecutorService.getInstance().getObjectFactory().getTaskDao();
        String planId = task.getString("planid");
        if (!planId.isEmpty()) {
            tdao.deleteTaskByScheduleId(planId);
            sdao.disableSchedule(planId);
            jdp.deletePlan(planId);
        }
        JobInfo jobInfo = PlanExecCommonUtil.initJobInfo((DynamicObject)task, (int)CalcuColumns.Caltype.XQJH_CAL.ordinal(), (String)"number");
        String jobId = jdp.createJob(jobInfo);
        task.set("jobid", (Object)jobId);
        PlanInfo planInfo = PlanExecCommonUtil.initPlanInfo((String)jobId, (DynamicObject)task);
        planId = jdp.createPlan(planInfo);
        boolean isSuccess = sdao.existed(planId);
        while (!isSuccess) {
            planId = jdp.createPlan(planInfo);
            isSuccess = sdao.existed(planId);
        }
        task.set("planid", (Object)planId);
        task.set("status", (Object)CalcuColumns.Billstatus.PLAN.getCode());
        if (!"0".equals(rt)) {
            task.set("enable", (Object)CalcuColumns.CalcStatus.WAIT.getCode());
        } else {
            task.set("enable", (Object)CalcuColumns.CalcStatus.RUNNING.getCode());
        }
        if ("0".equals(rt)) {
            JobClient.dispatch((JobInfo)jobInfo);
        } else {
            scheduleManager.enableSchedule(planId);
            scheduleManager.enableJob(jobId);
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{task});
        CalcuColumns.releaseLock((String)"mds_planexec", (String)"calculating", (String)task.getPkValue().toString());
        return "";
    }
}

