/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PurQuotaAllocatePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CO_CREATEORG = "org";
    private static final String CO_USEORG = "useorg";
    private static final String CO_ALLOCATEORG = "allocateorg";
    private static final String ENT_STRUCT_ORG = "bos_org_structure";
    private static final String BILL_ENTRY = "entryentity";
    private static final String ACTION_SUBMIT = "submit";
    private static final String ACTION_SAVE = "save";
    private static final String CO_QUOTAMOD = "quotamod";
    private static final String CO_QUOTATYPE = "quotatype";
    private static final String CO_MATERIAL_NAME = "materialname";
    private static final String CO_MATERIAL = "material";
    private static final String CO_BILLSTATUS = "status";
    private static final String CO_ENABLE = "enable";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final String BAR_ENABLE = "bar_enable";
    private static final String BAR_DISABLE = "bar_disable";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_DISABLE = "disable";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bd = (BasedataEdit)this.getView().getControl(CO_ALLOCATEORG);
        bd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate acts = (FormOperate)e.getSource();
        if (ACTION_SUBMIT.equals(acts.getOperateKey()) || ACTION_SAVE.equals(acts.getOperateKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(BILL_ENTRY);
            HashMap<Object, Object> orgMap = new HashMap<Object, Object>();
            for (DynamicObject o : entryEntity) {
                DynamicObject org = o.getDynamicObject(CO_ALLOCATEORG);
                if (org == null) continue;
                if (orgMap.containsKey(org.getPkValue())) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u4f9b\u5e94\u7ec4\u7ec7\u201c%s\u201d\u5df2\u8bbe\u7f6e\u91cd\u590d\u3002", (String)"PurQuotaAllocatePlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), org.getString("name")));
                    e.setCancel(true);
                    return;
                }
                orgMap.put(org.getPkValue(), org.getPkValue());
            }
        }
        if (ACTION_SUBMIT.equals(acts.getOperateKey())) {
            Date loseDate;
            Date effectDate;
            DynamicObject material;
            if (!this.allEntiesCorrect()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7269\u6599\u5b9a\u989d\u7684\u5206\u914d\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u4e3a100\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PurQuotaAllocatePlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(CO_CREATEORG);
            if (!this.uniqueOrgMaterial(org, material = (DynamicObject)this.getModel().getValue(CO_MATERIAL), effectDate = this.getModel().getDataEntity().getDate("effectDate"), loseDate = this.getModel().getDataEntity().getDate("loseDate"))) {
                SimpleDateFormat simpleDateFormat = this.sdf;
                synchronized (simpleDateFormat) {
                    String effectDate2 = this.sdf.format(effectDate);
                    String loseDate2 = this.sdf.format(loseDate);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5728\u751f\u6548\u65e5\u671f%2$s\u548c\u5931\u6548\u65e5\u671f%3$s\u4e4b\u95f4\uff0c\u5df2\u7ecf\u5b9a\u4e49\u4e86\u914d\u989d\u3002", (String)"PurQuotaAllocatePlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]), material.getString("name"), effectDate2, loseDate2));
                }
                e.setCancel(true);
                return;
            }
        }
        super.beforeDoOperation(e);
    }

    private boolean uniqueOrgMaterial(DynamicObject org, DynamicObject material, Date effectDate, Date loseDate) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(CO_MATERIAL, "=", material == null ? Integer.valueOf(0) : material.getPkValue()));
        filters.add(new QFilter(CO_BILLSTATUS, "=", (Object)"C").or(new QFilter(CO_BILLSTATUS, "=", (Object)"B")));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mds_quotadata", (String)"effectDate,loseDate", (QFilter[])filters.toArray(new QFilter[0]));
        if (query == null || query.isEmpty()) {
            return true;
        }
        for (DynamicObject obj : query) {
            Date _effectDate = obj.getDate("effectDate");
            Date _loseDate = obj.getDate("loseDate");
            if (effectDate.compareTo(_loseDate) > 0 || loseDate.compareTo(_effectDate) < 0) continue;
            return false;
        }
        return true;
    }

    private boolean allEntiesCorrect() {
        BigDecimal sum = new BigDecimal("0.00");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(BILL_ENTRY);
        for (DynamicObject o : entryEntity) {
            BigDecimal mod = o.getBigDecimal(CO_QUOTAMOD);
            sum = sum.add(mod);
        }
        BigDecimal zero = new BigDecimal("0.00");
        if (sum.subtract(new BigDecimal("100.00")).compareTo(zero) > 0) {
            return false;
        }
        BigInteger sum1 = sum.toBigInteger();
        return sum1.intValue() == 100 ? Boolean.TRUE : Boolean.FALSE;
    }

    public void afterBindData(EventObject e) {
        String enable = (String)this.getModel().getValue("enable");
        if (enable != null) {
            if ("0".equals(enable)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_ENABLE});
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_DISABLE});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_ENABLE});
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
            }
        }
        super.afterBindData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)KEY_DISABLE, (CharSequence)operateKey)) {
            this.setViewStyle("0");
        }
        if (StringUtils.equals((CharSequence)"enable", (CharSequence)operateKey)) {
            this.setViewStyle("1");
        }
        super.afterDoOperation(args);
    }

    private void setViewStyle(String type) {
        if ("0".equals(type)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_ENABLE});
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_DISABLE});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_ENABLE});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel dm = this.getModel();
        if (CO_ALLOCATEORG.equals(name)) {
            DynamicObjectCollection doc = (DynamicObjectCollection)dm.getValue(BILL_ENTRY);
            DynamicObject org = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int row = e.getChangeSet()[0].getRowIndex();
            if (org != null && !this.valid(doc, org)) {
                dm.setValue(CO_ALLOCATEORG, null, row);
            }
        } else if (CO_MATERIAL.equals(name)) {
            ChangeData cd = e.getChangeSet()[0];
            Object masterid = cd.getNewValue();
            if (masterid != null && !"0".equals(masterid.toString())) {
                DynamicObject master = (DynamicObject)masterid;
                this.getModel().setValue(CO_MATERIAL_NAME, master.get("name"));
            } else {
                this.getModel().setValue(CO_MATERIAL_NAME, null);
            }
        } else if (CO_QUOTATYPE.equals(name)) {
            this.getModel().setValue(CO_MATERIAL_NAME, null);
        }
    }

    private boolean valid(DynamicObjectCollection doc, DynamicObject org) {
        int count = 0;
        for (DynamicObject row : doc) {
            DynamicObject org0 = row.getDynamicObject(CO_ALLOCATEORG);
            if (org0 == null || org0.getPkValue() != org.getPkValue()) continue;
            ++count;
        }
        return count > 1 ? Boolean.FALSE : Boolean.TRUE;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
    }
}

