/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.FieldTip;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mmc.mds.common.util.MDSUtils;

public class ResourceRegisterPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static String FIELD_RESOURCE = "resource";
    private static String FIELD_BILLFIELDTRANSFER = "billfieldtransfer";
    private static String FIELD_FILTERDESC = "filterdesc";
    private static String FIELD_BUSINESSENTITY = "businessentity";
    private static String RESOURCEENTITY = "resourceentity";
    private static String FIELDINFOENTITY = "fieldinfoentity";
    private static final String FIELD_SIGNID = "signid";
    private static final String FIELD_SIGNNAME = "signname";
    private static final String FIELD_DATATYPE = "datatype";
    private static final String FIELD_DEFAULTVALUE = "defaultvalue";

    public void registerListener(EventObject e) {
        BasedataEdit resource = (BasedataEdit)this.getView().getControl(FIELD_RESOURCE);
        resource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit businessentity = (BasedataEdit)this.getView().getControl(FIELD_BUSINESSENTITY);
        businessentity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        if (FIELD_RESOURCE.equals(prop.getName())) {
            ChangeData data = e.getChangeSet()[0];
            DynamicObject newobj = (DynamicObject)data.getNewValue();
            if (newobj != null) {
                DynamicObject resource = this.loadResourceData(newobj.getPkValue());
                String filterStringDesc = this.buildFilterDesc(resource);
                this.getModel().setValue(FIELD_FILTERDESC, (Object)filterStringDesc, data.getRowIndex());
            } else {
                this.getModel().setValue(FIELD_FILTERDESC, (Object)"", data.getRowIndex());
            }
            this.getView().updateView(RESOURCEENTITY, data.getRowIndex());
        } else if (FIELD_BUSINESSENTITY.equals(prop.getName())) {
            ChangeData data = e.getChangeSet()[0];
            DynamicObject newobj = (DynamicObject)data.getNewValue();
            if (newobj != null && !this.checkResourceEntityIsNotEmpty()) {
                this.getModel().beginInit();
                this.queryMetaDataInfo();
                FieldTip fieldTip = new FieldTip();
                fieldTip.setFieldKey(FIELD_BUSINESSENTITY);
                fieldTip.setSuccess(true);
                this.getView().showFieldTip(fieldTip);
                this.getModel().endInit();
            } else {
                if (this.checkResourceEntityIsNotEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u914d\u7f6e\u9875\u7b7e\u4e0d\u4e3a\u7a7a\uff0c\u7981\u6b62\u4fee\u6539\u76ee\u6807\u5b9e\u4f53\u3002", (String)"ResourceRegisterPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                }
                DynamicObject dy = this.getModel().getDataEntity();
                this.getModel().beginInit();
                dy.beginInit();
                dy.set(FIELD_BUSINESSENTITY, data.getOldValue());
                dy.endInit();
                this.getModel().endInit();
                this.getView().updateView(FIELD_BUSINESSENTITY);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object businessentity;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("newentry".equals(operateKey) && (businessentity = this.getModel().getValue(FIELD_BUSINESSENTITY)) == null) {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setFieldKey(FIELD_BUSINESSENTITY);
            fieldTip.setSuccess(false);
            fieldTip.setTip(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u76ee\u6807\u5b9e\u4f53\u3002", (String)"ResourceRegisterPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            this.getView().showFieldTip(fieldTip);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operatekey = afterDoOperationEventArgs.getOperateKey();
        if ("submit".equals(operatekey) || "save".equals(operatekey) || "audit".equals(operatekey)) {
            this.getModel().beginInit();
            this.queryMetaDataInfo();
            this.queryFilterDataInfo();
            this.getModel().endInit();
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        this.getModel().beginInit();
        this.queryMetaDataInfo();
        this.queryFilterDataInfo();
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
    }

    private String buildFilterDesc(DynamicObject resource) {
        String filterStringDesc;
        String filters = resource.getString("filter_tag");
        String number = resource.getString("billfieldtransfer.srcbill.number");
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filters, FilterCondition.class);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)number);
        FilterBuilder fb = new FilterBuilder(mainType, filterCondition, false);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        String string = filterStringDesc = fb.getFilterString() == null ? "" : fb.getFilterString();
        if (filterStringDesc.length() > 1024) {
            filterStringDesc = filterStringDesc.substring(0, 1000);
            filterStringDesc = filterStringDesc + "...";
        }
        return filterStringDesc;
    }

    private DynamicObject loadResourceData(Object pk) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"mrp_resource_dataconf_rgt");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String type;
        String fieldKey = evt.getProperty().getName();
        QFilter qFilter = null;
        if (FIELD_RESOURCE.equals(fieldKey)) {
            DynamicObject businessentity = (DynamicObject)this.getModel().getValue(FIELD_BUSINESSENTITY);
            if (businessentity != null) {
                qFilter = new QFilter("billfieldtransfer.destbill.id", "=", businessentity.getPkValue());
                DynamicObjectCollection collection = this.getModel().getEntryEntity(RESOURCEENTITY);
                if (collection.size() > 0) {
                    Set resources = collection.stream().map(o -> o.getLong("resource.id")).filter(o -> o > 0L).collect(Collectors.toSet());
                    qFilter.and("id", "not in", resources);
                }
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if (FIELD_BUSINESSENTITY.equals(fieldKey) && "1".equals(type = String.valueOf(this.getModel().getValue("type")))) {
            qFilter = new QFilter("number", "=", (Object)"mds_stockupstatus");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void queryFilterDataInfo() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(RESOURCEENTITY);
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject row = this.getModel().getEntryRowEntity(RESOURCEENTITY, i);
            DynamicObject resource = null;
            if (row != null) {
                resource = row.getDynamicObject("resource");
            }
            if (resource != null) {
                resource = this.loadResourceData(resource.getPkValue());
                String filterStringDesc = this.buildFilterDesc(resource);
                this.getModel().setValue(FIELD_FILTERDESC, (Object)filterStringDesc, i);
                this.getModel().setValue(FIELD_BILLFIELDTRANSFER, resource.get("billfieldtransfer"), i);
                continue;
            }
            this.getModel().setValue(FIELD_FILTERDESC, (Object)"", i);
        }
        this.getView().updateView(RESOURCEENTITY);
    }

    private void queryMetaDataInfo() {
        Map allFields;
        Object businessentity = this.getModel().getValue(FIELD_BUSINESSENTITY);
        if (businessentity == null) {
            return;
        }
        this.getModel().deleteEntryData(FIELDINFOENTITY);
        MainEntityType dataEntityType = this.getMainEntityType(FIELD_BUSINESSENTITY);
        if (dataEntityType != null && (allFields = dataEntityType.getAllFields()) != null && allFields.size() > 0) {
            this.getModel().batchCreateNewEntryRow(FIELDINFOENTITY, allFields.size());
            int rowIndex = 0;
            for (String field : allFields.keySet()) {
                this.buildRow(dataEntityType, rowIndex, field);
                ++rowIndex;
            }
        }
        this.getView().updateView(FIELDINFOENTITY);
    }

    private MainEntityType getMainEntityType(String entityname) {
        DynamicObject accEntity = (DynamicObject)this.getModel().getValue(entityname);
        if (accEntity != null) {
            Object billentityPkValue = accEntity.getPkValue();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billentityPkValue.toString());
            return dataEntityType;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5c5e\u4e8e\u5b9e\u4f53F7\u7c7b\u578b\u7684\u5b57\u6bb5", (String)"ResourceRegisterPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]), entityname));
    }

    private void buildRow(MainEntityType dataEntityType, int rowIndex, String signid) {
        DynamicProperty findProperty = (DynamicProperty)dataEntityType.findProperty(signid);
        this.getModel().setValue(FIELD_SIGNID, (Object)signid, rowIndex);
        if (findProperty.getParent() instanceof EntryType) {
            EntryType entry = (EntryType)findProperty.getParent();
            this.getModel().setValue(FIELD_SIGNID, (Object)(entry.getName() + '.' + signid), rowIndex);
        } else {
            this.getModel().setValue(FIELD_SIGNID, (Object)signid, rowIndex);
        }
        LocaleString signName = findProperty.getDisplayName();
        this.getModel().setValue(FIELD_SIGNNAME, (Object)signName, rowIndex);
        Object defaultValue = findProperty.getDefaultValue();
        if (StringUtils.isNotBlank((Object)defaultValue)) {
            this.getModel().setValue(FIELD_DEFAULTVALUE, defaultValue, rowIndex);
        }
        String dataType = MDSUtils.getMetaDataFieldType((DynamicProperty)findProperty);
        this.getModel().setValue(FIELD_DATATYPE, (Object)dataType, rowIndex);
    }

    private boolean checkResourceEntityIsNotEmpty() {
        DynamicObjectCollection entryentityds = this.getModel().getEntryEntity(RESOURCEENTITY);
        if (entryentityds != null && !entryentityds.isEmpty()) {
            return entryentityds.stream().anyMatch(p -> p.getDynamicObject(FIELD_RESOURCE) != null);
        }
        return false;
    }
}

