/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SiteBaseDataEditPlugin
extends AbstractFormPlugin {
    private static Map<String, String> tabMap = new HashMap<String, String>();
    private static final String STOCKSETUP = "stocksetup";
    private static final String STOCKSETUPENTRY = "stocksetupentry";
    private static final String STOCKNUMBER = "stocknumber";
    private static final String WAREHOUSE = "warehousetext";
    private static final String SEQ = "seq";
    private static final String ADDRESS = "fullname";
    private static final String BAR_ENABLE = "bar_enable";
    private static final String BAR_DISABLE = "bar_disable";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_DISABLE = "disable";

    public void afterCreateNewData(EventObject e) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("supplytype", new Object[0]);
        vs.addField("isselected", new Object[0]);
        vs.addRow(new Object[]{"A", false});
        vs.addRow(new Object[]{"B", false});
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.getModel().updateCache();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"addsetup", "deletesetup"});
    }

    public void afterBindData(EventObject e) {
        this.initTabStatus();
        this.initInvBase();
        this.initWareText();
        this.initStockMust();
        this.setViewStyle(this.getModel().getValue(KEY_ENABLE) + "");
    }

    private void initTabStatus() {
        DynamicObjectCollection colls = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : colls) {
            String supplytype = obj.getString("supplytype");
            boolean isselected = obj.getBoolean("isselected");
            String fieldkeys = tabMap.get(supplytype);
            if (fieldkeys == null) continue;
            Container flex1 = (Container)this.getControl(fieldkeys);
            flex1.setCollapse(!isselected);
        }
    }

    private void initStockMust() {
        EntryGrid grid = (EntryGrid)this.getControl(STOCKSETUPENTRY);
        String value = (String)this.getModel().getValue(STOCKSETUP);
        if ("2".equals(value) || "3".equals(value)) {
            this.setStockIsMust(grid, STOCKSETUPENTRY, STOCKNUMBER, true);
            this.setStockIsMust(grid, STOCKSETUPENTRY, "stockorg", true);
        } else {
            this.setStockIsMust(grid, STOCKSETUPENTRY, STOCKNUMBER, false);
            this.setStockIsMust(grid, STOCKSETUPENTRY, "stockorg", false);
        }
        this.getModel().setDataChanged(false);
    }

    private void setStockIsMust(EntryGrid grid, String entityname, String fieldname, boolean flag) {
        IFormView view = grid.getView();
        int rowcount = this.getModel().getEntryRowCount(entityname);
        for (int i = 0; i < rowcount; ++i) {
            view.setEnable(Boolean.valueOf(flag), i, new String[]{fieldname});
        }
        grid.setMustInput(fieldname, flag);
    }

    private void initWareText() {
        String value = (String)this.getModel().getValue(STOCKSETUP);
        if ("2".equals(value) || "3".equals(value)) {
            DynamicObjectCollection coll = this.getModel().getEntryEntity(STOCKSETUPENTRY);
            for (DynamicObject ware : coll) {
                DynamicObject stock = ware.getDynamicObject(STOCKNUMBER);
                this.setWareText(stock, WAREHOUSE, ware.getInt(SEQ) - 1);
                this.getModel().setDataChanged(false);
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"addsetup", "deletesetup"});
        }
    }

    private void setWareText(DynamicObject ware, String fieldname, int index) {
        if (ware != null && ware.get("address") != null) {
            QFilter filter = new QFilter("id", "=", (Object)ware.getLong("address"));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_admindivision", (String)ADDRESS, (QFilter[])new QFilter[]{filter});
            if (!dynamicObjects.isEmpty()) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
                String adminName = dynamicObject.getString(ADDRESS);
                this.getModel().setValue(fieldname, (Object)adminName, index);
            }
        } else {
            this.getModel().setValue(fieldname, null, index);
        }
    }

    private void initInvBase() {
        QFilter typefilter = new QFilter(KEY_ENABLE, "=", (Object)"1");
        QFilter statusfilter = new QFilter(KEY_ENABLE, "=", (Object)"1");
        DynamicObjectCollection stockstype = QueryServiceHelper.query((String)"bd_invtype", (String)"id,number", (QFilter[])new QFilter[]{typefilter}, (String)"number asc");
        DynamicObjectCollection statustype = QueryServiceHelper.query((String)"bd_invstatus", (String)"id,number", (QFilter[])new QFilter[]{statusfilter}, (String)"number asc");
        EntryGrid statusgrid = (EntryGrid)this.getView().getControl("stockstatusentity");
        EntryGrid typegrid = (EntryGrid)this.getView().getControl("stockstypeentity");
        this.batchCreateEntryRows(statusgrid, typegrid, stockstype, statustype);
        this.setEntryValue(statusgrid, typegrid, stockstype, statustype);
        this.getModel().setDataChanged(false);
    }

    private void batchCreateEntryRows(EntryGrid statusgrid, EntryGrid typegrid, DynamicObjectCollection stockstype, DynamicObjectCollection statustype) {
        int statussize = this.getModel().getEntryRowCount("stockstatusentity");
        int typesize = this.getModel().getEntryRowCount("stockstypeentity");
        if (statussize < statustype.size()) {
            statusgrid.getModel().batchCreateNewEntryRow("stockstatusentity", statustype.size() - statussize);
        }
        if (typesize < stockstype.size()) {
            typegrid.getModel().batchCreateNewEntryRow("stockstypeentity", stockstype.size() - typesize);
        }
    }

    private void setEntryValue(EntryGrid statusgrid, EntryGrid typegrid, DynamicObjectCollection stockstype, DynamicObjectCollection statustype) {
        this.setEntryGridValue(statusgrid, "stocktype", stockstype);
        this.setEntryGridValue(typegrid, "stocktype1", statustype);
        statusgrid.setPageIndex(1);
        typegrid.setPageIndex(1);
    }

    private void setEntryGridValue(EntryGrid grid, String dyncolumn, DynamicObjectCollection collection) {
        Iterator its = collection.iterator();
        int row = 0;
        while (its.hasNext()) {
            Object id = ((DynamicObject)its.next()).get("id");
            grid.getModel().setValue(dyncolumn, id, row++);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propname = e.getProperty().getName();
        if ("isselected".equals(propname)) {
            String[] fieldkeys;
            boolean isSelected = (Boolean)e.getChangeSet()[0].getNewValue();
            String supptype = e.getChangeSet()[0].getDataEntity().getString("supplytype");
            for (String fieldkey : fieldkeys = tabMap.get(supptype).split(";")) {
                Container flex1 = (Container)this.getControl(fieldkey);
                flex1.setCollapse(!isSelected);
            }
            if ("B".equals(supptype)) {
                BasedataEdit transactproduct = (BasedataEdit)this.getControl("transactproduct");
                if (isSelected) {
                    transactproduct.setMustInput(true);
                } else {
                    transactproduct.setMustInput(false);
                }
            } else if ("C".equals(supptype)) {
                BasedataEdit dpsversion = (BasedataEdit)this.getControl("dpsversion");
                if (!isSelected) {
                    dpsversion.setMustInput(false);
                }
            }
        } else if (STOCKSETUP.equals(propname)) {
            String value = (String)this.getModel().getValue(STOCKSETUP);
            if (!"1".equals(value)) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"addsetup", "deletesetup"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"addsetup", "deletesetup"});
                this.getModel().deleteEntryData(STOCKSETUPENTRY);
            }
            this.initStockMust();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)KEY_DISABLE, (CharSequence)operateKey)) {
            this.setViewStyle("0");
        }
        if (StringUtils.equals((CharSequence)KEY_ENABLE, (CharSequence)operateKey)) {
            this.setViewStyle("1");
        }
        super.afterDoOperation(args);
    }

    private void setViewStyle(String type) {
        if ("0".equals(type)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_ENABLE});
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_DISABLE});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_ENABLE});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
        }
    }

    static {
        tabMap.put("A", "flexstockstypeentity");
        tabMap.put("B", "flexwip");
        tabMap.put("C", "flexdps");
    }
}

