/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.algorithmdef;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mmc.mds.common.algorithm.util.ResourceFieldUtil;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;

public class AlgorithmDefEditPlugin
extends AbstractBasePlugIn {
    private static final String SRCBILL = "srcbill";
    private static final String DESTBILL = "destbill";
    private static final String ENTRYENTITYSRC = "entryentitysrc";
    private static final String CALDIMENSIONSRC = "caldimensionsrc";
    private static final String CALDIMENSIONVALSRC = "caldimensionvalsrc";
    private static final String FIELDIDSRC = "fieldidsrc";
    private static final String FIELDNAMESRC = "fieldnamesrc";
    private static final String CALMETHODSRC = "calmethodsrc";
    private static final String CALCULATEEXCSRC_TAG = "calculateexcsrc_tag";
    private static final String CALCULATEEXCSRC = "calculateexcsrc";
    private static final String CALCULATETEXTSRC = "calculatetextsrc";
    private static final String DESCRIBESRC = "describesrc";
    private static final String ENTRYENTITYDEST = "entryentitydest";
    private static final String CALDIMENSIONDEST = "caldimensiondest";
    private static final String CALDIMENSIONVALDEST = "caldimensionvaldest";
    private static final String FIELDIDDEST = "fieldiddest";
    private static final String FIELDNAMEDEST = "fieldnamedest";
    private static final String CALMETHODDEST = "calmethoddest";
    private static final String CALCULATEEXCDEST_TAG = "calculateexcdest_tag";
    private static final String CALCULATEEXCDEST = "calculateexcdest";
    private static final String CALCULATETEXTDEST = "calculatetextdest";
    private static final String DESCRIBEDEST = "describedest";
    private static final String CACHE_SRCBILL_CAL = "cache_srcbilltree_cal";
    private static final String CALLBACK_CALTEXT_SRC = "caltextcallback_src";
    private static final String CALLBACK_CALTEXT_DEST = "caltextcallback_dest";
    private static final String CustParamKey_Formula = "formula";
    private static final String CustParamKey_TreeNodes = "treenodes";
    private static final String CustParamKey_EntityNumber = "entitynumber";
    private static final String FormId_Formula = "mds_algorithm_formula";
    private static final String CACHE_DESTBILL = "cache_destbilltree";
    private static final String CALLBACK_DESTFIELD_SRC = "destfieldcallback_src";
    private static final String CALLBACK_DESTFIELD_DEST = "destfieldcallback_dest";
    private static final String FORMID_SELECTFIELD = "mds_billfieldselect";
    private static final String CUSTPARAM_TREENODES = "treenodes";
    private static final String MDS_CALDIMENSION = "mds_caldimension";
    private static final String CALLBACK_CALDIMENSION_SRC = "caldimensionsrc";
    private static final String CALLBACK_CALDIMENSION_DEST = "caldimensiondest";
    private static final String MDS_CALCULATEPLUGIN = "mds_calculateplugin";
    private static final String[] supportMethod = new String[]{"count", "sum", "max", "min", "avg"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"caldimensionsrc", "caldimensiondest", FIELDNAMESRC, FIELDNAMEDEST, CALCULATETEXTSRC, CALCULATETEXTDEST});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int row = changeData[0].getRowIndex();
        switch (key) {
            case "srcbill": {
                this.getModel().deleteEntryData(ENTRYENTITYSRC);
                break;
            }
            case "destbill": {
                this.getModel().deleteEntryData(ENTRYENTITYDEST);
                this.getModel().deleteEntryData(ENTRYENTITYSRC);
                break;
            }
            case "caldimensionsrc": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().setValue(CALDIMENSIONVALSRC, (Object)"", row);
                break;
            }
            case "fieldnamesrc": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().setValue(FIELDIDSRC, (Object)"", row);
                break;
            }
            case "fieldnamedest": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().setValue(FIELDIDDEST, (Object)"", row);
                break;
            }
            case "calculatetextsrc": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().setValue(CALCULATEEXCSRC, (Object)"", row);
                this.getModel().setValue(CALCULATEEXCSRC_TAG, (Object)"", row);
                break;
            }
            case "calculatetextdest": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().setValue(CALCULATEEXCDEST_TAG, (Object)"", row);
                this.getModel().setValue(CALCULATEEXCDEST, (Object)"", row);
                break;
            }
            case "calmethodsrc": {
                this.getModel().setValue(CALCULATETEXTSRC, (Object)"", row);
                this.getModel().setValue(CALCULATEEXCSRC_TAG, (Object)"", row);
                break;
            }
            case "calmethoddest": {
                this.getModel().setValue(CALCULATETEXTDEST, (Object)"", row);
                this.getModel().setValue(CALCULATEEXCDEST_TAG, (Object)"", row);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        List<String> propertiesSrc = Arrays.asList(CALDIMENSIONVALSRC, CALCULATEEXCSRC, CALCULATEEXCSRC_TAG, DESCRIBESRC);
        ProbabilityUtil.setBizChanged((DynamicObject)dataEntity, (String)ENTRYENTITYSRC, propertiesSrc);
        List<String> propertiesDest = Arrays.asList(CALDIMENSIONVALDEST, CALCULATEEXCDEST, CALCULATEEXCDEST_TAG, DESCRIBEDEST);
        ProbabilityUtil.setBizChanged((DynamicObject)dataEntity, (String)ENTRYENTITYDEST, propertiesDest);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save || e.getSource() instanceof Submit) {
            DynamicObjectCollection entryentitydest;
            List<String> fieldidDestList;
            DynamicObjectCollection entryentitysrc = this.getModel().getEntryEntity(ENTRYENTITYSRC);
            List<String> fieldidSrcList = this.getRepeatField(entryentitysrc, FIELDIDSRC, FIELDNAMESRC);
            if (fieldidSrcList != null && !fieldidSrcList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u76ee\u6807\u5b57\u6bb5\u4e0d\u5141\u8bb8\u91cd\u590d\uff1a%s\u3002", (String)"AlgorithmDefEditPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), fieldidSrcList));
                e.setCancel(true);
            }
            if ((fieldidDestList = this.getRepeatField(entryentitydest = this.getModel().getEntryEntity(ENTRYENTITYDEST), FIELDIDDEST, FIELDNAMEDEST)) != null && !fieldidDestList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u76ee\u6807\u5b57\u6bb5\u4e0d\u5141\u8bb8\u91cd\u590d\uff1a%s\u3002", (String)"AlgorithmDefEditPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]), fieldidDestList));
                e.setCancel(true);
            }
            List srcList = entryentitydest.stream().filter(f -> StringUtils.isNotEmpty((CharSequence)f.getString(FIELDIDDEST))).map(m -> m.getString(FIELDNAMEDEST).concat("(").concat(m.getString(FIELDIDDEST)).concat(")")).collect(Collectors.toList());
            Set repeatSet = entryentitysrc.stream().map(m -> m.getString(FIELDNAMESRC).concat("(").concat(m.getString(FIELDIDSRC)).concat(")")).filter(f -> StringUtils.isNotEmpty((CharSequence)f) && srcList.contains(f)).collect(Collectors.toSet());
            if (!repeatSet.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6765\u6e90\u548c\u76ee\u6807\u5355\u636e\u5b57\u6bb5\u4e0d\u5141\u8bb8\u91cd\u590d\uff1a%s\u3002", (String)"AlgorithmDefEditPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]), repeatSet));
                e.setCancel(true);
            }
        }
    }

    private List<String> getRepeatField(DynamicObjectCollection entryentity, String field, String fieldName) {
        if (entryentity.isEmpty() || StringUtils.isEmpty((CharSequence)field)) {
            return null;
        }
        Map<String, Long> map = entryentity.stream().filter(f -> StringUtils.isNotEmpty((CharSequence)f.getString(field))).map(m -> m.getString(fieldName).concat("(").concat(m.getString(field).concat(")"))).collect(Collectors.groupingBy(m -> m, Collectors.counting()));
        return map.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public void click(EventObject evt) {
        super.click(evt);
        TextEdit textEdit = (TextEdit)evt.getSource();
        String key = textEdit.getKey();
        String entryKey = textEdit.getEntryKey();
        int row = this.getModel().getEntryCurrentRowIndex(entryKey);
        if ("caldimensionsrc".equals(key) || "caldimensiondest".equals(key)) {
            this.openCaldimensionView(row, key);
        } else if (FIELDNAMESRC.equals(key) || FIELDNAMEDEST.equals(key)) {
            this.openSrcBillFieldList(key);
        } else if (CALCULATETEXTSRC.equals(key) || CALCULATETEXTDEST.equals(key)) {
            String calmethod = "";
            calmethod = CALCULATETEXTSRC.equals(key) ? (String)this.getModel().getValue(CALMETHODSRC, row) : (String)this.getModel().getValue(CALMETHODDEST, row);
            if ("0".equals(calmethod)) {
                this.openCalBillFieldView(row, key);
            } else if ("1".equals(calmethod)) {
                this.openCalMethodView(row, key);
            }
        }
    }

    private void openSrcBillFieldList(String fieldKey) {
        MainEntityType billMainType = this.getMainEntityType(DESTBILL);
        if (billMainType == null) {
            return;
        }
        String custumparam = CALLBACK_DESTFIELD_SRC;
        if (FIELDNAMEDEST.equals(fieldKey)) {
            custumparam = CALLBACK_DESTFIELD_DEST;
        }
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(billMainType);
        parameter.setIncludePKField(false);
        parameter.setOnlyPhysicsField(true);
        String nodesJson = this.getPageCache().get(CACHE_SRCBILL_CAL);
        if (StringUtils.isBlank((CharSequence)nodesJson)) {
            TreeNode destBillNode = ResourceFieldUtil.buildCalTreeNodes((BillTreeBuildParameter)parameter);
            nodesJson = SerializationUtils.toJsonString((Object)destBillNode);
            this.getPageCache().put(CACHE_DESTBILL, nodesJson);
            this.showBillFieldForm(nodesJson, custumparam);
        } else {
            this.showBillFieldForm(nodesJson, custumparam);
        }
    }

    private void showBillFieldForm(String nodesJson, String callBackActionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void openCalBillFieldView(int row, String fieldKey) {
        String nodesJson = this.getPageCache().get(fieldKey);
        MainEntityType billMainType = null;
        String formula = "";
        String sourceCtrlKey = CALLBACK_CALTEXT_SRC;
        if (CALCULATETEXTSRC.equals(fieldKey)) {
            billMainType = this.getMainEntityType(SRCBILL);
            formula = (String)this.getModel().getValue(CALCULATEEXCSRC_TAG, row);
        } else {
            sourceCtrlKey = CALLBACK_CALTEXT_DEST;
            billMainType = this.getMainEntityType(DESTBILL);
            formula = (String)this.getModel().getValue(CALCULATEEXCDEST_TAG, row);
        }
        if (billMainType == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)formula)) {
            CRFormula crFormula = new CRFormula();
            formula = SerializationUtils.toJsonString((Object)crFormula);
        }
        if (StringUtils.isBlank((CharSequence)nodesJson)) {
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(billMainType);
            parameter.setIncludePKField(true);
            TreeNode billTreeNode = ResourceFieldUtil.buildCalTreeNodes((BillTreeBuildParameter)parameter);
            nodesJson = SerializationUtils.toJsonString((Object)billTreeNode);
            this.getPageCache().put(fieldKey, nodesJson);
            this.showFormulaForm(formula, billMainType.getName(), nodesJson, sourceCtrlKey);
        } else {
            this.showFormulaForm(formula, billMainType.getName(), nodesJson, sourceCtrlKey);
        }
    }

    private void openCalMethodView(int row, String fieldKey) {
        Object describe = null;
        Object calculateexc_tag = null;
        if (CALCULATETEXTSRC.equals(fieldKey)) {
            describe = this.getModel().getValue(DESCRIBESRC, row);
            calculateexc_tag = this.getModel().getValue(CALCULATEEXCSRC_TAG, row);
        } else {
            describe = this.getModel().getValue(DESCRIBEDEST, row);
            calculateexc_tag = this.getModel().getValue(CALCULATEEXCDEST_TAG, row);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(MDS_CALCULATEPLUGIN);
        showParameter.getCustomParams().put("describe", describe);
        showParameter.getCustomParams().put("expression", calculateexc_tag);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void openCaldimensionView(int row, String fieldKey) {
        DynamicObject bill = null;
        String caldimension = "caldimensionsrc";
        Object fieldKeyValues = null;
        if ("caldimensionsrc".equals(fieldKey)) {
            bill = (DynamicObject)this.getModel().getValue(SRCBILL);
            if (bill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ed9\u6765\u6e90\u5355\u636e\u8d4b\u503c\u3002", (String)"AlgorithmDefEditPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return;
            }
            fieldKeyValues = this.getModel().getValue(CALDIMENSIONVALSRC, row);
        } else {
            bill = (DynamicObject)this.getModel().getValue(DESTBILL);
            if (bill == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ed9\u76ee\u6807\u5355\u636e\u8d4b\u503c\u3002", (String)"AlgorithmDefEditPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return;
            }
            caldimension = "caldimensiondest";
            fieldKeyValues = this.getModel().getValue(CALDIMENSIONVALDEST, row);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(MDS_CALDIMENSION);
        showParameter.getCustomParams().put("entityId", bill.getPkValue());
        showParameter.getCustomParams().put("fieldKeyValues", fieldKeyValues);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, caldimension));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private MainEntityType getMainEntityType(String entityname) {
        DynamicObject accEntity = (DynamicObject)this.getModel().getValue(entityname);
        if (accEntity != null) {
            Object billentityPkValue = accEntity.getPkValue();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billentityPkValue.toString());
            return dataEntityType;
        }
        if (DESTBILL.equals(entityname)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ed9\u76ee\u6807\u5355\u636e\u8d4b\u503c\u3002", (String)"AlgorithmDefEditPlugin_5", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ed9\u6765\u6e90\u5355\u636e\u8d4b\u503c\u3002", (String)"AlgorithmDefEditPlugin_6", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        }
        return null;
    }

    private void showFormulaForm(String formulaJson, String entityNumber, String fieldNodes, String callBackActionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormId_Formula);
        showParameter.getCustomParams().put(CustParamKey_Formula, formulaJson);
        showParameter.getCustomParams().put(CustParamKey_EntityNumber, entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = ResourceFieldUtil.getFuncsXML((String[])supportMethod);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.isBlank((Object)returnData)) {
            return;
        }
        int rowSrc = this.getModel().getEntryCurrentRowIndex(ENTRYENTITYSRC);
        int rowDest = this.getModel().getEntryCurrentRowIndex(ENTRYENTITYDEST);
        if (returnData instanceof String) {
            String jsonString = (String)returnData;
            if (CALLBACK_CALTEXT_SRC.equals(actionId) || CALLBACK_CALTEXT_DEST.equals(actionId)) {
                CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)jsonString, CRFormula.class);
                if (CALLBACK_CALTEXT_SRC.equals(actionId)) {
                    this.getModel().setValue(CALCULATEEXCSRC, (Object)formula.getExpression(), rowSrc);
                    this.getModel().setValue(CALCULATEEXCSRC_TAG, (Object)jsonString, rowSrc);
                    this.getModel().setValue(CALCULATETEXTSRC, (Object)formula.getExprDesc(), rowSrc);
                }
                if (CALLBACK_CALTEXT_DEST.equals(actionId)) {
                    this.getModel().setValue(CALCULATEEXCDEST, (Object)formula.getExpression(), rowDest);
                    this.getModel().setValue(CALCULATEEXCDEST_TAG, (Object)jsonString, rowDest);
                    this.getModel().setValue(CALCULATETEXTDEST, (Object)formula.getExprDesc(), rowDest);
                }
            }
            if (CALLBACK_DESTFIELD_SRC.equals(actionId) || CALLBACK_DESTFIELD_DEST.equals(actionId)) {
                MainEntityType srcbillMainType = this.getMainEntityType(DESTBILL);
                String fieldCaption = ResourceFieldUtil.buildPropFullCaption((EntityType)srcbillMainType, (String)jsonString);
                if (CALLBACK_DESTFIELD_SRC.equals(actionId)) {
                    this.getModel().setValue(FIELDIDSRC, (Object)jsonString, rowSrc);
                    this.getModel().setValue(FIELDNAMESRC, (Object)fieldCaption, rowSrc);
                }
                if (CALLBACK_DESTFIELD_DEST.equals(actionId)) {
                    this.getModel().setValue(FIELDIDDEST, (Object)jsonString, rowDest);
                    this.getModel().setValue(FIELDNAMEDEST, (Object)fieldCaption, rowDest);
                }
            }
        } else if (returnData instanceof Map) {
            Map params = (Map)returnData;
            if ("caldimensionsrc".equals(actionId) || "caldimensiondest".equals(actionId)) {
                String keys = String.join((CharSequence)",", params.keySet());
                String values = String.join((CharSequence)",", params.values());
                if ("caldimensionsrc".equals(actionId)) {
                    this.getModel().setValue("caldimensionsrc", (Object)values, rowSrc);
                    this.getModel().setValue(CALDIMENSIONVALSRC, (Object)keys, rowSrc);
                }
            }
            if (CALCULATETEXTSRC.equals(actionId) || CALCULATETEXTDEST.equals(actionId)) {
                String expression = (String)params.get("expression");
                String describe = (String)params.get("describe");
                if (CALCULATETEXTSRC.equals(actionId)) {
                    this.getModel().setValue(DESCRIBESRC, (Object)describe);
                    this.getModel().setValue(CALCULATEEXCSRC, (Object)expression);
                    this.getModel().setValue(CALCULATEEXCSRC_TAG, (Object)expression);
                    if (StringUtils.isEmpty((CharSequence)describe)) {
                        this.getModel().setValue(CALCULATETEXTSRC, (Object)expression);
                    } else {
                        this.getModel().setValue(CALCULATETEXTSRC, (Object)describe);
                    }
                }
                if (CALCULATETEXTDEST.equals(actionId)) {
                    this.getModel().setValue(DESCRIBEDEST, (Object)describe);
                    this.getModel().setValue(CALCULATEEXCDEST, (Object)expression);
                    this.getModel().setValue(CALCULATEEXCDEST_TAG, (Object)expression);
                    if (StringUtils.isEmpty((CharSequence)describe)) {
                        this.getModel().setValue(CALCULATETEXTDEST, (Object)expression);
                    } else {
                        this.getModel().setValue(CALCULATETEXTDEST, (Object)describe);
                    }
                }
            }
        }
    }
}

