/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.algorithmdef;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mmc.mds.common.algorithm.util.ResourceFieldUtil;

public class CaldimensionEditPlugin
extends AbstractFormPlugin
implements F7SelectedListRemoveListener,
RowClickEventListener,
SearchEnterListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String SEQ = "seq";
    private static final String FIELDNAME = "fieldname";
    private static final String FIELDID = "fieldid";
    private static final String FIELDTYPE = "fieldtype";
    private static final String BILLNUMBER = "billnumber";
    private static final String BILLNAME = "billname";
    private static final String F7SELECTEDLISTAP = "f7selectedlistap";
    private static final String SEARCHAP = "searchap";
    private static final String BTNOK = "btnok";
    private static final String BOS_ENTITYOBJECT = "bos_entityobject";
    private static DynamicObjectCollection dyCollection;

    public void registerListener(EventObject e) {
        Search serach;
        EntryGrid entryentity;
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
        if (f7SelectedList != null) {
            f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
            f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        }
        if ((entryentity = (EntryGrid)this.getControl(ENTRYENTITY)) != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
        if ((serach = (Search)this.getControl(SEARCHAP)) != null) {
            serach.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        Label labelap;
        String fieldKeyValues;
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        Object entityId = parameterParams.get("entityId");
        if (entityId != null) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(entityId, (String)BOS_ENTITYOBJECT);
            this.initEntryentity(dynamicObject);
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
            dyCollection = (DynamicObjectCollection)entrys.clone();
        }
        if (StringUtils.isNotEmpty((CharSequence)(fieldKeyValues = (String)parameterParams.get("fieldKeyValues")))) {
            this.selectEntryentityRows(fieldKeyValues);
        }
        if ("mds_probabilitycaldef".equals(this.getView().getParentView().getEntityId()) && (labelap = (Label)this.getControl("labelap")) != null) {
            labelap.setText(ResManager.loadKDString((String)"\u6570\u636e\u9009\u62e9\u7ef4\u5ea6", (String)"CaldimensionEditPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        this.initF7selectedlistap();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(16);
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            String values = this.getPageCache().get("valueTextItems");
            if (StringUtils.isNotEmpty((CharSequence)values)) {
                List valueTextItems = JSON.parseArray((String)values, ValueTextItem.class);
                for (ValueTextItem valueTextItem : valueTextItems) {
                    params.put(valueTextItem.getValue(), valueTextItem.getText());
                }
            }
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    private void initEntryentity(DynamicObject entity) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        Object o = parameterParams.get("showList");
        List list = null;
        if (o instanceof List) {
            list = (List)o;
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)((String)entity.getPkValue()));
        if (dataEntityType != null) {
            Map allFields = dataEntityType.getAllFields();
            if (allFields != null && allFields.size() > 0) {
                Collection<Object> fieldColl = allFields.keySet();
                if (list != null && list.size() > 0) {
                    fieldColl = list;
                }
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, fieldColl.size());
                int rowIndex = 0;
                for (String string : fieldColl) {
                    this.buildRow(dataEntityType, rowIndex, string, entity);
                    ++rowIndex;
                }
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private void buildRow(MainEntityType dataEntityType, int rowIndex, String field, DynamicObject entity) {
        DynamicProperty findProperty = (DynamicProperty)dataEntityType.findProperty(field);
        this.getModel().setValue(FIELDID, (Object)field, rowIndex);
        if (findProperty.getParent() instanceof EntryType) {
            EntryType entry = (EntryType)findProperty.getParent();
            this.getModel().setValue(FIELDID, (Object)(entry.getName() + '.' + field), rowIndex);
        } else {
            this.getModel().setValue(FIELDID, (Object)field, rowIndex);
        }
        LocaleString displayName = findProperty.getDisplayName();
        this.getModel().setValue(FIELDNAME, (Object)displayName, rowIndex);
        String dataType = ResourceFieldUtil.getMetaDataFieldType((DynamicProperty)findProperty);
        this.getModel().setValue(FIELDTYPE, (Object)dataType, rowIndex);
        this.getModel().setValue(BILLNUMBER, (Object)entity.getString("number"), rowIndex);
        this.getModel().setValue(BILLNAME, (Object)entity.getString("name"), rowIndex);
    }

    public void RemoveClick(F7SelectedListRemoveEvent e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (e.getParam() == null) {
            entryGrid.clearEntryState();
            this.getPageCache().remove("valueTextItems");
        } else {
            String values;
            String param = (String)e.getParam();
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
            for (DynamicObject entry : entrys) {
                if (!StringUtils.equals((CharSequence)entry.getString(FIELDID), (CharSequence)param)) continue;
                List rows = Arrays.stream(entryGrid.getSelectRows()).boxed().collect(Collectors.toList());
                rows = rows.stream().filter(f -> entry.getInt(SEQ) - 1 != f).collect(Collectors.toList());
                entryGrid.selectRows(rows.stream().mapToInt(Integer::valueOf).toArray(), 0);
                break;
            }
            if (StringUtils.isNotEmpty((CharSequence)(values = this.getPageCache().get("valueTextItems")))) {
                List valueTextItems = JSON.parseArray((String)values, ValueTextItem.class);
                valueTextItems.removeIf(f -> StringUtils.equals((CharSequence)param, (CharSequence)f.getValue()));
                this.getPageCache().put("valueTextItems", JSON.toJSONString((Object)valueTextItems));
            }
        }
    }

    private void selectEntryentityRows(String fieldKeyValues) {
        String[] values = fieldKeyValues.split(",");
        List<String> list = Arrays.asList(values);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        for (DynamicObject entry : entrys) {
            if (!list.contains(entry.getString(FIELDID))) continue;
            selectRows.add(entry.getInt(SEQ) - 1);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.selectRows(selectRows.stream().mapToInt(Integer::valueOf).toArray(), 0);
        this.initF7selectedlistap();
    }

    private void initF7selectedlistap() {
        int[] rows;
        String values = this.getPageCache().get("valueTextItems");
        ArrayList<ValueTextItem> valueTextItems = null;
        if (StringUtils.isNotEmpty((CharSequence)values)) {
            valueTextItems = JSON.parseArray((String)values, ValueTextItem.class);
        }
        if (valueTextItems == null) {
            valueTextItems = new ArrayList<ValueTextItem>(16);
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7SELECTEDLISTAP);
        for (int i : rows = entryGrid.getSelectRows()) {
            String fileldis = ((DynamicObject)entrys.get(i)).getString(FIELDID);
            boolean isMatch = valueTextItems.stream().anyMatch(t -> StringUtils.equals((CharSequence)t.getValue(), (CharSequence)fileldis));
            if (isMatch) continue;
            ValueTextItem item = new ValueTextItem(((DynamicObject)entrys.get(i)).getString(FIELDID), ((DynamicObject)entrys.get(i)).getString(FIELDNAME));
            valueTextItems.add(item);
        }
        f7SelectedList.addItems(valueTextItems);
        this.getPageCache().put("valueTextItems", JSON.toJSONString(valueTextItems));
    }

    public void search(SearchEnterEvent e) {
        String searchText = e.getText();
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
            ArrayList<String> list = new ArrayList<String>(16);
            for (DynamicObject dy : entrys) {
                String fieldname = dy.getString(FIELDNAME);
                String fieldid = dy.getString(FIELDID);
                Pattern pattern = Pattern.compile(searchText);
                Matcher matcherFieldname = pattern.matcher(fieldname);
                Matcher matcherFieldid = pattern.matcher(fieldid);
                if (!matcherFieldname.find() && !matcherFieldid.find()) continue;
                list.add(fieldid);
            }
            this.buildEntryentity(entrys, list);
        } else {
            this.buildEntryentity(dyCollection, null);
        }
    }

    private void buildEntryentity(DynamicObjectCollection entrys, List<String> list) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (entrys == null || entrys.isEmpty()) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)entryGrid.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{FIELDID, FIELDNAME, FIELDTYPE, BILLNUMBER, BILLNAME});
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entrys.get(i);
            String fieldid = dynamicObject.getString(FIELDID);
            if (list != null && !list.contains(fieldid)) continue;
            String fieldname = dynamicObject.getString(FIELDNAME);
            String fieldtype = dynamicObject.getString(FIELDTYPE);
            String billnumber = dynamicObject.getString(BILLNUMBER);
            String billname = dynamicObject.getString(BILLNAME);
            vs.addRow(new Object[]{fieldid, fieldname, fieldtype, billnumber, billname});
        }
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (dyCollection != null) {
            dyCollection.clear();
        }
    }
}

