/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.algorithmdef;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEdit;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.func.FuncSettingHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.excel.FormulaException;

public class FormulaEditAlgorithmPlugIn
extends FormulaEdit {
    public void afterCreateNewData(EventObject e) {
        String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        CRFormula formulaObj = this.deserialize(conditonJson);
        this.setFormulaObj(formulaObj);
    }

    protected void setFormulaObj(CRFormula formulaObj) {
        this.getModel().setValue("fexpression", (Object)formulaObj.getExpression());
        this.getModel().setValue("fdescription", (Object)formulaObj.getDescription().toString());
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        this.getModel().setValue("ftranexpr", (Object)tranExpr);
    }

    protected String tranExpression(String expression) {
        if (this.checkIsCaseWhen(expression)) {
            return expression;
        }
        return super.tranExpression(expression);
    }

    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
            CRFormula formulaObj = this.deserialize(conditonJson);
            this.getFormulaObj(formulaObj);
            try {
                String expression = formulaObj.getExpression();
                if (this.checkIsCaseWhen(expression)) {
                    formulaObj.setExprTran(formulaObj.getExpression());
                } else {
                    String tranExpr = this.tranFormula(formulaObj);
                    formulaObj.setExprTran(tranExpr);
                }
            }
            catch (FormulaException var6) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FormulaEdit_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), var6.getCause() != null ? var6.getCause().getMessage() : var6.getMessage()));
                return;
            }
            catch (Exception var7) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FormulaEdit_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), var7.getMessage()));
                return;
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)"btnfunction")) {
            this.showFuncSetting();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)"clr")) {
            this.getModel().setValue("fexpression", (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)"fexpression", (int)0);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)"backspace")) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)"backspace", (String)"fexpression");
        } else {
            this.clickCompareButton(ctlSource.getKey());
        }
    }

    private void showFuncSetting() {
        String funcsXML = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML) && StringUtils.isBlank((CharSequence)(funcsXML = this.getPageCache().get("functiontypes")))) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        String jsonNode = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "btnfunction");
        FuncSettingHelper.show((String)funcsXML, (String)entityNumber, (String)jsonNode, null, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnequal": {
                compareValue = "=";
                break;
            }
            case "btnnotequal": {
                compareValue = "<>";
                break;
            }
            case "btnlessthen": {
                compareValue = "<";
                break;
            }
            case "btnmorethen": {
                compareValue = ">";
                break;
            }
            case "btnlessequal": {
                compareValue = "<=";
                break;
            }
            case "btnmoreequal": {
                compareValue = ">=";
                break;
            }
            case "btnand": {
                compareValue = "and";
                break;
            }
            case "btnor": {
                compareValue = "or";
                break;
            }
            case "btnleft": {
                compareValue = "(";
                break;
            }
            case "btnright": {
                compareValue = ")";
                break;
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)compareKey, (String)"fexpression", (String)compareValue);
        }
    }

    private boolean checkIsCaseWhen(String expression) {
        HashSet<String> keyWords = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)expression)) {
            String[] expres;
            expression = expression.replaceAll("\\s+", " ");
            for (String expre : expres = expression.split(" ")) {
                if ("case".equalsIgnoreCase(expre)) {
                    keyWords.add(expre);
                }
                if ("when".equalsIgnoreCase(expre)) {
                    keyWords.add(expre);
                }
                if ("then".equalsIgnoreCase(expre)) {
                    keyWords.add(expre);
                }
                if (!"end".equalsIgnoreCase(expre)) continue;
                keyWords.add(expre);
            }
        }
        return keyWords.size() >= 4;
    }
}

