/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class DpsArrangeSetEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String BAR_ENABLE = "bar_enable";
    private static final String BAR_DISABLE = "bar_disable";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_DISABLE = "disable";
    private static final String DELIVERYRADIOGROUP = "deliveryradiogroup";
    private static final String DELIVERYENTITY = "deliveryentity";
    private static final String STOCKTYPEENTITY = "stocktypeentity";
    private static final String CO_STOCKTYPE = "stocktype";
    private static final String CO_STOCKRADIOGROUP = "stockradiogroup";
    private static final String STOCKSTATUSENTITY = "stockstatusentity";
    private static final String CO_STOCKSTATUS = "stockstatus";
    private static final String STOCKENTITY = "stockentity";
    private static final String CO_STOCKORG = "stockorg";
    private static final String CO_STOCKNUMBER = "stocknumber";
    private static final String CO_STOCKINDEX = "stockindex";
    private static final String CO_WORKORDERRADIOGROUP = "workorderradiogroup";
    private static final String WORKORDERENTITY = "workorderentity";
    private static final String CO_ORDERUSEORG = "orderuseorg";
    private static final String CO_TRANSACTPRODUCT = "transactproduct";
    private static final String CO_TRANSACTPRODUCTNAME = "transactproductname";

    public void afterCreateNewData(EventObject e) {
        this.initDeliverySetting();
        this.initDeliveryMust();
        this.setTransTypeVisible();
        this.initStockSetting();
        this.initWorkorderSetting();
    }

    public void afterBindData(EventObject e) {
        String enable = (String)this.getModel().getValue(KEY_ENABLE);
        if (enable != null) {
            if ("0".equals(enable)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_ENABLE});
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_DISABLE});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_ENABLE});
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
            }
        }
        this.initDeliverySetting();
        this.initDeliveryMust();
        this.setTransTypeVisible();
        this.initStock();
        this.initStockSetting();
        this.initWorkorderSetting();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        int i;
        DynamicObject[] entryDatas;
        EntryGrid grid;
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)KEY_DISABLE, (CharSequence)operateKey)) {
            this.setViewStyle("0");
        }
        if (StringUtils.equals((CharSequence)KEY_ENABLE, (CharSequence)operateKey)) {
            this.setViewStyle("1");
        }
        if ("deliverydeleteentry".equals(operateKey)) {
            this.setTransTypeVisible();
        }
        if ("stocknewentry".equals(operateKey)) {
            grid = (EntryGrid)this.getControl(STOCKENTITY);
            entryDatas = grid.getEntryData().getDataEntitys();
            for (i = 0; i < entryDatas.length; ++i) {
                DynamicObject stocknumber;
                DynamicObject stockorg = entryDatas[i].getDynamicObject(CO_STOCKORG);
                if (stockorg == null) {
                    grid.getView().setEnable(Boolean.FALSE, i, new String[]{CO_STOCKNUMBER});
                }
                if ((stocknumber = entryDatas[i].getDynamicObject(CO_STOCKNUMBER)) != null) continue;
                grid.getView().setEnable(Boolean.FALSE, i, new String[]{CO_STOCKINDEX});
            }
        }
        if ("workordernewentry".equals(operateKey)) {
            grid = (EntryGrid)this.getControl(WORKORDERENTITY);
            entryDatas = grid.getEntryData().getDataEntitys();
            for (i = 0; i < entryDatas.length; ++i) {
                DynamicObject orderuseorg = entryDatas[i].getDynamicObject(CO_ORDERUSEORG);
                if (orderuseorg != null) continue;
                grid.getView().setEnable(Boolean.FALSE, i, new String[]{CO_TRANSACTPRODUCT});
            }
        }
    }

    private void setViewStyle(String type) {
        if ("0".equals(type)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_ENABLE});
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_DISABLE});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_ENABLE});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid grid = (EntryGrid)this.getControl(DELIVERYENTITY);
        IFormView view = grid.getView();
        BasedataEdit biztype = (BasedataEdit)view.getControl("biztype");
        BasedataEdit invscheme = (BasedataEdit)view.getControl("invscheme");
        BasedataEdit sopvrds = (BasedataEdit)this.getView().getControl("sopvrds");
        biztype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        invscheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        sopvrds.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit stockorg = (BasedataEdit)view.getControl(CO_STOCKORG);
        stockorg.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit stocknumber = (BasedataEdit)view.getControl(CO_STOCKNUMBER);
        stocknumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        stocknumber.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit stockindex = (BasedataEdit)view.getControl(CO_STOCKINDEX);
        stockindex.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orderuseorg = (BasedataEdit)view.getControl(CO_ORDERUSEORG);
        orderuseorg.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit transactproduct = (BasedataEdit)view.getControl(CO_TRANSACTPRODUCT);
        transactproduct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propname = e.getProperty().getName();
        if (DELIVERYRADIOGROUP.equals(propname)) {
            String value = (String)this.getModel().getValue(DELIVERYRADIOGROUP);
            if (!"1".equals(value)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"deliveryadd", "deliverydel"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"deliveryadd", "deliverydel"});
                this.getModel().deleteEntryData(DELIVERYENTITY);
            }
            this.initDeliveryMust();
        } else if ("billtype".equals(propname)) {
            ChangeData[] changeData = e.getChangeSet();
            if (changeData != null) {
                for (int i = 0; i < changeData.length; ++i) {
                    EntryGrid grid = (EntryGrid)this.getControl(DELIVERYENTITY);
                    IDataModel iDataModel = grid.getModel();
                }
            }
            this.setTransTypeVisible();
        } else if (CO_STOCKRADIOGROUP.equals(propname)) {
            this.initStockSetting();
        } else if (CO_WORKORDERRADIOGROUP.equals(propname)) {
            this.initWorkorderSetting();
        }
    }

    private void initStockSetting() {
        String value = (String)this.getModel().getValue(CO_STOCKRADIOGROUP);
        if (!"4".equals(value)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"stockadd", "stockdel"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"stockadd", "stockdel"});
            this.getModel().deleteEntryData(STOCKENTITY);
        }
        EntryGrid grid = (EntryGrid)this.getControl(STOCKENTITY);
        if ("5".equals(value) || "6".equals(value)) {
            this.setEntryIsMust(grid, STOCKENTITY, CO_STOCKNUMBER, true);
            this.setEntryIsMust(grid, STOCKENTITY, CO_STOCKORG, true);
        } else {
            this.setEntryIsMust(grid, STOCKENTITY, CO_STOCKNUMBER, false);
            this.setEntryIsMust(grid, STOCKENTITY, CO_STOCKORG, false);
        }
    }

    private void initWorkorderSetting() {
        String value = (String)this.getModel().getValue(CO_WORKORDERRADIOGROUP);
        if (!"7".equals(value)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"workorderadd", "workorderdel"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"workorderadd", "workorderdel"});
            this.getModel().deleteEntryData(WORKORDERENTITY);
        }
        EntryGrid grid = (EntryGrid)this.getControl(WORKORDERENTITY);
        if ("8".equals(value) || "9".equals(value)) {
            this.setEntryIsMust(grid, WORKORDERENTITY, CO_ORDERUSEORG, true);
            this.setEntryIsMust(grid, WORKORDERENTITY, CO_TRANSACTPRODUCT, true);
            this.setEntryIsMust(grid, WORKORDERENTITY, CO_TRANSACTPRODUCTNAME, true);
        } else {
            this.setEntryIsMust(grid, WORKORDERENTITY, CO_ORDERUSEORG, false);
            this.setEntryIsMust(grid, WORKORDERENTITY, CO_TRANSACTPRODUCT, false);
            this.setEntryIsMust(grid, WORKORDERENTITY, CO_TRANSACTPRODUCTNAME, false);
        }
    }

    private void setTransTypeVisible() {
        EntryGrid grid = (EntryGrid)this.getControl(DELIVERYENTITY);
        IDataModel dm = grid.getModel();
        boolean showTransType = false;
        IFormView view = grid.getView();
        int rowcount = this.getModel().getEntryRowCount(DELIVERYENTITY);
        for (int i = 0; i < rowcount; ++i) {
            DynamicObject delivery = dm.getEntryRowEntity(DELIVERYENTITY, i);
            String billtype = delivery.getString("billtype");
            if ("3".equals(billtype) || "4".equals(billtype)) {
                showTransType = true;
                view.setEnable(Boolean.TRUE, i, new String[]{"transtype"});
                continue;
            }
            view.setEnable(Boolean.FALSE, i, new String[]{"transtype"});
            dm.setValue("transtype", null, i);
        }
        view.setVisible(Boolean.valueOf(showTransType), new String[]{"transtype"});
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        Object source = arg0.getSource();
        if (source instanceof BasedataEdit) {
            DynamicObject stocknumber;
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            List<Object> qFilterList = new ArrayList(16);
            int row = arg0.getRow();
            String filedKey = ((BasedataEdit)source).getFieldKey();
            if ("biztype".equals(filedKey)) {
                DynamicObject delivery = this.getEntryEntity(row, DELIVERYENTITY);
                qFilterList = this.getBizTypeQfilters(delivery);
            } else if ("invscheme".equals(filedKey)) {
                DynamicObject delivery = this.getEntryEntity(row, DELIVERYENTITY);
                qFilterList = this.getInvschemeQfilters(delivery);
            } else if (CO_STOCKINDEX.equals(filedKey) && (stocknumber = (DynamicObject)this.getModel().getValue(CO_STOCKNUMBER, row)) != null) {
                Set<Object> flocationidSet = new HashSet(16);
                DynamicObjectCollection entryentity = stocknumber.getDynamicObjectCollection("entryentity");
                if (entryentity != null && !entryentity.isEmpty()) {
                    flocationidSet = entryentity.stream().map(p -> p.getLong("location.id")).collect(Collectors.toSet());
                }
                qFilterList.add(new QFilter("id", "in", flocationidSet));
            }
            if (!qFilterList.isEmpty()) {
                qFilters.addAll(qFilterList);
            }
        }
    }

    private List<QFilter> getInvschemeQfilters(DynamicObject delivery) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        String billtype = delivery.getString("billtype");
        DynamicObject biztype = delivery.getDynamicObject("biztype");
        return qFilters;
    }

    private List<QFilter> getBizTypeQfilters(DynamicObject delivery) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        String billtype = delivery.getString("billtype");
        return qFilters;
    }

    private DynamicObject getEntryEntity(int row, String entryName) {
        EntryGrid grid = (EntryGrid)this.getControl(entryName);
        IDataModel dm = grid.getModel();
        DynamicObject dynamicObject = dm.getEntryRowEntity(entryName, row);
        return dynamicObject;
    }

    public void afterF7Select(AfterF7SelectEvent arg0) {
        Object source = arg0.getSource();
        int index = arg0.getCurrentRowIndex();
        if (source instanceof BasedataEdit) {
            String filedKey = ((BasedataEdit)source).getFieldKey();
            if (CO_STOCKORG.equals(filedKey)) {
                EntryGrid grid = (EntryGrid)this.getControl(STOCKENTITY);
                int[] row = grid.getSelectRows();
                if (row != null && row.length > 0) {
                    index = row[0];
                }
                grid.getView().setEnable(Boolean.TRUE, index, new String[]{CO_STOCKNUMBER});
                grid.getModel().setValue(CO_STOCKNUMBER, null, index);
                grid.getModel().setValue(CO_STOCKINDEX, null, index);
            } else if (CO_ORDERUSEORG.equals(filedKey)) {
                EntryGrid grid = (EntryGrid)this.getControl(WORKORDERENTITY);
                int[] row = grid.getSelectRows();
                if (row != null && row.length > 0) {
                    index = row[0];
                }
                grid.getView().setEnable(Boolean.TRUE, index, new String[]{CO_TRANSACTPRODUCT});
                grid.getModel().setValue(CO_TRANSACTPRODUCT, null, index);
            } else if (CO_STOCKNUMBER.equals(filedKey)) {
                List locationidList;
                DynamicObject dynamicObject;
                DynamicObjectCollection entryentity;
                EntryGrid grid = (EntryGrid)this.getControl(STOCKENTITY);
                int[] row = grid.getSelectRows();
                if (row != null && row.length > 0) {
                    index = row[0];
                }
                grid.getView().setEnable(Boolean.TRUE, index, new String[]{CO_STOCKINDEX});
                grid.getModel().setValue(CO_STOCKINDEX, null, index);
                DynamicObject stocknumber = (DynamicObject)this.getModel().getValue(CO_STOCKNUMBER, index);
                if (stocknumber != null && (entryentity = (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)stocknumber.getPkValue(), (String)"bd_warehouse")).getDynamicObjectCollection("entryentity")) != null && (locationidList = entryentity.stream().filter(f -> "1".equals(f.getString("location.enable"))).map(m -> m.getLong("location.id")).collect(Collectors.toList())) != null && locationidList.size() == 1) {
                    grid.getModel().setValue(CO_STOCKINDEX, locationidList.get(0), index);
                }
            }
        }
    }

    private void initDeliverySetting() {
        String value = (String)this.getModel().getValue(DELIVERYRADIOGROUP);
        if (!"2".equals(value) && !"3".equals(value)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"deliveryadd", "deliverydel"});
            this.getModel().deleteEntryData(DELIVERYENTITY);
        }
    }

    private void initDeliveryMust() {
        EntryGrid grid = (EntryGrid)this.getControl(DELIVERYENTITY);
        String value = (String)this.getModel().getValue(DELIVERYRADIOGROUP);
        if ("2".equals(value) || "3".equals(value)) {
            this.setEntryIsMust(grid, DELIVERYENTITY, "billtype", true);
        } else {
            this.setEntryIsMust(grid, DELIVERYENTITY, "billtype", false);
        }
    }

    private void setEntryIsMust(EntryGrid grid, String entityname, String fieldname, boolean flag) {
        IFormView view = grid.getView();
        int rowcount = this.getModel().getEntryRowCount(entityname);
        for (int i = 0; i < rowcount; ++i) {
            view.setEnable(Boolean.valueOf(flag), i, new String[]{fieldname});
        }
        grid.setMustInput(fieldname, flag);
    }

    private void initStock() {
        QFilter typefilter = new QFilter(KEY_ENABLE, "=", (Object)"1");
        QFilter statusfilter = new QFilter(KEY_ENABLE, "=", (Object)"1");
        DynamicObjectCollection stockstype = QueryServiceHelper.query((String)"bd_invtype", (String)"id,number", (QFilter[])new QFilter[]{typefilter}, (String)"number asc");
        DynamicObjectCollection statustype = QueryServiceHelper.query((String)"bd_invstatus", (String)"id,number", (QFilter[])new QFilter[]{statusfilter}, (String)"number asc");
        EntryGrid typegrid = (EntryGrid)this.getView().getControl(STOCKTYPEENTITY);
        EntryGrid statusgrid = (EntryGrid)this.getView().getControl(STOCKSTATUSENTITY);
        this.batchCreateEntryRows(statusgrid, typegrid, stockstype, statustype);
        this.setEntryValue(statusgrid, typegrid, stockstype, statustype);
        this.getModel().setDataChanged(false);
    }

    private void batchCreateEntryRows(EntryGrid statusgrid, EntryGrid typegrid, DynamicObjectCollection stockstype, DynamicObjectCollection statustype) {
        int statussize = this.getModel().getEntryRowCount(STOCKSTATUSENTITY);
        int typesize = this.getModel().getEntryRowCount(STOCKTYPEENTITY);
        if (statussize < statustype.size()) {
            statusgrid.getModel().batchCreateNewEntryRow(STOCKSTATUSENTITY, statustype.size() - statussize);
        }
        if (typesize < stockstype.size()) {
            typegrid.getModel().batchCreateNewEntryRow(STOCKTYPEENTITY, stockstype.size() - typesize);
        }
    }

    private void setEntryValue(EntryGrid statusgrid, EntryGrid typegrid, DynamicObjectCollection stockstype, DynamicObjectCollection statustype) {
        this.setEntryGridValue(statusgrid, CO_STOCKTYPE, stockstype);
        this.setEntryGridValue(typegrid, CO_STOCKSTATUS, statustype);
        statusgrid.setPageIndex(1);
        typegrid.setPageIndex(1);
    }

    private void setEntryGridValue(EntryGrid grid, String dyncolumn, DynamicObjectCollection collection) {
        Iterator its = collection.iterator();
        int row = 0;
        while (its.hasNext()) {
            Object id = ((DynamicObject)its.next()).get("id");
            grid.getModel().setValue(dyncolumn, id, row++);
        }
    }
}

