/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.mmc.mds.common.util.CalcuColumns;

public class FastPhotoSetPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BTNCANCEL = "btncancel";
    private static final String BTNOK = "btnok";
    private static final String BTNRUNNING = "btnrunning";
    private static final String REQTYPE1 = "reqtype1";
    private static final String REQTYPE2 = "reqtype2";
    private static final String STATUS = "status";
    private static final String ENABLE = "enable";
    private static final String VERTYPE = "vertype";
    private static final String ID = "id";
    private static final String FASTPHOTOTYPE = "fastphototype";
    private static final String PROJNAME = "mmc-mds-formplugin";
    private static final String[] MONTHDAY = new String[]{"m1", "m2", "m3", "m4", "m5", "m6", "m7", "m8", "m9", "m10", "m11", "m12", "m13", "m14", "m15", "m16", "m17", "m18", "m19", "m20", "m21", "m22", "m23", "m24", "m25", "m26", "m27", "m28", "m29", "m30", "m31"};
    private static final String[] WEEKDAY = new String[]{"day7", "day1", "day2", "day3", "day4", "day5", "day6"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNRUNNING, BTNCANCEL});
        BasedataEdit fastphototype1 = (BasedataEdit)this.getView().getControl(REQTYPE1);
        BasedataEdit fastphototype2 = (BasedataEdit)this.getView().getControl(REQTYPE2);
        if (fastphototype1 != null) {
            fastphototype1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (fastphototype2 != null) {
            fastphototype2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter p = this.getView().getFormShowParameter();
        Map cp = p.getCustomParams();
        String billstatus = (String)cp.get("billstatus");
        boolean forbid = true;
        this.initpages(cp, billstatus);
        this.forbidCons(forbid);
        this.getView().setEnable(Boolean.valueOf(forbid), new String[]{BTNRUNNING});
        String hidden = (String)p.getCustomParam("hidden");
        if ("0".equals(hidden)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNRUNNING});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{REQTYPE1});
        MulBasedataEdit te1 = (MulBasedataEdit)this.getView().getControl(REQTYPE2);
        te1.setMustInput(Boolean.TRUE.booleanValue());
        String openType = (String)p.getCustomParam("openType");
        if ("edit".equals(openType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FASTPHOTOTYPE});
        }
    }

    private void initpages(Map<String, Object> cp, String billstatus) {
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel model = this.getModel();
        String runningtype = (String)cp.get("runningtype");
        if (runningtype != null && !runningtype.equals("")) {
            model.setValue("runningtype", (Object)runningtype);
        } else {
            runningtype = "0";
            model.setValue("runningtype", (Object)"0");
        }
        Object fcvrnnumId = cp.get("fcvrnnumId");
        if (fcvrnnumId != null) {
            this.getModel().setValue(REQTYPE2, (Object)new Object[]{fcvrnnumId});
        }
        boolean repeat = false;
        boolean isEnablePred = false;
        if (!"0".equals(runningtype) && CalcuColumns.Billstatus.SAVE.getCode().equals(billstatus)) {
            isEnablePred = true;
        }
        this.getView().setEnable(Boolean.valueOf(isEnablePred), new String[]{"predtime"});
        this.getView().setVisible(Boolean.valueOf(repeat), new String[]{"repeattype", "predtime", "losedate", "repeat"});
        this.getView().updateView();
    }

    private void forbidCons(boolean fg) {
        this.getView().setEnable(Boolean.valueOf(fg), new String[]{"runningtype"});
        this.getView().setEnable(Boolean.valueOf(fg), new String[]{"losedate"});
        this.getView().setEnable(Boolean.valueOf(fg), new String[]{"repeat"});
        this.getView().setEnable(Boolean.valueOf(fg), new String[]{"repeattype"});
        for (String w : WEEKDAY) {
            this.getView().setEnable(Boolean.valueOf(fg), new String[]{w});
        }
        for (String m : MONTHDAY) {
            this.getView().setEnable(Boolean.valueOf(fg), new String[]{m});
        }
    }

    private boolean isMust(String t) {
        return Integer.parseInt(t) == 1;
    }

    public void click(EventObject evt) {
        Control btn = (Control)evt.getSource();
        HashMap<String, Object> params = new HashMap<String, Object>();
        switch (btn.getKey()) {
            case "btncancel": {
                params.put("op", 2);
                this.getView().returnDataToParent(params);
                this.getView().close();
                break;
            }
            case "btnrunning": {
                if (!this.validOp(params, 1)) break;
                this.getView().returnDataToParent(params);
                this.getView().close();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
    }

    private List<String> getDays(String[] label, boolean isWeek) {
        ArrayList<String> days = new ArrayList<String>();
        int sub = isWeek ? 3 : 1;
        for (String element : label) {
            boolean day = (Boolean)this.getModel().getValue(element);
            if (!day) continue;
            days.add(element.substring(sub));
        }
        return days;
    }

    private List<String> getDaysOfMonth() {
        boolean b = false;
        return this.getDays(MONTHDAY, b);
    }

    private List<String> getDaysOfWeek() {
        boolean b = true;
        return this.getDays(WEEKDAY, b);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String dn;
        switch (dn = e.getProperty().getName()) {
            case "runningtype": {
                String type = (String)e.getChangeSet()[0].getNewValue();
                this.setCustomState(this.isMust(type));
                break;
            }
            case "repeat": {
                boolean repeated = (Boolean)e.getChangeSet()[0].getNewValue();
                this.repeatedChanged(repeated);
                break;
            }
            case "repeattype": {
                this.repeattypechg();
                break;
            }
            case "losedate": {
                Date lost = (Date)e.getChangeSet()[0].getNewValue();
                if (null == lost || CalcuColumns.compare((Date)lost, (Date)new Date(System.currentTimeMillis())) > 0) break;
                this.getModel().setValue("losedate", null);
                break;
            }
            case "fastphototype": {
                this.chgStype(e);
                break;
            }
        }
    }

    private void chgStype(PropertyChangedArgs e) {
        String type = (String)e.getChangeSet()[0].getNewValue();
        MulBasedataEdit te2 = (MulBasedataEdit)this.getView().getControl(REQTYPE2);
        MulBasedataEdit te1 = (MulBasedataEdit)this.getView().getControl(REQTYPE1);
        if ("mds_vrds".equals(type)) {
            this.getModel().setValue(REQTYPE1, null);
            te2.setMustInput(Boolean.TRUE.booleanValue());
            te1.setMustInput(Boolean.FALSE.booleanValue());
            this.getView().setEnable(Boolean.TRUE, new String[]{REQTYPE2});
            this.getView().setVisible(Boolean.TRUE, new String[]{REQTYPE2});
            this.getView().setEnable(Boolean.FALSE, new String[]{REQTYPE1});
            this.getView().setVisible(Boolean.FALSE, new String[]{REQTYPE1});
        } else if ("mds_dmtp".equals(type)) {
            this.getModel().setValue(REQTYPE2, null);
            te1.setMustInput(Boolean.TRUE.booleanValue());
            te2.setMustInput(Boolean.FALSE.booleanValue());
            this.getView().setEnable(Boolean.FALSE, new String[]{REQTYPE2});
            this.getView().setVisible(Boolean.FALSE, new String[]{REQTYPE2});
            this.getView().setVisible(Boolean.TRUE, new String[]{REQTYPE1});
            this.getView().setEnable(Boolean.TRUE, new String[]{REQTYPE1});
        }
    }

    private void setCustomState(boolean isMust) {
        if (isMust) {
            this.getModel().setValue("predtime", (Object)0);
        } else {
            this.getModel().setValue("predtime", (Object)-1);
            this.getModel().setValue("losedate", null);
            this.getModel().setValue("repeat", (Object)Boolean.FALSE);
        }
        this.getView().setEnable(Boolean.valueOf(isMust), new String[]{"predtime"});
        this.getView().setVisible(Boolean.valueOf(isMust), new String[]{"predtime", "losedate", "repeat"});
    }

    private void repeatedChanged(boolean repeated) {
        this.getView().setVisible(Boolean.valueOf(repeated), new String[]{"repeattype"});
        ComboEdit te = (ComboEdit)this.getView().getControl("repeattype");
        te.setMustInput(repeated);
        boolean clear = false;
        this.clearWeekData(clear);
        this.clearMonthData(clear);
        this.getView().setVisible(Boolean.valueOf(repeated), new String[]{"weekpanel"});
        this.getView().setVisible(Boolean.valueOf(repeated), new String[]{"monthpanel"});
    }

    private void repeattypechg() {
        boolean clear = false;
        this.clearWeekData(clear);
        this.clearMonthData(clear);
    }

    private void clearWeekData(boolean clear) {
        for (String w : WEEKDAY) {
            this.getModel().setValue(w, (Object)clear);
        }
    }

    private void clearMonthData(boolean clear) {
        for (String m : MONTHDAY) {
            this.getModel().setValue(m, (Object)clear);
        }
    }

    private boolean validAndInit(Map<String, Object> h) {
        IDataModel model = this.getModel();
        String rt = (String)model.getValue("runningtype");
        Integer pred = (Integer)model.getValue("predtime");
        if ((pred == null || pred < 0) && "1".equals(rt)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7ea6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u9884\u7ea6\u65f6\u95f4\u3002", (String)"FastPhotoSetPlugin_0", (String)PROJNAME, (Object[])new Object[0]));
            return false;
        }
        if (!this.validDays()) {
            return false;
        }
        h.put("runningtype", rt);
        HashSet idList = new HashSet();
        DynamicObjectCollection typeColl = (DynamicObjectCollection)model.getValue(REQTYPE1);
        if ("mds_vrds".equals(model.getValue(FASTPHOTOTYPE).toString())) {
            typeColl = (DynamicObjectCollection)model.getValue(REQTYPE2);
        }
        typeColl.forEach(tcoll -> idList.add(tcoll.getDynamicObject("fbasedataid").getPkValue().toString()));
        h.put("reqtype", idList);
        h.put(FASTPHOTOTYPE, model.getValue(FASTPHOTOTYPE));
        h.put("coverflag", model.getValue("coverflag"));
        h.put("losedate", model.getValue("losedate"));
        h.put("repeattype", model.getValue("repeattype"));
        Object value = model.getValue("predtime");
        if (value == null || "".equals(value.toString()) || "-1".equals(value.toString())) {
            h.put("predtime", 0);
        } else {
            h.put("predtime", model.getValue("predtime"));
        }
        h.put("repeat", model.getValue("repeat"));
        h.put("daysofweek", this.getDaysOfWeek());
        h.put("daysofmon", this.getDaysOfMonth());
        return true;
    }

    private boolean validDays() {
        IDataModel model = this.getModel();
        boolean repeat = (Boolean)model.getValue("repeat");
        if (repeat) {
            String repeattype = (String)model.getValue("repeattype");
            if (repeattype == null || "".equals(repeattype)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u590d\u8fd0\u7b97\u9009\u62e9\u65f6\uff0c\u65f6\u95f4\u91cd\u590d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FastPhotoSetPlugin_1", (String)PROJNAME, (Object[])new Object[0]));
                return false;
            }
            if ("0".equals(repeattype) && this.getDaysOfWeek().isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u91cd\u590d\u7c7b\u578b\u4e3a\u5468\u65f6\uff0c\u8bf7\u9009\u62e9\u5468\u5185\u7684\u8ba1\u5212\u6267\u884c\u65f6\u95f4\u3002", (String)"FastPhotoSetPlugin_2", (String)PROJNAME, (Object[])new Object[0]));
                return false;
            }
            if ("1".equals(repeattype) && this.getDaysOfMonth().isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u91cd\u590d\u7c7b\u578b\u4e3a\u6708\u65f6\uff0c\u8bf7\u9009\u62e9\u6708\u5185\u7684\u8ba1\u5212\u6267\u884c\u65f6\u95f4\u3002", (String)"FastPhotoSetPlugin_3", (String)PROJNAME, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean validOp(Map<String, Object> params, int op) {
        if (!this.validAndInit(params)) {
            return false;
        }
        params.put("op", op);
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        List qFilters = param.getListFilterParameter().getQFilters();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        Object stype = this.getModel().getValue(FASTPHOTOTYPE);
        if (stype == null || "".equals(stype.toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5feb\u7167\u7c7b\u578b\u3002", (String)"FastPhotoSetPlugin_4", (String)PROJNAME, (Object[])new Object[0]));
            return;
        }
        qFilterList.add(new QFilter(STATUS, "=", (Object)"C"));
        qFilterList.add(new QFilter(ENABLE, "=", (Object)"1"));
        if (REQTYPE2.equals(name) && "mds_vrds".equals(stype)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String entityNumber = (String)fsp.getCustomParam("entityNumber");
            Long fcvrnnumId = (Long)fsp.getCustomParam("fcvrnnumId");
            if (fcvrnnumId != null) {
                qFilterList.add(new QFilter(ID, "=", (Object)fcvrnnumId));
            }
            if ("mds_mdsplandata".contains(entityNumber)) {
                qFilterList.add(new QFilter(VERTYPE, "=", (Object)"1"));
            } else if ("mds_forecastplandata".contains(entityNumber)) {
                qFilterList.add(new QFilter(VERTYPE, "=", (Object)"0"));
            } else if ("mds_dpsplandata".contains(entityNumber)) {
                qFilterList.add(new QFilter(VERTYPE, "=", (Object)"2"));
            }
        }
        if (qFilters != null && !qFilterList.isEmpty()) {
            qFilters.addAll(qFilterList);
        }
    }
}

