/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FcCorlFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_TGTVRNNUM = "tgtvrnnum";
    private static final String KEY_SRCVRNNUM = "srcvrnnum";
    private static final String KEY_SHOWMODE = "showMode";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_STATUS = "status";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_FORECAST = "Forecast";
    private static final String KEY_VRNTYPE = "vrntype";
    private static final String KEY_ENTITY = "entryentity";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.mdsInit();
        this.initButton();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        this.initButton();
        super.afterDoOperation(args);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit tgtvrnnum = (BasedataEdit)this.getView().getControl(KEY_TGTVRNNUM);
        tgtvrnnum.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit srcvrnnum = (BasedataEdit)this.getView().getControl(KEY_SRCVRNNUM);
        srcvrnnum.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        String showMode = this.getPageCache().get(KEY_SHOWMODE);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (KEY_TGTVRNNUM.equals(fieldKey)) {
            this.filterTgtVrn(showMode, showParameter);
        }
        if (KEY_SRCVRNNUM.equals(fieldKey)) {
            this.filterSrcVrn(showMode, showParameter, e.getOriginalValue(), e.getRow());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propname = e.getProperty().getName();
        if (KEY_VRNTYPE.equals(propname)) {
            int row = e.getChangeSet()[0].getRowIndex();
            DynamicObject srcvrnnum = (DynamicObject)this.getModel().getValue(KEY_SRCVRNNUM, row);
            if (srcvrnnum != null) {
                this.getModel().setValue(KEY_SRCVRNNUM, null, row);
            }
        }
    }

    private void initButton() {
        String enable = (String)this.getModel().getValue(KEY_ENABLE);
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        if (enable != null) {
            if ("0".equals(enable)) {
                this.getView().setEnable(t, new String[]{"bar_enable"});
                this.getView().setEnable(f, new String[]{"bar_disable"});
            } else {
                this.getView().setEnable(f, new String[]{"bar_enable"});
                this.getView().setEnable(t, new String[]{"bar_disable"});
            }
        }
    }

    private void filterSrcVrn(String showMode, ListShowParameter showParameter, Object original, int rowindex) {
        QFilter[] qfilters;
        DynamicObjectCollection id;
        String vrnType;
        QFilter qfilter = new QFilter(KEY_ENABLE, "=", (Object)"1").and(KEY_STATUS, "=", (Object)"C");
        Object tgtnum = this.getModel().getValue(KEY_TGTVRNNUM);
        if (tgtnum != null) {
            qfilter.and(KEY_NUMBER, "<>", ((DynamicObject)tgtnum).get(KEY_NUMBER));
        }
        DynamicObjectCollection doc = this.getModel().getEntryEntity(KEY_ENTITY);
        ArrayList<Object> srcnums = new ArrayList<Object>();
        for (DynamicObject doj : doc) {
            DynamicObject fcvrn = doj.getDynamicObject(KEY_SRCVRNNUM);
            if (fcvrn == null || srcnums.contains(fcvrn.get(KEY_NUMBER)) || fcvrn.equals(original)) continue;
            srcnums.add(fcvrn.get(KEY_NUMBER));
        }
        if (!srcnums.isEmpty()) {
            qfilter.and(KEY_NUMBER, "not in", srcnums);
        }
        if (!StringUtils.isBlank((CharSequence)(vrnType = this.pickVrnType(showMode, rowindex))) && !(id = QueryServiceHelper.query((String)"mds_vrdsgroup", (String)"id", (QFilter[])(qfilters = new QFilter[]{new QFilter(KEY_NUMBER, "=", (Object)vrnType), new QFilter(KEY_ENABLE, "=", (Object)"1"), new QFilter(KEY_STATUS, "=", (Object)"C")}))).isEmpty()) {
            qfilter.and("group", "=", ((DynamicObject)id.get(0)).get("id"));
        }
        showParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private String pickVrnType(String showMode, int rowindex) {
        if (KEY_FORECAST.equals(showMode)) {
            return "0";
        }
        if ("MDS".equals(showMode)) {
            String vrnType = this.getModel().getEntryRowEntity(KEY_ENTITY, rowindex).getString(KEY_VRNTYPE);
            if (StringUtils.isBlank((CharSequence)vrnType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7248\u672c\u7c7b\u522b\u3002", (String)"FcCorlFormPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            }
            return vrnType;
        }
        return null;
    }

    private void filterTgtVrn(String showMode, ListShowParameter showParameter) {
        QFilter[] qfilters;
        DynamicObjectCollection id;
        QFilter qfilter = new QFilter(KEY_ENABLE, "=", (Object)"1").and(KEY_STATUS, "=", (Object)"C");
        DynamicObjectCollection doc = this.getModel().getEntryEntity(KEY_ENTITY);
        ArrayList<Object> srcnums = new ArrayList<Object>();
        for (DynamicObject doj : doc) {
            DynamicObject fcvrn = doj.getDynamicObject(KEY_SRCVRNNUM);
            if (fcvrn == null || srcnums.contains(fcvrn.get(KEY_NUMBER))) continue;
            srcnums.add(fcvrn.get(KEY_NUMBER));
        }
        if (!srcnums.isEmpty()) {
            qfilter.and(KEY_NUMBER, "not in", srcnums);
        }
        String vrnType = "1";
        if (KEY_FORECAST.equals(showMode)) {
            vrnType = "0";
        }
        if (!StringUtils.isBlank((CharSequence)vrnType) && !(id = QueryServiceHelper.query((String)"mds_vrdsgroup", (String)"id", (QFilter[])(qfilters = new QFilter[]{new QFilter(KEY_NUMBER, "=", (Object)vrnType), new QFilter(KEY_ENABLE, "=", (Object)"1"), new QFilter(KEY_STATUS, "=", (Object)"C")}))).isEmpty()) {
            qfilter.and("group", "=", ((DynamicObject)id.get(0)).get("id"));
        }
        showParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void mdsInit() {
        FormShowParameter p = this.getView().getFormShowParameter();
        if (p != null && p.getCustomParam(KEY_SHOWMODE) != null) {
            String showMode = (String)p.getCustomParam(KEY_SHOWMODE);
            if (StringUtils.isBlank((CharSequence)showMode)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u4f1a\u8bdd\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u5217\u8868\u540e\u518d\u8fdb\u5165\u5355\u636e\u3002", (String)"FcCorlFormPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            }
            if (KEY_FORECAST.equals(showMode)) {
                this.initForecastShow();
            }
            if ("MDS".equals(showMode)) {
                ComboEdit vrntype = (ComboEdit)this.getView().getControl(KEY_VRNTYPE);
                vrntype.setMustInput(true);
            }
            this.getPageCache().put(KEY_SHOWMODE, showMode);
            this.getModel().setValue("corltype", (Object)showMode);
        }
    }

    private void initForecastShow() {
        Boolean f = Boolean.FALSE;
        this.getView().setVisible(f, new String[]{KEY_VRNTYPE});
    }
}

