/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TimeEdit;
import kd.bos.form.operate.FormOperate;
import kd.mmc.mds.common.util.CalcuColumns;

public class PurDyLockUIPlugin
extends AbstractBillPlugIn {
    private static final String BTNCANCEL = "btncancel";
    private static final String BTNOK = "btnok";
    private static final String BTNRUNNING = "btnrunning";
    private static final String[] MONTHDAY = new String[]{"m1", "m2", "m3", "m4", "m5", "m6", "m7", "m8", "m9", "m10", "m11", "m12", "m13", "m14", "m15", "m16", "m17", "m18", "m19", "m20", "m21", "m22", "m23", "m24", "m25", "m26", "m27", "m28", "m29", "m30", "m31"};
    private static final String[] WEEKDAY = new String[]{"day7", "day1", "day2", "day3", "day4", "day5", "day6"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter p = this.getView().getFormShowParameter();
        Map cp = p.getCustomParams();
        String billstatus = (String)cp.get("billstatus");
        boolean forbid = true;
        if (CalcuColumns.Billstatus.SAVE.getCode().equals(billstatus)) {
            forbid = true;
            this.initpages(cp, billstatus);
            this.forbidCons(forbid);
        } else {
            this.initpages(cp, billstatus);
            this.forbidCons(forbid);
        }
        this.getView().setEnable(Boolean.valueOf(forbid), new String[]{BTNOK});
        this.getView().setEnable(Boolean.valueOf(forbid), new String[]{BTNRUNNING});
        String hidden = (String)p.getCustomParam("hidden");
        if ("0".equals(hidden)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNOK});
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNRUNNING});
        }
    }

    private void initpages(Map<String, Object> cp, String billstatus) {
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel model = this.getModel();
        String runningtype = (String)cp.get("runningtype");
        if (runningtype != null && !runningtype.equals("")) {
            model.setValue("runningtype", (Object)runningtype);
        } else {
            runningtype = "0";
            model.setValue("runningtype", (Object)"0");
        }
        TimeEdit time = (TimeEdit)fv.getControl("predtime");
        if (time != null) {
            time.setMustInput(this.isMust(runningtype));
        }
        boolean repeat = false;
        if (cp.get("repeat") != null) {
            repeat = (Boolean)cp.get("repeat");
            model.setValue("repeat", (Object)repeat);
            ComboEdit te = (ComboEdit)fv.getControl("repeattype");
            if (te != null) {
                te.setMustInput(repeat);
            }
        }
        if (cp.get("predtime") != null && (Integer)cp.get("predtime") != -1) {
            model.setValue("predtime", cp.get("predtime"));
        }
        if (cp.get("losedate") != null) {
            model.setValue("losedate", cp.get("losedate"));
        }
        boolean isEnablePred = false;
        if (!"0".equals(runningtype) && CalcuColumns.Billstatus.SAVE.getCode().equals(billstatus)) {
            isEnablePred = true;
        }
        this.getView().setEnable(Boolean.valueOf(isEnablePred), new String[]{"predtime"});
        this.controlByRepeat(repeat, cp);
        this.getView().setVisible(Boolean.valueOf(repeat), new String[]{"repeattype"});
        this.getView().updateView();
    }

    private void forbidCons(boolean fg) {
        this.getView().setEnable(Boolean.valueOf(fg), new String[]{"runningtype"});
        this.getView().setEnable(Boolean.valueOf(fg), new String[]{"losedate"});
        this.getView().setEnable(Boolean.valueOf(fg), new String[]{"repeat"});
        this.getView().setEnable(Boolean.valueOf(fg), new String[]{"repeattype"});
        for (String w : WEEKDAY) {
            this.getView().setEnable(Boolean.valueOf(fg), new String[]{w});
        }
        for (String m : MONTHDAY) {
            this.getView().setEnable(Boolean.valueOf(fg), new String[]{m});
        }
    }

    private boolean isMust(String t) {
        return Integer.parseInt(t) == 1;
    }

    private void controlByRepeat(boolean repeat, Map<String, Object> cp) {
        IDataModel model = this.getModel();
        if (repeat) {
            model.setValue("repeattype", cp.get("repeattype"));
            String week = (String)cp.get("daysofweek");
            String month = (String)cp.get("daysofmon");
            if (week != null && !week.isEmpty()) {
                String[] weeks;
                for (String w : weeks = week.split(",")) {
                    model.setValue("day" + w, (Object)"1");
                }
            }
            if (month != null && !month.isEmpty()) {
                String[] months;
                for (String d : months = month.split(",")) {
                    model.setValue("m" + d, (Object)"1");
                }
            }
        }
    }

    public void click(EventObject evt) {
        Control btn = (Control)evt.getSource();
        HashMap<String, Object> params = new HashMap<String, Object>();
        switch (btn.getKey()) {
            case "btnok": {
                if (!this.validOp(params, 0)) break;
                this.getView().returnDataToParent(params);
                this.getView().close();
                break;
            }
            case "btncancel": {
                params.put("op", 2);
                this.getView().returnDataToParent(params);
                this.getView().close();
                break;
            }
            case "btnrunning": {
                if (!this.validOp(params, 1)) break;
                this.getView().returnDataToParent(params);
                this.getView().close();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Button button;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)BTNRUNNING, (CharSequence)formOperate.getOperateKey()) && (button = (Button)this.getView().getControl(BTNOK)) != null) {
            button.click();
        }
    }

    private List<String> getDays(String[] label, boolean isWeek) {
        ArrayList<String> days = new ArrayList<String>();
        int sub = isWeek ? 3 : 1;
        for (String element : label) {
            boolean day = (Boolean)this.getModel().getValue(element);
            if (!day) continue;
            days.add(element.substring(sub));
        }
        return days;
    }

    private List<String> getDaysOfMonth() {
        boolean b = false;
        return this.getDays(MONTHDAY, b);
    }

    private List<String> getDaysOfWeek() {
        boolean b = true;
        return this.getDays(WEEKDAY, b);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String dn;
        switch (dn = e.getProperty().getName()) {
            case "runningtype": {
                String type = (String)e.getChangeSet()[0].getNewValue();
                this.setCustomState(this.isMust(type));
                break;
            }
            case "repeat": {
                boolean repeated = (Boolean)e.getChangeSet()[0].getNewValue();
                this.repeatedChanged(repeated);
                break;
            }
            case "repeattype": {
                this.repeattypechg();
                break;
            }
            case "losedate": {
                Date lost = (Date)e.getChangeSet()[0].getNewValue();
                if (null == lost || CalcuColumns.compare((Date)lost, (Date)new Date(System.currentTimeMillis())) > 0) break;
                this.getModel().setValue("losedate", null);
                break;
            }
        }
    }

    private void setCustomState(boolean isMust) {
        TimeEdit time = (TimeEdit)this.getView().getControl("predtime");
        time.setMustInput(isMust);
        this.getModel().setValue("predtime", (Object)-1);
        this.getView().setEnable(Boolean.valueOf(isMust), new String[]{"predtime"});
    }

    private void repeatedChanged(boolean repeated) {
        this.getView().setVisible(Boolean.valueOf(repeated), new String[]{"repeattype"});
        ComboEdit te = (ComboEdit)this.getView().getControl("repeattype");
        te.setMustInput(repeated);
        boolean clear = false;
        this.clearWeekData(clear);
        this.clearMonthData(clear);
        this.getView().setVisible(Boolean.valueOf(repeated), new String[]{"weekpanel"});
        this.getView().setVisible(Boolean.valueOf(repeated), new String[]{"monthpanel"});
    }

    private void repeattypechg() {
        boolean clear = false;
        this.clearWeekData(clear);
        this.clearMonthData(clear);
    }

    private void clearWeekData(boolean clear) {
        for (String w : WEEKDAY) {
            this.getModel().setValue(w, (Object)clear);
        }
    }

    private void clearMonthData(boolean clear) {
        for (String m : MONTHDAY) {
            this.getModel().setValue(m, (Object)clear);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK, BTNRUNNING, BTNCANCEL});
    }

    private boolean validAndInit(Map<String, Object> h) {
        IDataModel model = this.getModel();
        String rt = (String)model.getValue("runningtype");
        Integer pred = (Integer)model.getValue("predtime");
        if ((pred == null || pred < 0) && "1".equals(rt)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7ea6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u9884\u7ea6\u65f6\u95f4\u3002", (String)"PurDyLockUIPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.validDays()) {
            return false;
        }
        h.put("runningtype", rt);
        h.put("losedate", model.getValue("losedate"));
        h.put("repeattype", model.getValue("repeattype"));
        h.put("predtime", model.getValue("predtime"));
        h.put("repeat", model.getValue("repeat"));
        h.put("daysofweek", this.getDaysOfWeek());
        h.put("daysofmon", this.getDaysOfMonth());
        return true;
    }

    private boolean validDays() {
        IDataModel model = this.getModel();
        boolean repeat = (Boolean)model.getValue("repeat");
        if (repeat) {
            String repeattype = (String)model.getValue("repeattype");
            if (repeattype == null || "".equals(repeattype)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u9009\u62e9\u91cd\u590d\u8fd0\u7b97\u65f6\uff0c\u65f6\u95f4\u91cd\u590d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurDyLockUIPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return false;
            }
            if ("0".equals(repeattype) && this.getDaysOfWeek().isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u91cd\u590d\u7c7b\u578b\u4e3a\u5468\u65f6\uff0c\u8bf7\u9009\u62e9\u5468\u5185\u7684\u8ba1\u5212\u6267\u884c\u65f6\u95f4\u3002", (String)"PurDyLockUIPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return false;
            }
            if ("1".equals(repeattype) && this.getDaysOfMonth().isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u91cd\u590d\u7c7b\u578b\u4e3a\u6708\u65f6\uff0c\u8bf7\u9009\u62e9\u6708\u5185\u7684\u8ba1\u5212\u6267\u884c\u65f6\u95f4\u3002", (String)"PurDyLockUIPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean validOp(Map<String, Object> params, int op) {
        if (!this.validAndInit(params)) {
            return false;
        }
        params.put("op", op);
        return true;
    }
}

