/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PurMdsVrdsEditPlugin
extends AbstractFormPlugin {
    private static final String BAR_DISABLE = "bar_disable";
    private static final String BAR_ENABLE = "bar_enable";
    private static final String KEY_DISABLE = "disable";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_LOSEDATE = "losedate";
    private static final String KEY_GROUP = "group";
    private static final String KEY_VERTYPE = "vertype";
    private static final String SUBMIT = "submit";
    private static final String CYTYPE = "cytype";
    private static final String DAYOFWEEK = "dayofweek";

    public void afterCreateNewData(EventObject e) {
        RequestContext rc;
        String enable;
        super.afterCreateNewData(e);
        IDataModel dm = this.getModel();
        if (dm == null) {
            return;
        }
        DynamicObject d = (DynamicObject)dm.getValue(KEY_GROUP);
        if (d != null) {
            dm.setValue(KEY_VERTYPE, (Object)d.getString("number"));
        }
        if ((enable = (String)dm.getValue(KEY_ENABLE)) != null) {
            this.setViewStyle(enable);
        }
        Long curOrgID = (rc = RequestContext.get()) == null ? -1L : rc.getOrgId();
        Object createOrgObj = dm.getValue("createorg");
        if (createOrgObj == null && curOrgID > 0L) {
            dm.setValue("createorg", (Object)curOrgID);
        }
    }

    private void setViewStyle(String type) {
        if ("0".equals(type)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_ENABLE});
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_DISABLE});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_ENABLE});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
        }
    }

    public void afterBindData(EventObject e) {
        String enable = (String)this.getModel().getValue(KEY_ENABLE);
        if (enable != null) {
            if ("0".equals(enable)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_ENABLE});
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_DISABLE});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_ENABLE});
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
            }
        }
        String cytype = (String)this.getModel().getValue(CYTYPE);
        this.dayOfWeekShow(String.valueOf(cytype));
        super.afterBindData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List listPkId;
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)KEY_DISABLE, (CharSequence)operateKey)) {
            this.setViewStyle("0");
        }
        if (StringUtils.equals((CharSequence)KEY_ENABLE, (CharSequence)operateKey)) {
            this.setViewStyle("1");
        }
        if (StringUtils.equals((CharSequence)SUBMIT, (CharSequence)operateKey) && (listPkId = args.getOperationResult().getSuccessPkIds()) != null && listPkId.size() > 0) {
            this.getView().invokeOperation("refresh");
        }
        super.afterDoOperation(args);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (KEY_VERTYPE.equals(name)) {
            DynamicObject group = BusinessDataServiceHelper.loadSingle((String)"mds_vrdsgroup", (String)"number, name", (QFilter[])new QFilter[]{new QFilter("number", "=", newValue)});
            this.getModel().setValue(KEY_GROUP, (Object)group);
        } else if (CYTYPE.equals(name)) {
            this.dayOfWeekShow(String.valueOf(newValue));
            if ("0".equals(newValue) || "1".equals(newValue)) {
                this.getModel().setValue(DAYOFWEEK, (Object)"Mon");
            }
            if ("3".equals(newValue)) {
                this.getModel().setValue(DAYOFWEEK, (Object)"Mbeg");
            }
        }
    }

    private void dayOfWeekShow(String value) {
        ArrayList<String> showList = new ArrayList<String>(16);
        if ("1".equals(value)) {
            showList.add("Mon");
            showList.add("Tue");
            showList.add("Wed");
            showList.add("Thu");
            showList.add("Fri");
        }
        if ("3".equals(value)) {
            showList.add("Mbeg");
            showList.add("Mmid");
            showList.add("Mend");
        }
        this.comboEditShow(DAYOFWEEK, showList);
    }

    private void comboEditShow(String key, List<String> showList) {
        ComboEdit comboEditType = (ComboEdit)this.getControl(key);
        ComboProp property = (ComboProp)comboEditType.getProperty();
        List listValue = property.getComboItems();
        List items = listValue.stream().filter(p -> showList.contains(p.getValue())).map(item -> new ComboItem(item.getName(), item.getValue())).collect(Collectors.toList());
        comboEditType.setComboItems(items);
    }
}

