/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.util.CalcuColumns;

public class PurMdsVrdsListPlugin
extends AbstractListPlugin {
    public static final String BILLLIST = "billlistap";
    private static final String BTNDATAENTRY = "dataentry";
    private static final String THISBILL = "mds_vrds";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        super.registerListener(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (BTNDATAENTRY.endsWith(operateKey)) {
            IFormView fv = this.getView();
            if (fv == null) {
                return;
            }
            BillList list = (BillList)this.getControl(BILLLIST);
            ListSelectedRowCollection rows = list.getSelectedRows();
            if (rows.size() > 1) {
                fv.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u8fdb\u884c\u591a\u6761\u6570\u636e\u5f55\u5165\u3002", (String)"PurMdsVrdsListPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow lsr = rows.get(0);
            if (lsr == null) {
                fv.showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u9009\u4e2d\u7684\u884c\u5931\u8d25\u3002", (String)"PurMdsVrdsListPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return;
            }
            Object pk = lsr.getPrimaryKeyValue();
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)pk, (String)THISBILL);
            if (loadSingle == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6570\u636e\u3002", (String)"PurMdsVrdsListPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return;
            }
            String number = loadSingle.getString("number");
            String enable = loadSingle.getString("enable");
            String status = loadSingle.getString("status");
            if (StringUtils.isEmpty((CharSequence)number)) {
                number = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"PurMdsVrdsListPlugin_9", (String)"mmc-mds-formplugin", (Object[])new Object[0]), lsr.getRowKey() + 1);
            }
            if ("0".equals(enable)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u7ecf\u7981\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u6570\u636e\u5f55\u5165\u3002", (String)"PurMdsVrdsListPlugin_10", (String)"mmc-mds-formplugin", (Object[])new Object[0]), number));
                return;
            }
            if ("A".equals(status)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u6682\u5b58\u6570\u636e\u4e0d\u80fd\u8fdb\u884c\u6570\u636e\u5f55\u5165\u3002", (String)"PurMdsVrdsListPlugin_11", (String)"mmc-mds-formplugin", (Object[])new Object[0]), number));
                return;
            }
            StringBuilder lockMsg = new StringBuilder();
            boolean createLock = MutexHelper.require((String)THISBILL, (Object)pk.toString(), (String)BTNDATAENTRY, (boolean)true, (StringBuilder)lockMsg);
            if (!createLock) {
                this.getView().showTipNotification(lockMsg.toString());
                return;
            }
            DynamicObject group = loadSingle.getDynamicObject("group");
            String groupNumber = group.getString("number");
            String name = "forecast";
            if ("1".equals(groupNumber)) {
                name = "mds";
            } else if ("2".equals(groupNumber)) {
                name = "dps";
            }
            QFilter[] q = new QFilter[1];
            QFilter filter = new QFilter("fcvrnnum", "=", loadSingle.getPkValue());
            String formId = "mds_" + name.toLowerCase() + "plandata";
            if ("mds".equalsIgnoreCase(name)) {
                Long userid = RequestContext.get().getCurrUserId();
                formId = "mds_mdsplandatamulti";
                filter.and("creator", "=", (Object)userid);
            }
            q[0] = filter;
            DynamicObject[] dob = BusinessDataServiceHelper.load((String)formId, (String)"id", (QFilter[])q);
            if (dob != null && dob.length > 0) {
                Object id = dob[0].get("id");
                this.openForm(id, null, true, name);
            } else {
                this.openForm(null, loadSingle.getPkValue(), false, name);
            }
            CalcuColumns.releaseLock((String)THISBILL, (String)BTNDATAENTRY, (String)pk.toString());
        }
    }

    private void openForm(Object id, Object vrn, boolean vrntip, String showMode) {
        BillShowParameter showParameter = new BillShowParameter();
        String formId = "mds_" + showMode.toLowerCase() + "plandata";
        if ("mds".equalsIgnoreCase(showMode)) {
            formId = "mds_mdsplandatamulti";
        }
        showParameter.setFormId(formId);
        if (id != null) {
            showParameter.setPkId(id);
        } else {
            showParameter.setCustomParam("fcvrnnum", vrn);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        if ("mds".equalsIgnoreCase(showMode)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u5904\u7406", (String)"PurMdsVrdsListPlugin_8", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("createtime desc");
    }
}

