/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FlexBeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;

public class SafetyStockEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_UNIT = "unit";
    private static final String KEY_MATERIAL_BASEUNIT = "baseunit";
    private static final String KEY_AUXPTY = "auxpty";
    private static final String ACTION_SAVE = "save";
    private static final String PLANMODE_MRP = "D";
    private static final String PLANMODE_AGAIN = "A";
    private static final String PLANMODE_MANUAL = "B";
    private static final String PLANMODE_MPS = "c";
    private static final String OPEN_BOM = "open";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar control = (Toolbar)this.getView().getControl("tbmain");
        control.addItemClickListener((ItemClickListener)this);
        BasedataEdit planscope = (BasedataEdit)this.getControl("planscope");
        if (planscope != null) {
            planscope.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals(OPEN_BOM)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c55\u5f00BOM\u3002", (String)"SafetyStockEditPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        HashMap<String, Integer> editorProps = new HashMap<String, Integer>();
        editorProps.put("sc", 2);
        HashMap<String, HashMap<String, Integer>> ctrlProps = new HashMap<String, HashMap<String, Integer>>();
        ctrlProps.put("item", editorProps);
        this.getView().updateControlMetadata("qty", ctrlProps);
    }

    public void afterBindData(EventObject e) {
        String saftype = this.getModel().getDataEntity().getString("saftytype");
        if (PLANMODE_AGAIN.equals(saftype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"effecttime"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"loseeffecttime"});
            this.getModel().setValue("loseeffecttime", null);
            this.getModel().setValue("effecttime", null);
            QtyEdit qty = (QtyEdit)this.getView().getControl("qty");
            qty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf", (String)"SafetyStockEditPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0])));
        } else if (PLANMODE_MANUAL.equals(saftype)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"effecttime"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"loseeffecttime"});
            DateTimeEdit effecttime = (DateTimeEdit)this.getView().getControl("effecttime");
            DateTimeEdit loseeffecttime = (DateTimeEdit)this.getView().getControl("loseeffecttime");
            effecttime.setMustInput(true);
            loseeffecttime.setMustInput(true);
            QtyEdit qty = (QtyEdit)this.getView().getControl("qty");
            qty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf", (String)"SafetyStockEditPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0])));
        } else if ("C".equals(saftype)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"effecttime"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"loseeffecttime"});
            DateTimeEdit effecttime = (DateTimeEdit)this.getView().getControl("effecttime");
            DateTimeEdit loseeffecttime = (DateTimeEdit)this.getView().getControl("loseeffecttime");
            effecttime.setMustInput(true);
            loseeffecttime.setMustInput(true);
            QtyEdit qty = (QtyEdit)this.getView().getControl("qty");
            qty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u5929\u6570\uff08\u5929\uff09", (String)"SafetyStockEditPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0])));
        }
        this.setQtyScale();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String opkey = operate.getOperateKey();
        if (ACTION_SAVE.equals(opkey)) {
            this.getModel().setValue("number", (Object)this.getModel().getDataEntity().getString("material.number"));
            this.setDefaultPlanScope();
        } else if ("submit".equals(opkey)) {
            this.getModel().setValue("number", (Object)this.getModel().getDataEntity().getString("material.number"));
            this.setDefaultPlanScope();
        }
    }

    private void setDefaultPlanScope() {
        Object createorg;
        Object planscope = this.getModel().getValue("planscope");
        if (planscope == null && (createorg = this.getModel().getValue("createorg")) instanceof DynamicObject) {
            Long defaultPlanScopeId = FCPlanDataHelper.getDefaultPlanScopeId((long)((DynamicObject)createorg).getLong("id"));
            this.getModel().setValue("planscope", (Object)defaultPlanScopeId);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "saftytype": {
                this.saftypeChg(e);
                this.setQtyScale();
                break;
            }
            case "material": {
                this.materialChng(e);
                this.setQtyScale();
                this.getModel().setValue("planscope", null);
                break;
            }
            case "qty": {
                this.qtyChg(e);
                break;
            }
        }
    }

    private void qtyChg(PropertyChangedArgs e) {
        BigDecimal qty = (BigDecimal)e.getChangeSet()[0].getNewValue();
        if (qty != null) {
            this.showDynamicNumInfo("0", null, null, qty, null, null, false);
        }
    }

    private void showDynamicNumInfo(String sftype, Object materialId, Object orgId, BigDecimal qty, Object sourceId, BigDecimal rats, boolean isFirst) {
    }

    private void setQtyScale() {
        String saftytype = this.getModel().getDataEntity().getString("saftytype");
        if (this.getModel().getDataEntity().get("material") == null) {
            HashMap<String, Integer> fmt = new HashMap<String, Integer>();
            if (PLANMODE_AGAIN.equals(saftytype) || PLANMODE_MANUAL.equals(saftytype)) {
                fmt.put("pa", 2);
                fmt.put("ct", 1);
                fmt.put("ps", 2);
            } else {
                fmt.put("pa", 1);
                fmt.put("ct", 1);
                fmt.put("ps", 0);
            }
            ((FormView)this.getView()).getClientProxy().setNumFmtInfo(KEY_UNIT, fmt);
        } else if ("C".equals(saftytype)) {
            HashMap<String, Integer> fmt = new HashMap<String, Integer>();
            fmt.put("pa", 1);
            fmt.put("ct", 1);
            fmt.put("ps", 0);
            ((FormView)this.getView()).getClientProxy().setNumFmtInfo(KEY_UNIT, fmt);
        } else {
            HashMap<String, Object> fmt = new HashMap<String, Object>();
            DynamicObject material = this.getModel().getDataEntity().getDynamicObject("material");
            DynamicObject baseunit = material.getDynamicObject(KEY_MATERIAL_BASEUNIT);
            if (baseunit != null) {
                fmt.put("pa", baseunit.get("precisionaccount"));
                fmt.put("ct", 1);
                fmt.put("ps", baseunit.get("precision"));
                ((FormView)this.getView()).getClientProxy().setNumFmtInfo(KEY_UNIT, fmt);
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
    }

    private void saftypeChg(PropertyChangedArgs e) {
        String saftype = (String)e.getChangeSet()[0].getNewValue();
        if (PLANMODE_AGAIN.equals(saftype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"effecttime"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"loseeffecttime"});
            this.getModel().setValue("loseeffecttime", null);
            this.getModel().setValue("effecttime", null);
            DateTimeEdit effecttime = (DateTimeEdit)this.getView().getControl("effecttime");
            DateTimeEdit loseeffecttime = (DateTimeEdit)this.getView().getControl("loseeffecttime");
            effecttime.setMustInput(false);
            loseeffecttime.setMustInput(false);
            QtyEdit qty = (QtyEdit)this.getView().getControl("qty");
            qty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf", (String)"SafetyStockEditPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0])));
        } else if (PLANMODE_MANUAL.equals(saftype)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"effecttime"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"loseeffecttime"});
            DateTimeEdit effecttime = (DateTimeEdit)this.getView().getControl("effecttime");
            DateTimeEdit loseeffecttime = (DateTimeEdit)this.getView().getControl("loseeffecttime");
            effecttime.setMustInput(true);
            loseeffecttime.setMustInput(true);
            QtyEdit qty = (QtyEdit)this.getView().getControl("qty");
            qty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf", (String)"SafetyStockEditPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0])));
        } else if ("C".equals(saftype)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"effecttime"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"loseeffecttime"});
            DateTimeEdit effecttime = (DateTimeEdit)this.getView().getControl("effecttime");
            DateTimeEdit loseeffecttime = (DateTimeEdit)this.getView().getControl("loseeffecttime");
            effecttime.setMustInput(true);
            loseeffecttime.setMustInput(true);
            QtyEdit qty = (QtyEdit)this.getView().getControl("qty");
            qty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u5929\u6570\uff08\u5929\uff09", (String)"SafetyStockEditPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0])));
        }
    }

    private void materialChng(PropertyChangedArgs e) {
        DynamicObject material = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (material != null) {
            DynamicObject materialUnit = material.getDynamicObject(KEY_MATERIAL_BASEUNIT);
            this.getModel().setValue(KEY_UNIT, (Object)materialUnit);
            String sftype = (String)this.getModel().getValue("saftytype");
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty");
            DynamicObject orgId = (DynamicObject)this.getModel().getValue("createorg");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("safetysource");
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject dy = this.getModel().getDataEntity();
        String number = dy.getString("material.number");
        dy.set("number", (Object)number);
        if (PLANMODE_AGAIN.equals(dy.getString("saftytype"))) {
            dy.set("effecttime", null);
            dy.set("loseeffecttime", null);
        }
        this.setDefaultPlanScope();
    }

    public void flexBeforeClosed(FlexBeforeClosedEvent e) {
        BaseView object = (BaseView)e.getSource();
        IDataModel dataModel = object.getModel();
        DynamicObject dataEntity = dataModel.getDataEntity();
        if (KEY_AUXPTY.equals(e.getFlexKey())) {
            this.auxptyClose(dataEntity);
        }
    }

    private void auxptyClose(DynamicObject dataEntity) {
        String auxpropJson;
        DynamicObject auxprop = dataEntity.getDynamicObject(KEY_AUXPTY);
        if (auxprop != null && StringUtils.isNotEmpty((String)(auxpropJson = auxprop.getString("value")))) {
            Map axpropValueMap = (Map)SerializationUtils.fromJsonString((String)auxpropJson, LinkedHashMap.class);
            LinkedHashMap axpropMap = new LinkedHashMap(8);
            for (Map.Entry entry : axpropValueMap.entrySet()) {
                if ("0".equals(entry.getValue().toString()) || "".equals(entry.getValue().toString())) continue;
                axpropMap.put(entry.getKey(), entry.getValue());
            }
            if (axpropMap.isEmpty()) {
                return;
            }
            Object materialId = dataEntity.getDynamicObject("material").getPkValue();
            QFilter materialIdFilter = new QFilter("id", "=", materialId);
            materialIdFilter.and("auxptyentry.isaffectplan", "=", (Object)Boolean.FALSE);
            DynamicObjectCollection auxptyentry = QueryServiceHelper.query((String)"bd_material", (String)"auxptyentry.auxpty,auxptyentry.isaffectplan", (QFilter[])new QFilter[]{materialIdFilter});
            HashMap<String, String> flexfields = new HashMap<String, String>(8);
            if (auxptyentry != null && !auxptyentry.isEmpty()) {
                for (DynamicObject dynamicObject : auxptyentry) {
                    Long auxptyid = dynamicObject.getLong("auxptyentry.auxpty");
                    QFilter entryid = new QFilter("id", "=", (Object)auxptyid);
                    DynamicObject basFlexProperty = QueryServiceHelper.queryOne((String)"bd_auxproperty", (String)"flexfield,name", (QFilter[])new QFilter[]{entryid});
                    if (basFlexProperty == null) continue;
                    flexfields.put(basFlexProperty.getString("flexfield"), basFlexProperty.getString("name"));
                }
                StringBuilder sb = new StringBuilder();
                ArrayList array = new ArrayList(axpropMap.keySet());
                Collections.reverse(array);
                array.forEach(key -> {
                    if (flexfields.containsKey(key)) {
                        sb.append(flexfields.getOrDefault(key, "")).append(';');
                    }
                });
                if (sb.length() > 0) {
                    sb.insert(0, ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\uff1a", (String)"SafetyStockEditPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append(ResManager.loadKDString((String)"\u5728\u4e3b\u6570\u636e\u4e2d\u672a\u6253\u5f00\u201c\u5f71\u54cd\u8ba1\u5212\u201d\u5f00\u5173\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SafetyStockEditPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                    this.getView().showTipNotification(sb.toString());
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        if ("planscope".equals(name)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            DynamicObject prodorg = (DynamicObject)this.getModel().getValue("createorg");
            DynamicObject material = (DynamicObject)this.getModel().getValue("material");
            QFilter filter = new QFilter("1", "=", (Object)2);
            if (prodorg != null && material != null) {
                List planScopeIds = FCPlanDataHelper.getPlanScopeIds((long)prodorg.getLong("id"), (long)material.getLong("id"));
                filter = new QFilter("id", "in", (Object)planScopeIds);
            }
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }
}

