/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;

public class SafetyStockListPlugin
extends AbstractListPlugin {
    private static final int CTHIDE = 10;
    private static final int CTSHOW = 63;
    private static final String DBROUTEKEY = "scm";
    private static final String EXPORT_ACTION = "exportlistbyselectfields";

    public void initialize() {
        this.addExecutionListDataProvider();
    }

    private void addExecutionListDataProvider() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        if (list == null) {
            return;
        }
        IFormView parentView = this.getView();
        list.addCreateListDataProviderListener(e -> e.setListDataProvider((IListDataProvider)new CustomListDataProvider(parentView)));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map obj = (Map)closedCallBackEvent.getReturnData();
        if (obj != null && "mds_safety_conditon".equals(closedCallBackEvent.getActionId())) {
            FormShowParameter showParamter = new FormShowParameter();
            CloseCallBack closepanel = new CloseCallBack((IFormPlugin)this, "mds_safety_numbs");
            showParamter.setFormId("mds_safety_numbs");
            showParamter.setCloseCallBack(closepanel);
            showParamter.setCustomParams(obj);
            showParamter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParamter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowdata = e.getRowData();
        String saftytype = rowdata.getString("saftytype");
        if ("C".equals(saftytype)) {
            DynamicObject baseunit = rowdata.getDynamicObject("unit");
            if (baseunit == null) {
                return;
            }
            DynamicObject cloneObject = ORM.create().newDynamicObject(baseunit.getDynamicObjectType());
            cloneObject.set("precision", (Object)0);
            cloneObject.set("precisionaccount", (Object)1);
            cloneObject.set("conversiontype", (Object)1);
            cloneObject.set("number", baseunit.get("number"));
            cloneObject.set("name", baseunit.get("name"));
            rowdata.set("unit", (Object)cloneObject);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate op = (FormOperate)args.getSource();
        if ("submit".equals(op.getOperateKey())) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection listSelectedRowCollection = list.getSelectedRows();
        } else if (EXPORT_ACTION.equals(op.getOperateKey())) {
            // empty if block
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operatekey = args.getOperateKey();
        if ("brower".equals(operatekey)) {
            OperationResult result = args.getOperationResult();
            List ids = result.getSuccessPkIds();
            HashMap<String, List> paramMap = new HashMap<String, List>();
            paramMap.put("ids", ids);
            FormShowParameter showParamter = new FormShowParameter();
            CloseCallBack closepanel = new CloseCallBack((IFormPlugin)this, "mds_safety_conditon");
            showParamter.setFormId("mds_safety_conditon");
            showParamter.setCustomParams(paramMap);
            showParamter.setCloseCallBack(closepanel);
            showParamter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParamter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    protected void setListField(DataEntityPropertyCollection properties, DynamicObject co, String listQty, Object value) {
        if (properties.containsKey((Object)listQty) && value != null && ((BigDecimal)value).compareTo(new BigDecimal("0")) > 0) {
            co.set(listQty, value);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (evt == null) {
            return;
        }
        String itemKey = evt.getItemKey();
        if (StringUtils.isEmpty((CharSequence)itemKey)) {
            return;
        }
        if (evt.isCancel()) {
            return;
        }
    }

    class CustomListDataProvider
    extends ListDataProvider {
        private final IFormView parentView;

        public CustomListDataProvider(IFormView parentView) {
            this.parentView = parentView;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DataEntityPropertyCollection properties;
            DynamicObjectCollection cols = super.getData(start, limit);
            List<Date> monList = this.monthList(new Date());
            if (cols == null || cols.isEmpty()) {
                this.initDynamicColumnName(monList, null);
                return cols;
            }
            ArrayList<String> ids = new ArrayList<String>();
            for (DynamicObject col : cols) {
                ids.add(col.getPkValue().toString());
            }
            DataSet monsOfQtys = DB.queryDataSet((String)"db_SafetyStockListPlugin", (DBRoute)new DBRoute(SafetyStockListPlugin.DBROUTEKEY), (String)this.selected(monList, String.join((CharSequence)",", ids)));
            DataSet copy = monsOfQtys.copy();
            this.initDynamicColumnName(monList, copy);
            DataEntityPropertyCollection dataEntityPropertyCollection = properties = cols.isEmpty() ? null : cols.getDynamicObjectType().getProperties();
            block1: while (monsOfQtys.hasNext()) {
                Row row = monsOfQtys.next();
                for (DynamicObject co : cols) {
                    if (!co.get("id").equals(row.get("fid"))) continue;
                    SafetyStockListPlugin.this.setListField(properties, co, "c0", row.get("c0"));
                    SafetyStockListPlugin.this.setListField(properties, co, "c1", row.get("c1"));
                    SafetyStockListPlugin.this.setListField(properties, co, "c2", row.get("c2"));
                    SafetyStockListPlugin.this.setListField(properties, co, "c3", row.get("c3"));
                    SafetyStockListPlugin.this.setListField(properties, co, "c4", row.get("c4"));
                    SafetyStockListPlugin.this.setListField(properties, co, "c5", row.get("c5"));
                    SafetyStockListPlugin.this.setListField(properties, co, "c6", row.get("c6"));
                    SafetyStockListPlugin.this.setListField(properties, co, "c7", row.get("c7"));
                    SafetyStockListPlugin.this.setListField(properties, co, "c8", row.get("c8"));
                    SafetyStockListPlugin.this.setListField(properties, co, "c9", row.get("c9"));
                    SafetyStockListPlugin.this.setListField(properties, co, "c10", row.get("c10"));
                    SafetyStockListPlugin.this.setListField(properties, co, "c11", row.get("c11"));
                    continue block1;
                }
            }
            return cols;
        }

        private List<Date> monthList(Date cmon) {
            ArrayList<Date> monList = new ArrayList<Date>(11);
            if (cmon == null) {
                return new ArrayList<Date>();
            }
            for (int i = 0; i <= 11; ++i) {
                Calendar c = Calendar.getInstance();
                c.setTime(cmon);
                c.add(2, i);
                monList.add(c.getTime());
            }
            return monList;
        }

        private void initDynamicColumnName(List<Date> monList, DataSet dataSet) {
            Map<String, BigDecimal> maps = this.createMap(dataSet);
            String columHeadCap = "decimallistcolumnap";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Collections.sort(monList);
        }

        private String selected(List<Date> monList, String ids) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            if (!monList.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("select fid,");
                int i = 0;
                for (Date d : monList) {
                    String dstr = sdf.format(d);
                    if (i < 11) {
                        sb.append("case fdatenode when '").append(dstr).append("' then fqtys else 0 end c").append(i).append(',');
                    } else {
                        sb.append("case fdatenode when '").append(dstr).append("' then fqtys else 0 end c").append(i);
                    }
                    ++i;
                }
                sb.append(" from T_MDS_SAFESTK_ENTITY where fid in (").append(ids).append(')');
                return sb.toString();
            }
            return "";
        }

        private Map<String, BigDecimal> createMap(DataSet dataSet) {
            HashMap<String, BigDecimal> maps = new HashMap<String, BigDecimal>();
            if (dataSet != null) {
                RowMeta rowMeta = dataSet.getRowMeta();
                int fieldCount = rowMeta.getFieldCount();
                for (Row row : dataSet) {
                    for (int i = 0; i < fieldCount; ++i) {
                        BigDecimal ro = row.getBigDecimal(rowMeta.getFieldName(i));
                        if ("fid".equalsIgnoreCase(rowMeta.getFieldName(i)) || ro == null || ro.compareTo(new BigDecimal("0")) <= 0) continue;
                        maps.put(rowMeta.getFieldName(i), ro);
                    }
                }
            }
            return maps;
        }
    }
}

