/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.planSetoff;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.mmc.mds.common.algorithm.util.ResourceFieldUtil;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;

public class SetOffDimEditPlugin
extends AbstractFormPlugin {
    private static final String FORM_ID_FIELD_SELECT = "mds_billfieldselect";
    private static final String SELECT_FIELD_PARAM_TREE_NODES = "treenodes";
    private static final String FORM_ID_REQUEST_RECORD = "mds_requestrecord";
    private static final String FORM_ID_PROVIDER_RECORD = "mds_providerrecord";
    private static final String CALL_BACK_REQ_SELECT_FIELD = "callBackReqSelectField";
    private static final String CALL_BACK_PRO_SELECT_FIELD = "callBackProSelectField";
    private static final String FIELD_KEY_MATERIAL = "materiel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"reqfieldname", "profieldname", "reqfieldkey", "profieldkey"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.insertFixedDim();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("reqfieldkey".equals(key)) {
            this.showReqFieldTree();
        } else if ("profieldkey".equals(key)) {
            this.showProFieldTree();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (CALL_BACK_REQ_SELECT_FIELD.equals(actionId)) {
            this.writeBackReqField(returnData);
        } else if (CALL_BACK_PRO_SELECT_FIELD.equals(actionId)) {
            this.writeBackProField(returnData);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            int[] selectRows;
            EntryGrid entryGrid = (EntryGrid)this.getControl("fieldsettingentry");
            for (int index : selectRows = entryGrid.getSelectRows()) {
                boolean fixedDim = (Boolean)this.getModel().getValue("fixeddim", index);
                if (!fixedDim) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u4e3a\u56fa\u5b9a\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SetOffDimEditPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]), index + 1));
                args.setCancel(true);
            }
        }
    }

    private void insertFixedDim() {
        this.getModel().deleteEntryData("fieldsettingentry");
        int rowIndex = this.getModel().createNewEntryRow("fieldsettingentry");
        MainEntityType reqRecordEntityType = EntityMetadataCache.getDataEntityType((String)FORM_ID_REQUEST_RECORD);
        String reqFieldCaption = ResourceFieldUtil.buildPropFullCaption((EntityType)reqRecordEntityType, (String)FIELD_KEY_MATERIAL);
        MainEntityType proRecordEntityType = EntityMetadataCache.getDataEntityType((String)FORM_ID_PROVIDER_RECORD);
        String proFieldCaption = ResourceFieldUtil.buildPropFullCaption((EntityType)proRecordEntityType, (String)FIELD_KEY_MATERIAL);
        this.getModel().setValue("fieldname", (Object)ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"SetOffDimEditPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), rowIndex);
        this.getModel().setValue("reqfieldkey", (Object)FIELD_KEY_MATERIAL, rowIndex);
        this.getModel().setValue("reqfieldname", (Object)reqFieldCaption, rowIndex);
        this.getModel().setValue("profieldkey", (Object)FIELD_KEY_MATERIAL, rowIndex);
        this.getModel().setValue("profieldname", (Object)proFieldCaption, rowIndex);
        this.getModel().setValue("enablestatus", (Object)true, rowIndex);
        this.getModel().setValue("fixeddim", (Object)true, rowIndex);
    }

    private void writeBackReqField(Object returnData) {
        if (returnData == null) {
            return;
        }
        String returnDataStr = (String)returnData;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)FORM_ID_REQUEST_RECORD);
        String fieldCaption = ResourceFieldUtil.buildPropFullCaption((EntityType)entityType, (String)returnDataStr);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("fieldsettingentry");
        this.getModel().setValue("reqfieldkey", (Object)returnDataStr, rowIndex);
        this.getModel().setValue("reqfieldname", (Object)fieldCaption, rowIndex);
    }

    private void writeBackProField(Object returnData) {
        if (returnData == null) {
            return;
        }
        String returnDataStr = (String)returnData;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)FORM_ID_PROVIDER_RECORD);
        String fieldCaption = ResourceFieldUtil.buildPropFullCaption((EntityType)entityType, (String)returnDataStr);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("fieldsettingentry");
        this.getModel().setValue("profieldkey", (Object)returnDataStr, rowIndex);
        this.getModel().setValue("profieldname", (Object)fieldCaption, rowIndex);
    }

    private void showReqFieldTree() {
        this.showFieldTree(FORM_ID_REQUEST_RECORD, CALL_BACK_REQ_SELECT_FIELD);
    }

    private void showProFieldTree() {
        this.showFieldTree(FORM_ID_PROVIDER_RECORD, CALL_BACK_PRO_SELECT_FIELD);
    }

    private void showFieldTree(String entityName, String callBackId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        BillTreeBuildParameter buildTreeParam = new BillTreeBuildParameter(entityType);
        buildTreeParam.setIncludePKField(true);
        buildTreeParam.setOnlyPhysicsField(false);
        TreeNode treeNode = this.buildBillTreeNodes(buildTreeParam);
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORM_ID_FIELD_SELECT);
        showParameter.getCustomParams().put(SELECT_FIELD_PARAM_TREE_NODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private TreeNode buildBillTreeNodes(BillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List fieldNode = BillFieldEntityHelper.buildFldTreeNodes((BillTreeBuildParameter)parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fieldNode) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fieldNode) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }
}

