/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.planSetoff;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mds.common.algorithm.util.ResourceFieldUtil;
import kd.mmc.mds.common.entity.SetoffFieldSetConst;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;

public class SetoffFieldSetEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(SetoffFieldSetEditPlugin.class);
    private static final String FORM_ID_FIELD_SELECT = "mds_billfieldselect";
    private static final String FORM_ID_FN_REPORT = "mds_fnreport";
    private static final String SELECT_FIELD_PARAM_TREE_NODES = "treenodes";
    private static final String CALL_BACK_TARGET_SELECT_FIELD = "callBackTargetSelectField";
    private static final String CALL_BACK_SRC_SELECT_FIELD = "callBackSrcSelectField";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"targetfieldkey", "srcfieldkey"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String srcFieldKey;
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("sourcetype".equals(propName)) {
            DynamicObject sourceType = (DynamicObject)this.getModel().getValue("sourcetype", rowIndex);
            if (sourceType == null) {
                this.getModel().setValue("srcfieldkey", null, rowIndex);
                this.getModel().setValue("srcfieldname", null, rowIndex);
            }
        } else if ("targetfieldkey".equals(propName)) {
            String targetFieldKey = (String)this.getModel().getValue("targetfieldkey", rowIndex);
            if (StringUtils.isBlank((CharSequence)targetFieldKey)) {
                this.getModel().setValue("targetfieldname", null, rowIndex);
            }
        } else if ("srcfieldkey".equals(propName) && StringUtils.isBlank((CharSequence)(srcFieldKey = (String)this.getModel().getValue("srcfieldkey", rowIndex)))) {
            this.getModel().setValue("srcfieldname", null, rowIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("targetfieldkey".equals(key)) {
            this.showTargetFieldTree();
        } else if ("srcfieldkey".equals(key)) {
            this.showSrcFieldTree();
        }
    }

    private void showTargetFieldTree() {
        this.showFieldTree(FORM_ID_FN_REPORT, CALL_BACK_TARGET_SELECT_FIELD, true);
    }

    private void showSrcFieldTree() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject sourceType = (DynamicObject)this.getModel().getValue("sourcetype", rowIndex);
        if (sourceType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6e90\u5355\u7c7b\u578b\u201d\u3002", (String)"SetoffFieldSetEditPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        String sourceTypeId = (String)sourceType.getPkValue();
        this.showFieldTree(sourceTypeId, CALL_BACK_SRC_SELECT_FIELD, false);
    }

    private void showFieldTree(String entityName, String callBackId, boolean isTargetField) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        BillTreeBuildParameter buildTreeParam = new BillTreeBuildParameter(entityType);
        buildTreeParam.setIncludePKField(true);
        buildTreeParam.setOnlyPhysicsField(false);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (isTargetField) {
            String sourceTypeId;
            MainEntityType srcBillMainType;
            IDataEntityProperty srcFieldProp;
            DynamicObject sourceType = (DynamicObject)this.getModel().getValue("sourcetype", rowIndex);
            String srcFieldKey = (String)this.getModel().getValue("srcfieldkey", rowIndex);
            if (sourceType != null && StringUtils.isNotBlank((CharSequence)srcFieldKey) && (srcFieldProp = (srcBillMainType = EntityMetadataCache.getDataEntityType((String)(sourceTypeId = (String)sourceType.getPkValue()))).findProperty(srcFieldKey)) != null) {
                buildTreeParam.setMatchedProperty(srcFieldProp);
            }
        } else {
            MainEntityType targetBillMainType;
            IDataEntityProperty targetFieldProp;
            String targetFieldKey = (String)this.getModel().getValue("targetfieldkey", rowIndex);
            if (StringUtils.isNotBlank((CharSequence)targetFieldKey) && (targetFieldProp = (targetBillMainType = EntityMetadataCache.getDataEntityType((String)FORM_ID_FN_REPORT)).findProperty(targetFieldKey)) != null) {
                buildTreeParam.setMatchedProperty(targetFieldProp);
            }
        }
        TreeNode treeNode = this.buildBillTreeNodes(buildTreeParam, isTargetField);
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORM_ID_FIELD_SELECT);
        showParameter.getCustomParams().put(SELECT_FIELD_PARAM_TREE_NODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private TreeNode buildBillTreeNodes(BillTreeBuildParameter parameter, boolean isTargetField) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        billNode.setDisabled(true);
        List fieldNodeList = BillFieldEntityHelper.buildFldTreeNodes((BillTreeBuildParameter)parameter);
        List logFieldList = fieldNodeList.stream().map(TreeNode::getId).collect(Collectors.toList());
        logger.info(String.format("\u51b2\u51cf\u5b57\u6bb5\u8bbe\u7f6e\uff0c\u89e3\u6790\u5b9e\u4f53\u5f97\u5230\u6811\u8282\u70b9\uff1a%1$s\uff0c\u5b57\u6bb5\u5e38\u91cf\uff1a%2$s", logFieldList, SetoffFieldSetConst.FIXED_FIELDS));
        if (isTargetField) {
            for (String fixedField : SetoffFieldSetConst.FIXED_FIELDS) {
                fieldNodeList = fieldNodeList.stream().filter(v -> v.getId() != null && !v.getId().startsWith(fixedField)).collect(Collectors.toList());
            }
        }
        for (TreeNode node : fieldNodeList) {
            String text = node.getText();
            text = text + String.format("(%s)", node.getId());
            node.setText(text);
        }
        for (TreeNode node : fieldNodeList) {
            String parentId = node.getParentid();
            if (!"billhead".equals(parentId)) continue;
            node.setParentid(billNode.getId());
            billNode.addChild(node);
        }
        return billNode;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (CALL_BACK_TARGET_SELECT_FIELD.equals(actionId)) {
            this.writeBackTargetField(returnData);
        } else if (CALL_BACK_SRC_SELECT_FIELD.equals(actionId)) {
            this.writeBackSrcField(returnData);
        }
    }

    private void writeBackTargetField(Object returnData) {
        if (returnData == null) {
            return;
        }
        String returnDataStr = (String)returnData;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)FORM_ID_FN_REPORT);
        String fieldCaption = ResourceFieldUtil.buildPropFullCaption((EntityType)entityType, (String)returnDataStr);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue("targetfieldkey", (Object)returnDataStr, rowIndex);
        this.getModel().setValue("targetfieldname", (Object)fieldCaption, rowIndex);
    }

    private void writeBackSrcField(Object returnData) {
        if (returnData == null) {
            return;
        }
        String returnDataStr = (String)returnData;
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject sourceType = (DynamicObject)this.getModel().getValue("sourcetype", rowIndex);
        if (sourceType == null) {
            logger.info("\u56de\u5199\u6e90\u5355\u5b57\u6bb5\u5931\u8d25\uff0c\u6e90\u5355\u7c7b\u578b\u4e3a\u7a7a");
            return;
        }
        String sourceTypeId = (String)sourceType.getPkValue();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)sourceTypeId);
        String fieldCaption = ResourceFieldUtil.buildPropFullCaption((EntityType)entityType, (String)returnDataStr);
        this.getModel().setValue("srcfieldkey", (Object)returnDataStr, rowIndex);
        this.getModel().setValue("srcfieldname", (Object)fieldCaption, rowIndex);
    }
}

