/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.probability;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;

public class FilterConditionEditPlugin
extends AbstractBillPlugIn {
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        String filter = (String)parameterParams.get("filter");
        String number = (String)parameterParams.get("billNumber");
        if (StringUtils.isNotEmpty((CharSequence)number)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            ProbabilityUtil.initFilterGridByNumber((String)number, (FilterGrid)filterGrid);
            if (StringUtils.isNotEmpty((CharSequence)filter)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
                filterGrid.SetValue(filterCondition);
                filterGrid.getFilterGridState();
            }
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    public void click(EventObject evt) {
        Control btn = (Control)evt.getSource();
        HashMap<String, String> params = new HashMap<String, String>(16);
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            String filter = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map parameterParams = parameter.getCustomParams();
            String number = (String)parameterParams.get("billNumber");
            params.put("filter", filter);
            params.put("billNumber", number);
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }
}

