/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.probability;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;

public class FilterContrastFieldEditPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String SAMPLEFILED = "samplefiled";
    private static final String HISTORYFIELD = "historyfield";
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterBindData(EventObject e) {
        String sampleHistoryValues;
        Object historyNumber;
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        Object sampleNumber = parameterParams.get("sampleNumber");
        if (StringUtils.isNotBlank(sampleNumber)) {
            this.initEntryComboEdit(String.valueOf(sampleNumber), SAMPLEFILED);
        }
        if (StringUtils.isNotBlank(historyNumber = parameterParams.get("historyNumber"))) {
            this.initEntryComboEdit(String.valueOf(historyNumber), HISTORYFIELD);
        }
        if (StringUtils.isNotEmpty((CharSequence)(sampleHistoryValues = (String)parameterParams.get("sampleHistoryValues")))) {
            this.insertEntryRows(sampleHistoryValues);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRYENTITY);
        String sampleItemStr = this.getPageCache().get("sampleItems");
        List sampleList = ProbabilityUtil.getRepeatField((DynamicObjectCollection)entryentitys, (String)sampleItemStr, (String)SAMPLEFILED);
        if (sampleList != null && !sampleList.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6837\u672c\u6570\u636e\u8868\u5b57\u6bb5\uff1a%s\u5b58\u5728\u91cd\u590d\u3002", (String)"FilterContrastFieldEditPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), sampleList));
            evt.setCancel(true);
            return;
        }
        String historyItemStr = this.getPageCache().get("historyItems");
        List historyList = ProbabilityUtil.getRepeatField((DynamicObjectCollection)entryentitys, (String)historyItemStr, (String)HISTORYFIELD);
        if (historyList != null && !historyList.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6837\u672c\u5386\u53f2\u4f7f\u7528\u6570\u636e\u8868\u5b57\u6bb5\uff1a%s\u5b58\u5728\u91cd\u590d\u3002", (String)"FilterContrastFieldEditPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]), historyList));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        ArrayList<String[]> params = new ArrayList<String[]>(16);
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            String sampleItemStr = this.getPageCache().get("sampleItems");
            List sampleItems = ProbabilityUtil.getComboItemList((String)sampleItemStr);
            if (sampleItems == null) {
                return;
            }
            String historyItemStr = this.getPageCache().get("historyItems");
            List historyItems = ProbabilityUtil.getComboItemList((String)historyItemStr);
            if (historyItems == null) {
                return;
            }
            DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRYENTITY);
            for (DynamicObject entryentity : entryentitys) {
                String samplefiled = entryentity.getString(SAMPLEFILED);
                String historyfield = entryentity.getString(HISTORYFIELD);
                if (StringUtils.isEmpty((CharSequence)samplefiled) || StringUtils.isEmpty((CharSequence)historyfield)) continue;
                String samplefiledName = ProbabilityUtil.getComboItemName((List)sampleItems, (String)samplefiled);
                String historyfieldName = ProbabilityUtil.getComboItemName((List)sampleItems, (String)historyfield);
                params.add(new String[]{samplefiled, historyfield, samplefiledName, historyfieldName});
            }
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    private void initEntryComboEdit(String number, String comboField) {
        ComboEdit comboEditType = (ComboEdit)this.getControl(comboField);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        if (dataEntityType != null) {
            Map allFields = dataEntityType.getAllFields();
            List items = allFields.keySet().stream().map(item -> {
                String fieldId;
                DynamicProperty findProperty = (DynamicProperty)dataEntityType.findProperty(item);
                if (findProperty.getParent() instanceof EntryType) {
                    EntryType entry = (EntryType)findProperty.getParent();
                    fieldId = String.join((CharSequence)".", entry.getName(), item);
                } else {
                    fieldId = item;
                }
                LocaleString displayName = findProperty.getDisplayName();
                return new ComboItem(displayName, fieldId);
            }).collect(Collectors.toList());
            comboEditType.setComboItems(items);
            if (SAMPLEFILED.equals(comboField)) {
                this.getPageCache().put("sampleItems", JSON.toJSONString(items));
            }
            if (HISTORYFIELD.equals(comboField)) {
                this.getPageCache().put("historyItems", JSON.toJSONString(items));
            }
        }
    }

    private void insertEntryRows(String sampleHistoryValues) {
        List values = JSON.parseArray((String)sampleHistoryValues, String[].class);
        this.getModel().deleteEntryData(ENTRYENTITY);
        EntryGrid entryentity = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)entryentity.getModel();
        TableValueSetter vs = new TableValueSetter(new String[]{SAMPLEFILED, HISTORYFIELD});
        model.beginInit();
        for (String[] val : values) {
            vs.addRow(new Object[]{val[0], val[1]});
        }
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }
}

