/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.probability;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.container.Tab;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.probability.task.ProbabilityAnalysisTask;
import kd.mmc.mds.common.probability.task.ProbabilityExportTask;
import kd.mmc.mds.common.probability.task.ProbabilityFetchRecordTask;
import kd.mmc.mds.common.probability.task.ProbabilityFetchSampleTask;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;
import kd.mmc.mds.common.schedule.TaskTrigger;

public class ProbabilityCalcFormPlugin
extends AbstractFormPlugin {
    private static final String SAMPLE_BILLLISTAP = "samplebilllistap";
    private static final String RECORD_BILLLISTAP = "recordbilllistap";
    private static final String RESULT_BILLLISTAP = "resultbilllistap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initAllBillListFilter();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("probabilitylog_filter".equals(key)) {
            this.refresh();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operatekey = e.getOperateKey();
        if ("fetchsample".equals(operatekey)) {
            if (this.operationSuccess(e.getOperationResult())) {
                this.doFetchSample();
            }
        } else if ("fetchrecord".equals(operatekey)) {
            if (this.operationSuccess(e.getOperationResult())) {
                this.doFetchRecord();
            }
        } else if ("analysis".equals(operatekey)) {
            if (this.operationSuccess(e.getOperationResult())) {
                this.doAnalysis();
            }
        } else if ("export".equals(operatekey)) {
            if (this.operationSuccess(e.getOperationResult())) {
                this.doExport();
            }
        } else if ("showlog".equals(operatekey)) {
            if (this.operationSuccess(e.getOperationResult())) {
                // empty if block
            }
        } else if ("refresh".equals(operatekey)) {
            this.refresh();
        }
    }

    private void refresh() {
        BillList samplebilllistap = (BillList)this.getView().getControl(SAMPLE_BILLLISTAP);
        this.initBillListFilter(samplebilllistap);
        this.initBillListSelect(samplebilllistap, "mds_sample");
        samplebilllistap.refresh();
        BillList recordbilllistap = (BillList)this.getView().getControl(RECORD_BILLLISTAP);
        this.initBillListFilter(recordbilllistap);
        this.initBillListSelect(recordbilllistap, "mds_samplerecord");
        recordbilllistap.refresh();
        BillList resultbilllistap = (BillList)this.getView().getControl(RESULT_BILLLISTAP);
        this.initBillListFilter(resultbilllistap, this.getResultQFilter());
        resultbilllistap.refresh();
    }

    private void doExport() {
        DynamicObject log = (DynamicObject)this.getModel().getValue("probabilitylog_filter");
        Long logid = null;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        if (log == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u521b\u5efa\u5931\u8d25\u3002", (String)"ProbabilityCalcFormPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        logid = log.getLong("id");
        params.put("clearProbability", true);
        this.getView().updateView("probabilitylog_filter");
        params.put("probabilitylog.id", logid);
        this.triggerDoExportTask(params);
    }

    private void initBillListSelect(BillList billlistap, String entryName) {
        DynamicObject log = (DynamicObject)this.getModel().getValue("probabilitylog_filter");
        Long logid = null;
        if (log == null) {
            billlistap.clearSelection();
            return;
        }
        logid = log.getLong("id");
        QFilter qFilter = new QFilter("logid", "=", (Object)logid);
        qFilter.and("use", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ProbabilityCalcFormPlugin.class.getName(), (String)entryName, (String)"id", (QFilter[])new QFilter[]{qFilter}, null);
        ListSelectedRowCollection coll = new ListSelectedRowCollection();
        for (Row row : dataSet) {
            ListSelectedRow listRow = new ListSelectedRow();
            listRow.setPrimaryKeyValue((Object)row.getLong("id"));
            coll.add((Object)listRow);
        }
        billlistap.clearSelection();
        billlistap.putSelectedRows(coll);
    }

    private Long createLog(long logId) {
        Object probabilitycaldefFilter = this.getModel().getValue("probabilitycaldef_filter");
        Long defId = null;
        if (probabilitycaldefFilter instanceof DynamicObject) {
            defId = ((DynamicObject)probabilitycaldefFilter).getLong("id");
        }
        Map<String, Object> params = this.buildLogParams();
        if (logId == 0L) {
            return ProbabilityUtil.CreateProbabilityLog((Object)defId, params);
        }
        return ProbabilityUtil.updateProbabilityLog((Object)defId, (Object)logId, params);
    }

    private Map<String, Object> buildLogParams() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject curorg = dataEntity.getDynamicObject("curorg");
        DynamicObjectCollection createorg_filter = dataEntity.getDynamicObjectCollection("createorg_filter");
        DynamicObject probabilitycaldef_filter = dataEntity.getDynamicObject("probabilitycaldef_filter");
        DynamicObject probabilitylog_filter = dataEntity.getDynamicObject("probabilitylog_filter");
        DynamicObjectCollection customer_filter = dataEntity.getDynamicObjectCollection("customer_filter");
        DynamicObjectCollection actype_filter = dataEntity.getDynamicObjectCollection("actype_filter");
        DynamicObjectCollection checktype_filter = dataEntity.getDynamicObjectCollection("checktype_filter");
        DynamicObjectCollection projectstate_filter = dataEntity.getDynamicObjectCollection("projectstate_filter");
        DynamicObjectCollection cardtype_filter = dataEntity.getDynamicObjectCollection("cardtype_filter");
        DynamicObjectCollection card_filter = dataEntity.getDynamicObjectCollection("card_filter");
        String commongroup = dataEntity.getString("commongroup");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterStr = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        DynamicObject backupproject_filter = dataEntity.getDynamicObject("backupproject_filter");
        DynamicObjectCollection biztype_filter = dataEntity.getDynamicObjectCollection("biztype_filter");
        DynamicObjectCollection cabinconfig_filter = dataEntity.getDynamicObjectCollection("cabinconfig_filter");
        DynamicObjectCollection polarisstatus_filter = dataEntity.getDynamicObjectCollection("polarisstatus_filter");
        String countdim_filter = dataEntity.getString("countdim_filter");
        String analysisdim_filter = dataEntity.getString("analysisdim_filter");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("createorg_filter", createorg_filter);
        params.put("probabilitycaldef_filter", probabilitycaldef_filter);
        params.put("probabilitylog_filter", probabilitylog_filter);
        params.put("customer_filter", customer_filter);
        params.put("actype_filter", actype_filter);
        params.put("checktype_filter", checktype_filter);
        params.put("projectstate_filter", projectstate_filter);
        params.put("cardtype_filter", cardtype_filter);
        params.put("card_filter", card_filter);
        params.put("curorg", curorg);
        params.put("commongroup", commongroup);
        params.put("filterStr", filterStr);
        params.put("filterEntityNumber", filterGrid.getEntityNumber());
        params.put("backupproject_filter", backupproject_filter);
        params.put("biztype_filter", biztype_filter);
        params.put("cabinconfig_filter", cabinconfig_filter);
        params.put("polarisstatus_filter", polarisstatus_filter);
        params.put("countdim_filter", countdim_filter);
        params.put("analysisdim_filter", analysisdim_filter);
        return params;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doFetchSample() {
        DynamicObject log = (DynamicObject)this.getModel().getValue("probabilitylog_filter");
        DynamicObject curorg = (DynamicObject)this.getModel().getValue("curorg");
        Long logid = null;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        if (log == null) {
            logid = this.createLog(0L);
            if (logid == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u521b\u5efa\u5931\u8d25\u3002", (String)"ProbabilityCalcFormPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return;
            }
            log = ProbabilityUtil.ProbabilityLog((Object)logid);
            this.getModel().setValue("probabilitylog_filter", (Object)log);
        } else {
            logid = log.getLong("id");
            logid = this.createLog(logid);
            params.put("clearProbability", true);
        }
        this.getView().updateView("probabilitylog_filter");
        Long orgid = curorg.getLong("id");
        params.put("probabilitylog.id", logid);
        params.put("curorg.id", orgid);
        this.triggerFetchSampleTask(params);
    }

    private void doFetchRecord() {
        DynamicObject log = (DynamicObject)this.getModel().getValue("probabilitylog_filter");
        DynamicObject curorg = (DynamicObject)this.getModel().getValue("curorg");
        Long logid = null;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        if (log == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u521b\u5efa\u5931\u8d25\u3002", (String)"ProbabilityCalcFormPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        logid = log.getLong("id");
        String calstatus = (log = ProbabilityUtil.ProbabilityLog((Object)logid)).getString("calstatus");
        if (!"B".equalsIgnoreCase(calstatus) && !"F".equalsIgnoreCase(calstatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u83b7\u53d6\u6837\u672c\u7684\u6570\u636e\u624d\u80fd\u83b7\u53d6\u5386\u53f2\u3002", (String)"ProbabilityCalcFormPlugin_6", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        params.put("clearProbability", true);
        BillList samplebilllistap = (BillList)this.getView().getControl(SAMPLE_BILLLISTAP);
        ListSelectedRowCollection collection = samplebilllistap.getSelectedRows();
        ProbabilityDBHelper.clearUserSelectField((long)logid, (String)"t_mds_sample");
        ProbabilityDBHelper.updateUserSelectField(collection.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toSet()), (String)"t_mds_sample");
        this.getView().updateView("probabilitylog_filter");
        Long orgid = curorg.getLong("id");
        params.put("probabilitylog.id", logid);
        params.put("curorg.id", orgid);
        this.triggerFetchRecordTask(params);
    }

    private void doAnalysis() {
        DynamicObject log = (DynamicObject)this.getModel().getValue("probabilitylog_filter");
        DynamicObject curorg = (DynamicObject)this.getModel().getValue("curorg");
        Long logid = null;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        if (log == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u521b\u5efa\u5931\u8d25\u3002", (String)"ProbabilityCalcFormPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        logid = log.getLong("id");
        String calstatus = (log = ProbabilityUtil.ProbabilityLog((Object)logid)).getString("calstatus");
        if (!"D".equalsIgnoreCase(calstatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u83b7\u53d6\u5386\u53f2\u7684\u6570\u636e\u624d\u80fd\u5206\u6790\u7ed3\u679c\u3002", (String)"ProbabilityCalcFormPlugin_5", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        params.put("clearProbability", true);
        BillList billlistap = (BillList)this.getView().getControl(RECORD_BILLLISTAP);
        ListSelectedRowCollection collection = billlistap.getSelectedRows();
        ProbabilityDBHelper.clearUserSelectField((long)logid, (String)"t_mds_samplehisrecord");
        ProbabilityDBHelper.updateUserSelectField(collection.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toSet()), (String)"t_mds_samplehisrecord");
        this.getView().updateView("probabilitylog_filter");
        Long orgid = curorg.getLong("id");
        params.put("probabilitylog.id", logid);
        params.put("curorg.id", orgid);
        this.triggerDoAnalysisTask(params);
    }

    private void triggerFetchRecordTask(Map<String, Object> params) {
        TaskTrigger trigger = new TaskTrigger(ProbabilityFetchRecordTask.class, this.getView(), ResManager.loadKDString((String)"\u83b7\u53d6\u6837\u672c\u5386\u53f2\u4f7f\u7528\u6570\u636e", (String)"ProbabilityCalcFormPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "fetchrecordcallback");
        trigger.setCloseCallBack(closeCallBack);
        trigger.run(params);
    }

    private void triggerFetchSampleTask(Map<String, Object> params) {
        TaskTrigger trigger = new TaskTrigger(ProbabilityFetchSampleTask.class, this.getView(), ResManager.loadKDString((String)"\u83b7\u53d6\u6837\u672c\u6570\u636e", (String)"ProbabilityCalcFormPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "fetchsamplecallback");
        trigger.setCloseCallBack(closeCallBack);
        trigger.run(params);
    }

    private void triggerDoAnalysisTask(Map<String, Object> params) {
        TaskTrigger trigger = new TaskTrigger(ProbabilityAnalysisTask.class, this.getView(), ResManager.loadKDString((String)"\u5206\u6790\u7ed3\u679c", (String)"ProbabilityCalcFormPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "analysiscallback");
        trigger.setCloseCallBack(closeCallBack);
        trigger.run(params);
    }

    private void triggerDoExportTask(Map<String, Object> params) {
        TaskTrigger trigger = new TaskTrigger(ProbabilityExportTask.class, this.getView(), ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e", (String)"ProbabilityCalcFormPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "exportcallback");
        trigger.setCloseCallBack(closeCallBack);
        trigger.run(params);
    }

    private boolean operationSuccess(OperationResult operationResult) {
        ValidateResultCollection resultCollection = operationResult.getValidateResult();
        List errResults = resultCollection.getValidateErrors();
        return errResults == null || errResults.size() == 0;
    }

    public void beforeBindData(EventObject e) {
        long orgid = RequestContext.get().getOrgId();
        if (orgid != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org");
            this.getModel().setValue("curorg", (Object)org);
        }
        this.initAllBillListFilter();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Tab tab;
        Map dataMap;
        String data;
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        Object returnData = e.getReturnData();
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotEmpty((CharSequence)(data = taskInfo.getData())) && (dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class)).containsKey("failed")) {
            this.getView().showErrorNotification(String.valueOf(dataMap.get("failed")));
        }
        if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"fetchsamplecallback")) {
            BillList samplebilllistap = (BillList)this.getView().getControl(SAMPLE_BILLLISTAP);
            this.initBillListFilter(samplebilllistap);
            this.initBillListSelect(samplebilllistap, "mds_sample");
            samplebilllistap.refresh();
            tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab("tabpageap");
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"fetchrecordcallback")) {
            BillList recordbilllistap = (BillList)this.getView().getControl(RECORD_BILLLISTAP);
            this.initBillListFilter(recordbilllistap);
            this.initBillListSelect(recordbilllistap, "mds_samplerecord");
            recordbilllistap.refresh();
            tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab("tabpageap1");
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"analysiscallback")) {
            BillList resultbilllistap = (BillList)this.getView().getControl(RESULT_BILLLISTAP);
            this.initBillListFilter(resultbilllistap, this.getResultQFilter());
            resultbilllistap.refresh();
            tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab("tabpageap2");
        } else if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"exportcallback") && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotEmpty((CharSequence)(data = taskInfo.getData())) && (dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class)).containsKey("exportUrl")) {
            String url = String.valueOf(dataMap.get("exportUrl"));
            this.getView().download(url);
        }
    }

    private void initBillListFilter(BillList billist, QFilter customQFilter) {
        SetFilterListener filterListener = setFilterEvent -> {
            QFilter qFilter;
            DynamicObject log = (DynamicObject)this.getModel().getValue("probabilitylog_filter");
            if (log != null) {
                long logid = log.getLong("id");
                qFilter = new QFilter("logid", "=", (Object)logid);
            } else {
                qFilter = new QFilter("1", "=", (Object)2);
            }
            if (customQFilter != null) {
                qFilter.and(customQFilter);
            }
            setFilterEvent.addCustomQFilter(qFilter);
        };
        billist.addSetFilterListener(filterListener);
    }

    private void initBillListFilter(BillList billist) {
        this.initBillListFilter(billist, null);
    }

    private void initAllBillListFilter() {
        BillList samplebilllistap = (BillList)this.getView().getControl(SAMPLE_BILLLISTAP);
        this.initBillListFilter(samplebilllistap);
        BillList recordbilllistap = (BillList)this.getView().getControl(RECORD_BILLLISTAP);
        this.initBillListFilter(recordbilllistap);
        BillList resultbilllistap = (BillList)this.getView().getControl(RESULT_BILLLISTAP);
        this.initBillListFilter(resultbilllistap, this.getResultQFilter());
    }

    public QFilter getResultQFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterStr = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        return ProbabilityUtil.getQFilter((String)filterStr, (String)"mds_probabilityresult");
    }
}

