/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.probability;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;

public class ProbabilityCalcFormRulePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String PROBABILITYCALDEF = "probabilitycaldef_filter";
    private static final String PROBABILITYLOG = "probabilitylog_filter";
    private static final String RESULTENTRYENTITY = "resultentryentity";
    private static final String RPSELECTFILTERVAL = "rpselectfilterval";
    private static final String FILTERGRIDAP = "filtergridap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit probabilitylog = (BasedataEdit)this.getControl(PROBABILITYLOG);
        if (probabilitylog != null) {
            probabilitylog.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        ProbabilityUtil.initFilterGridByNumber((String)this.getView().getEntityId(), (FilterGrid)filterGrid);
        this.getView().updateView(FILTERGRIDAP);
        this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP, PROBABILITYLOG});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (PROBABILITYCALDEF.equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.SetValue(new FilterCondition());
            if (newValue != null) {
                this.initFilterGridData((DynamicObject)newValue);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP, PROBABILITYLOG});
            }
            this.getModel().setValue(PROBABILITYLOG, null);
        } else if (PROBABILITYLOG.equals(key)) {
            IDataModel model = this.getModel();
            if (newValue != null) {
                DynamicObject probabilityLog = (DynamicObject)newValue;
                model.setValue("backupproject_filter", probabilityLog.get("backupproject"));
                model.setValue("customer_filter", probabilityLog.get("customer"));
                model.setValue("actype_filter", probabilityLog.get("actype"));
                model.setValue("checktype_filter", probabilityLog.get("checktype"));
                model.setValue("projectstate_filter", probabilityLog.get("projectstate"));
                model.setValue("biztype_filter", probabilityLog.get("biztype"));
                model.setValue("cabinconfig_filter", probabilityLog.get("cabinconfig"));
                model.setValue("polarisstatus_filter", probabilityLog.get("polarisstatus"));
                model.setValue("card_filter", probabilityLog.get("card"));
                model.setValue("countdim_filter", probabilityLog.get("countdim"));
                model.setValue("analysisdim_filter", probabilityLog.get("analysisdim"));
            } else {
                model.setValue("backupproject_filter", null);
                model.setValue("customer_filter", null);
                model.setValue("actype_filter", null);
                model.setValue("checktype_filter", null);
                model.setValue("projectstate_filter", null);
                model.setValue("biztype_filter", null);
                model.setValue("cabinconfig_filter", null);
                model.setValue("polarisstatus_filter", null);
                model.setValue("card_filter", null);
                model.setValue("countdim_filter", (Object)"1");
                model.setValue("analysisdim_filter", (Object)"A");
            }
        }
    }

    private void initFilterGridData(DynamicObject probabilityCalDef) {
        DynamicObject entry;
        String filterStr;
        if (probabilityCalDef == null) {
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP, PROBABILITYLOG});
        long algorithmId = probabilityCalDef.getLong("algorithmdef.id");
        DynamicObject algorithmDef = BusinessDataServiceHelper.loadSingle((Object)algorithmId, (String)"mds_algorithmdef", (String)"destbill.id");
        String destBill = algorithmDef.getString("destbill.id");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        ProbabilityUtil.initFilterGridByNumber((String)destBill, (FilterGrid)filterGrid);
        this.getView().updateView(FILTERGRIDAP);
        DynamicObjectCollection resultEntry = probabilityCalDef.getDynamicObjectCollection(RESULTENTRYENTITY);
        if (resultEntry != null && !resultEntry.isEmpty() && StringUtils.isNotEmpty((CharSequence)(filterStr = (entry = (DynamicObject)resultEntry.get(0)).getString(RPSELECTFILTERVAL)))) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        if (PROBABILITYLOG.equals(name)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            DynamicObject probabilitycaldef = (DynamicObject)this.getModel().getValue(PROBABILITYCALDEF);
            if (probabilitycaldef != null) {
                QFilter filter = new QFilter("probabilitycaldef", "=", probabilitycaldef.getPkValue());
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }
}

