/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.probability;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;

public class SortFieldEditPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String FIELD = "field";
    private static final String SORTORDER = "sortorder";
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterBindData(EventObject e) {
        String sortValues;
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        Object billNumber = parameterParams.get("billNumber");
        if (billNumber != null) {
            this.initEntryComboEdit((String)billNumber, FIELD);
        }
        if (StringUtils.isNotEmpty((CharSequence)(sortValues = (String)parameterParams.get("sortValues")))) {
            this.insertEntryRows(sortValues);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRYENTITY);
        String itemsStr = this.getPageCache().get("items");
        List fieldList = ProbabilityUtil.getRepeatField((DynamicObjectCollection)entryentitys, (String)itemsStr, (String)FIELD);
        if (fieldList != null && !fieldList.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u5b58\u5728\u91cd\u590d\u3002", (String)"SortFieldEditPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), fieldList));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        ArrayList<String[]> params = new ArrayList<String[]>(16);
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            String itemsStr = this.getPageCache().get("items");
            List items = ProbabilityUtil.getComboItemList((String)itemsStr);
            if (items == null) {
                return;
            }
            ComboEdit sortorderComboEditType = (ComboEdit)this.getControl(SORTORDER);
            ComboProp sortorderProperty = (ComboProp)sortorderComboEditType.getProperty();
            DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRYENTITY);
            for (DynamicObject entryentity : entryentitys) {
                String field = entryentity.getString(FIELD);
                String sortOrder = entryentity.getString(SORTORDER);
                if (StringUtils.isEmpty((CharSequence)field) || StringUtils.isEmpty((CharSequence)sortOrder)) continue;
                String fieldItemName = ProbabilityUtil.getComboItemName((List)items, (String)field);
                String sortOrderItemName = sortorderProperty.getItemByName(sortOrder);
                params.add(new String[]{field, sortOrder, fieldItemName, sortOrderItemName});
            }
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    private void initEntryComboEdit(String number, String comboField) {
        ComboEdit comboEditType = (ComboEdit)this.getControl(comboField);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        if (dataEntityType != null) {
            Map allFields = dataEntityType.getAllFields();
            List items = allFields.keySet().stream().map(item -> {
                DynamicProperty findProperty = (DynamicProperty)dataEntityType.findProperty(item);
                if (findProperty instanceof TimeProp || findProperty instanceof DateTimeProp || findProperty instanceof DecimalProp) {
                    String fieldId;
                    if (findProperty.getParent() instanceof EntryType) {
                        EntryType entry = (EntryType)findProperty.getParent();
                        fieldId = String.join((CharSequence)".", entry.getName(), item);
                    } else {
                        fieldId = item;
                    }
                    LocaleString displayName = findProperty.getDisplayName();
                    return new ComboItem(displayName, fieldId);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            comboEditType.setComboItems(items);
            this.getPageCache().put("items", JSON.toJSONString(items));
        }
    }

    private void insertEntryRows(String sortValues) {
        List values = JSON.parseArray((String)sortValues, String[].class);
        this.getModel().deleteEntryData(ENTRYENTITY);
        EntryGrid entryentity = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)entryentity.getModel();
        TableValueSetter vs = new TableValueSetter(new String[]{FIELD, SORTORDER});
        model.beginInit();
        for (String[] val : values) {
            vs.addRow(new Object[]{val[0], val[1]});
        }
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }
}

