/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.productfamily;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.productfamily.ProductFamilyCommons;
import org.apache.commons.collections4.MapUtils;

public class ProductFamilyTask
extends AbstractTask {
    private static final String LOCK_GLOBAL = "mds_productfamily-global";
    private static final String MDS_PRODUCTFAMILY = "mds_productfamily";
    private static final String FIELD_MATERIELITEM = "materielitem";
    private static final String FIELD_PRODUCTFAMILY = "productfamily";
    private static final String FIELD_PLANUSER = "planuser";
    public static final String SHOW_OFFERING = "offeringshow";
    public static final String SHOW_ITEMNAME = "itemnameshow";
    private static final String FIELD_MATERIALPLAN = "materialplan";
    private static final String SYS_CREATOR = "creator";
    private static final String SYS_CREATETIME = "createtime";
    private static final String SYS_MODIFIER = "modifier";
    private static final String SYS_MODIFYTIME = "modifytime";
    private static final String SYS_STATUS = "status";
    private static final String SYS_ENABLE = "enable";
    private static final String SYS_MASTERID = "masterid";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DLock globalLock = DLock.createReentrant((String)LOCK_GLOBAL, (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u5c1d\u8bd5\u83b7\u53d6\u5168\u5c40\u9501\u3002", (String)"ProductFamilyTask_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        globalLock.lock();
        try {
            QFilter productFilter = new QFilter(SYS_ENABLE, "=", (Object)"1");
            productFilter.and(SYS_STATUS, "=", (Object)"C");
            DynamicObjectCollection allData = QueryServiceHelper.query((String)MDS_PRODUCTFAMILY, (String)"id,materielitem.id,materielitem.offeringcode", (QFilter[])new QFilter[]{productFilter});
            String materialClassifyFilter = null;
            String fstandardNumber = null;
            String offeringFilter = null;
            if (!map.isEmpty()) {
                materialClassifyFilter = MapUtils.getString(map, (Object)"material_classify_filter", (String)"");
                fstandardNumber = MapUtils.getString(map, (Object)"fstandard_number", (String)"");
                offeringFilter = MapUtils.getString(map, (Object)"offering_filter", (String)"");
            }
            Set<Long> offeringSet = this.getAllOfferingMap(allData);
            Set<Long> itemIdSet = this.getExistItemSet(allData);
            Map<Long, DynamicObject> relItemMap = this.getAllItemMap(offeringSet, offeringFilter);
            HashSet<Long> newItemSet = new HashSet<Long>(1024);
            for (Long key : relItemMap.keySet()) {
                newItemSet.add(key);
            }
            newItemSet.removeAll(itemIdSet);
            HashSet<Long> removeIdSet = new HashSet<Long>();
            if (materialClassifyFilter != null && StringUtils.isNotEmpty((String)materialClassifyFilter)) {
                HashSet<Long> passMaterailIdSet = new HashSet<Long>();
                QFilter filter = new QFilter("material.id", "in", newItemSet);
                filter.and("group.number", "in", (Object)materialClassifyFilter.split(","));
                if (fstandardNumber != null && StringUtils.isNotEmpty((String)fstandardNumber)) {
                    filter.and("group.standard.number", "in", (Object)fstandardNumber.split(","));
                }
                DynamicObjectCollection materialobjs = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material.id,group.number,group.standard.number", (QFilter[])new QFilter[]{filter});
                for (DynamicObject dynamicObject : materialobjs) {
                    passMaterailIdSet.add(dynamicObject.getLong("material.id"));
                }
                for (Long materailId : newItemSet) {
                    if (passMaterailIdSet.contains(materailId)) continue;
                    removeIdSet.add(materailId);
                }
            }
            newItemSet.removeAll(removeIdSet);
            this.saveData(newItemSet, relItemMap);
        }
        finally {
            globalLock.unlock();
        }
    }

    private void saveData(Set<Long> newItemSet, Map<Long, DynamicObject> relItemMap) {
        if (newItemSet != null && !newItemSet.isEmpty()) {
            ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>(1024);
            for (Long id : newItemSet) {
                DynamicObject item = relItemMap.get(id);
                DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)MDS_PRODUCTFAMILY);
                data.set(FIELD_MATERIELITEM, (Object)item);
                String productfamily = ProductFamilyCommons.getProductfamily((Object)item);
                data.set(FIELD_PRODUCTFAMILY, (Object)productfamily);
                DynamicObject materialPlan = ProductFamilyCommons.getMaterialPlan((Object)item);
                data.set(FIELD_MATERIALPLAN, (Object)materialPlan);
                data.set(SYS_CREATOR, (Object)1);
                data.set(SYS_CREATETIME, (Object)new Date());
                data.set(SYS_MODIFIER, (Object)1);
                data.set(SYS_MODIFYTIME, (Object)new Date());
                data.set(SYS_ENABLE, (Object)"1");
                data.set(SYS_STATUS, (Object)"C");
                long newId = this.ormGetLongId(MDS_PRODUCTFAMILY);
                data.set("id", (Object)newId);
                data.set(SYS_MASTERID, (Object)newId);
                saveDatas.add(data);
            }
            DynamicObject[] result = saveDatas.toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])result);
        }
    }

    private long ormGetLongId(String entityName) {
        return ORM.create().genLongId(entityName);
    }

    private Set<Long> getExistItemSet(DynamicObjectCollection allData) {
        HashSet<Long> result = new HashSet<Long>();
        if (allData != null && !allData.isEmpty()) {
            for (int i = 0; i < allData.size(); ++i) {
                DynamicObject data = (DynamicObject)allData.get(i);
                result.add(data.getLong("materielitem.id"));
            }
        }
        return result;
    }

    private Map<Long, DynamicObject> getAllItemMap(Set<Long> offeringSet, String offeringFilter) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>();
        if (offeringSet != null && !offeringSet.isEmpty()) {
            DynamicObject[] materialObjects;
            QFilter filter = new QFilter(SYS_ENABLE, "=", (Object)"1");
            filter.and(SYS_STATUS, "=", (Object)"C");
            if ("1".equals(offeringFilter)) {
                filter.and("offeringcode", "in", offeringSet);
            }
            if ((materialObjects = BusinessDataServiceHelper.load((String)"bd_material", (String)"id,number,name,offeringcode", (QFilter[])new QFilter[]{filter})) != null) {
                for (int i = 0; i < materialObjects.length; ++i) {
                    DynamicObject material = materialObjects[i];
                    Long id = material.getLong("id");
                    result.put(id, material);
                }
            }
        }
        return result;
    }

    private Set<Long> getAllOfferingMap(DynamicObjectCollection allData) {
        HashSet<Long> result = new HashSet<Long>();
        if (allData != null && !allData.isEmpty()) {
            for (int i = 0; i < allData.size(); ++i) {
                DynamicObject data = (DynamicObject)allData.get(i);
                Long offeringCode = data.getLong("materielitem.offeringcode");
                if (offeringCode == 0L) continue;
                result.add(offeringCode);
            }
        }
        return result;
    }
}

