/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.mmc.mds.common.util.CalcuColumns;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.common.util.MDSCacheManager;

public class BaseCalcRunTask
implements Callable<String>,
Serializable {
    private static final long serialVersionUID = 1180321487745484802L;
    private static final String KEY_PLANGRP = "plangrp";
    private static final Log logger = LogFactory.getLog(BaseCalcRunTask.class);
    private List<String> subList = null;
    private Map<String, Object> params = null;
    private DynamicObject bill = null;
    private int type = 0;
    private static final DBRoute pur = new DBRoute("pur");

    public BaseCalcRunTask() {
    }

    public BaseCalcRunTask(List<String> sList, Map<String, Object> paramsMap, DynamicObject billDo, int type1) {
        this.subList = sList;
        this.params = paramsMap;
        this.bill = billDo;
        this.type = type1;
    }

    @Override
    public String call() throws Exception {
        String replaceAll = UUID.randomUUID().toString().replaceAll("-", "1");
        logger.info("BaseCalcRunningTask888:\u591a\u7ebf\u7a0b.-------start\uff1a" + replaceAll + "------" + System.currentTimeMillis());
        try (TXHandle h = TX.requiresNew((String)"call");){
            this.startBusinessFlow();
        }
        logger.info("BaseCalcRunningTask888:\u591a\u7ebf\u7a0b.-------end\uff1a" + replaceAll + "------" + System.currentTimeMillis());
        return null;
    }

    public void startBusinessFlow() {
        Boolean isquota = (Boolean)this.params.get("ISQUOTA");
        Object[] pkArray = (Object[])this.params.get("SOURCES");
        String inType = (String)this.params.get("INTYPE");
        Map relations = (Map)this.params.get("RATS");
        DynamicObject zdvr = (DynamicObject)this.params.get("DVR");
        DynamicObject dest = (DynamicObject)this.params.get("DESTVRDS");
        StringBuilder msb = new StringBuilder();
        int index = 0;
        for (String materialId : this.subList) {
            if (++index == this.subList.size()) {
                msb.append(materialId);
                continue;
            }
            msb.append(materialId).append(',');
        }
        Map<String, Map<Date, List<Map<String, String>>>> destMap = this.getDestMaterialData(msb.toString(), dest);
        Map<Object, Object> materialData = new HashMap(128);
        materialData = "mds_setoffsetting".equals(inType) ? this.getSetOffMaterialData(inType, pkArray, msb.toString(), dest) : this.getMaterialData(pkArray, relations, msb.toString(), dest);
        HashSet<String> unitList = new HashSet<String>(128);
        Map<String, String> materialUnitData = this.getMaterialUnitData(msb.toString(), unitList);
        Map<String, String> measureunitData = this.getMeasureunitData(unitList);
        this.writeToDest(this.bill, materialData, dest, zdvr, this.type, isquota, destMap, materialUnitData, measureunitData);
    }

    private boolean writeToDest(DynamicObject bill, Map<String, Map<Date, BigDecimal>> materials, DynamicObject dest, DynamicObject zdvr, int type, boolean isquota, Map<String, Map<Date, List<Map<String, String>>>> destMap, Map<String, String> materialUnitData, Map<String, String> measureunitData) {
        String cycletype = zdvr.getString("cytype");
        String sourcecode = ((DynamicObject)bill.get("sourcename")).getString("number");
        String changeway = bill.getString("changeway");
        ArrayList<Object[]> addParamsList = new ArrayList<Object[]>(128);
        ArrayList<Object[]> updateParamsList = new ArrayList<Object[]>(128);
        Object pkValue = dest.getPkValue();
        int totalcount = 0;
        for (Map.Entry<String, Map<Date, BigDecimal>> mts : materials.entrySet()) {
            logger.info("BaseCalcRunningTask:\u7269\u6599\u7ef4\u5ea6........." + totalcount++);
            Map<Date, BigDecimal> map = mts.getValue();
            String mapkey = mts.getKey();
            String materialId = this.getMapMaterialId(mapkey);
            String quotajson = MDSCacheManager.getInst().getData("basecalcrun_quota", materialId);
            logger.info("BaseCalcRunningTask:quotajson........." + quotajson);
            for (Map.Entry<Date, BigDecimal> node : map.entrySet()) {
                DynamicObject dp;
                Object plangrp = 0;
                if (CalcuColumns.Caltype.XQJH_CAL.ordinal() == type && (dp = bill.getDynamicObject(KEY_PLANGRP)) != null) {
                    plangrp = dp.getPkValue();
                }
                if (isquota) {
                    this.setQuotaEntry(materialUnitData, measureunitData, quotajson, node, materialId, bill, zdvr, type, addParamsList, updateParamsList, destMap, pkValue);
                    continue;
                }
                if ("1".equals(changeway)) {
                    Map<Date, List<Map<String, String>>> destmaprow = destMap.get(mapkey);
                    String maporg = this.getMapOrg(mapkey);
                    this.getEntryByConsAndOrg(materialUnitData, measureunitData, materialId, node, sourcecode, maporg, addParamsList, updateParamsList, destmaprow, cycletype, dest.getPkValue(), 0L, plangrp);
                    continue;
                }
                Object[] param = new Object[]{dest.getPkValue(), 0, 0, Long.valueOf(materialId), cycletype, node.getKey(), node.getValue(), 0, Long.valueOf(materialUnitData.get(materialId)), plangrp, sourcecode};
                addParamsList.add(param);
            }
        }
        if (addParamsList.size() > 0) {
            ORM orm = ORM.create();
            long[] ids = orm.genLongIds("mds_data.detailentity", addParamsList.size());
            for (int i = 0; i < addParamsList.size(); ++i) {
                Object[] object = (Object[])addParamsList.get(i);
                object[1] = ids[i];
            }
        }
        this.writeSourceToDest(dest.getPkValue(), addParamsList, updateParamsList);
        return true;
    }

    private void writeSourceToDest(Object pkid, List<Object[]> addParamsList, List<Object[]> updateParamsList) {
        try (TXHandle h = TX.requiresNew((String)"writeSourceToDest");){
            if (addParamsList.size() > 0) {
                String addsql = "insert into t_mds_fcdatadtlent(fid,fentryid,fseq,fmaterialid,fcycletyped,fdatenode,ffcqty,fprodorg,fbaseunitid,fplangp,fqtysrc) values(?,?,?,?,?,?,?,?,?,?,?)";
                DB.executeBatch((DBRoute)pur, (String)addsql, addParamsList);
            }
            if (updateParamsList.size() > 0) {
                String updatesql = "update T_MDS_FCDATADTLENT set ffcqty=?, fcycletyped=?,fprodorg=?,fbaseunitid=?,fplangp=?,fqtysrc=? where fentryid = ? ";
                DB.executeBatch((DBRoute)pur, (String)updatesql, updateParamsList);
            }
        }
    }

    private void setQuotaEntry(Map<String, String> materialUnitData, Map<String, String> measureunitData, String quotajson, Map.Entry<Date, BigDecimal> mentry, String materialId, DynamicObject bill, DynamicObject zdvr, int types, List<Object[]> addParamsList, List<Object[]> updateParamsList, Map<String, Map<Date, List<Map<String, String>>>> destMap, Object pkid) {
        String quoDate;
        String quotatype;
        Long losedate;
        Long effectdate;
        JSONObject jsonobj;
        int n;
        DynamicObject dp;
        Long quotadate = mentry.getKey().getTime();
        int ttype = 0;
        Object plangrp = 0;
        if (CalcuColumns.Caltype.XQJH_CAL.ordinal() == this.type && (dp = bill.getDynamicObject(KEY_PLANGRP)) != null) {
            plangrp = dp.getPkValue();
        }
        if (quotajson == null) {
            this.setDummysiteEntry(materialUnitData, measureunitData, plangrp, materialId, mentry, bill, zdvr, types, addParamsList, updateParamsList, destMap, pkid, 0L);
            return;
        }
        JSONArray quotaObj = JSONArray.parseArray((String)quotajson);
        JSONArray effectmaterialArray = new JSONArray();
        JSONArray effectproductArray = new JSONArray();
        HashMap<String, String> repeatMap = new HashMap<String, String>(128);
        for (n = 0; n < quotaObj.size(); ++n) {
            jsonobj = (JSONObject)quotaObj.get(n);
            effectdate = jsonobj.getLong("EFFECTDATE");
            losedate = jsonobj.getLong("LOSEDATE");
            quotatype = jsonobj.getString("QUOTATYPE");
            if (quotadate < effectdate || quotadate > losedate) continue;
            quoDate = quotadate + "@";
            if ("bd_material".equals(quotatype)) {
                effectmaterialArray.add((Object)jsonobj);
                repeatMap.put(quoDate, quoDate);
            }
            ++ttype;
        }
        for (n = 0; n < quotaObj.size(); ++n) {
            jsonobj = (JSONObject)quotaObj.get(n);
            effectdate = jsonobj.getLong("EFFECTDATE");
            losedate = jsonobj.getLong("LOSEDATE");
            quotatype = jsonobj.getString("QUOTATYPE");
            if (quotadate < effectdate || quotadate > losedate) continue;
            quoDate = quotadate + "@";
            if (!"bd_material".equals(quotatype) && !repeatMap.containsKey(quoDate)) {
                effectproductArray.add((Object)jsonobj);
            }
            ++ttype;
        }
        if (ttype == 0) {
            this.setDummysiteEntry(materialUnitData, measureunitData, plangrp, materialId, mentry, bill, zdvr, types, addParamsList, updateParamsList, destMap, pkid, 0L);
            ttype = 0;
        }
        if (effectmaterialArray.size() > 0) {
            this.setDeteailMapinfo(materialUnitData, measureunitData, destMap, plangrp, pkid, materialId, effectmaterialArray, mentry, bill, zdvr, types, addParamsList, updateParamsList);
        }
        if (effectproductArray.size() > 0) {
            this.setDeteailMapinfo(materialUnitData, measureunitData, destMap, plangrp, pkid, materialId, effectproductArray, mentry, bill, zdvr, types, addParamsList, updateParamsList);
        }
    }

    private void setDummysiteEntry(Map<String, String> materialUnitData, Map<String, String> measureunitData, Object plangrp, String materialId, Map.Entry<Date, BigDecimal> node, DynamicObject bill, DynamicObject zdvr, int type, List<Object[]> addParamsList, List<Object[]> updateParamsList, Map<String, Map<Date, List<Map<String, String>>>> destMap, Object pkid, long ids) {
        String cycletype = zdvr.getString("cytype");
        DynamicObject dummysite = bill.getDynamicObject("dummysite");
        if (null == dummysite) {
            return;
        }
        if (node.getValue() == null || BigDecimal.ZERO.compareTo(node.getValue()) == 0) {
            return;
        }
        String destkey = materialId + "@@@" + dummysite.getPkValue();
        Map<Date, List<Map<String, String>>> destmaprow = destMap.get(destkey);
        String sourcecode = ((DynamicObject)bill.get("sourcename")).getString("number");
        String changeway = bill.getString("changeway");
        String baseunit = materialUnitData.get(materialId);
        if ("1".equals(changeway)) {
            this.getEntryByConsAndOrg(materialUnitData, measureunitData, materialId, node, sourcecode, String.valueOf(dummysite.getPkValue()), addParamsList, updateParamsList, destmaprow, cycletype, pkid, ids, plangrp);
        } else {
            Object[] param = new Object[]{pkid, ids, 0, Long.valueOf(materialId), cycletype, node.getKey(), node.getValue(), dummysite.getPkValue(), Long.valueOf(baseunit), plangrp, sourcecode};
            addParamsList.add(param);
        }
    }

    private void setDeteailMapinfo(Map<String, String> materialUnitData, Map<String, String> measureunitData, Map<String, Map<Date, List<Map<String, String>>>> destMap, Object plangrp, Object pkid, String materialId, JSONArray effectmaterialArray, Map.Entry<Date, BigDecimal> node, DynamicObject bill, DynamicObject zdvr, int type, List<Object[]> addParamsList, List<Object[]> updateParamsList) {
        String cycletype = zdvr.getString("cytype");
        int size = effectmaterialArray.size();
        String baseunit = materialUnitData.get(materialId);
        String measureunit = measureunitData.get(baseunit);
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal nodeValue = node.getValue();
        for (int n = 0; n < effectmaterialArray.size(); ++n) {
            BigDecimal fcqty;
            JSONObject obj = effectmaterialArray.getJSONObject(n);
            BigDecimal quotamod = obj.getBigDecimal("QUOTAMOD");
            String allocateorg = obj.getString("ALLOCATEORG");
            String sourcecode = ((DynamicObject)bill.get("sourcename")).getString("number");
            String changeway = bill.getString("changeway");
            String destkey = materialId + "@@@" + allocateorg;
            Map<Date, List<Map<String, String>>> destmaprow = destMap.get(destkey);
            if ("1".equals(changeway)) {
                fcqty = this.getUnitDeal(measureunit, n, size, node.getValue(), total, quotamod);
                total = total.add(fcqty);
                node.setValue(fcqty);
                this.getEntryByConsAndOrg(materialUnitData, measureunitData, materialId, node, sourcecode, allocateorg, addParamsList, updateParamsList, destmaprow, cycletype, pkid, 0L, plangrp);
                node.setValue(nodeValue);
                continue;
            }
            fcqty = this.getUnitDeal(measureunit, n, size, node.getValue(), total, quotamod);
            total = total.add(fcqty);
            Object[] param = new Object[]{pkid, 0, 0, Long.valueOf(materialId), cycletype, node.getKey(), fcqty, Long.valueOf(allocateorg), Long.valueOf(baseunit), plangrp, sourcecode};
            addParamsList.add(param);
        }
    }

    private BigDecimal getUnitDeal(String measureunit, int index, int size, BigDecimal nodeData, BigDecimal total, BigDecimal quotamod) {
        BigDecimal newdata = BigDecimal.ZERO;
        if (index == size - 1) {
            newdata = nodeData.subtract(total);
            return newdata;
        }
        String[] split = measureunit.split("@@");
        int precision = Integer.parseInt(split[0]);
        String precisionaccount = split[1];
        int deal = 4;
        switch (precisionaccount) {
            case "2": {
                deal = 1;
                break;
            }
            case "3": {
                deal = 0;
                break;
            }
            default: {
                deal = 4;
            }
        }
        newdata = nodeData.multiply(quotamod).setScale(precision, deal);
        return newdata;
    }

    private void getEntryByConsAndOrg(Map<String, String> materialUnitData, Map<String, String> measureunitData, String materialId, Map.Entry<Date, BigDecimal> node, String sourcecode, String org, List<Object[]> addParamsList, List<Object[]> updateParamsList, Map<Date, List<Map<String, String>>> destmaprow, String cycletype, Object pkid, long ids, Object plangrp) {
        Long baseunit = Long.valueOf(materialUnitData.get(materialId));
        if (destmaprow == null || destmaprow.isEmpty()) {
            Object[] param = new Object[]{pkid, ids, 0, Long.valueOf(materialId), cycletype, node.getKey(), node.getValue(), Long.valueOf(org), baseunit, 0, sourcecode};
            addParamsList.add(param);
            return;
        }
        if (!destmaprow.containsKey(node.getKey())) {
            Object[] param = new Object[]{pkid, ids, 0, Long.valueOf(materialId), cycletype, node.getKey(), node.getValue(), Long.valueOf(org), baseunit, plangrp, sourcecode};
            addParamsList.add(param);
            return;
        }
        List<Map<String, String>> list = destmaprow.get(node.getKey());
        int index = 0;
        for (Map<String, String> lmap : list) {
            if (index == 0) {
                BigDecimal ffcqty = lmap.get("ffcqty") == null ? BigDecimal.ZERO : new BigDecimal(lmap.get("ffcqty"));
                Object[] param = new Object[]{node.getValue().add(ffcqty), cycletype, Long.valueOf(org), baseunit, plangrp, sourcecode, Long.valueOf(lmap.get("fentryid"))};
                updateParamsList.add(param);
            }
            ++index;
        }
    }

    private String getMapMaterialId(String mapKey) {
        String[] split = mapKey.split("@@@");
        String materialId = null;
        if (split.length > 0) {
            materialId = split[0];
        }
        return materialId;
    }

    private String getMapOrg(String mapKey) {
        String[] split = mapKey.split("@@@");
        String org = "";
        if (split.length == 2) {
            org = split[1];
        }
        return org;
    }

    private Map<String, Map<Date, BigDecimal>> getMaterialData(Object[] pkArray, Map<Long, BigDecimal> relations, String msb, DynamicObject dest) {
        HashMap<String, Map<Date, BigDecimal>> map = new HashMap<String, Map<Date, BigDecimal>>(128);
        String sbStr = "cdl.fid,cdl.fentryid,cdl.fseq,cdl.fmaterialid,cdl.fdatenode,cdl.ffcqty,cdl.fbaseunitid,cdl.fprodorg,cdl.fplangp,cdl.fwriteoffnum,cdl.fremark";
        String sbids = null;
        StringBuilder sbidsSb = new StringBuilder();
        int index = 1;
        for (Object pkid : pkArray) {
            if (index == pkArray.length) {
                sbidsSb.append(pkid);
            } else {
                sbidsSb.append(pkid);
                sbidsSb.append(",");
            }
            ++index;
        }
        sbids = sbidsSb.toString();
        String queryMainSql = "select " + sbStr + ",cd.ffcvrnnum,cd.fbillno from T_MDS_FCDATADTLENT  cdl inner join t_mds_fcdata cd on cdl.fid = cd.fid where cdl.fid in (" + sbids + ") and cdl.fmaterialid in (" + msb + ") order by cdl.fmaterialid,cdl.fprodorg";
        try (DataSet queryMainData = DB.queryDataSet((String)"querySopData", (DBRoute)pur, (String)queryMainSql);){
            for (Row row : queryMainData) {
                Date monday;
                String prodAndMaterial;
                BigDecimal resultvalue;
                Long fcvrnnum;
                BigDecimal pds = new BigDecimal("1");
                if (relations != null && !relations.isEmpty() && (fcvrnnum = row.getLong("ffcvrnnum")) != null && fcvrnnum != 0L) {
                    pds = relations.get(fcvrnnum);
                }
                String stype = this.bill.getString("sourcetype");
                BigDecimal devides = new BigDecimal("100");
                if (!"mds_corl".equals(stype)) {
                    pds = new BigDecimal("1");
                }
                DynamicObject cycletype = dest.getDynamicObject("fcvrnnum");
                String cycletype2 = cycletype.getString("cytype");
                BigDecimal mod = this.bill.getBigDecimal("mod");
                Date[] arrays = this.getDateByOutlookPeriodOrDirect(this.bill);
                Date end = arrays[1];
                String amt = this.bill.getString("amounttype");
                Date datenode = row.getDate("fdatenode");
                if (datenode != null) {
                    datenode = DateUtil.getZeroTime((Date)datenode);
                }
                String material = row.getString("fmaterialid");
                BigDecimal svalue = row.getBigDecimal("ffcqty");
                String prodorg = row.getString("fprodorg");
                if (datenode == null || end == null || CalcuColumns.compare((Date)datenode, (Date)end) > 0) continue;
                String dayofweek = cycletype.getString("dayofweek");
                if (amt == null || "".equals(amt)) {
                    amt = "0";
                }
                BigDecimal writeoff = row.get("fwriteoffnum") == null ? BigDecimal.ZERO : row.getBigDecimal("fwriteoffnum");
                BigDecimal bigDecimal = resultvalue = "0".equals(amt) ? svalue : svalue.subtract(writeoff);
                if (resultvalue.compareTo(BigDecimal.ZERO) <= 0) {
                    resultvalue = BigDecimal.ZERO;
                }
                BigDecimal result = resultvalue.multiply(pds).divide(devides, RoundingMode.HALF_UP).multiply(mod);
                Map<Date, BigDecimal> dns = null;
                StringBuilder sb = new StringBuilder();
                sb.append(material).append("@@@");
                if (prodorg != null) {
                    sb.append(prodorg);
                }
                if (!map.containsKey(prodAndMaterial = sb.toString())) {
                    dns = new HashMap(16);
                    if ("1".equals(cycletype2)) {
                        monday = DateUtil.findTheWeekMonday((Date)datenode);
                        monday = DateUtil.getMondayOffset((Date)monday, (String)dayofweek);
                        dns.put(monday, result);
                    } else {
                        dns.put(datenode, result);
                    }
                    map.put(prodAndMaterial, dns);
                    continue;
                }
                dns = (Map)map.get(prodAndMaterial);
                if ("1".equals(cycletype2)) {
                    monday = DateUtil.findTheWeekMonday((Date)datenode);
                    BigDecimal result1 = dns.get(monday = DateUtil.getMondayOffset((Date)monday, (String)dayofweek)) == null ? new BigDecimal("0") : (BigDecimal)dns.get(monday);
                    BigDecimal sum = result.add(result1);
                    dns.put(monday, sum);
                    continue;
                }
                BigDecimal result1 = dns.get(datenode) == null ? new BigDecimal("0") : (BigDecimal)dns.get(datenode);
                BigDecimal sum = result.add(result1);
                dns.put(datenode, sum);
            }
        }
        return map;
    }

    private Map<String, Map<Date, BigDecimal>> getSetOffMaterialData(String intype, Object[] pkArray, String msb, DynamicObject dest) {
        HashMap<String, Map<Date, BigDecimal>> map = new HashMap<String, Map<Date, BigDecimal>>(128);
        StringBuilder sbs = new StringBuilder();
        sbs.append("select fmaterialid,fexecqty,ffordate  from t_mds_fnreport where  1=1  ");
        sbs.append(" and fsetid = ");
        sbs.append(pkArray[0]);
        sbs.append(" and fsetoffqty = 0 ");
        sbs.append(" and fforecastqty != 0 ");
        sbs.append(" and fmaterialid in (");
        sbs.append(msb);
        sbs.append(") ");
        if (pkArray[1] != null) {
            sbs.append(" and fsetoffverid = ");
            sbs.append(pkArray[1]);
        }
        try (DataSet queryMainData = DB.queryDataSet((String)"querySetOffData", (DBRoute)pur, (String)sbs.toString());){
            for (Row row : queryMainData) {
                Date monday;
                BigDecimal result;
                DynamicObject cycletype = dest.getDynamicObject("fcvrnnum");
                String cycletype2 = cycletype.getString("cytype");
                Date[] arrays = this.getDateByOutlookPeriodOrDirect(this.bill);
                Date end = arrays[1];
                Date datenode = row.getDate("ffordate");
                if (datenode != null) {
                    datenode = DateUtil.getZeroTime((Date)datenode);
                }
                String material = row.getString("fmaterialid");
                BigDecimal bigDecimal = result = row.get("fexecqty") == null ? BigDecimal.ZERO : row.getBigDecimal("fexecqty");
                if (datenode == null || end == null || CalcuColumns.compare((Date)datenode, (Date)end) > 0) continue;
                Map<Date, BigDecimal> dns = null;
                String prodAndMaterial = material;
                if (!map.containsKey(prodAndMaterial)) {
                    dns = new HashMap(16);
                    if ("1".equals(cycletype2)) {
                        monday = DateUtil.findTheWeekMonday((Date)datenode);
                        dns.put(monday, result);
                    } else {
                        dns.put(datenode, result);
                    }
                    map.put(prodAndMaterial, dns);
                    continue;
                }
                dns = (Map)map.get(prodAndMaterial);
                if ("1".equals(cycletype2)) {
                    monday = DateUtil.findTheWeekMonday((Date)datenode);
                    BigDecimal result1 = dns.get(monday) == null ? new BigDecimal("0") : (BigDecimal)dns.get(monday);
                    BigDecimal sum = result.add(result1);
                    dns.put(monday, sum);
                    continue;
                }
                BigDecimal result1 = dns.get(datenode) == null ? new BigDecimal("0") : (BigDecimal)dns.get(datenode);
                BigDecimal sum = result.add(result1);
                dns.put(datenode, sum);
            }
        }
        return map;
    }

    private Map<String, Map<Date, List<Map<String, String>>>> getDestMaterialData(String msb, DynamicObject dest) {
        HashMap<String, Map<Date, List<Map<String, String>>>> map = new HashMap<String, Map<Date, List<Map<String, String>>>>(128);
        String sbStr = "fid,fentryid,fseq,fmaterialid,fdatenode,ffcqty,fbaseunitid,fnowqty,fqtysrc,fwriteoffnum,fprodorg,fplangp,fwriteoffnum,fremark";
        String sbids = dest.getPkValue().toString();
        String queryMainSql = "select " + sbStr + " from T_MDS_FCDATADTLENT where fid in (" + sbids + ") and fmaterialid in (" + msb + ") order by fmaterialid,fprodorg ";
        try (DataSet queryMainData = DB.queryDataSet((String)"querySopData", (DBRoute)pur, (String)queryMainSql);){
            for (Row row : queryMainData) {
                String prodAndMaterial;
                Date datenode = row.getDate("fdatenode");
                if (datenode != null) {
                    datenode = DateUtil.getZeroTime((Date)datenode);
                }
                String material = row.getString("fmaterialid");
                String prodorg = row.getString("fprodorg");
                Map rowMap = new HashMap(128);
                List rowList = new ArrayList(128);
                HashMap<String, String> lMap = new HashMap<String, String>(128);
                StringBuilder sb = new StringBuilder();
                sb.append(material);
                sb.append("@@@");
                if (prodorg != null) {
                    sb.append(prodorg);
                }
                if (!map.containsKey(prodAndMaterial = sb.toString())) {
                    rowMap = new HashMap(16);
                    rowList = new ArrayList(16);
                    lMap = new HashMap(16);
                    lMap.put("fentryid", row.getString("fentryid"));
                    lMap.put("ffcqty", row.getString("ffcqty"));
                    rowList.add(lMap);
                    rowMap.put(datenode, rowList);
                    map.put(prodAndMaterial, rowMap);
                    continue;
                }
                rowMap = (Map)map.get(prodAndMaterial);
                rowList = (List)rowMap.get(datenode);
                if (rowList != null) {
                    lMap = new HashMap(16);
                    lMap.put("fentryid", row.getString("fentryid"));
                    lMap.put("ffcqty", row.getString("ffcqty"));
                    rowList.add(lMap);
                    continue;
                }
                rowList = new ArrayList(16);
                lMap = new HashMap(16);
                lMap.put("fentryid", row.getString("fentryid"));
                lMap.put("ffcqty", row.getString("ffcqty"));
                rowList.add(lMap);
                rowMap.put(datenode, rowList);
            }
        }
        return map;
    }

    private Map<String, String> getMeasureunitData(Set<String> unitList) {
        HashMap<String, String> map = new HashMap<String, String>(128);
        int index = 0;
        StringBuilder msb = new StringBuilder();
        for (String unitId : unitList) {
            if (++index == unitList.size()) {
                msb.append(unitId);
                continue;
            }
            msb.append(unitId);
            msb.append(',');
        }
        String queryMainSql = "select fid,fprecision,fprecisiontype from T_bd_Measureunit where  fid in (" + msb + ") ";
        try (DataSet queryMainData = DB.queryDataSet((String)"queryMeasureunitData", (DBRoute)DBRoute.base, (String)queryMainSql);){
            for (Row row : queryMainData) {
                String fid = row.getString("fid");
                String precision = row.getString("fprecision");
                String precisiontype = row.getString("fprecisiontype");
                map.put(fid, precision + "@@" + precisiontype);
            }
        }
        return map;
    }

    private Map<String, String> getMaterialUnitData(String msb, Set<String> unitList) {
        HashMap<String, String> map = new HashMap<String, String>(128);
        String queryMainSql = "select fid,fbaseunit from T_BD_Material where  fid in (" + msb + ") ";
        try (DataSet queryMainData = DB.queryDataSet((String)"queryunitData", (DBRoute)DBRoute.base, (String)queryMainSql);){
            for (Row row : queryMainData) {
                String fid = row.getString("fid");
                String baseunit = row.getString("fbaseunit");
                map.put(fid, baseunit);
                unitList.add(baseunit);
            }
        }
        return map;
    }

    private Date[] getDateByOutlookPeriodOrDirect(DynamicObject bill) {
        Date start = null;
        Date end = null;
        if ("mds_pdcc".equals(bill.getDataEntityType().getName())) {
            start = bill.getDate("start");
            end = bill.getDate("end");
        } else {
            Object outlookperiod = bill.get("outlookperiod");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            start = calendar.getTime();
            Integer outlookperiodInt = (Integer)outlookperiod;
            calendar.set(5, calendar.get(5) + outlookperiodInt);
            end = calendar.getTime();
        }
        return new Date[]{start, end};
    }
}

