/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.impl.KDCloudMdsLogRecorder;
import kd.mmc.mds.common.itf.IMDSExecuteLogRecorder;
import kd.mmc.mds.common.plancalc.CalculateDataSetHandler;
import kd.mmc.mds.common.util.CalcuColumns;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.common.util.MDSCacheManager;
import kd.mmc.mds.common.util.MDSUtils;
import kd.mmc.mds.common.util.PlanDataToFcDataTranUtil;
import kd.mmc.mds.formplugin.basedata.task.BaseCalcRunTask;

public class BaseCalcRunningTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(BaseCalcRunningTask.class);
    private static final DBRoute pur = new DBRoute("pur");
    private static Map<String, String> materialMap = new HashMap<String, String>(256);

    private boolean validataBillData(DynamicObject bill, int type, Map<String, Object> params) {
        DynamicObject dvr = (DynamicObject)bill.get("predversion");
        if (dvr == null) {
            bill.set("runninglog_tag", (Object)ResManager.loadKDString((String)"\u76ee\u6807\u7248\u672c\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BaseCalcRunningTask_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return false;
        }
        String inType = bill.getString("sourcetype");
        DynamicObject vrds = bill.getDynamicObject("sourcename");
        DynamicObject[] sIn = null;
        if (inType.equals("mds_setoffsetting")) {
            boolean validSetoff;
            Object setoffid = vrds.getPkValue();
            sIn = new DynamicObject[2];
            sIn[0] = vrds;
            DynamicObject setoffverid = bill.getDynamicObject("setoffverid");
            if (setoffverid != null) {
                sIn[1] = setoffverid;
            }
            if (!(validSetoff = this.validSetoff(bill, setoffid, setoffverid))) {
                return false;
            }
        } else {
            boolean validSvrds = this.validSvrds(vrds, bill, inType, type);
            if (!validSvrds) {
                return false;
            }
            HashMap<Long, BigDecimal> relat = new HashMap<Long, BigDecimal>(128);
            List<String> relations = this.getVrdsByRelations(inType, vrds, relat);
            QFilter filter0 = this.createFilter(relations);
            if (filter0 == null) {
                bill.set("runninglog_tag", (Object)ResManager.loadKDString((String)"\u6765\u6e90\u7248\u672c\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseCalcRunningTask_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                SaveServiceHelper.update((DynamicObject)bill);
                return false;
            }
            sIn = BusinessDataServiceHelper.load((String)"mds_data", (String)this.createBillHeadSelected(), (QFilter[])new QFilter[]{filter0});
            if (sIn == null || sIn.length == 0) {
                bill.set("runninglog_tag", (Object)ResManager.loadKDString((String)"\u6765\u6e90\u7248\u672c\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseCalcRunningTask_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                SaveServiceHelper.update((DynamicObject)bill);
                return false;
            }
            Map<Long, BigDecimal> rats = this.getRatio(inType, sIn, relat);
            params.put("RATS", rats);
        }
        boolean validdest = this.validateStatus(dvr, bill, type, 2);
        if (!validdest) {
            return false;
        }
        Object[] pkArray = this.pks(sIn);
        QFilter filter1 = new QFilter("fcvrnnum.number", "=", dvr.get("number"));
        DynamicObject[] dIn = BusinessDataServiceHelper.load((String)"mds_data", (String)this.createBillHeadSelected(), (QFilter[])new QFilter[]{filter1});
        Object destVrdsId = null;
        DynamicObject destVrds = null;
        if (dIn == null || dIn.length == 0) {
            destVrds = this.createDestVrds(bill, dvr);
            destVrdsId = destVrds.getPkValue();
        } else {
            destVrds = dIn[0];
            destVrdsId = dIn[0].getPkValue();
        }
        Object[] dInPKArray = dIn == null ? new Object[]{} : this.pks(dIn);
        Object[] dataPKArray = ArrayUtils.addAll((Object[])pkArray, (Object[])dInPKArray);
        Boolean isquota = Boolean.FALSE;
        if (CalcuColumns.Caltype.XQJH_CAL.ordinal() == type) {
            isquota = (Boolean)bill.get("isquota");
        }
        params.put("INTYPE", inType);
        params.put("DVR", dvr);
        params.put("destVrdsId", destVrdsId);
        params.put("SOURCES", pkArray);
        params.put("ISQUOTA", isquota);
        params.put("DESTVRDS", destVrds);
        params.put("DATAPKARRAY", dataPKArray);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calculatingByAlgoX(DynamicObject bill, int type, Object schemeid) {
        log.info("BaseCalcRunningAlgoXTask:start calculating....");
        HashMap<String, Object> params = new HashMap<String, Object>();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)"mds_planexec");
        ORM orm = ORM.create();
        KDCloudMdsLogRecorder recorder = new KDCloudMdsLogRecorder(orm, obj);
        recorder.initMDSRunLog();
        DynamicObject rplancal = obj.getDynamicObject("rplancal");
        materialMap = this.getMaterialIds();
        long beginTime = System.currentTimeMillis();
        obj.set("startdate", (Object)beginTime);
        int index = 0;
        long startTime = System.currentTimeMillis();
        boolean result = true;
        try {
            result = this.validataBillData(bill, type, params);
            if (!result) {
                recorder.createStepLog(++index, ResManager.loadKDString((String)"\u9a8c\u8bc1\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"BaseCalcRunningTask_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, result);
                boolean bl = result;
                return bl;
            }
            log.info("BaseCalcRunningAlgoXTask:validataBillData\u7ed3\u675f....");
            recorder.createStepLog(++index, ResManager.loadKDString((String)"\u9a8c\u8bc1\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"BaseCalcRunningTask_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, result);
            startTime = System.currentTimeMillis();
            Object[] pkArray = (Object[])params.get("SOURCES");
            String inType = (String)params.get("INTYPE");
            int outlookperiod = bill.getInt("outlookperiod");
            Date outlookDate = DateUtil.dateAddDays((Date)new Date(), (int)outlookperiod);
            Set<String> materialList = this.getMaterialIdList(pkArray, inType, outlookDate);
            recorder.createStepLog(++index, String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6765\u6e90\u5355\u636e\u4e2d\u7269\u6599\uff0c\u7269\u6599\u6570\u91cf\uff1a%s\u3002", (String)"BaseCalcRunningTask_22", (String)"mmc-mds-formplugin", (Object[])new Object[0]), materialList.size()), startTime, bill, result);
            startTime = System.currentTimeMillis();
            log.info("BaseCalcRunningAlgoXTask:\u8ba1\u7b97\u5f00\u59cb\uff1a" + startTime);
            String changeWay = bill.getString("changeWay");
            boolean isquota = bill.getBoolean("isquota");
            CalculateDataSetHandler.calculate((Object)bill.getPkValue(), (String)"mds_rplancal", (String)changeWay, (boolean)isquota);
            log.info("BaseCalcRunningAlgoXTask:\u8ba1\u7b97\u7ed3\u675f\uff1a" + System.currentTimeMillis());
            recorder.createStepLog(++index, ResManager.loadKDString((String)"\u5c06\u6765\u6e90\u5355\u636e\u7684\u8ba1\u7b97\u7ed3\u679c\u5199\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"BaseCalcRunningTask_6", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, result);
            log.info("BaseCalcRunningAlgoXTask:\u66f4\u65b0\u9700\u6c42\u7c7b\u578b\u548c\u66f4\u65b0\u5355\u636e\u4f53\u6570\u636e...");
            startTime = System.currentTimeMillis();
            try (TXHandle h1 = TX.requiresNew();){
                this.stepFour(bill, params);
            }
            finally {
                recorder.createStepLog(++index, ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u72b6\u6001\u5df2\u53d8\u66f4\u3002", (String)"BaseCalcRunningTask_7", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, result);
            }
            startTime = System.currentTimeMillis();
            log.info("BaseCalcRunningAlgoXTask:\u540c\u6b65\u5f00\u59cb\uff1a" + startTime);
            this.sycnDataToNewPlan(bill);
            log.info("BaseCalcRunningAlgoXTask:\u540c\u6b65\u7ed3\u675f\uff1a" + System.currentTimeMillis());
            recorder.createStepLog(++index, ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u540c\u6b65\u6570\u636e\u5230\u65b0\u5355\u636e\u3002", (String)"BaseCalcRunningTask_8", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, true);
        }
        catch (Exception exc) {
            log.info("BaseCalcRunningTask:set66611...." + exc.getMessage());
            if (exc.getMessage() != null && exc.getMessage().length() >= 255) {
                bill.set("runninglog_tag", (Object)exc.getMessage().substring(0, 200));
            } else {
                bill.set("runninglog_tag", (Object)exc.getMessage());
            }
            result = false;
            recorder.createStepLog(++index, ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"BaseCalcRunningTask_9", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, result);
        }
        finally {
            CalcuColumns.releaseLock((String)"mds_rplancal", (String)"modify", (String)String.valueOf(rplancal.getPkValue()));
            Long endtime = System.currentTimeMillis();
            float seconds = (float)(endtime - beginTime) / 1000.0f;
            obj.set("enddate", (Object)endtime);
            obj.set("summin", (Object)Float.valueOf(seconds));
            SaveServiceHelper.update((DynamicObject)obj);
        }
        log.info("BaseCalcRunningAlgoXTask:end calculating....");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calculating(DynamicObject bill, int type, Object schemeid) {
        log.info("BaseCalcRunningTask:start calcu....");
        HashMap<String, Object> params = new HashMap<String, Object>();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)"mds_planexec");
        ORM orm = ORM.create();
        KDCloudMdsLogRecorder recorder = new KDCloudMdsLogRecorder(orm, obj);
        recorder.initMDSRunLog();
        DynamicObject rplancal = obj.getDynamicObject("rplancal");
        materialMap = this.getMaterialIds();
        long beginTime = System.currentTimeMillis();
        obj.set("startdate", (Object)beginTime);
        int index = 0;
        long startTime = System.currentTimeMillis();
        try {
            boolean state = false;
            boolean isValidata = this.validataBillData(bill, type, params);
            if (!isValidata) {
                recorder.createStepLog(++index, ResManager.loadKDString((String)"\u9a8c\u8bc1\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"BaseCalcRunningTask_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, false);
                boolean bl = false;
                return bl;
            }
            log.info("BaseCalcRunningTask:set1....");
            DynamicObject obj2 = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)"mds_planexec");
            String calcstatus = obj2.getString("enable");
            if (CalcuColumns.CalcStatus.STOP.getCode().equals(calcstatus)) {
                boolean seconds = false;
                return seconds;
            }
            recorder.createStepLog(++index, ResManager.loadKDString((String)"\u9a8c\u8bc1\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"BaseCalcRunningTask_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, true);
            startTime = System.currentTimeMillis();
            Object[] pkArray = (Object[])params.get("SOURCES");
            String inType = (String)params.get("INTYPE");
            Set<String> materialList = this.getMaterialIdList(pkArray, inType);
            this.cacheQuotaData(materialList);
            DynamicObject obj3 = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)"mds_planexec");
            String calcstatus3 = obj3.getString("enable");
            if (CalcuColumns.CalcStatus.STOP.getCode().equals(calcstatus3)) {
                boolean bl = false;
                return bl;
            }
            recorder.createStepLog(++index, String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6765\u6e90\u5355\u636e\u4e2d\u7269\u6599\uff0c\u7269\u6599\u6570\u91cf\uff1a%s\u3002", (String)"BaseCalcRunningTask_22", (String)"mmc-mds-formplugin", (Object[])new Object[0]), materialList.size()), startTime, bill, true);
            startTime = System.currentTimeMillis();
            state = this.stepOne(bill, type, params, index, (IMDSExecuteLogRecorder)recorder, materialList);
            if (!state) {
                recorder.createStepLog(++index, ResManager.loadKDString((String)"\u5c06\u6765\u6e90\u5355\u636e\u7684\u8ba1\u7b97\u7ed3\u679c\u5199\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"BaseCalcRunningTask_6", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, false);
                boolean bl = false;
                return bl;
            }
            int columnSize = this.getdateNodeColumn(params);
            if (columnSize > 150) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u65f6\u95f4\u8282\u70b9\u8d85\u8fc7150\u5217\u3002", (String)"BaseCalcRunningTask_10", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            }
            DynamicObject obj4 = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)"mds_planexec");
            String calcstatus4 = obj4.getString("enable");
            if (CalcuColumns.CalcStatus.STOP.getCode().equals(calcstatus4)) {
                boolean bl = false;
                return bl;
            }
            recorder.createStepLog(++index, ResManager.loadKDString((String)"\u5c06\u6765\u6e90\u5355\u636e\u7684\u8ba1\u7b97\u7ed3\u679c\u5199\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"BaseCalcRunningTask_6", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, true);
            startTime = System.currentTimeMillis();
            try (TXHandle h1 = TX.requiresNew();){
                this.stepFour(bill, params);
            }
            finally {
                recorder.createStepLog(++index, ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u72b6\u6001\u5df2\u53d8\u66f4\u3002", (String)"BaseCalcRunningTask_7", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, true);
            }
            startTime = System.currentTimeMillis();
            log.info("BaseCalcRunningTask888:\u540c\u6b65\u65f6\u95f4\uff1a" + System.currentTimeMillis());
            this.sycnDataToNewPlan(bill);
            recorder.createStepLog(++index, ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u540c\u6b65\u6570\u636e\u5230\u65b0\u5355\u636e\u3002", (String)"BaseCalcRunningTask_8", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, true);
        }
        catch (Exception exc) {
            log.info("BaseCalcRunningTask:set66611...." + exc.getMessage());
            if (exc.getMessage() != null && exc.getMessage().length() >= 255) {
                bill.set("runninglog_tag", (Object)exc.getMessage().substring(0, 200));
            } else {
                bill.set("runninglog_tag", (Object)exc.getMessage());
            }
            recorder.createStepLog(++index, ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"BaseCalcRunningTask_9", (String)"mmc-mds-formplugin", (Object[])new Object[0]), startTime, bill, false);
            throw exc;
        }
        finally {
            CalcuColumns.releaseLock((String)"mds_rplancal", (String)"modify", (String)String.valueOf(rplancal.getPkValue()));
            Long endtime = System.currentTimeMillis();
            float seconds = (float)(endtime - beginTime) / 1000.0f;
            obj.set("enddate", (Object)endtime);
            obj.set("summin", (Object)Float.valueOf(seconds));
            SaveServiceHelper.update((DynamicObject)obj);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getdateNodeColumn(Map<String, Object> params) {
        String cytype;
        if (params == null) {
            return 0;
        }
        Long destVrdsId = (Long)params.get("destVrdsId");
        Set<Date> dateNodeSet = new HashSet<Date>();
        String querySql = "select fdatenode from t_mds_fcdatadtlent where fid = ? ";
        try (DataSet queryData = DB.queryDataSet((String)"qFcdData", (DBRoute)pur, (String)querySql, (Object[])new Object[]{destVrdsId});){
            for (Row row : queryData) {
                Date dateNode = row.getDate("fdatenode");
                dateNodeSet.add(dateNode);
            }
        }
        DynamicObject dvr = (DynamicObject)params.get("DVR");
        if (dvr != null && "1".equals(cytype = dvr.getString("cytype"))) {
            dateNodeSet = this.getAllMonday(dateNodeSet);
        }
        return dateNodeSet.size();
    }

    private void sycnDataToNewPlan(DynamicObject bill) {
        DynamicObject version = (DynamicObject)bill.get("predversion");
        DynamicObject objlog = ORM.create().newDynamicObject("mds_syncplanlog");
        objlog.set("version", (Object)version);
        objlog.set("direction", (Object)"B");
        objlog.set("status", (Object)"C");
        objlog.set("enable", (Object)1);
        objlog.set("creator", (Object)RequestContext.get().getCurrUserId());
        objlog.set("createtime", (Object)Calendar.getInstance().getTime());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{objlog});
        PlanDataToFcDataTranUtil.tranFcDataToPlanDataByTask((String)version.getString("number"), (Object)objlog.getPkValue());
    }

    private void stepFour(DynamicObject bill, Map<String, Object> params) {
        DynamicObject dmdType = (DynamicObject)bill.get("dtype");
        DynamicObject dt = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)params.get("DVR")).getPkValue(), (String)"mds_vrds");
        dt.set("dtype", (Object)dmdType);
        SaveServiceHelper.update((DynamicObject)dt);
        SaveServiceHelper.update((DynamicObject)bill);
    }

    private String createBillHeadSelected() {
        StringBuilder sql = new StringBuilder();
        sql.append("fcvrnnum, billno, dmdtype, invaldate, deduct, prededucts, bkdeducts,");
        sql.append("billstatus, enablestatus, modifytime,modifier ");
        return sql.toString();
    }

    private DynamicObject createDestVrds(DynamicObject bill, DynamicObject vrds) {
        DynamicObject dest = BusinessDataServiceHelper.newDynamicObject((String)"mds_data");
        dest.set("fcvrnnum", (Object)vrds);
        dest.set("billstatus", (Object)"A");
        dest.set("billno", vrds.get("number"));
        dest.set("org", bill.get("org"));
        dest.set("creator", bill.get("creator"));
        dest.set("createtime", (Object)new Date());
        dest.set("enablestatus", (Object)"A");
        dest.set("modifier", bill.get("modifier"));
        dest.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dest});
        return dest;
    }

    private QFilter createFilter(List<String> nos) {
        if (nos == null || nos.isEmpty()) {
            return null;
        }
        QFilter qf = null;
        for (String no : nos) {
            if (qf == null) {
                qf = new QFilter("fcvrnnum.number", "=", (Object)no);
                continue;
            }
            qf.or(new QFilter("fcvrnnum.number", "=", (Object)no));
        }
        return qf;
    }

    private String errorLog(DynamicObject bill, Map<String, String> materials, Object pkValue) {
        StringBuilder errInfo = new StringBuilder(300);
        if (!materials.isEmpty()) {
            int i = 0;
            ArrayList<Long> lstmat = new ArrayList<Long>(64);
            for (Map.Entry<String, String> e : materials.entrySet()) {
                lstmat.add(Long.valueOf(e.getKey()));
                if (++i <= 5) continue;
                break;
            }
            QFilter filter = new QFilter("id", "in", lstmat);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{filter});
            int index = 0;
            for (DynamicObject mo : query) {
                errInfo.append(mo.getString("number"));
                if (++index >= query.size()) continue;
                errInfo.append(',');
            }
            String msg = "";
            msg = errInfo.toString().length() > 240 ? errInfo.toString().substring(0, 240) : errInfo.toString();
            return String.format(ResManager.loadKDString((String)"\u7269\u6599%s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"BaseCalcRunningTask_23", (String)"mmc-mds-formplugin", (Object[])new Object[0]), msg);
        }
        return "";
    }

    public synchronized void execute(RequestContext context, Map<String, Object> params) {
        Object billid = params.get("billno");
        int type = (Integer)params.get("tasktype");
        DynamicObject bill = this.loadBill(billid, type);
        Object schemeid = params.get("schemeid");
        if (schemeid == null) {
            return;
        }
        DynamicObject schemebill = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)"mds_planexec");
        if (schemebill == null) {
            log.info("BaseCalcRunningTask:schemebill....null");
            return;
        }
        if ("true".equals(MDSUtils.getMdsSysConfig((String)"planlocalmodel", (String)"true"))) {
            boolean calculating = this.calculatingByAlgoX(bill, type, schemeid);
            if (calculating) {
                if (schemeid != null && schemebill != null) {
                    schemebill.set("status", (Object)this.state(params));
                    schemebill.set("enable", (Object)CalcuColumns.CalcStatus.FINISH.getCode());
                    SaveServiceHelper.update((DynamicObject)schemebill);
                }
            } else if (schemeid != null && schemebill != null) {
                schemebill.set("status", (Object)CalcuColumns.Billstatus.PLAN.getCode());
                schemebill.set("enable", (Object)CalcuColumns.CalcStatus.ERROR.getCode());
                SaveServiceHelper.update((DynamicObject)schemebill);
            }
        } else {
            try {
                boolean calculating = this.calculating(bill, type, schemeid);
                if (calculating) {
                    if (schemeid != null && schemebill != null) {
                        schemebill.set("status", (Object)this.state(params));
                        schemebill.set("enable", (Object)CalcuColumns.CalcStatus.FINISH.getCode());
                        SaveServiceHelper.update((DynamicObject)schemebill);
                    }
                } else if (schemeid != null && schemebill != null) {
                    schemebill.set("status", (Object)CalcuColumns.Billstatus.PLAN.getCode());
                    schemebill.set("enable", (Object)CalcuColumns.CalcStatus.ERROR.getCode());
                    SaveServiceHelper.update((DynamicObject)schemebill);
                }
            }
            catch (Exception e) {
                log.info("BaseCalcRunningTask:error....", (Object)e);
                StackTraceElement[] errorSTArray = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                sb.setLength(0);
                for (StackTraceElement errorST : errorSTArray) {
                    if (errorST == null) continue;
                    sb.append(errorST).append("\r\n");
                }
                DynamicObjectCollection clist = schemebill.getDynamicObjectCollection("execlogeentry");
                ORM create = ORM.create();
                DynamicObject entryLogInfo = create.newDynamicObject("mds_planexec.execlogeentry");
                entryLogInfo.set("seq", (Object)String.valueOf(1));
                entryLogInfo.set("entrystepseq", (Object)String.valueOf(1));
                if (sb.toString().length() >= 255) {
                    entryLogInfo.set("entrydetailmsg", (Object)sb.toString().substring(0, 200));
                } else {
                    entryLogInfo.set("entrydetailmsg", (Object)sb.toString());
                }
                clist.add((Object)entryLogInfo);
                schemebill.set("status", (Object)CalcuColumns.Billstatus.PLAN.getCode());
                schemebill.set("enable", (Object)CalcuColumns.CalcStatus.ERROR.getCode());
                SaveServiceHelper.update((DynamicObject)schemebill);
            }
        }
    }

    private Map<Long, BigDecimal> getRatio(String type, DynamicObject[] sin, Map<Long, BigDecimal> r) {
        if (!"mds_corl".equals(type)) {
            return null;
        }
        if (sin.length < 1) {
            return null;
        }
        HashMap<Long, BigDecimal> rats = new HashMap<Long, BigDecimal>(sin.length);
        for (DynamicObject d : sin) {
            DynamicObject dynamicObject = (DynamicObject)d.get("fcvrnnum");
            if (dynamicObject == null) continue;
            Long srcvrnnumId = (Long)dynamicObject.getPkValue();
            rats.put(srcvrnnumId, r.get(srcvrnnumId));
        }
        return rats;
    }

    private List<String> getVrdsByRelations(String stype, DynamicObject svr, Map<Long, BigDecimal> relat) {
        ArrayList<String> nos = new ArrayList<String>(128);
        if ("mds_corl".equals(stype)) {
            Object masterid = svr.getPkValue();
            DynamicObject sgl = BusinessDataServiceHelper.loadSingle((Object)masterid, (String)"mds_corl");
            DynamicObjectCollection etrs = sgl.getDynamicObjectCollection("entryentity");
            for (DynamicObject o : etrs) {
                DynamicObject o1 = (DynamicObject)o.get("srcvrnnum");
                if (o1 == null) continue;
                String billno = o1.getString("number");
                nos.add(billno);
                relat.put((Long)o1.getPkValue(), o.getBigDecimal("propt").divide(new BigDecimal("100"), 10, 4));
            }
            return nos;
        }
        nos.add(svr.getString("number"));
        return nos;
    }

    private DynamicObject loadBill(Object billid, int type) {
        if (CalcuColumns.Caltype.XQJH_CAL.ordinal() == type) {
            return BusinessDataServiceHelper.loadSingle((Object)billid, (String)"mds_rplancal");
        }
        return BusinessDataServiceHelper.loadSingle((Object)billid, (String)"mds_pdcc");
    }

    private Object[] pks(DynamicObject[] arr) {
        if (ArrayUtils.isEmpty((Object[])arr)) {
            return null;
        }
        Object[] pks = new Object[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null) continue;
            pks[i] = arr[i].getPkValue();
        }
        return pks;
    }

    private String state(Map<String, Object> p) {
        boolean repeat = (Boolean)p.get("repeat");
        if (repeat) {
            return "B";
        }
        return "C";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stepOne(DynamicObject bill, int type, Map<String, Object> params, int index, IMDSExecuteLogRecorder recorder, Set<String> materialList) {
        DynamicObject dest = (DynamicObject)params.get("DESTVRDS");
        String changeWays = bill.getString("changeway");
        if ("0".equals(changeWays)) {
            Long destVrdsId = (Long)params.get("destVrdsId");
            try (TXHandle h2 = TX.requiresNew();){
                log.info("BaseCalcRunningTask888\u5220\u9664\u5206\u5f55start--------\uff1a" + System.currentTimeMillis());
                String deletesql = "delete from T_MDS_FCDATADTLENT where fid = " + destVrdsId;
                DB.execute((DBRoute)pur, (String)deletesql);
            }
            finally {
                log.info("BaseCalcRunningTask888\u5220\u9664\u5206\u5f55end--------\uff1a" + System.currentTimeMillis());
            }
        }
        int batchSize = 100;
        ArrayList<String> subList = new ArrayList<String>(100);
        int i = 0;
        try {
            if (materialList != null) {
                for (String materialId : materialList) {
                    subList.add(materialId);
                    if (++i % 100 != 0) continue;
                    BaseCalcRunTask baseCalcRunTask = new BaseCalcRunTask(new ArrayList<String>(subList), params, bill, type);
                    baseCalcRunTask.call();
                    subList.clear();
                }
            }
            if (!subList.isEmpty()) {
                BaseCalcRunTask baseCalcRunTask = new BaseCalcRunTask(new ArrayList<String>(subList), params, bill, type);
                baseCalcRunTask.call();
            }
        }
        catch (Exception e1) {
            log.info("BaseCalcRunningTask888:\u591a\u7ebf\u7a0b.--------111 error\uff1a" + System.currentTimeMillis(), (Object)e1);
            if (e1.getMessage() != null && e1.getMessage().length() >= 255) {
                bill.set("runninglog_tag", (Object)e1.getMessage().substring(0, 200));
            } else {
                bill.set("runninglog_tag", (Object)e1.getMessage());
            }
            if (recorder != null) {
                recorder.createStepLog(++index, ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"BaseCalcRunningTask_9", (String)"mmc-mds-formplugin", (Object[])new Object[0]), System.currentTimeMillis(), bill, false);
            }
            return false;
        }
        log.info("BaseCalcRunningTask888:\u591a\u7ebf\u7a0b\u7ed3\u675f----\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        SaveServiceHelper.update((DynamicObject)bill);
        dest.set("modifier", bill.get("modifier"));
        dest.set("modifytime", (Object)new Date());
        dest.set("billstatus", (Object)"A");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dest});
        MDSCacheManager.getInst().clearData("basecalcrun_quota");
        return true;
    }

    private Set<String> getMaterialIdList(Object[] pkArray, String inType) {
        return this.getMaterialIdList(pkArray, inType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getMaterialIdList(Object[] pkArray, String inType, Date outlookDate) {
        HashSet<String> materialList = new HashSet<String>(128);
        if (pkArray.length == 0) {
            return materialList;
        }
        DataSet materialIdData = null;
        if ("mds_setoffsetting".equals(inType)) {
            StringBuilder sbs = new StringBuilder();
            sbs.append("select fmaterialid,ffordate as  datenode from t_mds_fnreport where  1=1  ");
            sbs.append(" and fsetid = ").append(pkArray[0]);
            sbs.append(" and fsetoffqty = 0 ");
            sbs.append(" and fforecastqty != 0 ");
            if (pkArray[1] != null) {
                sbs.append(" and fsetoffverid = ").append(pkArray[1]);
            }
            materialIdData = DB.queryDataSet((String)"qurSetOffData", (DBRoute)pur, (String)sbs.toString());
        } else {
            String sbids = null;
            int index = 0;
            for (Object pkid : pkArray) {
                sbids = index == pkArray.length ? sbids + pkid : (index == 0 ? pkid.toString() : sbids + "," + pkid);
                ++index;
            }
            String queryMaterialIdSql = "select fmaterialid,fdatenode as datenode from T_MDS_FCDATADTLENT where fid in (" + sbids + ") ";
            materialIdData = DB.queryDataSet((String)"queryMaterialIdData", (DBRoute)pur, (String)queryMaterialIdSql);
        }
        try {
            if (materialIdData != null && !materialIdData.isEmpty()) {
                if (outlookDate != null) {
                    HashMap<String, Date> params = new HashMap<String, Date>();
                    params.put("outlookDate", outlookDate);
                    materialIdData = materialIdData.filter("datenode <= outlookDate", params);
                }
                for (Row row : materialIdData) {
                    String materialid = row.getString("fmaterialid");
                    materialList.add(materialid);
                }
            }
        }
        finally {
            if (materialIdData != null) {
                materialIdData.close();
            }
        }
        return materialList;
    }

    private boolean validateStatus(DynamicObject vs, DynamicObject bill, int calcType, int vrdsindex) {
        String validateMaterials;
        DynamicObject vrds = BusinessDataServiceHelper.loadSingle((Object)vs.getPkValue(), (String)"mds_vrds");
        Date losedate = vrds.getDate("losedate");
        if (losedate != null && !DateUtil.comp((Date)losedate, (Date)new Date())) {
            bill.set("runninglog_tag", (Object)String.format(ResManager.loadKDString((String)"\u7248\u672c\u201c%s\u201d\u5df2\u5931\u6548\u3002", (String)"BaseCalcRunningTask_24", (String)"mmc-mds-formplugin", (Object[])new Object[0]), vrds.getString("name")));
            return false;
        }
        if ("0".equals(vrds.getString("enable"))) {
            bill.set("runninglog_tag", (Object)String.format(ResManager.loadKDString((String)"\u7248\u672c\u201c%s\u201d\u5df2\u88ab\u7981\u7528\u3002", (String)"BaseCalcRunningTask_25", (String)"mmc-mds-formplugin", (Object[])new Object[0]), vrds.getString("name")));
            return false;
        }
        Object pkValue = vrds.getPkValue();
        QFilter qfilter0 = new QFilter("fcvrnnum", "=", pkValue);
        DynamicObject dataIn = QueryServiceHelper.queryOne((String)"mds_data", (String)"id,enablestatus, invaldate,billstatus", (QFilter[])new QFilter[]{qfilter0});
        if (dataIn != null) {
            Date invaldate = dataIn.getDate("invaldate");
            String enablestatus = dataIn.getString("enablestatus");
            if (invaldate != null && !DateUtil.comp((Date)invaldate, (Date)new Date())) {
                bill.set("runninglog_tag", (Object)(calcType == CalcuColumns.Caltype.XQJH_CAL.ordinal() ? ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u5904\u7406\u201c%s\u201d\u5df2\u5931\u6548\u3002", (String)"BaseCalcRunningTask_16_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u5212\u5904\u7406\u201c%s\u201d\u5df2\u5931\u6548\u3002", (String)"BaseCalcRunningTask_26", (String)"mmc-mds-formplugin", (Object[])new Object[0]), vrds.getString("name"))));
                return false;
            }
            if (enablestatus != null && "B".equals(enablestatus)) {
                bill.set("runninglog_tag", (Object)(calcType == CalcuColumns.Caltype.XQJH_CAL.ordinal() ? ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u5904\u7406\u201c%s\u201d\u5df2\u7981\u7528\u3002", (String)"BaseCalcRunningTask_16_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u5212\u5904\u7406\u201c%s\u201d\u5df2\u7981\u7528\u3002", (String)"BaseCalcRunningTask_27", (String)"mmc-mds-formplugin", (Object[])new Object[0]), vrds.getString("name"))));
                return false;
            }
            if (vrdsindex == 1) {
                Boolean needCheckStatus = bill.getBoolean("billstatuscheckbox");
                String billstatus = dataIn.getString("billstatus");
                if (needCheckStatus.booleanValue() && billstatus != null && "A".equals(billstatus)) {
                    bill.set("runninglog_tag", (Object)(calcType == CalcuColumns.Caltype.XQJH_CAL.ordinal() ? ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u5904\u7406\u201c%s\u201d\u6765\u6e90\u7248\u672c\u4e3a\u5f85\u786e\u8ba4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseCalcRunningTask_16_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u5212\u5904\u7406\u201c%s\u201d\u6765\u6e90\u7248\u672c\u4e3a\u5f85\u786e\u8ba4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseCalcRunningTask_28", (String)"mmc-mds-formplugin", (Object[])new Object[0]), vrds.getString("name"))));
                    return false;
                }
            }
        }
        if (!"".equals((validateMaterials = this.validateMaterials(dataIn, bill, pkValue)).trim())) {
            bill.set("runninglog_tag", (Object)validateMaterials);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String validateMaterials(DynamicObject dataIn, DynamicObject bill, Object fcvrnnum) {
        HashMap<String, String> maters = new HashMap<String, String>(128);
        if (dataIn != null) {
            Map<String, String> materiralMap = materialMap;
            String queryMainSql = "select fmaterialid from T_MDS_FCDATADTLENT where fid = " + dataIn.get("id");
            try (DataSet queryMainData = DB.queryDataSet((String)"queryFcData2", (DBRoute)pur, (String)queryMainSql, null);){
                for (Row row : queryMainData) {
                    String materialId = row.getString("fmaterialid");
                    if (materiralMap.containsKey(materialId) || maters.containsKey(materialId)) continue;
                    maters.put(materialId, materialId);
                }
            }
        }
        return this.errorLog(bill, maters, fcvrnnum);
    }

    private boolean validSvrds(DynamicObject s, DynamicObject bill, String type, int calcType) {
        if (type.equals("mds_vrds")) {
            return this.validateStatus(s, bill, calcType, 1);
        }
        if (type.equals("mds_corl")) {
            Object masterid = s.getPkValue();
            DynamicObject sgl = BusinessDataServiceHelper.loadSingle((Object)masterid, (String)"mds_corl");
            Object enable = sgl.get("enable");
            Object status = sgl.get("status");
            if (!"1".equals(enable.toString())) {
                bill.set("runninglog_tag", (Object)ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb\u5355\u636e\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseCalcRunningTask_20", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!"C".equals(status.toString())) {
                bill.set("runninglog_tag", (Object)ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb\u5355\u636e\u672a\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseCalcRunningTask_21", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection etrs = sgl.getDynamicObjectCollection("entryentity");
            for (DynamicObject o : etrs) {
                DynamicObject vrds = (DynamicObject)o.get("srcvrnnum");
                if (this.validateStatus(vrds, bill, calcType, 1)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validSetoff(DynamicObject bill, Object setoffid, DynamicObject setoffverid) {
        HashMap<String, String> maters = new HashMap<String, String>(128);
        Map<String, String> materiralMap = materialMap;
        StringBuilder sb = new StringBuilder();
        sb.append("select fmaterialid  from t_mds_fnreport where  1=1  ");
        sb.append(" and fsetid = ");
        sb.append(setoffid);
        sb.append(" and fsetoffqty = 0 ");
        sb.append(" and fforecastqty != 0 ");
        if (setoffverid != null) {
            sb.append(" and fsetoffverid = ");
            sb.append(setoffverid.getPkValue());
        }
        try (DataSet queryMainData = DB.queryDataSet((String)"querySetoffData", (DBRoute)pur, (String)sb.toString());){
            for (Row row : queryMainData) {
                String materialId = row.getString("fmaterialid");
                if (materiralMap.containsKey(materialId) || maters.containsKey(materialId)) continue;
                maters.put(materialId, materialId);
            }
        }
        String validateMaterials = this.errorLog(bill, maters, null);
        if (!"".equals(validateMaterials.trim())) {
            bill.set("runninglog_tag", (Object)validateMaterials);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getMaterialIds() {
        HashMap<String, String> materialMap = new HashMap<String, String>(128);
        String sqlk = "select fid from T_BD_Material where fstatus='C' and fenable='1' ";
        try (DataSet queryDataSet = DB.queryDataSet((String)"queryAllmaterail", (DBRoute)DBRoute.base, (String)sqlk);){
            for (Row row : queryDataSet) {
                String pkid = row.getString("fid");
                materialMap.put(pkid, pkid);
            }
        }
        return materialMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheQuotaData(Set<String> materialSet) {
        log.info("BaseCalcRunningTask222:redis-start.........");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("quotatype", "=", (Object)"bd_productsummary"));
        DataSet quotas = QueryServiceHelper.queryDataSet((String)"basecalcrun_quotadata", (String)"mds_quotadata", (String)this.createQuotaDataSelected(), (QFilter[])new QFilter[]{filter}, (String)"entryentity.quotamod");
        ArrayList<Long> offingidList = new ArrayList<Long>();
        HashMap<Long, JSONArray> offingMap = new HashMap<Long, JSONArray>();
        HashMap<Long, JSONArray> materialjsonMap = new HashMap<Long, JSONArray>();
        try {
            for (Row row : quotas) {
                Long offingid = row.getLong("material.id");
                Long effectdate = row.getDate("effectdate").getTime();
                Long losedate = row.getDate("losedate").getTime();
                BigDecimal quotamod = row.getBigDecimal("entryentity.quotamod");
                if (quotamod != null) {
                    quotamod = quotamod.divide(BigDecimal.valueOf(100L), new MathContext(12));
                }
                Long allocateorg = row.getLong("entryentity.allocateorg");
                JSONObject obj = new JSONObject();
                obj.put("QUOTATYPE", (Object)"bd_productsummary");
                obj.put("EFFECTDATE", (Object)effectdate);
                obj.put("LOSEDATE", (Object)losedate);
                obj.put("QUOTAMOD", (Object)quotamod);
                obj.put("ALLOCATEORG", (Object)allocateorg);
                if (offingMap.containsKey(offingid)) {
                    ((JSONArray)offingMap.get(offingid)).add((Object)obj);
                } else {
                    JSONArray array = new JSONArray();
                    array.add((Object)obj);
                    offingMap.put(offingid, array);
                }
                offingidList.add(offingid);
            }
        }
        finally {
            quotas.close();
        }
        filter = new QFilter("offeringcode", "in", offingidList);
        filter.and(new QFilter("status", "=", (Object)"C"));
        try (DataSet offings = QueryServiceHelper.queryDataSet((String)"basecalcrun_offings", (String)"bd_material", (String)"id,offeringcode", (QFilter[])new QFilter[]{filter}, (String)"");){
            for (Row row : offings) {
                Long materialid = row.getLong("id");
                Long offeringcode = row.getLong("offeringcode");
                if (!materialSet.contains(materialid.toString())) continue;
                JSONArray jsonArray = (JSONArray)offingMap.get(offeringcode);
                JSONArray clone = (JSONArray)jsonArray.clone();
                materialjsonMap.put(materialid, clone);
            }
        }
        filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("quotatype", "=", (Object)"bd_material"));
        try (DataSet materials = QueryServiceHelper.queryDataSet((String)"basecalcrun_material", (String)"mds_quotadata", (String)this.createQuotaDataSelected(), (QFilter[])new QFilter[]{filter}, (String)"entryentity.quotamod");){
            for (Row row : materials) {
                Long materialid = row.getLong("material.id");
                Long effectdate = row.getDate("effectdate").getTime();
                Long losedate = row.getDate("losedate").getTime();
                BigDecimal quotamod = row.getBigDecimal("entryentity.quotamod");
                if (quotamod != null) {
                    quotamod = quotamod.divide(BigDecimal.valueOf(100L), new MathContext(12));
                }
                Long allocateorg = row.getLong("entryentity.allocateorg");
                JSONObject obj = new JSONObject();
                obj.put("QUOTATYPE", (Object)"bd_material");
                obj.put("EFFECTDATE", (Object)effectdate);
                obj.put("LOSEDATE", (Object)losedate);
                obj.put("QUOTAMOD", (Object)quotamod);
                obj.put("ALLOCATEORG", (Object)allocateorg);
                if (materialjsonMap.containsKey(materialid)) {
                    ((JSONArray)materialjsonMap.get(materialid)).add((Object)obj);
                    continue;
                }
                JSONArray array = new JSONArray();
                array.add((Object)obj);
                materialjsonMap.put(materialid, array);
            }
        }
        Iterator materialiter = materialjsonMap.entrySet().iterator();
        HashMap<String, String> marp = new HashMap<String, String>(128);
        while (materialiter.hasNext()) {
            Map.Entry entry = materialiter.next();
            String key = ((Long)entry.getKey()).toString();
            JSONArray value = (JSONArray)entry.getValue();
            if (!materialSet.contains(key)) continue;
            marp.put(key, JSONArray.toJSONString((Object)value));
            if (marp.size() <= 100) continue;
            MDSCacheManager.getInst().putData("basecalcrun_quota", marp);
            marp.clear();
        }
        if (marp.size() > 0) {
            MDSCacheManager.getInst().putData("basecalcrun_quota", marp);
            marp.clear();
        }
    }

    private String createQuotaDataSelected() {
        StringBuilder sql = new StringBuilder();
        sql.append("quotatype,material.id,effectdate,losedate,entryentity.quotamod,entryentity.allocateorg");
        return sql.toString();
    }

    private Set<Date> getAllMonday(Set<Date> dateList) {
        HashSet<Date> mondaySet = new HashSet<Date>(100);
        for (Date date : dateList) {
            Date monday = DateUtil.getTheWeekStart((Date)date, (int)2);
            mondaySet.add(monday);
        }
        return mondaySet;
    }
}

