/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.task;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.common.util.MDSUtils;

public class ForecastCalRunTask
implements Callable<String>,
Serializable {
    private static final long serialVersionUID = 1180391652745484852L;
    private static Log log = LogFactory.getLog(ForecastCalRunTask.class);
    private static DBRoute pur = new DBRoute("pur");
    private List<String> subList = null;
    private Map<String, Object> params = null;
    private DynamicObject dynamicObject = null;

    public ForecastCalRunTask() {
    }

    public ForecastCalRunTask(List<String> sList, Map<String, Object> params, DynamicObject dynamicObject) {
        this.subList = sList;
        this.params = params;
        this.dynamicObject = dynamicObject;
    }

    @Override
    public String call() throws Exception {
        log.info("ForecastCalRunTask:\u591a\u7ebf\u7a0b.-------start\uff1a" + System.currentTimeMillis());
        try (TXHandle h = TX.requiresNew((String)"call");){
            this.calculateData(this.dynamicObject, this.params, this.subList);
        }
        catch (Exception e) {
            log.error("ForecastCalRunTask:\u591a\u7ebf\u7a0b\u5199\u5165\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage());
            throw e;
        }
        log.info("ForecastCalRunTask:\u591a\u7ebf\u7a0b.-------end\uff1a" + System.currentTimeMillis());
        return null;
    }

    private void calculateData(DynamicObject dynamicObject, Map<String, Object> params, List<String> materialList) {
        if (dynamicObject == null || params == null || materialList == null) {
            return;
        }
        String materials = materialList.stream().collect(Collectors.joining(","));
        DynamicObject preData = (DynamicObject)params.get("preData");
        DynamicObject predversion = (DynamicObject)dynamicObject.get("predversion");
        Map<String, Map<Date, List<Map<String, String>>>> preMap = this.getPreMaterialData(preData, materials);
        List pkList = (List)params.get("pkList");
        Map relations = (Map)params.get("relations");
        Map<String, Map<Date, BigDecimal>> sourceMap = this.getSourceMaterialData(dynamicObject, preData, pkList, relations, materials);
        Map<String, String> materialUnitMap = this.getMaterialUnitData(materials);
        ArrayList<Object[]> addParamsList = new ArrayList<Object[]>(256);
        ArrayList<Object[]> updateParamsList = new ArrayList<Object[]>(256);
        String changeway = dynamicObject.getString("changeway");
        String sourcecode = ((DynamicObject)dynamicObject.get("forecast")).getString("number");
        String cycletype = predversion == null ? null : predversion.getString("cytype");
        long[] ids = ORM.create().genLongIds("mds_data", 40000);
        Long plangrp = 0L;
        int idindex = 0;
        for (Map.Entry<String, Map<Date, BigDecimal>> mts : sourceMap.entrySet()) {
            Map<Date, BigDecimal> map = mts.getValue();
            String mapkey = mts.getKey();
            String materialId = this.getMapMaterialId(mapkey);
            for (Map.Entry<Date, BigDecimal> node : map.entrySet()) {
                if ("1".equals(changeway)) {
                    Map<Date, List<Map<String, String>>> preMapRow = preMap.get(mapkey);
                    Long org = Long.valueOf(this.getMapOrg(mapkey));
                    this.getEntryByConsAndOrg(materialUnitMap, materialId, node, sourcecode, org, addParamsList, updateParamsList, preMapRow, cycletype, preData.getPkValue(), ids[idindex], plangrp);
                    ++idindex;
                    continue;
                }
                Object[] param = new Object[]{preData.getPkValue(), ids[idindex], 0, Long.valueOf(materialId), cycletype, node.getKey(), node.getValue(), 0, Long.valueOf(materialUnitMap.get(materialId)), plangrp, sourcecode};
                addParamsList.add(param);
                ++idindex;
            }
        }
        this.writeSourceToPre(preData.getPkValue(), addParamsList, updateParamsList);
    }

    private void writeSourceToPre(Object pkid, List<Object[]> addParamsList, List<Object[]> updateParamsList) {
        try (TXHandle h = TX.requiresNew((String)"writeSourceToDest");){
            if (addParamsList.size() > 0) {
                String addsql = "insert into t_mds_fcdatadtlent(fid,fentryid,fseq,fmaterialid,fcycletyped,fdatenode,ffcqty,fprodorg,fbaseunitid,fplangp,fqtysrc) values(?,?,?,?,?,?,?,?,?,?,?)";
                DB.executeBatch((DBRoute)pur, (String)addsql, addParamsList);
                log.info("ForecastCalRunTask:\u591a\u7ebf\u7a0b\u65b0\u589e\u6570\u636e" + addParamsList.size() + "\u6761\uff0c\u65f6\u95f4\uff1a" + System.currentTimeMillis());
            }
            if (updateParamsList.size() > 0) {
                String updatesql = "update t_mds_fcdatadtlent set ffcqty=?, fcycletyped=?,fprodorg=?,fbaseunitid=?,fplangp=?,fqtysrc=? where fentryid = ? ";
                DB.executeBatch((DBRoute)pur, (String)updatesql, updateParamsList);
                log.info("ForecastCalRunTask:\u591a\u7ebf\u7a0b\u66f4\u65b0\u6570\u636e" + updateParamsList.size() + "\u6761\uff0c\u65f6\u95f4\uff1a" + System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u6570\u636e\u5f02\u5e38-writeSourceToPre\uff1a" + e.getMessage());
            throw new KDBizException((Throwable)e, new ErrorCode("ForecastCalRunTaskError", ResManager.loadKDString((String)"writeSourceToPre()\u8fd0\u884c\u5f02\u5e38\u3002", (String)"ForecastCalRunTask_0", (String)"mmc-mds-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
    }

    private void getEntryByConsAndOrg(Map<String, String> materialUnitMap, String materialId, Map.Entry<Date, BigDecimal> node, String sourcecode, Long org, List<Object[]> addParamsList, List<Object[]> updateParamsList, Map<Date, List<Map<String, String>>> preMapRow, String cycletype, Object pkid, long ids, Object plangrp) {
        Long baseunit = Long.valueOf(materialUnitMap.get(materialId));
        if (preMapRow == null || preMapRow.isEmpty()) {
            Object[] param = new Object[]{pkid, ids, 0, Long.valueOf(materialId), cycletype, node.getKey(), node.getValue(), org, baseunit, 0, sourcecode};
            addParamsList.add(param);
            return;
        }
        if (!preMapRow.containsKey(node.getKey())) {
            Object[] param = new Object[]{pkid, ids, 0, Long.valueOf(materialId), cycletype, node.getKey(), node.getValue(), org, baseunit, plangrp, sourcecode};
            addParamsList.add(param);
            return;
        }
        List<Map<String, String>> list = preMapRow.get(node.getKey());
        int index = 0;
        for (Map<String, String> lmap : list) {
            if (index == 0) {
                BigDecimal ffcqty = lmap.get("ffcqty") == null ? BigDecimal.ZERO : new BigDecimal(lmap.get("ffcqty"));
                Object[] param = new Object[]{node.getValue().add(ffcqty), cycletype, org, baseunit, plangrp, sourcecode, Long.valueOf(lmap.get("fentryid"))};
                updateParamsList.add(param);
            }
            ++index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getMaterialUnitData(String materials) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append("fid, fbaseunit ");
        sql.append("from t_bd_material ");
        sql.append("where fid in (");
        sql.append(materials);
        sql.append(") ");
        try (DataSet queryData = null;){
            queryData = DB.queryDataSet((String)"queryunitData", (DBRoute)DBRoute.base, (String)sql.toString());
            for (Row row : queryData) {
                String fid = row.getString("fid");
                String baseunit = row.getString("fbaseunit");
                map.put(fid, baseunit);
            }
        }
        return map;
    }

    private Map<String, Map<Date, BigDecimal>> getSourceMaterialData(DynamicObject dynamicObject, DynamicObject preData, List<String> pkList, Map<Long, BigDecimal> relations, String materials) {
        if (dynamicObject == null || preData == null || pkList.isEmpty() || MDSUtils.isEmpty((CharSequence)materials)) {
            return null;
        }
        HashMap<String, Map<Date, BigDecimal>> map = new HashMap<String, Map<Date, BigDecimal>>();
        String pks = pkList.stream().filter(p -> !MDSUtils.isEmpty((CharSequence)p)).collect(Collectors.joining(","));
        String sqlField = "cdl.fid,cdl.fentryid,cdl.fseq,cdl.fmaterialid,cdl.fdatenode,cdl.ffcqty,cdl.fbaseunitid,cdl.fprodorg,cdl.fplangp,cdl.fwriteoffnum,cdl.fremark";
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append(sqlField);
        sql.append(" ,cd.ffcvrnnum, cd.fbillno ");
        sql.append("from t_mds_fcdatadtlent cdl ");
        sql.append("join t_mds_fcdata cd ");
        sql.append("on cdl.fid = cd.fid ");
        sql.append("where cdl.fid in ( ");
        sql.append(pks);
        sql.append(") ");
        sql.append("and cdl.fmaterialid in ( ");
        sql.append(materials);
        sql.append(") ");
        try (DataSet queryData = null;){
            String sourcetype = dynamicObject.getString("sourcetype");
            Integer outlookperiod = dynamicObject.getInt("outlookperiod");
            BigDecimal mod = dynamicObject.getBigDecimal("mod");
            Date outlookDate = this.getDateByOutlookperiod(outlookperiod);
            queryData = DB.queryDataSet((String)"querySourceMaterialData", (DBRoute)pur, (String)sql.toString());
            for (Row row : queryData) {
                Date monday;
                String prodAndMaterial;
                Long ffcvrnnum;
                Date datenode = row.getDate("fdatenode");
                String material = row.getString("fmaterialid");
                BigDecimal fcqty = row.getBigDecimal("ffcqty");
                String prodorg = row.getString("fprodorg");
                DynamicObject fcvrnnum = preData.getDynamicObject("fcvrnnum");
                String cytype = fcvrnnum.getString("cytype");
                if (DateUtil.comp((Date)datenode, (Date)outlookDate)) continue;
                String dayofweek = fcvrnnum.getString("dayofweek");
                BigDecimal percent = new BigDecimal("1");
                if (relations != null && !relations.isEmpty() && "mds_corl".equals(sourcetype) && (ffcvrnnum = row.getLong("ffcvrnnum")) != null && ffcvrnnum != 0L) {
                    percent = relations.get(ffcvrnnum);
                }
                if (percent == null) {
                    percent = new BigDecimal("1");
                }
                if (BigDecimal.ZERO.compareTo(fcqty) >= 0) {
                    fcqty = BigDecimal.ZERO;
                }
                BigDecimal devides = new BigDecimal("100");
                BigDecimal result = fcqty.multiply(percent).divide(devides, 10, RoundingMode.HALF_UP).multiply(mod);
                Map<Date, BigDecimal> dns = null;
                StringBuilder sb = new StringBuilder();
                sb.append(material).append("@@@");
                if (prodorg != null) {
                    sb.append(prodorg);
                }
                if (!map.containsKey(prodAndMaterial = sb.toString())) {
                    dns = new HashMap();
                    if ("1".equals(cytype)) {
                        monday = DateUtil.findTheWeekMonday((Date)datenode);
                        monday = DateUtil.getMondayOffset((Date)monday, (String)dayofweek);
                        dns.put(monday, result);
                    } else {
                        dns.put(datenode, result);
                    }
                    map.put(prodAndMaterial, dns);
                    continue;
                }
                dns = (Map)map.get(prodAndMaterial);
                if ("1".equals(cytype)) {
                    monday = DateUtil.findTheWeekMonday((Date)datenode);
                    BigDecimal result1 = dns.get(monday = DateUtil.getMondayOffset((Date)monday, (String)dayofweek)) == null ? new BigDecimal("0") : (BigDecimal)dns.get(monday);
                    BigDecimal sum = result.add(result1);
                    dns.put(monday, sum);
                    continue;
                }
                BigDecimal result1 = dns.get(datenode) == null ? new BigDecimal("0") : (BigDecimal)dns.get(datenode);
                BigDecimal sum = result.add(result1);
                dns.put(datenode, sum);
            }
        }
        return map;
    }

    private Date getDateByOutlookperiod(Integer outlookperiod) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, calendar.get(5) + outlookperiod);
        return calendar.getTime();
    }

    private Map<String, Map<Date, List<Map<String, String>>>> getPreMaterialData(DynamicObject dynamicObject, String materials) {
        if (dynamicObject == null || MDSUtils.isEmpty((CharSequence)materials)) {
            return null;
        }
        String fid = dynamicObject.getPkValue().toString();
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append("fid, fentryid, fmaterialid, fdatenode, ffcqty, fprodorg ");
        sql.append("from t_mds_fcdatadtlent where fid= ");
        sql.append(fid);
        sql.append(" and fmaterialid in (");
        sql.append(materials);
        sql.append(") ");
        DataSet queryData = null;
        HashMap<String, Map<Date, List<Map<String, String>>>> map = new HashMap<String, Map<Date, List<Map<String, String>>>>();
        Map rowMap = new HashMap();
        List rowList = new ArrayList();
        HashMap<String, String> lMap = new HashMap<String, String>();
        try {
            queryData = DB.queryDataSet((String)"PreMaterialData", (DBRoute)pur, (String)sql.toString(), null);
            for (Row row : queryData) {
                String prodAndMaterial;
                String fentryid = row.getString("fentryid");
                String ffcqty = row.getString("ffcqty");
                Date datenode = row.getDate("fdatenode");
                String material = row.getString("fmaterialid");
                String prodorg = row.getString("fprodorg");
                StringBuilder sb = new StringBuilder();
                sb.append(material);
                sb.append("@@@");
                if (prodorg != null) {
                    sb.append(prodorg);
                }
                if (!map.containsKey(prodAndMaterial = sb.toString())) {
                    rowMap = new HashMap();
                    rowList = new ArrayList();
                    lMap = new HashMap();
                    lMap.put("fentryid", fentryid);
                    lMap.put("ffcqty", ffcqty);
                    rowList.add(lMap);
                    rowMap.put(datenode, rowList);
                    map.put(prodAndMaterial, rowMap);
                    continue;
                }
                rowMap = (Map)map.get(prodAndMaterial);
                rowList = (List)rowMap.get(datenode);
                if (rowList != null) {
                    lMap = new HashMap();
                    lMap.put("fentryid", fentryid);
                    lMap.put("ffcqty", ffcqty);
                    rowList.add(lMap);
                    continue;
                }
                rowList = new ArrayList();
                lMap = new HashMap();
                lMap.put("fentryid", fentryid);
                lMap.put("ffcqty", ffcqty);
                rowList.add(lMap);
                rowMap.put(datenode, rowList);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u76ee\u6807\u6570\u636e-getPreMaterialData:" + e.getMessage());
            throw new KDBizException((Throwable)e, new ErrorCode("ForecastCalRunTaskError", ResManager.loadKDString((String)"getPreMaterialData()\u8fd0\u884c\u5f02\u5e38\u3002", (String)"ForecastCalRunTask_2", (String)"mmc-mds-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        finally {
            if (queryData != null) {
                queryData.close();
            }
        }
        return map;
    }

    private String getMapOrg(String mapKey) {
        String[] split = mapKey.split("@@@");
        String org = "";
        if (split.length == 2) {
            org = split[1];
        }
        return org;
    }

    private String getMapMaterialId(String mapKey) {
        String[] split = mapKey.split("@@@");
        String materialId = null;
        if (split.length > 0) {
            materialId = split[0];
        }
        return materialId;
    }
}

