/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.deliveryquery.DeliveryQueryManger;
import kd.mmc.mds.common.impl.ExecuteForecastCalLogRecorder;
import kd.mmc.mds.common.plancalc.CalculateDataSetHandler;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.common.util.ForecastCalUtil;
import kd.mmc.mds.common.util.MDSUtils;
import kd.mmc.mds.common.util.PlanDataToFcDataTranUtil;
import kd.mmc.mds.formplugin.basedata.task.ForecastCalRunTask;

public class ForecastCalRunningTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ForecastCalRunningTask.class);
    private static final DBRoute pur = new DBRoute("pur");
    private final Set<String> materialsSet = new HashSet<String>(256);
    private static final String CO_RUNNINGLOG = "runninglog";
    private final List<String> logs = new ArrayList<String>(16);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        Object calplanid = params.get("calplanid");
        DynamicObject forecastcalplan = BusinessDataServiceHelper.loadSingle((Object)calplanid, (String)"mds_forecastcalplan");
        if (forecastcalplan == null) {
            log.info("ForecastCalRunningTask: forecastcalplan is null");
            return;
        }
        Object schemeid = params.get("schemeid");
        DynamicObject forecastcal = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)"mds_forecastcal");
        if (forecastcal == null) {
            log.info("ForecastCalRunningTask: forecastcal is null");
            return;
        }
        try {
            if ("true".equals(MDSUtils.getMdsSysConfig((String)"forecastlocalmodel", (String)"true"))) {
                boolean result = this.calculatingByAlgoX(forecastcalplan, schemeid);
                if (result) {
                    forecastcal.set("status", (Object)this.getStatus(params));
                    forecastcal.set("calstatus", (Object)ForecastCalUtil.CalcStatus.FINISH.getCode());
                } else {
                    forecastcal.set("status", (Object)ForecastCalUtil.Billstatus.PLAN.getCode());
                    forecastcal.set("calstatus", (Object)ForecastCalUtil.CalcStatus.ERROR.getCode());
                }
            } else {
                boolean result = this.calculating(forecastcalplan, schemeid);
                if (result) {
                    forecastcal.set("status", (Object)this.getStatus(params));
                    forecastcal.set("calstatus", (Object)ForecastCalUtil.CalcStatus.FINISH.getCode());
                } else {
                    forecastcal.set("status", (Object)ForecastCalUtil.Billstatus.PLAN.getCode());
                    forecastcal.set("calstatus", (Object)ForecastCalUtil.CalcStatus.ERROR.getCode());
                }
            }
            SaveServiceHelper.update((DynamicObject)forecastcal);
        }
        catch (Exception e) {
            log.error("ForecastCalRunningTask:error....", (Throwable)e);
            StackTraceElement[] errorSTArray = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            for (StackTraceElement errorST : errorSTArray) {
                if (errorST == null) continue;
                sb.append(errorST).append("\r\n");
            }
            DynamicObjectCollection clist = forecastcal.getDynamicObjectCollection("execlogeentry");
            ORM create = ORM.create();
            DynamicObject entryLogInfo = create.newDynamicObject("mds_forecastcal.execlogeentry");
            entryLogInfo.set("seq", (Object)String.valueOf(1));
            entryLogInfo.set("entrystepseq", (Object)String.valueOf(1));
            if (sb.toString().length() >= 255) {
                entryLogInfo.set("entrydetailmsg", (Object)sb.toString().substring(0, 200));
            } else {
                entryLogInfo.set("entrydetailmsg", (Object)sb.toString());
            }
            clist.add((Object)entryLogInfo);
            forecastcal.set("status", (Object)ForecastCalUtil.Billstatus.PLAN.getCode());
            forecastcal.set("calstatus", (Object)ForecastCalUtil.CalcStatus.ERROR.getCode());
            SaveServiceHelper.update((DynamicObject)forecastcal);
        }
    }

    private void getMdsDataPredversion(DynamicObject dynamicObject) {
        DynamicObject predversion = (DynamicObject)dynamicObject.get("predversion");
        QFilter filter = new QFilter("fcvrnnum", "=", predversion.getPkValue());
        String sql = "fcvrnnum, billno, dmdtype, invaldate, deduct, prededucts, bkdeducts ,billstatus, enablestatus, modifytime, modifier";
        DynamicObject mdsDataPre = BusinessDataServiceHelper.loadSingle((String)"mds_data", (String)sql, (QFilter[])new QFilter[]{filter});
        if (mdsDataPre == null) {
            DynamicObject pred = BusinessDataServiceHelper.newDynamicObject((String)"mds_data");
            pred.set("fcvrnnum", (Object)predversion);
            pred.set("billstatus", (Object)"A");
            pred.set("billno", predversion.get("number"));
            pred.set("enablestatus", (Object)"A");
            pred.set("org", dynamicObject.get("org"));
            pred.set("creator", dynamicObject.get("creator"));
            pred.set("createtime", (Object)new Date());
            pred.set("modifier", dynamicObject.get("modifier"));
            pred.set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pred});
        }
    }

    private boolean calculatingByAlgoX(DynamicObject forecastcalplan, Object schemeid) {
        if (forecastcalplan == null) {
            return false;
        }
        log.info("ForecastCalRunningTask: calculating start...");
        DynamicObject forecastcal = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)"mds_forecastcal");
        if (forecastcal == null) {
            log.info("ForecastCalRunningTask: forecastcal is null");
            return false;
        }
        ORM orm = ORM.create();
        ExecuteForecastCalLogRecorder recorder = new ExecuteForecastCalLogRecorder(orm, forecastcal);
        recorder.initMDSRunLog();
        Integer index = 0;
        long startTime = System.currentTimeMillis();
        forecastcal.set("startdate", (Object)startTime);
        HashMap<String, Object> params = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        boolean result = true;
        try {
            result = this.validateData(forecastcalplan, params);
            if (!result) {
                index = index + 1;
                recorder.createStepLog(index.intValue(), ResManager.loadKDString((String)"\u9a8c\u8bc1\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"ForecastCalRunningTask_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), currentTime, forecastcalplan, result);
                boolean bl = false;
                return bl;
            }
            if (!this.logs.isEmpty()) {
                forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"%s\uff1a\u7248\u672c\u6570\u636e\u4e3a\u7a7a\u3002", (String)"ForecastCalRunningTask_37", (String)"mmc-mds-formplugin", (Object[])new Object[0]), this.logs.toString()));
            }
            index = index + 1;
            recorder.createStepLog(index.intValue(), ResManager.loadKDString((String)"\u9a8c\u8bc1\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"ForecastCalRunningTask_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), currentTime, forecastcalplan, true);
            index = index + 1;
            recorder.createStepLog(index.intValue(), String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6765\u6e90\u5355\u636e\u4e2d\u7269\u6599\uff0c\u7269\u6599\u6570\u91cf\uff1a%s\u3002", (String)"ForecastCalRunningTask_24", (String)"mmc-mds-formplugin", (Object[])new Object[0]), this.materialsSet.size()), currentTime, forecastcalplan, true);
            this.getMdsDataPredversion(forecastcalplan);
            currentTime = System.currentTimeMillis();
            log.info("ForecastCalRunningAlgoXTask:\u8ba1\u7b97\u5f00\u59cb\uff1a" + currentTime);
            String changeWay = forecastcalplan.getString("changeWay");
            CalculateDataSetHandler.calculate((Object)forecastcalplan.getPkValue(), (String)"mds_forecastcalplan", (String)changeWay, (boolean)false);
            index = index + 1;
            recorder.createStepLog(index.intValue(), ResManager.loadKDString((String)"\u5c06\u6765\u6e90\u5355\u636e\u7684\u8ba1\u7b97\u7ed3\u679c\u5199\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"ForecastCalRunningTask_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]), currentTime, forecastcalplan, true);
            currentTime = System.currentTimeMillis();
            log.info(String.format("ForecastCalRunningTask->sycnData\u540c\u6b65\u5f00\u59cb\u65f6\u95f4\uff1a%s", currentTime));
            this.sycnDataToNewPlan(forecastcalplan);
            log.info(String.format("ForecastCalRunningTask->sycnData\u540c\u6b65\u7ed3\u675f\u65f6\u95f4\uff1a%s", currentTime));
            index = index + 1;
            recorder.createStepLog(index.intValue(), ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u540c\u6b65\u6570\u636e\u5230\u65b0\u5355\u636e\u3002", (String)"ForecastCalRunningTask_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]), currentTime, forecastcalplan, true);
        }
        catch (Exception e) {
            log.error("ForecastCalRunningTask:calculateException....", (Throwable)e);
            if (e.getMessage() != null && e.getMessage().length() >= 255) {
                forecastcalplan.set(CO_RUNNINGLOG, (Object)e.getMessage().substring(0, 200));
            } else {
                forecastcalplan.set(CO_RUNNINGLOG, (Object)e.getMessage());
            }
            result = false;
            index = index + 1;
            recorder.createStepLog(index.intValue(), ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"ForecastCalRunningTask_5", (String)"mmc-mds-formplugin", (Object[])new Object[0]), currentTime, forecastcalplan, result);
            throw e;
        }
        finally {
            ForecastCalUtil.releaseLock((String)"mds_forecastcalplan", (String)"modify", (String)String.valueOf(forecastcalplan.getPkValue()));
            Long endtime = System.currentTimeMillis();
            float seconds = (float)(endtime - startTime) / 1000.0f;
            forecastcal.set("enddate", (Object)endtime);
            forecastcal.set("summin", (Object)Float.valueOf(seconds));
            SaveServiceHelper.update((DynamicObject)forecastcal);
        }
        log.info("ForecastCalRunningTask: calculating end...");
        return result;
    }

    private boolean calculating(DynamicObject forecastcalplan, Object schemeid) {
        if (forecastcalplan == null) {
            return false;
        }
        log.info("ForecastCalRunningTask: calculating start...");
        DynamicObject forecastcal = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)"mds_forecastcal");
        if (forecastcal == null) {
            log.info("ForecastCalRunningTask: forecastcal is null");
            return false;
        }
        ORM orm = ORM.create();
        ExecuteForecastCalLogRecorder recorder = new ExecuteForecastCalLogRecorder(orm, forecastcal);
        recorder.initMDSRunLog();
        Integer index = 0;
        long startTime = System.currentTimeMillis();
        forecastcal.set("startdate", (Object)startTime);
        HashMap<String, Object> params = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        try {
            boolean validateResult = this.validateData(forecastcalplan, params);
            if (!validateResult) {
                index = index + 1;
                recorder.createStepLog(index.intValue(), ResManager.loadKDString((String)"\u9a8c\u8bc1\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"ForecastCalRunningTask_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), currentTime, forecastcalplan, false);
                boolean bl = false;
                return bl;
            }
            if (!this.logs.isEmpty()) {
                forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"%s\uff1a\u7248\u672c\u6570\u636e\u4e3a\u7a7a\u3002", (String)"ForecastCalRunningTask_37", (String)"mmc-mds-formplugin", (Object[])new Object[0]), this.logs.toString()));
            }
            index = index + 1;
            recorder.createStepLog(index.intValue(), ResManager.loadKDString((String)"\u9a8c\u8bc1\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"ForecastCalRunningTask_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), currentTime, forecastcalplan, true);
            index = index + 1;
            recorder.createStepLog(index.intValue(), String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6765\u6e90\u5355\u636e\u4e2d\u7269\u6599\uff0c\u7269\u6599\u6570\u91cf\uff1a%s\u3002", (String)"ForecastCalRunningTask_24", (String)"mmc-mds-formplugin", (Object[])new Object[0]), this.materialsSet.size()), currentTime, forecastcalplan, true);
            currentTime = System.currentTimeMillis();
            boolean result = this.startCalculate(forecastcalplan, params);
            if (!result) {
                index = index + 1;
                recorder.createStepLog(index.intValue(), ResManager.loadKDString((String)"\u5c06\u6765\u6e90\u5355\u636e\u7684\u8ba1\u7b97\u7ed3\u679c\u5199\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"ForecastCalRunningTask_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]), currentTime, forecastcalplan, false);
                boolean endtime = false;
                return endtime;
            }
            int columnSize = this.getdateNodeColumn(params);
            if (columnSize > 150) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u65f6\u95f4\u8282\u70b9\u8d85\u8fc7150\u5217\u3002", (String)"ForecastCalRunningTask_6", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            }
            index = index + 1;
            recorder.createStepLog(index.intValue(), ResManager.loadKDString((String)"\u5c06\u6765\u6e90\u5355\u636e\u7684\u8ba1\u7b97\u7ed3\u679c\u5199\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"ForecastCalRunningTask_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]), currentTime, forecastcalplan, true);
            currentTime = System.currentTimeMillis();
            log.info(String.format("ForecastCalRunningTask->sycnData start\uff1a%s", currentTime));
            this.sycnDataToNewPlan(forecastcalplan);
            log.info(String.format("ForecastCalRunningTask->sycnData end\uff1a%s", currentTime));
            index = index + 1;
            recorder.createStepLog(index.intValue(), ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u540c\u6b65\u6570\u636e\u5230\u65b0\u5355\u636e\u3002", (String)"ForecastCalRunningTask_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]), currentTime, forecastcalplan, true);
        }
        catch (Exception e) {
            log.error("ForecastCalRunningTask:calculateException....", (Throwable)e);
            if (e.getMessage() != null && e.getMessage().length() >= 255) {
                forecastcalplan.set(CO_RUNNINGLOG, (Object)e.getMessage().substring(0, 200));
            } else {
                forecastcalplan.set(CO_RUNNINGLOG, (Object)e.getMessage());
            }
            index = index + 1;
            recorder.createStepLog(index.intValue(), ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"ForecastCalRunningTask_5", (String)"mmc-mds-formplugin", (Object[])new Object[0]), currentTime, forecastcalplan, false);
            throw e;
        }
        finally {
            ForecastCalUtil.releaseLock((String)"mds_forecastcalplan", (String)"modify", (String)String.valueOf(forecastcalplan.getPkValue()));
            Long endtime = System.currentTimeMillis();
            float seconds = (float)(endtime - startTime) / 1000.0f;
            forecastcal.set("enddate", (Object)endtime);
            forecastcal.set("summin", (Object)Float.valueOf(seconds));
            SaveServiceHelper.update((DynamicObject)forecastcal);
        }
        log.info("ForecastCalRunningTask: calculating end...");
        return true;
    }

    private boolean startCalculate(DynamicObject dynamicObject, Map<String, Object> params) {
        if (dynamicObject == null) {
            return false;
        }
        DynamicObject predversion = (DynamicObject)dynamicObject.get("predversion");
        if (predversion == null) {
            dynamicObject.set(CO_RUNNINGLOG, (Object)ResManager.loadKDString((String)"\u76ee\u6807\u7248\u672c\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ForecastCalRunningTask_7", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject mdsDataPre = this.getMdsDataPre(dynamicObject, predversion);
        params.put("preData", mdsDataPre);
        int batchSize = 200;
        ArrayList<String> subList = new ArrayList<String>(200);
        int i = 0;
        Set<String> materialList = this.materialsSet;
        try {
            if (materialList != null) {
                for (String materialId : materialList) {
                    subList.add(materialId);
                    if (++i % 200 != 0) continue;
                    ForecastCalRunTask forecastCalRunTask = new ForecastCalRunTask(new ArrayList<String>(subList), params, dynamicObject);
                    forecastCalRunTask.call();
                    subList.clear();
                }
            }
            if (!subList.isEmpty()) {
                ForecastCalRunTask forecastCalRunTask = new ForecastCalRunTask(new ArrayList<String>(subList), params, dynamicObject);
                forecastCalRunTask.call();
            }
        }
        catch (Exception e) {
            long currentTime = System.currentTimeMillis();
            log.error("ForecastCalRunningTask:\u591a\u7ebf\u7a0b.--------error\uff1a" + currentTime, (Throwable)e);
            if (e.getMessage() != null && e.getMessage().length() >= 255) {
                dynamicObject.set(CO_RUNNINGLOG, (Object)e.getMessage().substring(0, 200));
            } else {
                dynamicObject.set(CO_RUNNINGLOG, (Object)e.getMessage());
            }
            return false;
        }
        log.info("ForecastCalRunningTask:\u591a\u7ebf\u7a0b\u7ed3\u675f----\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        SaveServiceHelper.update((DynamicObject)dynamicObject);
        DynamicObject preData = (DynamicObject)params.get("preData");
        if (preData != null) {
            preData.set("modifier", dynamicObject.get("modifier"));
            preData.set("modifytime", (Object)new Date());
            preData.set("billstatus", (Object)"A");
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{preData});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject getMdsDataPre(DynamicObject dynamicObject, DynamicObject predversion) {
        QFilter filter = new QFilter("fcvrnnum.number", "=", predversion.get("number"));
        String sql = "fcvrnnum, billno, dmdtype, invaldate, deduct, prededucts, bkdeducts ,billstatus, enablestatus, modifytime, modifier";
        DynamicObject mdsDataPre = BusinessDataServiceHelper.loadSingle((String)"mds_data", (String)sql, (QFilter[])new QFilter[]{filter});
        if (mdsDataPre == null) {
            DynamicObject pred = BusinessDataServiceHelper.newDynamicObject((String)"mds_data");
            pred.set("fcvrnnum", (Object)predversion);
            pred.set("billstatus", (Object)"C");
            pred.set("billno", predversion.get("number"));
            pred.set("enablestatus", (Object)"A");
            pred.set("org", dynamicObject.get("org"));
            pred.set("creator", dynamicObject.get("creator"));
            pred.set("createtime", (Object)new Date());
            pred.set("modifier", dynamicObject.get("modifier"));
            pred.set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pred});
            return pred;
        }
        String changeWays = dynamicObject.getString("changeway");
        if ("0".equals(changeWays)) {
            try (TXHandle h2 = TX.requiresNew();){
                log.info("ForecastCalRunningTask\u5220\u9664\u5206\u5f55start--------\uff1a" + System.currentTimeMillis());
                String deletesql = "delete from t_mds_fcdatadtlent where fid = " + mdsDataPre.getPkValue();
                DB.execute((DBRoute)pur, (String)deletesql);
            }
            finally {
                log.info("ForecastCalRunningTask\u5220\u9664\u5206\u5f55end--------\uff1a" + System.currentTimeMillis());
            }
        }
        return mdsDataPre;
    }

    private boolean validateData(DynamicObject forecastcalplan, Map<String, Object> params) {
        if (forecastcalplan == null) {
            return false;
        }
        String calstatus = forecastcalplan.getString("calstatus");
        if ("0".equals(calstatus)) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u7b97\u65b9\u6848\uff1a%s\u5df2\u7981\u7528\u3002", (String)"ForecastCalRunningTask_25", (String)"mmc-mds-formplugin", (Object[])new Object[0]), forecastcalplan.getString("billno")));
            return false;
        }
        String billstatus = forecastcalplan.getString("billstatus");
        if ("A".equals(billstatus)) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u7b97\u65b9\u6848\uff1a%s\u5c1a\u672a\u63d0\u4ea4\u3002", (String)"ForecastCalRunningTask_26", (String)"mmc-mds-formplugin", (Object[])new Object[0]), forecastcalplan.getString("billno")));
            return false;
        }
        DynamicObject predversion = (DynamicObject)forecastcalplan.get("predversion");
        if (predversion == null) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)ResManager.loadKDString((String)"\u76ee\u6807\u7248\u672c\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ForecastCalRunningTask_7", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean validPred = this.validateVrds(forecastcalplan, predversion, "pred", false);
        if (!validPred) {
            return false;
        }
        params.put("pre", predversion);
        String sourcetype = forecastcalplan.getString("sourcetype");
        DynamicObject forecast = forecastcalplan.getDynamicObject("forecast");
        if (forecast == null) {
            if ("mds_vrds".equals(sourcetype)) {
                forecastcalplan.set(CO_RUNNINGLOG, (Object)ResManager.loadKDString((String)"\u9884\u6d4b\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ForecastCalRunningTask_11", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            } else if ("mds_corl".equals(sourcetype)) {
                forecastcalplan.set(CO_RUNNINGLOG, (Object)ResManager.loadKDString((String)"\u9884\u6d4b\u6574\u5408\u89c4\u5219\u5b9a\u4e49\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ForecastCalRunningTask_12", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            } else if ("mds_deliveryqueryset".equals(sourcetype)) {
                forecastcalplan.set(CO_RUNNINGLOG, (Object)ResManager.loadKDString((String)"\u53d1\u8d27\u67e5\u8be2\u65b9\u6848\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ForecastCalRunningTask_38", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        boolean validForecast = true;
        if ("mds_vrds".equals(sourcetype)) {
            validForecast = this.validateVrds(forecastcalplan, forecast, "forecast", true);
        } else if ("mds_corl".equals(sourcetype)) {
            validForecast = this.validateCorl(forecastcalplan, forecast);
        } else if ("mds_deliveryqueryset".equals(sourcetype)) {
            validForecast = this.validateDeliveryQuerySet(forecastcalplan, forecast);
        }
        if (!validForecast) {
            return false;
        }
        params.put("source", forecast);
        validForecast = this.getRelations(forecastcalplan, forecast, params, sourcetype);
        return validForecast;
    }

    private boolean validateDeliveryQuerySet(DynamicObject forecastcalplan, DynamicObject dynamicObject) {
        if (forecastcalplan == null || dynamicObject == null) {
            return false;
        }
        try {
            DeliveryQueryManger deliveryQueryManger = DeliveryQueryManger.create((Object)dynamicObject.getPkValue());
            DataSet dataSet = deliveryQueryManger.queryDeliverySet().groupBy(new String[]{"materiel"}).finish();
            for (Row row : dataSet) {
                this.materialsSet.add(row.getString("materiel"));
            }
        }
        catch (Exception ex) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)ex.getMessage());
        }
        return true;
    }

    private boolean getRelations(DynamicObject dynamicObject, DynamicObject forecast, Map<String, Object> params, String sourcetype) {
        if (params == null || params.isEmpty()) {
            return false;
        }
        ArrayList<String> numberList = new ArrayList<String>();
        if ("mds_corl".equals(sourcetype)) {
            DynamicObject corl = BusinessDataServiceHelper.loadSingleFromCache((Object)forecast.getPkValue(), (String)"mds_corl");
            if (corl == null) {
                dynamicObject.set(CO_RUNNINGLOG, (Object)ResManager.loadKDString((String)"\u9884\u6d4b\u6574\u5408\u89c4\u5219\u5b9a\u4e49\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ForecastCalRunningTask_12", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection entrys = corl.getDynamicObjectCollection("entryentity");
            if (entrys != null && !entrys.isEmpty()) {
                HashMap<Long, BigDecimal> relations = new HashMap<Long, BigDecimal>(entrys.size());
                for (DynamicObject entry : entrys) {
                    DynamicObject srcvrnnum = (DynamicObject)entry.get("srcvrnnum");
                    if (srcvrnnum == null) continue;
                    String number = srcvrnnum.getString("number");
                    numberList.add(number);
                    relations.put((Long)srcvrnnum.getPkValue(), entry.getBigDecimal("propt").divide(new BigDecimal("100"), 10, 4));
                }
                params.put("relations", relations);
            }
        } else {
            numberList.add(forecast.getString("number"));
        }
        if (numberList.isEmpty()) {
            if ("mds_corl".equals(sourcetype)) {
                dynamicObject.set(CO_RUNNINGLOG, (Object)ResManager.loadKDString((String)"\u9884\u6d4b\u6574\u5408\u89c4\u5219\u5b9a\u4e49\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForecastCalRunningTask_13", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            } else {
                dynamicObject.set(CO_RUNNINGLOG, (Object)ResManager.loadKDString((String)"\u9884\u6d4b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForecastCalRunningTask_14", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        QFilter qFilter = new QFilter("fcvrnnum.number", "in", numberList);
        DynamicObject[] mdsDatas = BusinessDataServiceHelper.load((String)"mds_data", (String)"id, fcvrnnum", (QFilter[])new QFilter[]{qFilter});
        List<String> pkList = this.getPks(mdsDatas);
        params.put("pkList", pkList);
        return true;
    }

    private boolean validateCorl(DynamicObject forecastcalplan, DynamicObject dynamicObject) {
        if (forecastcalplan == null || dynamicObject == null) {
            return false;
        }
        DynamicObject corl = BusinessDataServiceHelper.loadSingleFromCache((Object)dynamicObject.getPkValue(), (String)"mds_corl");
        if (corl == null) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)ResManager.loadKDString((String)"\u9884\u6d4b\u6574\u5408\u89c4\u5219\u5b9a\u4e49\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ForecastCalRunningTask_12", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return false;
        }
        String enable = corl.getString("enable");
        if ("0".equals(enable)) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u6574\u5408\u89c4\u5219\u5b9a\u4e49\uff1a%s\u5df2\u7981\u7528\u3002", (String)"ForecastCalRunningTask_27", (String)"mmc-mds-formplugin", (Object[])new Object[0]), corl.getString("name")));
            return false;
        }
        String status = corl.getString("status");
        if (!"C".equals(status)) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u6574\u5408\u89c4\u5219\u5b9a\u4e49\uff1a%s\u5c1a\u672a\u63d0\u4ea4\u3002", (String)"ForecastCalRunningTask_28", (String)"mmc-mds-formplugin", (Object[])new Object[0]), corl.getString("name")));
            return false;
        }
        DynamicObjectCollection entrys = corl.getDynamicObjectCollection("entryentity");
        if (entrys == null || entrys.isEmpty()) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u6574\u5408\u89c4\u5219\u5b9a\u4e49\uff1a%s\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForecastCalRunningTask_29", (String)"mmc-mds-formplugin", (Object[])new Object[0]), corl.getString("name")));
            return false;
        }
        for (DynamicObject entry : entrys) {
            if (this.validateVrds(forecastcalplan, entry.getDynamicObject("srcvrnnum"), "forecast", false)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateVrds(DynamicObject forecastcalplan, DynamicObject dynamicObject, String type, boolean isValidateStatus) {
        if (dynamicObject == null) {
            return false;
        }
        DynamicObject vrds = BusinessDataServiceHelper.loadSingleFromCache((Object)dynamicObject.getPkValue(), (String)"mds_vrds");
        if (vrds == null) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)ResManager.loadKDString((String)"\u76ee\u6807\u7248\u672c\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ForecastCalRunningTask_7", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return false;
        }
        String enable = vrds.getString("enable");
        if ("0".equals(enable)) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u7248\u672c\uff1a%s\u5df2\u88ab\u7981\u7528\u3002", (String)"ForecastCalRunningTask_30", (String)"mmc-mds-formplugin", (Object[])new Object[0]), vrds.getString("name")));
            return false;
        }
        String status = vrds.getString("status");
        if (!"C".equals(status)) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u7248\u672c\uff1a%s\u8fd8\u672a\u63d0\u4ea4\u3002", (String)"ForecastCalRunningTask_31", (String)"mmc-mds-formplugin", (Object[])new Object[0]), vrds.getString("name")));
            return false;
        }
        Date losedate = vrds.getDate("losedate");
        if (losedate != null && !DateUtil.comp((Date)losedate, (Date)new Date())) {
            forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u7248\u672c\uff1a%s\u5df2\u5931\u6548\u3002", (String)"ForecastCalRunningTask_32", (String)"mmc-mds-formplugin", (Object[])new Object[0]), vrds.getString("name")));
            return false;
        }
        if ("forecast".equals(type)) {
            String selectProperties = "id, enablestatus, invaldate, billstatus, fcvrnnum.number";
            QFilter qfilter = new QFilter("fcvrnnum", "=", vrds.getPkValue());
            DynamicObject mdsData = QueryServiceHelper.queryOne((String)"mds_data", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
            if (mdsData != null) {
                Date invaldate = mdsData.getDate("invaldate");
                if (invaldate != null && !DateUtil.comp((Date)invaldate, (Date)new Date())) {
                    forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u6765\u6e90\u9884\u6d4b\u8ba1\u5212\u5904\u7406\uff1a%s\u5df2\u5931\u6548\u3002", (String)"ForecastCalRunningTask_33", (String)"mmc-mds-formplugin", (Object[])new Object[0]), mdsData.getString("fcvrnnum.number")));
                    return false;
                }
                String mdsStatus = mdsData.getString("enablestatus");
                if ("B".equals(mdsStatus)) {
                    forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u6765\u6e90\u9884\u6d4b\u8ba1\u5212\u5904\u7406\uff1a%s\u5df2\u7981\u7528\u3002", (String)"ForecastCalRunningTask_34", (String)"mmc-mds-formplugin", (Object[])new Object[0]), mdsData.getString("fcvrnnum.number")));
                    return false;
                }
                String billstatus = mdsData.getString("billstatus");
                Boolean statuscheckbox = forecastcalplan.getBoolean("billstatuscheckbox");
                if (isValidateStatus && statuscheckbox.booleanValue() && "A".equals(billstatus)) {
                    forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u6765\u6e90\u9884\u6d4b\u8ba1\u5212\u5904\u7406\uff1a%s\u4e3a\u5f85\u786e\u8ba4\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForecastCalRunningTask_35", (String)"mmc-mds-formplugin", (Object[])new Object[0]), mdsData.getString("fcvrnnum.number")));
                    return false;
                }
                HashSet<String> materialSet = new HashSet<String>(128);
                try (DataSet dataSet = null;){
                    StringBuilder sb = new StringBuilder();
                    sb.append("select fmaterialid,fdatenode as datenode from t_mds_fcdatadtlent ");
                    sb.append("where fid = ");
                    sb.append(mdsData.getString("id"));
                    dataSet = DB.queryDataSet((String)"fcdatadtlent-01", (DBRoute)pur, (String)sb.toString());
                    int outlookperiod = forecastcalplan.getInt("outlookperiod");
                    Date outlookDate = DateUtil.dateAddDays((Date)new Date(), (int)outlookperiod);
                    HashMap<String, Date> params = new HashMap<String, Date>();
                    params.put("outlookDate", outlookDate);
                    dataSet = dataSet.filter("datenode <= outlookDate", params);
                    for (Row row : dataSet) {
                        String materialid = row.getString("fmaterialid");
                        materialSet.add(materialid);
                    }
                }
                log.info(String.format("ForecastCalRunningTask-->\u7248\u672c\uff1a%1$s\uff0c\u7269\u6599\u6570\u91cf\uff1a%2$s", vrds.getString("name"), materialSet.size()));
                List<String> materials = this.validateMaterials(materialSet);
                if (materials != null && !materials.isEmpty()) {
                    forecastcalplan.set(CO_RUNNINGLOG, (Object)String.format(ResManager.loadKDString((String)"\u7269\u6599\uff1a%s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ForecastCalRunningTask_36", (String)"mmc-mds-formplugin", (Object[])new Object[0]), materials));
                    return false;
                }
            } else if (this.logs.size() < 20) {
                this.logs.add(vrds.getString("name"));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> validateMaterials(Set<String> idSet) {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        DataSet dataSet = null;
        String ids = idSet.stream().filter(p -> !MDSUtils.isEmpty((CharSequence)p)).collect(Collectors.joining(","));
        ArrayList<String> materials = new ArrayList<String>(16);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("select fid, fnumber, fstatus, fenable from t_bd_material ");
            sb.append("where (fstatus <> 'C' or fenable <> '1') ");
            sb.append("and fid in (");
            sb.append(ids);
            sb.append(") ");
            dataSet = DB.queryDataSet((String)"material-01", (DBRoute)DBRoute.base, (String)sb.toString());
            int index = 0;
            for (Row row : dataSet) {
                String number = row.getString("fnumber");
                if (index < 5) {
                    materials.add(number);
                    ++index;
                    continue;
                }
                break;
            }
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
        }
        this.materialsSet.addAll(idSet);
        return materials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getdateNodeColumn(Map<String, Object> params) {
        String cytype;
        if (params == null) {
            return 0;
        }
        DynamicObject preData = (DynamicObject)params.get("preData");
        if (preData == null) {
            return 0;
        }
        Set<Date> dateNodeSet = new HashSet<Date>();
        try (DataSet dataSet = null;){
            String querySql = "select fdatenode from t_mds_fcdatadtlent where fid = ? ";
            dataSet = DB.queryDataSet((String)"queryDateNodeColumn", (DBRoute)pur, (String)querySql, (Object[])new Object[]{preData.getPkValue()});
            for (Row row : dataSet) {
                Date dateNode = row.getDate("fdatenode");
                dateNodeSet.add(dateNode);
            }
        }
        DynamicObject pre = (DynamicObject)params.get("pre");
        if (pre != null && "1".equals(cytype = pre.getString("cytype"))) {
            dateNodeSet = this.getAllMonday(dateNodeSet);
        }
        return dateNodeSet.size();
    }

    private void sycnDataToNewPlan(DynamicObject dynamicObject) {
        DynamicObject version = (DynamicObject)dynamicObject.get("predversion");
        DynamicObject objlog = ORM.create().newDynamicObject("mds_syncplanlog");
        objlog.set("version", (Object)version);
        objlog.set("direction", (Object)"B");
        objlog.set("status", (Object)"C");
        objlog.set("enable", (Object)1);
        objlog.set("creator", (Object)RequestContext.get().getCurrUserId());
        objlog.set("createtime", (Object)Calendar.getInstance().getTime());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{objlog});
        PlanDataToFcDataTranUtil.tranFcDataToPlanDataByTask((String)version.getString("number"), (Object)objlog.getPkValue());
    }

    private List<String> getPks(DynamicObject[] arr) {
        if (ArrayUtils.isEmpty((Object[])arr)) {
            return null;
        }
        ArrayList<String> pks = new ArrayList<String>();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null) continue;
            pks.add(arr[i].getPkValue().toString());
        }
        return pks;
    }

    private Set<Date> getAllMonday(Set<Date> dateList) {
        HashSet<Date> mondaySet = new HashSet<Date>(100);
        for (Date date : dateList) {
            Date monday = DateUtil.getTheWeekStart((Date)date, (int)2);
            mondaySet.add(monday);
        }
        return mondaySet;
    }

    private String getStatus(Map<String, Object> map) {
        boolean repeat = (Boolean)map.get("repeat");
        if (repeat) {
            return ForecastCalUtil.Billstatus.PLAN.getCode();
        }
        return ForecastCalUtil.Billstatus.CLOSE.getCode();
    }
}

