/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.weekroll;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.weekroll.WeekrollExecUtil;
import kd.mmc.mds.formplugin.basedata.weekroll.WeekrollOp;

public class WeekrollPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String CON_STATUS = "accstatus";
    private static final Log logger = LogFactory.getLog(WeekrollPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.start();
        progressBar.setPercent(0);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operatekey = afterDoOperationEventArgs.getOperateKey();
        Long billid = (Long)this.getModel().getValue("id");
        if ("set".equals(operatekey)) {
            if (!this.checkStat()) {
                return;
            }
            String reString = (String)this.getModel().getValue("setval");
            WeekrollOp.showSetFrom(this.getView(), ((Object)((Object)this)).getClass().getName(), reString);
        } else if ("exec".equals(operatekey) || "rexec".equals(operatekey)) {
            if (!this.checkStat()) {
                return;
            }
            ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
            progressBar.start();
            progressBar.setPercent(0);
            this.getModel().setValue("calculatepro", (Object)0);
            WeekrollExecUtil.exec((Long)billid, (Boolean)"rexec".equals(operatekey));
            this.getModel().setDataChanged(false);
        } else if ("stop".equals(operatekey)) {
            if (billid <= 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"WeekrollPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("execstatus", (Object)"C");
            WeekrollOp.stop(billid);
            this.getModel().setDataChanged(false);
        }
    }

    private boolean checkStat() {
        Long billid = (Long)this.getModel().getValue("id");
        if (billid <= 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"WeekrollPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject thisBill = BusinessDataServiceHelper.loadSingle((Object)billid, (String)"mds_weekroll");
        if ("E".equals(thisBill.getString("execstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WeekrollPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("mds_weekrolltime".equals(e.getActionId()) && e.getReturnData() != null) {
            String resval = e.getReturnData().toString();
            Long billid = (Long)this.getModel().getValue("id");
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billid, (String)"mds_weekroll", (String)"setval");
            this.getModel().setValue("setval", (Object)resval);
            bill.set("setval", (Object)resval);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            JSONObject parseObject = JSONArray.parseObject((String)resval);
            int ordinal = this.getModel().getProperty("setval").getOrdinal();
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
            if (parseObject.getBoolean("isExec").booleanValue()) {
                if ("0".equals(parseObject.getString("runningtype"))) {
                    ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
                    progressBar.start();
                    progressBar.setPercent(0);
                    this.getModel().setValue("calculatepro", (Object)0);
                    int ordinal2 = this.getModel().getProperty("calculatepro").getOrdinal();
                    this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal2, false);
                    WeekrollExecUtil.exec((Long)billid, (Boolean)false);
                } else {
                    String jobId = WeekrollExecUtil.createJob((Long)billid, (JSONObject)parseObject);
                    String scheduleId = WeekrollExecUtil.createPlan((String)jobId, (JSONObject)parseObject);
                    ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                    scheduleManager.enableSchedule(scheduleId);
                    WeekrollOp.updatePlan(billid, scheduleId, jobId);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5468\u6eda\u52a8\u4efb\u52a1\u5df2\u5206\u53d1\u6210\u529f\u3002", (String)"WeekrollPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void onProgress(ProgressEvent arg0) {
        Long id = 0L;
        try {
            id = (Long)this.getModel().getValue("id");
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        Long zero = 0L;
        if (zero.compareTo(id) == 0) {
            return;
        }
        DynamicObject thisBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mds_weekroll");
        this.getModel().updateEntryCache(thisBill.getDynamicObjectCollection("logentry"));
        this.getView().updateView("logentry");
        String stats = thisBill.getString("execstatus");
        String bstats = thisBill.getString(CON_STATUS);
        this.getModel().setValue(CON_STATUS, (Object)bstats);
        int precent = thisBill.getBigDecimal("calculatepro").intValue();
        if (precent > 100) {
            precent = 100;
        }
        arg0.setProgress(precent);
        if ("A".equals(stats) || "B".equals(stats) || "C".equals(stats)) {
            ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
            arg0.setProgress(precent);
            progressBar.stop();
            this.getModel().setValue("calculatepro", (Object)precent);
            this.getModel().setValue("execstatus", (Object)stats);
            this.getModel().setDataChanged(false);
            return;
        }
        this.getModel().setValue("calculatepro", (Object)precent);
        if (precent == 100) {
            ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
            progressBar.stop();
            this.getModel().setValue("stime", (Object)thisBill.getDate("stime"));
            this.getModel().setValue("etime", (Object)thisBill.getDate("etime"));
            this.getModel().setValue("summin", (Object)thisBill.getBigDecimal("summin"));
            this.getModel().setValue("execstatus", (Object)"D");
        } else {
            this.getModel().setValue("execstatus", (Object)"E");
        }
        this.getModel().setDataChanged(false);
    }
}

