/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.basedata.weekroll;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mds.common.setoff.SetOffCommonUtil;

public class WeekrollTimePlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(WeekrollTimePlugin.class);
    private static final String BTNCANCEL = "btncancel";
    private static final String BTNOK = "btnok";
    private static final String BTNRUNNING = "btnrunning";
    private static final String[] MONTHDAY = new String[]{"m1", "m2", "m3", "m4", "m5", "m6", "m7", "m8", "m9", "m10", "m11", "m12", "m13", "m14", "m15", "m16", "m17", "m18", "m19", "m20", "m21", "m22", "m23", "m24", "m25", "m26", "m27", "m28", "m29", "m30", "m31"};
    private static final String[] WEEKDAY = new String[]{"day7", "day1", "day2", "day3", "day4", "day5", "day6"};

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK, BTNRUNNING, BTNCANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setData();
    }

    private void setData() {
        FormShowParameter p = this.getView().getFormShowParameter();
        try {
            String resval = (String)p.getCustomParam("settingstring");
            if ("".equals(resval) || resval.length() < 10) {
                return;
            }
            JSONObject parseObject = JSONArray.parseObject((String)resval);
            if ("0".equals(parseObject.getString("runningtype"))) {
                return;
            }
            this.getModel().setValue("runningtype", (Object)"1");
            this.getModel().setValue("repeat", (Object)parseObject.getString("repeat"));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                this.getModel().setValue("predtime", (Object)parseObject.getString("predtime"));
                this.getModel().setValue("losedate", (Object)format.parse(parseObject.getString("losedate")));
            }
            catch (Exception e) {
                logger.warn((Throwable)e);
            }
            if (!parseObject.getBooleanValue("repeat")) {
                return;
            }
            this.getModel().setValue("repeattype", (Object)parseObject.getString("repeattype"));
            if ("0".equals(parseObject.getString("repeattype"))) {
                for (String ditem : WEEKDAY) {
                    this.getModel().setValue(ditem, (Object)parseObject.getString(ditem));
                }
            } else {
                for (String mitem : MONTHDAY) {
                    this.getModel().setValue(mitem, (Object)parseObject.getString(mitem));
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    public void click(EventObject evt) {
        Control btn = (Control)evt.getSource();
        switch (btn.getKey()) {
            case "btnok": {
                this.save(false);
                break;
            }
            case "btnrunning": {
                this.save(true);
                break;
            }
            default: {
                this.getView().close();
            }
        }
    }

    private void save(boolean isExec) {
        Date thisdate;
        Date curdate;
        String runningtype = this.getModel().getValue("runningtype").toString();
        if ("1".equals(runningtype) && (this.getModel().getValue("predtime") == null || "-1".equals(this.getModel().getValue("predtime").toString()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9884\u7ea6\u65f6\u95f4\u3002", (String)"WeekrollTimePlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("1".equals(runningtype) && this.getModel().getValue("losedate") != null && (curdate = SetOffCommonUtil.formatDate((Date)new Date())).compareTo(thisdate = SetOffCommonUtil.formatDate((Date)((Date)this.getModel().getValue("losedate")))) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u9700\u8981\u5927\u4e8e\u5f53\u5929\u3002", (String)"WeekrollTimePlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        Boolean repeat = (Boolean)this.getModel().getValue("repeat");
        String repeattype = this.getModel().getValue("repeattype").toString();
        if (repeat.booleanValue() && !this.checkobj(repeattype).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u91cd\u590d\u65f6\u95f4\u3002", (String)"WeekrollTimePlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
            return;
        }
        String resval = this.convertToString(isExec);
        this.getView().returnDataToParent((Object)resval);
        this.getView().close();
    }

    private Boolean checkobj(String repeattype) {
        Boolean res = false;
        if ("0".equals(repeattype)) {
            for (String ditem : WEEKDAY) {
                if (!((Boolean)this.getModel().getValue(ditem)).booleanValue()) continue;
                res = true;
            }
        } else {
            for (String mitem : MONTHDAY) {
                if (!((Boolean)this.getModel().getValue(mitem)).booleanValue()) continue;
                res = true;
            }
        }
        return res;
    }

    private String convertToString(Boolean isExec) {
        HashMap<String, String> objmap = new HashMap<String, String>(100);
        objmap.put("isExec", isExec.toString());
        objmap.put("runningtype", this.getModel().getValue("runningtype").toString());
        if (this.getModel().getValue("predtime") != null) {
            objmap.put("predtime", this.getModel().getValue("predtime").toString());
        } else {
            objmap.put("predtime", "-1");
        }
        if (this.getModel().getValue("losedate") != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            objmap.put("losedate", format.format(this.getModel().getValue("losedate")));
        } else {
            objmap.put("losedate", "-1");
        }
        objmap.put("repeat", this.getModel().getValue("repeat").toString());
        objmap.put("repeattype", this.getModel().getValue("repeattype").toString());
        for (String ditem : WEEKDAY) {
            objmap.put(ditem, this.getModel().getValue(ditem).toString());
        }
        for (String mitem : MONTHDAY) {
            objmap.put(mitem, this.getModel().getValue(mitem).toString());
        }
        return JSON.toJSONString(objmap);
    }
}

