/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.stockup;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.mmc.mds.common.stockup.model.AcStockFactor;

public class AcStockFactorPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String PROBABILITY = "probability";
    private static final String SHELFLIFEITEM = "shelflifeitem";
    private static final String NOSHELFLIFEITEM = "noshelflifeitem";
    private static final List<String> defaultValue = Arrays.asList("=100%", ">=90%", ">=80%", ">=70%", ">=60%", ">=50%", ">=40%", ">=30%", ">=20%", ">=10%", ">0%");
    private static final String BTNOK = "btnok";
    private static final String SEARCHAP = "searchap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        Search search = (Search)this.getControl(SEARCHAP);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String values = (String)params.get("values");
        String status = (String)params.get("status");
        this.initEntryEntity(values, null);
        this.cacheEntryEntityData();
        this.setFiledEnable(status);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int row = changeData[0].getRowIndex();
        if (SHELFLIFEITEM.equals(name) || NOSHELFLIFEITEM.equals(name)) {
            String probability = (String)this.getModel().getValue(PROBABILITY, row);
            String values = this.getPageCache().get("data");
            List data = JSON.parseArray((String)values, AcStockFactor.class);
            Optional<AcStockFactor> optional = data.stream().filter(f -> StringUtils.equals((CharSequence)f.getProbability(), (CharSequence)probability)).findFirst();
            if (optional.isPresent()) {
                AcStockFactor acStockFactor = optional.get();
                if (SHELFLIFEITEM.equals(name)) {
                    acStockFactor.setShelfLifeItem((BigDecimal)newValue);
                } else {
                    acStockFactor.setNoShelfLifeItem((BigDecimal)newValue);
                }
                this.getPageCache().put("data", JSON.toJSONString((Object)data));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            String data = this.getPageCache().get("data");
            this.getView().returnDataToParent((Object)data);
            this.getView().close();
        }
    }

    private void initEntryEntity(String values, Pattern pattern) {
        List valueList = null;
        if (StringUtils.isNotEmpty((CharSequence)values)) {
            valueList = JSON.parseArray((String)values, AcStockFactor.class);
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)entryEntity.getModel();
        TableValueSetter vs = new TableValueSetter(new String[]{PROBABILITY, SHELFLIFEITEM, NOSHELFLIFEITEM});
        model.beginInit();
        if (valueList == null || valueList.isEmpty()) {
            for (String value : defaultValue) {
                if (pattern != null && !pattern.matcher(value).find()) continue;
                vs.addRow(new Object[]{value});
            }
        } else {
            for (AcStockFactor value : valueList) {
                String probability = value.getProbability();
                BigDecimal shelfLifeItem = value.getShelfLifeItem();
                BigDecimal noShelfLifeItem = value.getNoShelfLifeItem();
                if (pattern != null && !pattern.matcher(probability).find()) continue;
                vs.addRow(new Object[]{probability, shelfLifeItem, noShelfLifeItem});
            }
        }
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private void cacheEntryEntityData() {
        ArrayList<AcStockFactor> data = new ArrayList<AcStockFactor>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject entry : entryEntity) {
            String probability = entry.getString(PROBABILITY);
            BigDecimal shelfLifeItem = entry.getBigDecimal(SHELFLIFEITEM);
            BigDecimal noShelfLifeItem = entry.getBigDecimal(NOSHELFLIFEITEM);
            AcStockFactor factor = new AcStockFactor();
            factor.setProbability(probability);
            factor.setShelfLifeItem(shelfLifeItem);
            factor.setNoShelfLifeItem(noShelfLifeItem);
            data.add(factor);
        }
        this.getPageCache().put("data", JSON.toJSONString(data));
    }

    private void setFiledEnable(String status) {
        if ("B".equals(status) || "C".equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNOK});
            int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
            for (int i = 0; i < rowCount; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{SHELFLIFEITEM, NOSHELFLIFEITEM});
            }
        }
    }

    public void search(SearchEnterEvent e) {
        String searchText = e.getText();
        String values = this.getPageCache().get("data");
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            Pattern pattern = Pattern.compile(searchText);
            this.initEntryEntity(values, pattern);
        } else {
            this.initEntryEntity(values, null);
        }
    }
}

