/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.stockup;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.stockup.model.LongCycleMater;

public class GeneralEditPlugin
extends AbstractFormPlugin {
    private static final String MDS_MATERIALBACKUP = "mds_materialbackup";
    private static final String MDS_MATERIALPARAM = "mds_materialparam";
    private static final String MDS_LONGCYCLEMATER = "mds_longcyclemater";
    private static final String OP_LONGCYCLEMATER = "longcyclemater";
    private static final String LONGCYCLEMATERCALLBACK = "longcyclematercallback";
    private static final String ENTRYENTITY = "entryentity";
    private static final String MATERIAL = "material";
    private static final String MATERIALTYPE = "materialtype";
    private static final String AVGDELIVERY = "avgdelivery";
    private static final String LONGCYCLE = "longcycle";
    private static final String ISLONGCYCLEMATER = "islongcyclemater";

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int row = changeData[0].getRowIndex();
        if (MATERIAL.equals(name)) {
            if (newValue != null) {
                DynamicObject value = (DynamicObject)newValue;
                DynamicObject materialBackUp = this.getMaterialBackUp(value.getLong("id"));
                if (materialBackUp != null) {
                    this.getModel().setValue(AVGDELIVERY, materialBackUp.get(AVGDELIVERY), row);
                } else {
                    this.getModel().setValue(AVGDELIVERY, (Object)0, row);
                }
                DynamicObject materialParam = this.getMaterialParam(value.getLong("group.id"));
                if (materialParam != null) {
                    this.getModel().setValue(LONGCYCLE, materialParam.get(LONGCYCLE), row);
                } else {
                    this.getModel().setValue(LONGCYCLE, (Object)0, row);
                }
                DynamicObject group = this.getMaterialGroup(value.getLong("id"));
                if (group != null) {
                    this.getModel().setValue(MATERIALTYPE, (Object)group.getLong("group.id"), row);
                }
            } else {
                this.getModel().setValue(AVGDELIVERY, (Object)0, row);
                this.getModel().setValue(LONGCYCLE, (Object)0, row);
                this.getModel().setValue(MATERIALTYPE, null, row);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (OP_LONGCYCLEMATER.equals(operateKey)) {
            this.openFactorView(MDS_LONGCYCLEMATER, LONGCYCLEMATERCALLBACK);
        }
    }

    private void openFactorView(String formId, String callBackActionId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackActionId));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (StringUtils.isBlank((Object)returnData)) {
            return;
        }
        String actionId = event.getActionId();
        if (LONGCYCLEMATERCALLBACK.equals(actionId)) {
            List dataList = (List)returnData;
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            AbstractFormDataModel model = (AbstractFormDataModel)entryGrid.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[]{MATERIAL, MATERIALTYPE, AVGDELIVERY, LONGCYCLE, ISLONGCYCLEMATER});
            for (LongCycleMater data : dataList) {
                Long material = data.getMaterial();
                Long materialtype = data.getMaterialtype();
                BigDecimal avgDelivery = data.getAvgDelivery();
                BigDecimal longCycle = data.getLongCycle();
                vs.addRow(new Object[]{material, materialtype, avgDelivery, longCycle, true});
            }
            model.batchCreateNewEntryRow(ENTRYENTITY, vs);
            model.endInit();
            this.getView().updateView(ENTRYENTITY);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        for (DynamicObject entry : entryEntity) {
            DynamicObject material = entry.getDynamicObject(MATERIAL);
            DynamicObject materialBackUp = this.getMaterialBackUp(material.getLong("id"));
            if (materialBackUp != null) {
                entry.set(AVGDELIVERY, materialBackUp.get(AVGDELIVERY));
            } else {
                entry.set(AVGDELIVERY, (Object)0);
            }
            DynamicObject materialParam = this.getMaterialParam(material.getLong("group.id"));
            if (materialParam != null) {
                entry.set(LONGCYCLE, materialParam.get(LONGCYCLE));
            } else {
                entry.set(LONGCYCLE, (Object)0);
            }
            if (entry.getBigDecimal(AVGDELIVERY).compareTo(entry.getBigDecimal(LONGCYCLE)) > 0) {
                entry.set(ISLONGCYCLEMATER, (Object)true);
            } else {
                entry.set(ISLONGCYCLEMATER, (Object)false);
            }
            DynamicObject group = this.getMaterialGroup(material.getLong("id"));
            if (group != null) {
                entry.set(MATERIALTYPE, (Object)group.getLong("group.id"));
                continue;
            }
            entry.set(MATERIALTYPE, null);
        }
    }

    private DynamicObject getMaterialBackUp(Long materialId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and(MATERIAL, "=", (Object)materialId);
        return BusinessDataServiceHelper.loadSingle((String)MDS_MATERIALBACKUP, (String)"id,number,avgdelivery", (QFilter[])new QFilter[]{qFilter});
    }

    private DynamicObject getMaterialGroup(Long materialId) {
        QFilter filter = new QFilter("standard.number", "=", (Object)"JBFLBZ");
        filter.and(new QFilter("material.id", "=", (Object)materialId));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialgroupdetail", (String)"id,standard,group,material", (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject getMaterialParam(Long groupId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        QFilter paramFilter = new QFilter("materialgroup", "=", (Object)groupId);
        DynamicObject materialParam = BusinessDataServiceHelper.loadSingle((String)MDS_MATERIALPARAM, (String)"id,materialgroup,longcycle", (QFilter[])new QFilter[]{qFilter, paramFilter});
        if (materialParam != null) {
            return materialParam;
        }
        QFilter pFilter = new QFilter("materialgroup", "=", (Object)0);
        return BusinessDataServiceHelper.loadSingle((String)MDS_MATERIALPARAM, (String)"id,materialgroup,longcycle", (QFilter[])new QFilter[]{qFilter, pFilter});
    }
}

