/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.stockup;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GeneralLogEditPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String NUMBER = "number";
    private static final String PLANENTRYENTITY = "planentryentity";
    private static final String HISENTRYENTITY = "hisentryentity";
    private static final String TARGETENTRYENTITY = "targetentryentity";
    private static final String SPECIALENTRYENTITY = "specialentryentity";
    private static final String SUGENTRYENTITY = "sugentryentity";
    private static final String SUSPEND = "suspend";

    public void registerListener(EventObject e) {
        EntryGrid sugentryentity;
        EntryGrid specialentryentity;
        EntryGrid targetentryentity;
        EntryGrid hisentryentity;
        super.registerListener(e);
        EntryGrid planentryentity = (EntryGrid)this.getControl(PLANENTRYENTITY);
        if (planentryentity != null) {
            planentryentity.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((hisentryentity = (EntryGrid)this.getControl(HISENTRYENTITY)) != null) {
            hisentryentity.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((targetentryentity = (EntryGrid)this.getControl(TARGETENTRYENTITY)) != null) {
            targetentryentity.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((specialentryentity = (EntryGrid)this.getControl(SPECIALENTRYENTITY)) != null) {
            specialentryentity.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((sugentryentity = (EntryGrid)this.getControl(SUGENTRYENTITY)) != null) {
            sugentryentity.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.initPlanEntryEntity(dataEntity);
        this.initHisEntryEntity(dataEntity);
        this.initTargetEntryEntity(dataEntity);
        this.initSpecialEntryEntity(dataEntity);
        this.initSugEntryEntity(dataEntity);
        this.getModel().setDataChanged(false);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        String number = this.getModel().getDataEntity().getString(NUMBER);
        String hisusecalclog = this.getModel().getDataEntity().getString("hisusecalclog.number");
        switch (fieldName) {
            case "generalplancode": {
                this.showListForm("mds_generalplan", number);
                break;
            }
            case "hisusecalclogentry": {
                this.showListForm("mds_hisusecalclog", hisusecalclog);
                break;
            }
            case "hisusedetailentry": {
                this.showListForm("mds_hisusedetail", hisusecalclog);
                break;
            }
            case "hisuseresultentry": {
                this.showListForm("mds_hisuseresult", hisusecalclog);
                break;
            }
            case "targetmaterial": {
                this.showListForm("mds_targetmaterial", number);
                break;
            }
            case "targetmaterialtime": {
                this.showListForm("mds_targetmaterial_time", number);
                break;
            }
            case "targetmaterialeq": {
                this.showListForm("mds_targetmaterial_eq", number);
                break;
            }
            case "forecastbytime": {
                this.showListForm("mds_forecastbytime", number);
                break;
            }
            case "forecastbyeq": {
                this.showListForm("mds_forecastbyeq", number);
                break;
            }
            case "specialstock": 
            case "generalsuggest": {
                this.showListForm("mds_generalsuggest", number);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operatekey = e.getOperateKey();
        if (SUSPEND.equals(operatekey) && e.getOperationResult().isSuccess()) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            dynamicObject.set("calstatus", (Object)"D");
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            this.getModel().setDataChanged(false);
            this.getView().updateView("calstatus");
        }
    }

    private void showListForm(String billFormId, String number) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(billFormId);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.getCustomParams().put(NUMBER, number);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void initPlanEntryEntity(DynamicObject dataEntity) {
        TableValueSetter vs = new TableValueSetter(new String[]{"generalplancode", "plancountentry", "actypecountentry", "customercountentry", "checktypecountentry", "planstarttimeentry", "planendtimeentry", "plansumtimeentry"});
        String number = dataEntity.getString(NUMBER);
        int plancount = dataEntity.getInt("plancount");
        int actypecount = dataEntity.getInt("actypecount");
        int customercount = dataEntity.getInt("customercount");
        int checktypecount = dataEntity.getInt("checktypecount");
        Date planstarttime = dataEntity.getDate("planstarttime");
        Date planendtime = dataEntity.getDate("planendtime");
        BigDecimal plansumtime = dataEntity.getBigDecimal("plansumtime");
        vs.addRow(new Object[]{number, plancount, actypecount, customercount, checktypecount, planstarttime, planendtime, plansumtime});
        this.batchCreateNewEntry(PLANENTRYENTITY, vs);
    }

    private void initHisEntryEntity(DynamicObject dataEntity) {
        TableValueSetter vs = new TableValueSetter(new String[]{"hisusecalclogentry", "hisusecount"});
        long hisUseCalcLog = dataEntity.getLong("hisusecalclog.id");
        String usecountmin = dataEntity.getString("usecountmin");
        String usecountmax = dataEntity.getString("usecountmax");
        String hisusecount = String.join((CharSequence)ResManager.loadKDString((String)"\u5230", (String)"GeneralLogEditPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]), usecountmin, usecountmax);
        vs.addRow(new Object[]{hisUseCalcLog, hisusecount});
        this.batchCreateNewEntry(HISENTRYENTITY, vs);
    }

    private void initTargetEntryEntity(DynamicObject dataEntity) {
        TableValueSetter vs = new TableValueSetter(new String[]{"targetmaterial", "targetmaterialtime", "targetmaterialeq", "forecastbytime", "forecastbyeq", "targetstarttimeentry", "targetendtimeentry", "targetsumtimeentry"});
        String number = dataEntity.getString(NUMBER);
        Date targetstarttime = dataEntity.getDate("targetstarttime");
        Date targetendtime = dataEntity.getDate("targetendtime");
        BigDecimal targetsumtime = dataEntity.getBigDecimal("targetsumtime");
        vs.addRow(new Object[]{number, number, number, number, number, targetstarttime, targetendtime, targetsumtime});
        this.batchCreateNewEntry(TARGETENTRYENTITY, vs);
    }

    private void initSpecialEntryEntity(DynamicObject dataEntity) {
        TableValueSetter vs = new TableValueSetter(new String[]{"specialstock", "specialnocountentry", "specialstarttimeentry", "specialendtimeentry", "specialsumtimeentry"});
        String number = dataEntity.getString(NUMBER);
        int specialnocount = dataEntity.getInt("specialnocount");
        Date specialstarttime = dataEntity.getDate("specialstarttime");
        Date specialendtime = dataEntity.getDate("specialendtime");
        BigDecimal specialsumtime = dataEntity.getBigDecimal("specialsumtime");
        vs.addRow(new Object[]{number, specialnocount, specialstarttime, specialendtime, specialsumtime});
        this.batchCreateNewEntry(SPECIALENTRYENTITY, vs);
    }

    private void initSugEntryEntity(DynamicObject dataEntity) {
        TableValueSetter vs = new TableValueSetter(new String[]{"generalsuggest", "stocknocountentry", "sugstarttimeentry", "sugendtimeentry", "sugsumtimeentry"});
        String number = dataEntity.getString(NUMBER);
        int stocknocount = dataEntity.getInt("stocknocount");
        Date sugstarttime = dataEntity.getDate("sugstarttime");
        Date sugendtime = dataEntity.getDate("sugendtime");
        BigDecimal sugsumtime = dataEntity.getBigDecimal("sugsumtime");
        vs.addRow(new Object[]{number, stocknocount, sugstarttime, sugendtime, sugsumtime});
        this.batchCreateNewEntry(SUGENTRYENTITY, vs);
    }

    private void batchCreateNewEntry(String entryEntity, TableValueSetter tableValueSetter) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryEntity);
        AbstractFormDataModel model = (AbstractFormDataModel)entryGrid.getModel();
        this.getModel().deleteEntryData(entryEntity);
        model.beginInit();
        model.batchCreateNewEntryRow(entryEntity, tableValueSetter);
        model.endInit();
        this.getView().updateView(entryEntity);
    }
}

