/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.stockup;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;

public class GeneralSetEditPlugin
extends AbstractBasePlugIn
implements HyperLinkClickListener,
AfterF7SelectListener {
    private static final String MDS_MATERIALPARAM = "mds_materialparam";
    private static final String SPECIALCOND = "specialcond";
    private static final String GENERALPLAN = "generalplan";
    private static final String ENTRYENTITY = "entryentity";
    private static final String MATERIALGROUPADD = "materialgroupadd";
    private static final String MATERIALGROUP = "materialgroup";
    private static final String MATERIALGROUPNO = "materialgroupno";

    public void registerListener(EventObject e) {
        EntryGrid entryEntity;
        super.registerListener(e);
        BasedataEdit materialGroup = (BasedataEdit)this.getControl(MATERIALGROUP);
        if (materialGroup != null) {
            materialGroup.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((entryEntity = (EntryGrid)this.getControl(ENTRYENTITY)) != null) {
            entryEntity.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.syncEntryGrid();
        Object specialCond = this.getModel().getValue(SPECIALCOND);
        this.setFiledMust((Boolean)specialCond);
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (SPECIALCOND.equals(name)) {
            this.setFiledMust((Boolean)newValue);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (MATERIALGROUPADD.equals(key)) {
            BasedataEdit materialGroup = (BasedataEdit)this.getControl(MATERIALGROUP);
            materialGroup.click();
        } else if ("deleteentry".equals(key)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection materialGroup = model.getDataEntity().getDynamicObjectCollection(MATERIALGROUP);
            DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
            Set ids = entryEntity.stream().map(m -> m.getLong("materialgroupno.id")).collect(Collectors.toSet());
            materialGroup.removeIf(m -> !ids.contains(m.getLong("fbasedataid.id")));
            this.getView().updateView(MATERIALGROUP);
        } else if ("save".equals(key) || "submit".equals(key)) {
            this.syncEntryGrid();
            this.getModel().setDataChanged(false);
        }
    }

    public void afterF7Select(AfterF7SelectEvent paramAfterF7SelectEvent) {
        this.syncEntryGrid();
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        int row = e.getRowIndex();
        DynamicObject materialGroupNo = (DynamicObject)this.getModel().getValue(MATERIALGROUPNO, row);
        if (MATERIALGROUPNO.equals(fieldName) && materialGroupNo != null) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId(MDS_MATERIALPARAM);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter(MATERIALGROUP, "=", materialGroupNo.getPkValue()));
            ListFilterParameter listFilter = new ListFilterParameter();
            listFilter.setFilter(filter);
            listShowParameter.setListFilterParameter(listFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        List<String> properties = Collections.singletonList("fbasedataid_id");
        ProbabilityUtil.setBizChanged((DynamicObject)dataEntity, (String)MATERIALGROUP, properties);
    }

    private void syncEntryGrid() {
        EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)entryEntity.getModel();
        DynamicObjectCollection materialGroups = model.getDataEntity().getDynamicObjectCollection(MATERIALGROUP);
        TableValueSetter vs = new TableValueSetter(new String[]{MATERIALGROUPNO});
        model.beginInit();
        model.deleteEntryData(ENTRYENTITY);
        for (DynamicObject materialGroup : materialGroups) {
            vs.addRow(new Object[]{materialGroup.getDynamicObject("fbasedataid").getPkValue()});
        }
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private void setFiledMust(boolean value) {
        BasedataEdit generalPlan = (BasedataEdit)this.getControl(GENERALPLAN);
        if (generalPlan != null) {
            generalPlan.setMustInput(!value);
        }
    }
}

