/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.stockup;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.stockup.model.LongCycleMater;

public class LongCycleMaterEditPlugin
extends AbstractFormPlugin
implements F7SelectedListRemoveListener,
RowClickEventListener,
SearchEnterListener {
    private static final String MDS_MATERIALBACKUP = "mds_materialbackup";
    private static final String MDS_MATERIALPARAM = "mds_materialparam";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SEQ = "seq";
    private static final String MATERIAL = "material";
    private static final String AVGDELIVERY = "avgdelivery";
    private static final String LONGCYCLE = "longcycle";
    private static final String F7SELECTEDLISTAP = "f7selectedlistap";
    private static final String SEARCHAP = "searchap";
    private static final String BTNOK = "btnok";
    private static DynamicObjectCollection dyCollection;

    public void registerListener(EventObject e) {
        Search search;
        EntryGrid entryEntity;
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
        if (f7SelectedList != null) {
            f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
            f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        }
        if ((entryEntity = (EntryGrid)this.getControl(ENTRYENTITY)) != null) {
            entryEntity.addRowClickListener((RowClickEventListener)this);
        }
        if ((search = (Search)this.getControl(SEARCHAP)) != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initEntryEntity();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
        dyCollection = (DynamicObjectCollection)entrys.clone();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (dyCollection != null) {
            dyCollection.clear();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        ArrayList<LongCycleMater> params = new ArrayList<LongCycleMater>(16);
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            String values = this.getPageCache().get("valueTextItems");
            if (StringUtils.isNotEmpty((CharSequence)values)) {
                List valueTextItems = JSON.parseArray((String)values, ValueTextItem.class);
                Set materialIds = valueTextItems.stream().map(m -> Long.valueOf(m.getValue())).collect(Collectors.toSet());
                DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
                for (DynamicObject entry : entrys) {
                    long materialId = entry.getDynamicObject(MATERIAL).getLong("id");
                    if (!materialIds.contains(materialId)) continue;
                    LongCycleMater longCycleMater = new LongCycleMater();
                    long materialType = entry.getLong("material.group.id");
                    BigDecimal avgDelivery = entry.getBigDecimal(AVGDELIVERY);
                    BigDecimal longCycle = entry.getBigDecimal(LONGCYCLE);
                    longCycleMater.setMaterialtype(Long.valueOf(materialType));
                    longCycleMater.setMaterial(Long.valueOf(materialId));
                    longCycleMater.setAvgDelivery(avgDelivery);
                    longCycleMater.setLongCycle(longCycle);
                    params.add(longCycleMater);
                }
            }
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    public void entryRowClick(RowClickEvent e) {
        this.initF7SelectedListap();
    }

    public void RemoveClick(F7SelectedListRemoveEvent e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (e.getParam() == null) {
            entryGrid.clearEntryState();
            this.getPageCache().remove("valueTextItems");
        } else {
            String values;
            String param = (String)e.getParam();
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
            for (DynamicObject entry : entrys) {
                if (!StringUtils.equals((CharSequence)entry.getDynamicObject(MATERIAL).getString("id"), (CharSequence)param)) continue;
                List rows = Arrays.stream(entryGrid.getSelectRows()).boxed().collect(Collectors.toList());
                rows = rows.stream().filter(f -> entry.getInt(SEQ) - 1 != f).collect(Collectors.toList());
                entryGrid.selectRows(rows.stream().mapToInt(Integer::valueOf).toArray(), 0);
                break;
            }
            if (StringUtils.isNotEmpty((CharSequence)(values = this.getPageCache().get("valueTextItems")))) {
                List valueTextItems = JSON.parseArray((String)values, ValueTextItem.class);
                valueTextItems.removeIf(f -> StringUtils.equals((CharSequence)param, (CharSequence)f.getValue()));
                this.getPageCache().put("valueTextItems", JSON.toJSONString((Object)valueTextItems));
            }
        }
    }

    private void initEntryEntity() {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        QFilter mFilter = new QFilter("material.status", "=", (Object)"C");
        mFilter.and("material.enable", "=", (Object)"1");
        DataSet materialBackUp = QueryServiceHelper.queryDataSet((String)"materialbackup", (String)MDS_MATERIALBACKUP, (String)"id,material,material.status,material.enable,material.group as materialtype,avgdelivery", (QFilter[])new QFilter[]{qFilter, mFilter}, null);
        DataSet materialParam = QueryServiceHelper.queryDataSet((String)"materialparam", (String)MDS_MATERIALPARAM, (String)"id,materialgroup,longcycle", (QFilter[])new QFilter[]{qFilter}, null);
        JoinDataSet joinDataSet = materialBackUp.join(materialParam).on("materialtype", "materialgroup");
        DataSet dataSet = joinDataSet.select(new String[]{MATERIAL, "materialgroup", AVGDELIVERY, LONGCYCLE}).finish();
        dataSet = dataSet.where("avgdelivery > longcycle");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)entryGrid.getModel();
        this.getModel().deleteEntryData(ENTRYENTITY);
        TableValueSetter vs = new TableValueSetter(new String[]{MATERIAL, AVGDELIVERY, LONGCYCLE});
        model.beginInit();
        for (Row row : dataSet) {
            Long material = row.getLong(MATERIAL);
            BigDecimal avgDelivery = row.getBigDecimal(AVGDELIVERY);
            BigDecimal longCycle = row.getBigDecimal(LONGCYCLE);
            vs.addRow(new Object[]{material, avgDelivery, longCycle});
        }
        dataSet.close();
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private void initF7SelectedListap() {
        int[] rows;
        String values = this.getPageCache().get("valueTextItems");
        ArrayList<ValueTextItem> valueTextItems = null;
        if (StringUtils.isNotEmpty((CharSequence)values)) {
            valueTextItems = JSON.parseArray((String)values, ValueTextItem.class);
        }
        if (valueTextItems == null) {
            valueTextItems = new ArrayList<ValueTextItem>(16);
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7SELECTEDLISTAP);
        for (int i : rows = entryGrid.getSelectRows()) {
            DynamicObject material = ((DynamicObject)entrys.get(i)).getDynamicObject(MATERIAL);
            boolean isMatch = valueTextItems.stream().anyMatch(t -> StringUtils.equals((CharSequence)t.getValue(), (CharSequence)material.getString("id")));
            if (isMatch) continue;
            ValueTextItem item = new ValueTextItem(material.getString("id"), material.getString("number"));
            valueTextItems.add(item);
        }
        f7SelectedList.addItems(valueTextItems);
        this.getPageCache().put("valueTextItems", JSON.toJSONString(valueTextItems));
    }

    public void search(SearchEnterEvent e) {
        String searchText = e.getText();
        this.buildEntryEntity(searchText);
    }

    private void buildEntryEntity(String searchText) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)entryGrid.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{MATERIAL, AVGDELIVERY, LONGCYCLE});
        for (DynamicObject dynamicObject : dyCollection) {
            DynamicObject material = dynamicObject.getDynamicObject(MATERIAL);
            if (StringUtils.isNotEmpty((CharSequence)searchText)) {
                String number = material.getString("number");
                String name = material.getString("name");
                Pattern pattern = Pattern.compile(searchText);
                Matcher matcherNumber = pattern.matcher(number);
                Matcher matcherName = pattern.matcher(name);
                if (!matcherNumber.find() && !matcherName.find()) continue;
            }
            BigDecimal avgDelivery = dynamicObject.getBigDecimal(AVGDELIVERY);
            BigDecimal longCycle = dynamicObject.getBigDecimal(LONGCYCLE);
            vs.addRow(new Object[]{material.getPkValue(), avgDelivery, longCycle});
        }
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }
}

