/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.stockup;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.mmc.mds.common.stockup.model.AcStockFactor;
import kd.mmc.mds.common.stockup.model.QuarterFactor;
import kd.mmc.mds.common.stockup.model.ServiceFactor;
import kd.mmc.mds.common.stockup.model.StockFactor;

public class MaterialParamEditPlugin
extends AbstractFormPlugin {
    private static final String MDS_QUARTERFACTOR = "mds_quarterfactor";
    private static final String MDS_STOCKFACTOR = "mds_stockfactor";
    private static final String MDS_SERVICEFACTOR = "mds_servicefactor";
    private static final String MDS_ACSTOCKFACTOR = "mds_acstockfactor";
    private static final String QUARTERFACTOR = "quarterfactor";
    private static final String QUARTERFACTORSHOW = "quarterfactorshow";
    private static final String QUARTERFACTORCALLBACK = "quarterfactorcallback";
    private static final String QUARTERFACTOR_BUTTON = "quarterfactorbutton";
    private static final String STOCKFACTOR = "stockfactor";
    private static final String STOCKFACTORSHOW = "stockfactorshow";
    private static final String STOCKFACTORCALLBACK = "stockfactorcallback";
    private static final String STOCKFACTOR_BUTTON = "stockfactorbutton";
    private static final String SERVICEFACTOR = "servicefactor";
    private static final String SERVICEFACTORSHOW = "servicefactorshow";
    private static final String SERVICEFACTORCALLBACK = "servicefactorcallback";
    private static final String SERVICEFACTOR_BUTTON = "servicefactorbutton";
    private static final String ACSTOCKFACTOR = "acstockfactor";
    private static final String ACSTOCKFACTORSHOW = "acstockfactorshow";
    private static final String ACSTOCKFACTORCALLBACK = "acstockfactorcallback";
    private static final String ACSTOCKFACTOR_BUTTON = "acstockfactorbutton";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{QUARTERFACTOR_BUTTON, STOCKFACTOR_BUTTON, SERVICEFACTOR_BUTTON, ACSTOCKFACTOR_BUTTON});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showQuarterFactor();
        this.showStockFactor();
        this.showServiceFactor();
        this.showAcStockFactor();
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        if (QUARTERFACTOR_BUTTON.equals(key)) {
            this.openFactorView(MDS_QUARTERFACTOR, QUARTERFACTOR, QUARTERFACTORCALLBACK);
        } else if (STOCKFACTOR_BUTTON.equals(key)) {
            this.openFactorView(MDS_STOCKFACTOR, STOCKFACTOR, STOCKFACTORCALLBACK);
        } else if (SERVICEFACTOR_BUTTON.equals(key)) {
            this.openFactorView(MDS_SERVICEFACTOR, SERVICEFACTOR, SERVICEFACTORCALLBACK);
        } else if (ACSTOCKFACTOR_BUTTON.equals(key)) {
            this.openFactorView(MDS_ACSTOCKFACTOR, ACSTOCKFACTOR, ACSTOCKFACTORCALLBACK);
        }
    }

    private void openFactorView(String formId, String field, String callBackActionId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackActionId));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Object values = this.getModel().getValue(field);
        params.put("values", values);
        Object status = this.getModel().getValue("status");
        params.put("status", status);
        formShowParameter.setCustomParams(params);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (StringUtils.isBlank((Object)returnData)) {
            return;
        }
        String actionId = event.getActionId();
        if (QUARTERFACTORCALLBACK.equals(actionId)) {
            this.getModel().setValue(QUARTERFACTOR, returnData);
            this.setBizChanged(QUARTERFACTOR);
            this.showQuarterFactor();
        }
        if (STOCKFACTORCALLBACK.equals(actionId)) {
            this.getModel().setValue(STOCKFACTOR, returnData);
            this.setBizChanged(STOCKFACTOR);
            this.showStockFactor();
        }
        if (SERVICEFACTORCALLBACK.equals(actionId)) {
            this.getModel().setValue(SERVICEFACTOR, returnData);
            this.setBizChanged(SERVICEFACTOR);
            this.showServiceFactor();
        }
        if (ACSTOCKFACTORCALLBACK.equals(actionId)) {
            this.getModel().setValue(ACSTOCKFACTOR, returnData);
            this.setBizChanged(ACSTOCKFACTOR);
            this.showAcStockFactor();
        }
    }

    private void showQuarterFactor() {
        String quarterFactor = (String)this.getModel().getValue(QUARTERFACTOR);
        if (StringUtils.isNotEmpty((CharSequence)quarterFactor)) {
            List factorList = JSON.parseArray((String)quarterFactor, QuarterFactor.class);
            String quarterfactorshow = factorList.stream().filter(f -> BigDecimal.ZERO.compareTo(f.getQuarterFactor()) != 0).map(QuarterFactor::getQuarterCode).collect(Collectors.joining(","));
            this.getModel().setValue(QUARTERFACTORSHOW, (Object)quarterfactorshow);
        }
    }

    private void showStockFactor() {
        String stockFactor = (String)this.getModel().getValue(STOCKFACTOR);
        if (StringUtils.isNotEmpty((CharSequence)stockFactor)) {
            List stockList = JSON.parseArray((String)stockFactor, StockFactor.class);
            String stockFactorShow = stockList.stream().filter(f -> f.getNoShelfLifeItem() != 0 || f.getShelfLifeItem() != 0).map(StockFactor::getFreqCount).collect(Collectors.joining(","));
            this.getModel().setValue(STOCKFACTORSHOW, (Object)stockFactorShow);
        }
    }

    private void showServiceFactor() {
        String serviceFactor = (String)this.getModel().getValue(SERVICEFACTOR);
        if (StringUtils.isNotEmpty((CharSequence)serviceFactor)) {
            List serviceList = JSON.parseArray((String)serviceFactor, ServiceFactor.class);
            String serviceFactorShow = serviceList.stream().filter(f -> BigDecimal.ZERO.compareTo(f.getServiceFactor()) != 0 || BigDecimal.ZERO.compareTo(f.getServiceLevel()) != 0).map(ServiceFactor::getFreqCount).collect(Collectors.joining(","));
            this.getModel().setValue(SERVICEFACTORSHOW, (Object)serviceFactorShow);
        }
    }

    private void showAcStockFactor() {
        String acStockFactor = (String)this.getModel().getValue(ACSTOCKFACTOR);
        if (StringUtils.isNotEmpty((CharSequence)acStockFactor)) {
            List acStockList = JSON.parseArray((String)acStockFactor, AcStockFactor.class);
            String acStockFactorShow = acStockList.stream().filter(f -> BigDecimal.ZERO.compareTo(f.getShelfLifeItem()) != 0 || BigDecimal.ZERO.compareTo(f.getNoShelfLifeItem()) != 0).map(AcStockFactor::getProbability).collect(Collectors.joining(","));
            this.getModel().setValue(ACSTOCKFACTORSHOW, (Object)acStockFactorShow);
        }
    }

    private void setBizChanged(String property) {
        int ordinal = this.getModel().getProperty(property).getOrdinal();
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
    }
}

