/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.stockup;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.mmc.mds.common.stockup.model.QuarterFactor;

public class QuarterFactorPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String QUARTERCODE = "quartercode";
    private static final String QUARTER1 = "quarter1";
    private static final String QUARTER2 = "quarter2";
    private static final String QUARTER3 = "quarter3";
    private static final String QUARTER4 = "quarter4";
    private static final String QUARTERFACTOR = "quarterfactor";
    private static final List<String> defaultValue = Arrays.asList("0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111");
    private static final String BTNOK = "btnok";
    private static final String SEARCHAP = "searchap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        Search search = (Search)this.getControl(SEARCHAP);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String values = (String)params.get("values");
        String status = (String)params.get("status");
        this.initEntryEntity(values, null);
        this.cacheEntryEntityData();
        this.setFiledEnable(status);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int row = changeData[0].getRowIndex();
        if (QUARTERFACTOR.equals(name)) {
            String quarterCode = (String)this.getModel().getValue(QUARTERCODE, row);
            String values = this.getPageCache().get("data");
            List data = JSON.parseArray((String)values, QuarterFactor.class);
            Optional<QuarterFactor> optional = data.stream().filter(f -> StringUtils.equals((CharSequence)f.getQuarterCode(), (CharSequence)quarterCode)).findFirst();
            if (optional.isPresent()) {
                QuarterFactor quarterFactor = optional.get();
                quarterFactor.setQuarterFactor((BigDecimal)newValue);
                this.getPageCache().put("data", JSON.toJSONString((Object)data));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            String data = this.getPageCache().get("data");
            this.getView().returnDataToParent((Object)data);
            this.getView().close();
        }
    }

    private void initEntryEntity(String values, Pattern pattern) {
        List valueList = null;
        if (StringUtils.isNotEmpty((CharSequence)values)) {
            valueList = JSON.parseArray((String)values, QuarterFactor.class);
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)entryEntity.getModel();
        TableValueSetter vs = new TableValueSetter(new String[]{QUARTERCODE, QUARTER1, QUARTER2, QUARTER3, QUARTER4, QUARTERFACTOR});
        model.beginInit();
        if (valueList == null || valueList.isEmpty()) {
            for (String value : defaultValue) {
                if (pattern != null && !pattern.matcher(value).find()) continue;
                vs.addRow(new Object[]{value, Character.valueOf(value.charAt(0)), Character.valueOf(value.charAt(1)), Character.valueOf(value.charAt(2)), Character.valueOf(value.charAt(3))});
            }
        } else {
            for (QuarterFactor value : valueList) {
                String quarterCode = value.getQuarterCode();
                BigDecimal quarterFactor = value.getQuarterFactor();
                if (pattern != null && !pattern.matcher(quarterCode).find()) continue;
                vs.addRow(new Object[]{quarterCode, Character.valueOf(quarterCode.charAt(0)), Character.valueOf(quarterCode.charAt(1)), Character.valueOf(quarterCode.charAt(2)), Character.valueOf(quarterCode.charAt(3)), quarterFactor});
            }
        }
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private void cacheEntryEntityData() {
        ArrayList<QuarterFactor> data = new ArrayList<QuarterFactor>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject entry : entryEntity) {
            String quarterCode = entry.getString(QUARTERCODE);
            BigDecimal quarterFactor = entry.getBigDecimal(QUARTERFACTOR);
            QuarterFactor factor = new QuarterFactor();
            factor.setQuarterCode(quarterCode);
            factor.setQuarterFactor(quarterFactor);
            data.add(factor);
        }
        this.getPageCache().put("data", JSON.toJSONString(data));
    }

    private void setFiledEnable(String status) {
        if ("B".equals(status) || "C".equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNOK});
            int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
            for (int i = 0; i < rowCount; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{QUARTERFACTOR});
            }
        }
    }

    public void search(SearchEnterEvent e) {
        String searchText = e.getText();
        String values = this.getPageCache().get("data");
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            Pattern pattern = Pattern.compile(searchText);
            this.initEntryEntity(values, pattern);
        } else {
            this.initEntryEntity(values, null);
        }
    }
}

