/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.stockup;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class StockStatusAdjustEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ADJUSTFIELD = "adjustfield";
    private static final String CURRENTSTATUS = "currentstatus";
    private static final String ADJUSTTO = "adjustto";
    private static final String ADJUSTREASON = "adjustreason";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        BasedataEdit adjustto = (BasedataEdit)this.getControl(ADJUSTTO);
        if (adjustto != null) {
            adjustto.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map parameterParams = this.getView().getFormShowParameter().getCustomParams();
        Object adjustField = parameterParams.get(ADJUSTFIELD);
        this.getModel().setValue(ADJUSTFIELD, adjustField);
        this.getView().updateView(ADJUSTFIELD);
        Object currentStatus = parameterParams.get(CURRENTSTATUS);
        this.getModel().setValue(CURRENTSTATUS, currentStatus);
        this.getView().updateView(CURRENTSTATUS);
        Object field = parameterParams.get("field");
        Object planId = parameterParams.get("planid");
        Object projectId = parameterParams.get("projectid");
        this.initAdjustRecordEntry(field, planId, projectId);
        this.setFiledEnable();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            Map parameterParams = this.getView().getFormShowParameter().getCustomParams();
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            DynamicObject currentstatus = (DynamicObject)this.getModel().getValue(CURRENTSTATUS);
            result.put("beforeadjstus", currentstatus);
            DynamicObject adjustto = (DynamicObject)this.getModel().getValue(ADJUSTTO);
            result.put("afteradjstus", adjustto);
            String adjustreason = (String)this.getModel().getValue(ADJUSTREASON);
            result.put(ADJUSTREASON, adjustreason);
            Object field = parameterParams.get("field");
            result.put("field", field);
            Object planId = parameterParams.get("planid");
            result.put("planid", planId);
            Object projectId = parameterParams.get("projectid");
            result.put("projectid", projectId);
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        if (ADJUSTTO.equals(name)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            DynamicObjectCollection stockStatusRules = this.getStockStatusRule();
            if (stockStatusRules != null && !stockStatusRules.isEmpty()) {
                Set ids = stockStatusRules.stream().map(m -> m.getLong("entryentity.adjustrange.fbasedataid.id")).collect(Collectors.toSet());
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", ids));
            }
        }
    }

    private void setFiledEnable() {
        boolean allowAdjust;
        DynamicObjectCollection stockStatusRules = this.getStockStatusRule();
        if (stockStatusRules != null && !stockStatusRules.isEmpty() && !(allowAdjust = ((DynamicObject)stockStatusRules.get(0)).getBoolean("entryentity.allowadjust"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ADJUSTTO, ADJUSTREASON});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNOK});
            BasedataEdit adjustTo = (BasedataEdit)this.getControl(ADJUSTTO);
            adjustTo.setMustInput(false);
            TextEdit adjustReason = (TextEdit)this.getControl(ADJUSTREASON);
            adjustReason.setMustInput(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5907\u8d27\u72b6\u6001\u4e0d\u5141\u8bb8\u624b\u5de5\u8c03\u6574\u3002", (String)"StockStatusAdjustEditPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObjectCollection getStockStatusRule() {
        Map parameterParams = this.getView().getFormShowParameter().getCustomParams();
        QFilter targetFilter = new QFilter("targetentity", "=", (Object)"mds_stockupstatus");
        Object field = parameterParams.get("field");
        String targetStatus = "";
        if ("backupbom".equals(field)) {
            targetStatus = "0";
        } else if ("backuphis".equals(field)) {
            targetStatus = "1";
        } else if ("backupcustmor".equals(field)) {
            targetStatus = "2";
        }
        QFilter targetStatusFilter = new QFilter("targetstatus", "=", (Object)targetStatus);
        Object currentStatus = parameterParams.get(CURRENTSTATUS);
        QFilter stockStatusFilter = new QFilter("entryentity.stockstatus", "=", currentStatus);
        return QueryServiceHelper.query((String)"mds_stockstatusrule", (String)"number,entryentity,entryentity.stockstatus,entryentity.allowadjust,entryentity.adjustrange.fbasedataid.id", (QFilter[])new QFilter[]{targetFilter, targetStatusFilter, stockStatusFilter});
    }

    private void initAdjustRecordEntry(Object field, Object planId, Object projectId) {
        QFilter fieldFilter = new QFilter("field", "=", field);
        QFilter planIdFilter = new QFilter("planid", "=", planId);
        QFilter projectIdFilter = new QFilter("projectid", "=", projectId);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"mds_adjustrecord", (String)"field,beforeadjstus,afteradjstus,adjustreason,creator,createtime", (QFilter[])new QFilter[]{fieldFilter, planIdFilter, projectIdFilter}, (String)"createtime desc");
        this.getModel().deleteEntryData(ENTRYENTITY);
        EntryGrid entryentity = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)entryentity.getModel();
        TableValueSetter vs = new TableValueSetter(new String[]{"beforeadjstus", "afteradjstus", "adjreason", "operator", "operatortime"});
        model.beginInit();
        if (dynamicObjectCollection != null && !dynamicObjectCollection.isEmpty()) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                Long beforeAdjstus = dynamicObject.getLong("beforeadjstus");
                Long afterAdjstus = dynamicObject.getLong("afteradjstus");
                String adjustReason = dynamicObject.getString(ADJUSTREASON);
                Long creator = dynamicObject.getLong("creator");
                Date createTime = dynamicObject.getDate("createtime");
                vs.addRow(new Object[]{beforeAdjstus, afterAdjstus, adjustReason, creator, createTime});
            }
        }
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }
}

