/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin.stockup;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;

public class StockStatusRuleEditPlugin
extends AbstractFormPlugin {
    private static final String MDS_STOCKUPSTATUS = "mds_stockupstatus";
    private static final String MDS_FILTERCONDITION = "mds_filtercondition";
    private static final String ENTRYENTITY = "entryentity";
    private static final String MATCHELEMENT = "matchelement";
    private static final String FILTERCONDITION = "filtercondition";
    private static final String FILTERCONDITIONVAL = "filterconditionval";
    private static final String FILTERCONDITIONCALLBACK = "filterconditioncallback";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MATCHELEMENT, FILTERCONDITION});
    }

    public void click(EventObject evt) {
        super.click(evt);
        TextEdit textEdit = (TextEdit)evt.getSource();
        String entryKey = textEdit.getEntryKey();
        int row = this.getModel().getEntryCurrentRowIndex(entryKey);
        String key = textEdit.getKey();
        if (FILTERCONDITION.equals(key)) {
            this.openFilterConditionView(MDS_STOCKUPSTATUS, FILTERCONDITIONVAL, row, FILTERCONDITIONCALLBACK);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        List<String> properties = Collections.singletonList(FILTERCONDITIONVAL);
        ProbabilityUtil.setBizChanged((DynamicObject)dataEntity, (String)ENTRYENTITY, properties);
    }

    private void openFilterConditionView(String billNumber, String filterField, int row, String callBackActionId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(MDS_FILTERCONDITION);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackActionId));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Object filterValue = this.getModel().getValue(filterField, row);
        params.put("billNumber", billNumber);
        params.put("filter", filterValue);
        formShowParameter.setCustomParams(params);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (StringUtils.isBlank((Object)returnData)) {
            return;
        }
        String actionId = event.getActionId();
        int row = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            if (FILTERCONDITIONCALLBACK.equals(actionId)) {
                String filter = (String)data.get("filter");
                String billNumber = (String)data.get("billNumber");
                FilterBuilder filterBuilder = ProbabilityUtil.getFilterBuilder((String)filter, (String)billNumber);
                String filterDesc = filterBuilder.getFilterString();
                this.getModel().setValue(FILTERCONDITIONVAL, (Object)filter, row);
                this.getModel().setValue(FILTERCONDITION, (Object)filterDesc, row);
            }
        }
    }
}

