/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.report.deliverydata;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.mds.common.deliveryquery.DeliveryQueryManger;
import kd.mmc.mds.common.deliveryquery.algo.DayTransformMapFunctionByAlgo;
import kd.mmc.mds.common.deliveryquery.algo.MonthTransformMapFunctionByAlgo;
import kd.mmc.mds.common.deliveryquery.algo.WeekTransformMapFunctionByAlgo;

public class DeliveryDataListPlugin
extends AbstractReportListDataPlugin {
    static ThreadLocal<Boolean> isCurThreadLocal = new ThreadLocal();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        DataSet dataSet = null;
        FilterInfo filter = reportQueryParam.getFilter();
        DynamicObject setid = filter.getDynamicObject("setid");
        Date startdeliverydate = filter.getDate("startdeliverydate");
        Date enddeliverydate = filter.getDate("enddeliverydate");
        DynamicObject queryorg = filter.getDynamicObject("queryorg");
        String querydeliverytype = filter.getString("querydeliverytype");
        boolean iscur = filter.getBoolean("iscur");
        isCurThreadLocal.set(iscur);
        String gourptype = filter.getString("gourptype");
        DynamicObjectCollection materials = filter.getDynamicObjectCollection("materials");
        Set materialIds = null;
        if (materials != null) {
            materialIds = materials.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        }
        if (iscur) {
            DeliveryQueryManger deliveryQueryManger = DeliveryQueryManger.create((Object)setid.getPkValue());
            dataSet = deliveryQueryManger.queryDeliverySet(materialIds);
        } else {
            QFilter setFilter = new QFilter("deliveryqueryset", "=", setid.getPkValue());
            if (materialIds != null) {
                setFilter.and("materiel", "in", materialIds);
            }
            ORM orm = ORM.create();
            String selectedField = "deliveryqueryset,stockorg,materiel,deliverytype,deliverydate,rundate,qty,unit,billtype";
            dataSet = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "mds_deliverydata", selectedField, new QFilter[]{setFilter}, null);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        LinkedList<String> filedList = new LinkedList<String>();
        if (startdeliverydate != null) {
            params.put("startd", startdeliverydate);
            filedList.add(" deliverydate >= startd ");
        }
        if (enddeliverydate != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(enddeliverydate);
            c.add(5, 1);
            enddeliverydate = c.getTime();
            params.put("endd", enddeliverydate);
            filedList.add(" deliverydate < endd ");
        }
        if (queryorg != null) {
            params.put("queryorg", queryorg.getPkValue());
            filedList.add(" stockorg = queryorg ");
        }
        if (StringUtils.isNotEmpty((CharSequence)querydeliverytype)) {
            params.put("querydeliverytype", querydeliverytype);
            filedList.add(" deliverytype = querydeliverytype ");
        }
        String condition = String.join((CharSequence)" and ", filedList);
        if (!params.isEmpty()) {
            dataSet = dataSet.filter(condition, params);
        }
        dataSet.addNullField("deliverydateshow");
        DayTransformMapFunctionByAlgo mapFunction = null;
        String deliverydateshow = "TO_CHAR(deliverydate,\"yyyy-MM-dd\") as deliverydateshow";
        if ("0".equals(gourptype)) {
            mapFunction = new DayTransformMapFunctionByAlgo(dataSet.getRowMeta(), "deliverydate");
        } else if ("1".equals(gourptype)) {
            mapFunction = new WeekTransformMapFunctionByAlgo(dataSet.getRowMeta(), "deliverydate", "Mon");
            deliverydateshow = "Case  When deliverydate is null then '' else concat(TO_CHAR(deliverydate,'yyyy-MM-dd'),'~',TO_CHAR(DATEADD('Day',6,deliverydate),'yyyy-MM-dd')) end  as deliverydateshow ";
        } else if ("2".equals(gourptype)) {
            mapFunction = new MonthTransformMapFunctionByAlgo(dataSet.getRowMeta(), "deliverydate");
            deliverydateshow = "TO_CHAR(deliverydate,'yyyy-MM') as deliverydateshow";
        }
        if (mapFunction != null) {
            dataSet = dataSet.map((MapFunction)mapFunction);
        }
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"deliveryqueryset", "stockorg", "materiel", "deliverytype", "deliverydate", "rundate", "unit", "billtype"});
        groupbyDataSet = groupbyDataSet.sum("qty");
        dataSet = groupbyDataSet.finish();
        if ("0".equals(gourptype)) {
            dataSet = dataSet.select(new String[]{"deliveryqueryset", "stockorg", "materiel", "deliverytype", "deliverydate", "rundate", "unit", "billtype", "qty", deliverydateshow});
        } else if ("1".equals(gourptype)) {
            dataSet = dataSet.select(new String[]{"deliveryqueryset", "stockorg", "materiel", "deliverytype", "deliverydate", "rundate", "unit", "billtype", "qty", deliverydateshow});
        } else if ("2".equals(gourptype)) {
            dataSet = dataSet.select(new String[]{"deliveryqueryset", "stockorg", "materiel", "deliverytype", "deliverydate", "rundate", "unit", "billtype", "qty", deliverydateshow});
        }
        return dataSet;
    }

    public Object getSelectedObj() {
        return super.getSelectedObj();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Boolean iscur = isCurThreadLocal.get();
        if (iscur.booleanValue()) {
            columns.removeIf(p -> p instanceof ReportColumn && "rundate".equals(((ReportColumn)p).getFieldKey()));
        }
        isCurThreadLocal.remove();
        return columns;
    }

    public ReportQueryParam getQueryParam() {
        return super.getQueryParam();
    }

    public void setProgress(int percent) {
        super.setProgress(percent);
    }
}

