/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.report.dpsarrangeplan;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.util.MDSUtils;

public class ArrangePlanListPlugin
extends AbstractReportListDataPlugin {
    private static final String KEY_MATERIEL = "materiel";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat sdfss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean KEY_OPENPRODUCTFAMILY = false;
    private static ThreadLocal<List<String>> nodeSpanListThreadLocal = new ThreadLocal();
    private static final String sql = "dpsarrangeset,id,lastupdatetime,user,openproductfamily,mitem,mitem.number,pbom,pbom.number,mbom,materieldps,weekdelivery,baseunit,avastock,process,baremargin,weekdelivered,demandsend,displacement,waitdisplace,predisplace,monegap,mtwodemand,mtwopredisplace,mtwogap";
    private static final String[] fileds = new String[]{"lastupdatetime", "user", "mitem", "pbom", "mbom", "materieldps", "planmaterialorg", "planmaterialorgname", "weekdelivery", "baseunit", "avastock", "process", "baremargin", "weekdelivered", "demandsend", "displacement", "waitdisplace", "predisplace", "monegap", "mtwodemand", "mtwopredisplace", "mtwogap"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filter = reportQueryParam.getFilter();
        List qFilters = filter.getQFilters();
        qFilters.clear();
        Long dpsarrangeset = filter.getLong("dpsarrangeset");
        qFilters.add(new QFilter("dpsarrangeset", "=", (Object)dpsarrangeset));
        DynamicObjectCollection mulMateriel = filter.getDynamicObjectCollection(KEY_MATERIEL);
        if (mulMateriel != null && !mulMateriel.isEmpty()) {
            Set mitemSet = mulMateriel.stream().map(m -> m.getPkValue()).collect(Collectors.toSet());
            qFilters.add(new QFilter("mitem", "in", mitemSet));
        }
        HashSet<Long> idSet = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mds_dpstable", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                idSet.add(id);
            }
        }
        if (idSet.isEmpty()) {
            RowMeta metas = new RowMeta(new Field[0]);
            Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
            DataSetBuilder builder = algo.createDataSetBuilder(metas);
            return builder.build();
        }
        ArrayList<Field> fieldList = new ArrayList<Field>(16);
        for (Algo str : fileds) {
            fieldList.add(new Field((String)str, (DataType)DateType.StringType, true));
        }
        HashMap<Long, List<String>> planmaterialMap = new HashMap<Long, List<String>>(16);
        this.getDpsPlanMaterialData(idSet, planmaterialMap);
        HashMap<Long, List<String>> planmaterialorgMap = new HashMap<Long, List<String>>(16);
        HashMap<Long, List<String>> planmaterialorgNameMap = new HashMap<Long, List<String>>(16);
        this.getPlanmaterialOrgData(idSet, planmaterialorgMap, planmaterialorgNameMap);
        HashMap<Long, Map<String, BigDecimal>> weekMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        ArrayList<String> timeList = new ArrayList<String>(16);
        this.getWeekPlanData(idSet, weekMap, timeList);
        if (!timeList.isEmpty()) {
            nodeSpanListThreadLocal.set(timeList);
            for (String date : timeList) {
                fieldList.add(new Field(date, (DataType)DateType.BigDecimalType, true));
            }
        }
        RowMeta metas = new RowMeta(fieldList.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        Field[] field = metas.getFields();
        Object[] values = null;
        try (DataSet data = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mds_dpstable", (String)sql, (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)}, (String)"mitem.number");){
            while (data.hasNext()) {
                values = new Object[fieldList.size()];
                Row row = data.next();
                Long id = row.getLong("id");
                Boolean openproductfamily = row.getBoolean("openproductfamily");
                if (openproductfamily.booleanValue() && !this.KEY_OPENPRODUCTFAMILY) {
                    this.KEY_OPENPRODUCTFAMILY = openproductfamily;
                }
                Long mitem = row.getLong("mitem");
                String mitemName = row.getString("mitem.number");
                Long pbom = row.getLong("pbom");
                String pbomName = row.getString("pbom.number");
                for (int i = 0; i < fileds.length; ++i) {
                    String name = field[i].getName();
                    if ("lastupdatetime".equals(name)) {
                        Date lastupdatetime = row.getDate(name);
                        if (lastupdatetime != null) {
                            SimpleDateFormat simpleDateFormat = sdfss;
                            synchronized (simpleDateFormat) {
                                values[i] = sdfss.format(lastupdatetime);
                            }
                        }
                    } else if ("mbom".equals(name)) {
                        if (pbom != null && pbom != 0L) {
                            values[i] = Objects.equals(mitem, pbom) ? null : mitem;
                        }
                    } else if ("materieldps".equals(name)) {
                        List list = (List)planmaterialMap.get(id);
                        values[i] = list == null || list.isEmpty() ? (pbom != null && pbom != 0L ? pbomName : mitemName) : (list.size() == 1 ? list.get(0) : "ALL");
                    } else if ("planmaterialorg".equals(name)) {
                        List list = (List)planmaterialorgMap.get(id);
                        if (list != null && !list.isEmpty()) {
                            String munbers = list.stream().filter(p -> MDSUtils.isNotEmpty((CharSequence)p)).collect(Collectors.joining(","));
                            if (munbers != null && munbers.length() > 200) {
                                munbers = munbers.substring(0, 200).concat("...");
                            }
                            values[i] = munbers;
                        }
                    } else if ("planmaterialorgname".equals(name)) {
                        List list = (List)planmaterialorgNameMap.get(id);
                        if (list != null && !list.isEmpty()) {
                            String names = list.stream().filter(p -> MDSUtils.isNotEmpty((CharSequence)p)).collect(Collectors.joining(","));
                            if (names != null && names.length() > 200) {
                                names = names.substring(0, 200).concat("...");
                            }
                            values[i] = names;
                        }
                    } else {
                        values[i] = row.get(name);
                    }
                    for (int j = fileds.length; j < field.length; ++j) {
                        String name2 = field[j].getName();
                        Map map = (Map)weekMap.get(id);
                        if (map == null || map.isEmpty()) continue;
                        BigDecimal qty = (BigDecimal)map.get(name2);
                        values[j] = qty == null ? BigDecimal.ZERO : qty;
                    }
                }
                builder.append(values);
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDpsPlanMaterialData(Set<Long> idSet, Map<Long, List<String>> planmaterialMap) {
        try (DataSet dataSetMaterial = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mds_dpstable.dpsplanmaterial", (String)"id,fbasedataid,fbasedataid.number", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)}, null);){
            while (dataSetMaterial.hasNext()) {
                List<Object> list;
                Row row = dataSetMaterial.next();
                Long id = row.getLong("id");
                String number = row.getString("fbasedataid.number");
                if (!planmaterialMap.containsKey(id)) {
                    list = new ArrayList(16);
                    list.add(number);
                    planmaterialMap.put(id, list);
                    continue;
                }
                list = planmaterialMap.get(id);
                list.add(number);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPlanmaterialOrgData(Set<Long> idSet, Map<Long, List<String>> orgNumberMap, Map<Long, List<String>> orgNameMap) {
        try (DataSet dataSetMaterialOrg = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mds_dpstable.dpsplanmaterialorg", (String)"id,fbasedataid,fbasedataid.number,fbasedataid.name", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)}, (String)"id");){
            while (dataSetMaterialOrg.hasNext()) {
                List<Object> list;
                Row row = dataSetMaterialOrg.next();
                Long id = row.getLong("id");
                String number = row.getString("fbasedataid.number");
                String name = row.getString("fbasedataid.name");
                if (!orgNumberMap.containsKey(id)) {
                    list = new ArrayList(16);
                    list.add(number);
                    orgNumberMap.put(id, list);
                } else {
                    list = orgNumberMap.get(id);
                    list.add(number);
                }
                if (!orgNameMap.containsKey(id)) {
                    list = new ArrayList(16);
                    list.add(name);
                    orgNameMap.put(id, list);
                    continue;
                }
                list = orgNameMap.get(id);
                list.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWeekPlanData(Set<Long> idSet, Map<Long, Map<String, BigDecimal>> weekMap, List<String> timeList) {
        try (DataSet weekPlanDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mds_dpstable", (String)"id,entryentity,entryentity.weekplan,entryentity.weekdate", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)}, (String)"entryentity.weekdate");){
            while (weekPlanDataSet.hasNext()) {
                Map<Object, Object> map;
                Row row = weekPlanDataSet.next();
                Long id = row.getLong("id");
                Date weekdate = row.getDate("entryentity.weekdate");
                BigDecimal weekplan = row.getBigDecimal("entryentity.weekplan");
                if (weekplan == null) {
                    weekplan = BigDecimal.ZERO;
                }
                if (weekdate == null) continue;
                String date = "";
                SimpleDateFormat simpleDateFormat = sdf;
                synchronized (simpleDateFormat) {
                    date = sdf.format(weekdate);
                }
                if (!timeList.contains(date)) {
                    timeList.add(date);
                }
                if (!weekMap.containsKey(id)) {
                    map = new HashMap(16);
                    map.put(date, weekplan);
                    weekMap.put(id, map);
                    continue;
                }
                map = weekMap.get(id);
                if (!map.containsKey(date)) {
                    map.put(date, weekplan);
                    continue;
                }
                BigDecimal qty = (BigDecimal)map.get(date);
                if (qty == null) {
                    qty = BigDecimal.ZERO;
                }
                map.put(date, qty.add(weekplan));
            }
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List<String> resultList;
        List cols = super.getColumns(columns);
        if (!this.KEY_OPENPRODUCTFAMILY) {
            List<String> list = Arrays.asList("pbom", "mbom", "baremargin");
            cols.removeIf(p -> p instanceof ReportColumn && list.contains(((ReportColumn)p).getFieldKey()));
        }
        if ((resultList = nodeSpanListThreadLocal.get()) != null && !resultList.isEmpty()) {
            for (int i = 0; i < cols.size(); ++i) {
                ReportColumnGroup g;
                String key;
                if (!(cols.get(i) instanceof ReportColumnGroup) || !"groupplan".equals(key = (g = (ReportColumnGroup)cols.get(i)).getFieldKey())) continue;
                this.setGroupColumn(resultList, g);
            }
        }
        nodeSpanListThreadLocal.remove();
        return cols;
    }

    private void setGroupColumn(List<String> resultList, ReportColumnGroup g) {
        for (String pk : resultList) {
            ReportColumn qty = new ReportColumn();
            qty.setCaption(new LocaleString(pk));
            qty.setWidth(new LocaleString("100px"));
            qty.setFieldKey(pk);
            qty.setFieldType("qty");
            qty.setMeasureUnitField("baseunit");
            qty.setZeroShow(true);
            qty.setHideSingleColumnRow(false);
            ColumnStyle c = new ColumnStyle();
            c.setTextAlign("right");
            qty.setStyle(c);
            g.getChildren().add(qty);
        }
    }
}

