/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.report.fastphotoreport;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.plandata.PlanDataFieldsSetter;

public class FastFhotoReportListPlugin
extends AbstractReportListDataPlugin {
    private static final DBRoute pur = new DBRoute("pur");
    private static final String KEY_FASTPHOTOVER_STARTDATE = "fastphotover_startdate";
    private static final String KEY_FASTPHOTOVER_ENDDATE = "fastphotover_enddate";
    private static final String KEY_PRODUCTLINE = "productline_s";
    private static final String KEY_PRODUCTFAMILY = "productfamily_s";
    private static final String KEY_PRODUCTSERIES = "productseries_s";
    private static final String KEY_PRODUCTMODEL = "productmodel_s";
    private static final String KEY_MATERIAL = "material";
    private static final String KEY_REQUIRETYPE = "requiretype";
    private static final String KEY_VERNUMBER = "vernumber";
    private static final String KEY_SHOWTYPE = "showtype";
    private static final String KEY_LINE = "line";
    private static final String KEY_FIELD = "field";
    private static final String KEY_FAMILY = "family";
    private static final String KEY_SERIES = "series";
    private static final String KEY_MODEL = "model";
    private static final String[] fileds_init = new String[]{"planid", "ffcvrnnum", "requiretype", "fmaterialid", "number", "productline", "productfamily", "productseries", "productmodel"};
    private String[] fileds = fileds_init;
    private static String[] qtycolumns = new String[]{"fqty150", "fqty149", "fqty148", "fqty147", "fqty146", "fqty145", "fqty144", "fqty143", "fqty142", "fqty141", "fqty140", "fqty139", "fqty138", "fqty137", "fqty136", "fqty135", "fqty134", "fqty133", "fqty132", "fqty131", "fqty130", "fqty129", "fqty128", "fqty127", "fqty126", "fqty125", "fqty124", "fqty123", "fqty122", "fqty121", "fqty120", "fqty119", "fqty118", "fqty117", "fqty116", "fqty115", "fqty114", "fqty113", "fqty112", "fqty111", "fqty110", "fqty109", "fqty108", "fqty107", "fqty106", "fqty105", "fqty104", "fqty103", "fqty102", "fqty101", "fqty100", "fqty99", "fqty98", "fqty97", "fqty96", "fqty95", "fqty94", "fqty93", "fqty92", "fqty91", "fqty90", "fqty89", "fqty88", "fqty87", "fqty86", "fqty85", "fqty84", "fqty83", "fqty82", "fqty81", "fqty80", "fqty79", "fqty78", "fqty77", "fqty76", "fqty75", "fqty74", "fqty73", "fqty72", "fqty71", "fqty70", "fqty69", "fqty68", "fqty67", "fqty66", "fqty65", "fqty64", "fqty63", "fqty62", "fqty61", "fqty60", "fqty59", "fqty58", "fqty57", "fqty56", "fqty55", "fqty54", "fqty53", "fqty52", "fqty51", "fqty50", "fqty49", "fqty48", "fqty47", "fqty46", "fqty45", "fqty44", "fqty43", "fqty42", "fqty41", "fqty40", "fqty39", "fqty38", "fqty37", "fqty36", "fqty35", "fqty34", "fqty33", "fqty32", "fqty31", "fqty30", "fqty29", "fqty28", "fqty27", "fqty26", "fqty25", "fqty24", "fqty23", "fqty22", "fqty21", "fqty20", "fqty19", "fqty18", "fqty17", "fqty16", "fqty15", "fqty14", "fqty13", "fqty12", "fqty11", "fqty10", "fqty9", "fqty8", "fqty7", "fqty6", "fqty5", "fqty4", "fqty3", "fqty2", "fqty1"};
    private static final ThreadLocal<List<String>> threadLocalList = new ThreadLocal();

    public DataSet query(ReportQueryParam param, Object object) throws Throwable {
        List<String> extFieldsAlias;
        Set<Object> matSet;
        DynamicObjectCollection productmodels;
        Set<Object> offeringIdSet;
        DynamicObjectCollection productseries;
        Set<Object> seriesIdSet;
        DynamicObjectCollection productfamilys;
        Set<Object> familysIdSet;
        FilterInfo filterInfo = param.getFilter();
        List qFilters = filterInfo.getQFilters();
        qFilters.clear();
        Date startdate = filterInfo.getDate(KEY_FASTPHOTOVER_STARTDATE);
        Date enddate = filterInfo.getDate(KEY_FASTPHOTOVER_ENDDATE);
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection(KEY_MATERIAL);
        String materialIds = this.getIds(materials);
        DynamicObjectCollection vernumbers = filterInfo.getDynamicObjectCollection(KEY_VERNUMBER);
        String vernumbersIds = this.getIds(vernumbers);
        DynamicObject requiretype = filterInfo.getDynamicObject(KEY_REQUIRETYPE);
        ArrayList<QFilter> list = new ArrayList<QFilter>(16);
        DynamicObjectCollection productlines = filterInfo.getDynamicObjectCollection(KEY_PRODUCTLINE);
        Set<Object> linesIdSet = this.getIdSet(productlines);
        if (linesIdSet != null && !linesIdSet.isEmpty()) {
            QFilter qFilter = new QFilter("productline", "in", linesIdSet);
            list.add(qFilter);
        }
        if ((familysIdSet = this.getIdSet(productfamilys = filterInfo.getDynamicObjectCollection(KEY_PRODUCTFAMILY))) != null && !familysIdSet.isEmpty()) {
            QFilter qFilter = new QFilter("productfamily", "in", familysIdSet);
            list.add(qFilter);
        }
        if ((seriesIdSet = this.getIdSet(productseries = filterInfo.getDynamicObjectCollection(KEY_PRODUCTSERIES))) != null && !seriesIdSet.isEmpty()) {
            QFilter qFilter = new QFilter("productseries", "in", seriesIdSet);
            list.add(qFilter);
        }
        if ((offeringIdSet = this.getIdSet(productmodels = filterInfo.getDynamicObjectCollection(KEY_PRODUCTMODEL))) != null && !offeringIdSet.isEmpty()) {
            list.add(new QFilter("productmodel", "in", offeringIdSet));
        }
        if ((matSet = this.getIdSet(materials)) != null && !matSet.isEmpty()) {
            list.add(new QFilter("id", "in", matSet));
        }
        if ((extFieldsAlias = this.getExtFieldsAlias()) != null && extFieldsAlias.size() > 0) {
            ArrayList<String> filedsList = new ArrayList<String>(Arrays.asList(this.fileds));
            for (String filedAlias : extFieldsAlias) {
                if (filedsList.contains(filedAlias)) continue;
                filedsList.add(filedAlias);
            }
            this.fileds = filedsList.toArray(new String[0]);
        }
        String selectFields = "id, number,productline,productfamily,productseries,productmodel ";
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)selectFields, (QFilter[])list.toArray(new QFilter[0]), (String)"");
        StringBuilder columns = new StringBuilder();
        for (int i = 0; i < qtycolumns.length; ++i) {
            columns.append("ent.");
            columns.append(qtycolumns[i]);
            columns.append(',');
        }
        if (extFieldsAlias != null && extFieldsAlias.size() > 0) {
            for (String filedAlias : extFieldsAlias) {
                columns.append("ent.");
                columns.append(filedAlias);
                columns.append(',');
            }
        }
        String kzfields = "fc.fid as planid, fc.ffcvrnnum, ent.fmaterialid, vrds.fdtype as fdtype ";
        columns.append(kzfields);
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append((CharSequence)columns);
        sb.append("from t_mds_fcdatats_kz fc ");
        sb.append("join t_mds_fcdatatsentry_kz ent ");
        sb.append("on ent.fid=fc.fid ");
        sb.append("join t_mds_vrds vrds ");
        sb.append("on vrds.fid=fc.ffcvrnnum and vrds.fvertype='0' ");
        sb.append("where 1=1 ");
        if (StringUtils.isNotEmpty((String)materialIds)) {
            sb.append(" and ent.fmaterialid in (");
            sb.append(materialIds);
            sb.append(')');
        }
        if (StringUtils.isNotEmpty((String)vernumbersIds)) {
            sb.append(" and fc.ffcvrnnum in (");
            sb.append(vernumbersIds);
            sb.append(')');
        }
        Object[] params = null;
        if (startdate != null && enddate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String startStr = sdf.format(startdate).concat("001");
            String endStr = sdf.format(enddate).concat("999");
            if (StringUtils.isNumeric((String)startStr) && StringUtils.isNumeric((String)endStr)) {
                Long start = Long.parseLong(startStr);
                Long end = Long.parseLong(endStr);
                sb.append(" and fc.fid >= (?) ");
                sb.append(" and fc.fid <= (?) ");
                params = new Object[]{start, end};
            }
        }
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)pur, (String)sb.toString(), params);
        DataSet requireTypeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mds_dmtp", (String)"id", null, null);
        String[] leftFields = (String[])Arrays.stream(dataSet.getRowMeta().getFieldNames()).filter(v -> !"fdtype".equalsIgnoreCase((String)v)).toArray(String[]::new);
        String[] rightFields = new String[]{"id as requiretype"};
        dataSet = dataSet.leftJoin(requireTypeDataSet).on("fdtype", "id").select(leftFields, rightFields).finish();
        if (requiretype != null) {
            HashMap<String, Object> filterParamMap = new HashMap<String, Object>(2);
            filterParamMap.put("requireTypeId", requiretype.getPkValue());
            dataSet = dataSet.where("requiretype = requireTypeId", filterParamMap);
        }
        JoinDataSet joinDataSet = dataSet.join(materialDataSet);
        joinDataSet = joinDataSet.on("fmaterialid", "id");
        joinDataSet = joinDataSet.select(qtycolumns, this.fileds);
        DataSet dataSetFinish = joinDataSet.finish();
        dataSetFinish = dataSetFinish.addField("fmaterialid", "materialid");
        ArrayList<Field> fields = this.createFields(dataSetFinish.getRowMeta());
        String showtype = filterInfo.getString(KEY_SHOWTYPE);
        Map<Long, Map<String, String>> dateentryMap = this.getTargetdateAndQtyrelations(dataSetFinish, fields);
        DataSet dataSetResult = this.buildData(dataSetFinish, fields, dateentryMap);
        if (KEY_MATERIAL.equals(showtype)) {
            return dataSetResult == null ? null : dataSetResult.orderBy(new String[]{"planid asc"});
        }
        DataSet dataSetGroupResult = this.buildDataAndGroup(dataSetResult, fields, showtype);
        return dataSetGroupResult == null ? null : dataSetGroupResult.orderBy(new String[]{"planid asc"});
    }

    private List<String> getExtFieldsAlias() {
        List<String> asList = Arrays.asList(fileds_init);
        List deskFieldsAlias = PlanDataFieldsSetter.getNewFieldsAlias((String)"0");
        List<String> extField = deskFieldsAlias.stream().filter(o -> !asList.contains(o)).collect(Collectors.toList());
        return extField;
    }

    private Map<String, String> getExtAliasRelFields() {
        return PlanDataFieldsSetter.getExtAliasRelFields((String)"0");
    }

    private ArrayList<Field> createFields(RowMeta rowMeta) {
        ArrayList<Field> fields = new ArrayList<Field>(16);
        fields.add(new Field("planid", (DataType)DateType.LongType, true));
        fields.add(new Field("materialid", (DataType)DateType.LongType, true));
        fields.add(new Field("number", (DataType)DateType.StringType, true));
        fields.add(new Field("ffcvrnnum", (DataType)DateType.LongType, true));
        fields.add(new Field(KEY_REQUIRETYPE, (DataType)DateType.LongType, true));
        fields.add(new Field("productmodel", (DataType)DateType.LongType, true));
        fields.add(new Field("productseries", (DataType)DateType.LongType, true));
        fields.add(new Field("productfamily", (DataType)DateType.LongType, true));
        fields.add(new Field("productline", (DataType)DateType.LongType, true));
        List<String> extFieldsAlias = this.getExtFieldsAlias();
        Map<String, String> aliasRelFields = this.getExtAliasRelFields();
        for (String filed : extFieldsAlias) {
            String filedName = aliasRelFields.get(filed);
            fields.add(new Field(filedName, rowMeta.getField(filed).getDataType(), true));
        }
        return fields;
    }

    private DataSet buildDataAndGroup(DataSet dataSet, ArrayList<Field> fields, String showtype) {
        if (dataSet == null || fields == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)showtype)) {
            return dataSet;
        }
        ArrayList<String> group = new ArrayList<String>(16);
        group.add("planid");
        group.add("ffcvrnnum");
        group.add(KEY_REQUIRETYPE);
        List<String> dateList = threadLocalList.get();
        switch (showtype) {
            case "model": {
                group.add("productmodel");
            }
            case "series": {
                group.add("productseries");
            }
            case "family": {
                group.add("productfamily");
            }
            case "line": {
                group.add("productline");
            }
        }
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(group.toArray(new String[0]));
        if (dateList != null) {
            for (String dateField : dateList) {
                groupbyDataSet = groupbyDataSet.sum(dateField);
            }
        }
        dataSet = groupbyDataSet.finish();
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        List<String> asList = Arrays.asList(fieldNames);
        for (Field field : fields) {
            if (asList.contains(field.getName())) continue;
            dataSet = dataSet.addField("'ALL'", field.getName());
        }
        return dataSet;
    }

    private DataSet buildData(DataSet dataSet, ArrayList<Field> fields, Map<Long, Map<String, String>> dateentryMap) {
        if (dataSet == null || fields == null || dateentryMap == null) {
            return null;
        }
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        Object[] values = null;
        Field[] field = metas.getFields();
        List<String> extFieldsAlias = this.getExtFieldsAlias();
        for (Row row : dataSet.copy()) {
            Map<String, String> map;
            int n = 0;
            values = new Object[fields.size()];
            Long planid = row.getLong("planid");
            Long materialid = row.getLong("materialid");
            String material = row.getString("number");
            Long fcvrnnum = row.getLong("ffcvrnnum");
            Long requiretype = row.getLong(KEY_REQUIRETYPE);
            Long productmodel = row.getLong("productmodel");
            Long productseries = row.getLong("productseries");
            Long productfamily = row.getLong("productfamily");
            Long productline = row.getLong("productline");
            values[n] = planid;
            values[++n] = materialid;
            values[++n] = material;
            values[++n] = fcvrnnum;
            values[++n] = requiretype;
            values[++n] = productmodel;
            values[++n] = productseries;
            values[++n] = productfamily;
            values[++n] = productline;
            if (extFieldsAlias != null && extFieldsAlias.size() > 0) {
                for (String filedAlias : extFieldsAlias) {
                    values[++n] = row.getString(filedAlias);
                }
            }
            if ((map = dateentryMap.get(planid)) == null || map.isEmpty()) continue;
            for (int i = ++n; i < field.length; ++i) {
                String name = field[i].getName();
                String value = map.get(name);
                if (StringUtils.isNotEmpty((String)value)) {
                    BigDecimal qty = row.getBigDecimal("f".concat(value));
                    if (qty == null) {
                        qty = BigDecimal.ZERO;
                    }
                    values[i] = qty.stripTrailingZeros().toPlainString();
                    continue;
                }
                values[i] = BigDecimal.ZERO;
            }
            builder.append(values);
        }
        return builder.build();
    }

    private Map<Long, Map<String, String>> getTargetdateAndQtyrelations(DataSet dataSet, ArrayList<Field> fields) {
        HashSet<String> idSet = new HashSet<String>(16);
        for (Row row : dataSet.copy()) {
            String planid = row.getString("planid");
            idSet.add(planid);
        }
        HashMap<Long, Map<String, String>> dateentryMap = new HashMap<Long, Map<String, String>>(16);
        if (!idSet.isEmpty()) {
            String ids = idSet.stream().collect(Collectors.joining(","));
            StringBuilder sql = new StringBuilder();
            sql.append("select t.fid, t.ffieldkey, t.ftargetdate ");
            sql.append("from t_mds_dateentry_kz t ");
            sql.append("where t.fid in (");
            sql.append(ids);
            sql.append(')');
            DataSet dateentrySet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)pur, (String)sql.toString()).orderBy(new String[]{"ftargetdate asc"});
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd");
            ArrayList<String> dateList = new ArrayList<String>(16);
            for (Row entryRow : dateentrySet) {
                Map<String, String> map;
                Long id = entryRow.getLong("fid");
                String fieldkey = entryRow.getString("ffieldkey");
                Date targetdate = entryRow.getDate("ftargetdate");
                if (targetdate == null || !StringUtils.isNotEmpty((String)fieldkey) || !fieldkey.contains("qty")) continue;
                String target = sdf.format(targetdate);
                if (!dateList.contains(target)) {
                    fields.add(new Field(target, (DataType)DateType.BigDecimalType, true));
                    dateList.add(target);
                }
                if (!dateentryMap.containsKey(id)) {
                    map = new HashMap<String, String>();
                    map.put(target, fieldkey);
                    dateentryMap.put(id, map);
                    continue;
                }
                map = (Map)dateentryMap.get(id);
                map.put(target, fieldkey);
            }
            threadLocalList.set(dateList);
        }
        return dateentryMap;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        ReportColumnGroup colg = null;
        List children = null;
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("center");
        List<String> datelist = threadLocalList.get();
        HashSet<String> ymSet = new HashSet<String>(16);
        if (datelist != null && !datelist.isEmpty()) {
            for (String date : datelist) {
                if (StringUtils.isEmpty((String)date)) continue;
                String yearAndMonth = date.substring(0, 7);
                if (!ymSet.contains(yearAndMonth)) {
                    if (colg != null) {
                        this.setColumnGroupCaption(colg);
                        cols.add(colg);
                    }
                    colg = new ReportColumnGroup();
                    colg.setFieldKey(yearAndMonth);
                    colg.setCaption(new LocaleString(yearAndMonth));
                    colg.setTextAlign("center");
                    colg.setMerge(false);
                    children = colg.getChildren();
                }
                ReportColumn planvds = new ReportColumn();
                planvds.setCaption(new LocaleString(date.replaceAll("_", "-")));
                planvds.setWidth(new LocaleString("100px"));
                planvds.setFieldKey(date);
                planvds.setFieldType("text");
                planvds.setScale(0);
                planvds.setStyle(columnStyle);
                planvds.setHyperlink(false);
                planvds.setZeroShow(true);
                if (children != null) {
                    children.add(planvds);
                }
                ymSet.add(yearAndMonth);
            }
            if (colg != null) {
                this.setColumnGroupCaption(colg);
                cols.add(colg);
            }
        }
        return cols;
    }

    private void setColumnGroupCaption(ReportColumnGroup colg) {
        int size;
        if (colg == null) {
            return;
        }
        List children = colg.getChildren();
        if (children != null && (size = children.size()) == 1) {
            colg.setCaption(((AbstractReportColumn)children.get(0)).getCaption());
        }
    }

    private Set<Object> getIdSet(DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return null;
        }
        Set<Object> idSet = dynamicObjectCollection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        return idSet;
    }

    private String getIds(DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return null;
        }
        String ids = dynamicObjectCollection.stream().map(p -> p.getPkValue().toString()).collect(Collectors.joining(","));
        return ids;
    }
}

