/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.report.fastphotoreport;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.entity.MdsPlanDataRptConst;
import kd.mmc.mds.common.plandata.PlanDataFieldsSetter;
import kd.mmc.mds.common.util.MDSUtils;

public class MdsPlanHistoryDataRptListPlugin
extends AbstractReportListDataPlugin {
    private MainEntityType materialType = EntityMetadataCache.getDataEntityType((String)"bd_material");
    private static final String[] fileds_init = new String[]{"fpversion", "ffcvrnnum", "fmaterialid", "number", "name", "fbaseunitid", "offeringcode.id", "offeringcode.group", "offeringcode.group.category", "offeringcode.group.parent", "offeringcode.group.parent.parent", "offeringcode.group.parent.parent.parent", "offeringcode.group.parent.parent.parent.parent", "fprodorg", "fofferingedit", "flevel1edit", "fmdsuser", "fremark", "fspdt", "fedituser", "feditcreatedate", "fentrymodifier", "feditdate"};
    private String[] fileds = fileds_init;
    private String[] qtycolumns = new String[]{"fqty150", "fqty149", "fqty148", "fqty147", "fqty146", "fqty145", "fqty144", "fqty143", "fqty142", "fqty141", "fqty140", "fqty139", "fqty138", "fqty137", "fqty136", "fqty135", "fqty134", "fqty133", "fqty132", "fqty131", "fqty130", "fqty129", "fqty128", "fqty127", "fqty126", "fqty125", "fqty124", "fqty123", "fqty122", "fqty121", "fqty120", "fqty119", "fqty118", "fqty117", "fqty116", "fqty115", "fqty114", "fqty113", "fqty112", "fqty111", "fqty110", "fqty109", "fqty108", "fqty107", "fqty106", "fqty105", "fqty104", "fqty103", "fqty102", "fqty101", "fqty100", "fqty99", "fqty98", "fqty97", "fqty96", "fqty95", "fqty94", "fqty93", "fqty92", "fqty91", "fqty90", "fqty89", "fqty88", "fqty87", "fqty86", "fqty85", "fqty84", "fqty83", "fqty82", "fqty81", "fqty80", "fqty79", "fqty78", "fqty77", "fqty76", "fqty75", "fqty74", "fqty73", "fqty72", "fqty71", "fqty70", "fqty69", "fqty68", "fqty67", "fqty66", "fqty65", "fqty64", "fqty63", "fqty62", "fqty61", "fqty60", "fqty59", "fqty58", "fqty57", "fqty56", "fqty55", "fqty54", "fqty53", "fqty52", "fqty51", "fqty50", "fqty49", "fqty48", "fqty47", "fqty46", "fqty45", "fqty44", "fqty43", "fqty42", "fqty41", "fqty40", "fqty39", "fqty38", "fqty37", "fqty36", "fqty35", "fqty34", "fqty33", "fqty32", "fqty31", "fqty30", "fqty29", "fqty28", "fqty27", "fqty26", "fqty25", "fqty24", "fqty23", "fqty22", "fqty21", "fqty20", "fqty19", "fqty18", "fqty17", "fqty16", "fqty15", "fqty14", "fqty13", "fqty12", "fqty11", "fqty10", "fqty9", "fqty8", "fqty7", "fqty6", "fqty5", "fqty4", "fqty3", "fqty2", "fqty1"};
    private static final ThreadLocal<List<String>> threadLocalList = new ThreadLocal();

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        List<String> extFieldsAlias;
        FilterInfo filterInfo = param.getFilter();
        List qFilters = filterInfo.getQFilters();
        qFilters.clear();
        Date startdate = filterInfo.getDate("fastphotoversion_starttime");
        Date enddate = filterInfo.getDate("fastphotoversion_endtime");
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection("materialplan");
        String materialIds = this.getIds(materials);
        DynamicObjectCollection vernumbers = filterInfo.getDynamicObjectCollection("fcvrnnum");
        String vernumbersIds = this.getIds(vernumbers);
        ArrayList<QFilter> list = new ArrayList<QFilter>(16);
        DynamicObjectCollection inputperson = filterInfo.getDynamicObjectCollection("inputperson");
        String inputpersonIds = this.getIds(inputperson);
        Set<Object> matSet = this.getIdSet(materials);
        if (matSet != null && !matSet.isEmpty()) {
            list.add(new QFilter("id", "in", matSet));
        }
        String selectFields = "id, number,name, offeringcode.id, offeringcode.group, offeringcode.group.category, offeringcode.group.parent, offeringcode.group.parent.parent, offeringcode.group.parent.parent.parent,offeringcode.group.parent.parent.parent.parent";
        if (this.materialType.getProperty("hihn_color") != null) {
            selectFields = selectFields + "," + "hihn_color";
            List<String> filedsList = Arrays.asList(this.fileds);
            if (!filedsList.contains("hihn_color")) {
                ArrayList<String> asList = new ArrayList<String>(this.fileds.length + 1);
                asList.add("hihn_color");
                asList.addAll(filedsList);
                this.fileds = asList.toArray(new String[0]);
            }
        }
        if ((extFieldsAlias = this.getExtFieldsAlias()) != null && extFieldsAlias.size() > 0) {
            ArrayList<String> filedsList = new ArrayList<String>(Arrays.asList(this.fileds));
            for (String filedAlias : extFieldsAlias) {
                if (filedsList.contains(filedAlias)) continue;
                filedsList.add(filedAlias);
            }
            this.fileds = filedsList.toArray(new String[0]);
        }
        String fastphotover = filterInfo.getString("fastphotoverions");
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)selectFields, (QFilter[])list.toArray(new QFilter[0]), (String)"");
        StringBuilder columns = new StringBuilder();
        for (int i = 0; i < this.qtycolumns.length; ++i) {
            columns.append("ent.");
            columns.append(this.qtycolumns[i]);
            columns.append(',');
        }
        if (extFieldsAlias != null && extFieldsAlias.size() > 0) {
            for (String filedAlias : extFieldsAlias) {
                columns.append("ent.");
                columns.append(filedAlias);
                columns.append(',');
            }
        }
        String kzfields = "fc.fid as fpversion , fc.ffcvrnnum,ent.fbaseunitid,ent.fmaterialid,ent.fprodorg,ent.fofferingedit,ent.flevel1edit,ent.fmdsuser,ent.fremark,ent.fspdt,ent.fedituser,ent.feditcreatedate,ent.fentrymodifier,ent.feditdate, vrds.fdtype as fdtype ";
        columns.append(kzfields);
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append((CharSequence)columns);
        sb.append("from t_mds_fcdatats_kz fc ");
        sb.append("join t_mds_fcdatatsentry_kz ent ");
        sb.append("on ent.fid=fc.fid ");
        sb.append("left join t_mds_vrds vrds ");
        sb.append("on vrds.fid=fc.ffcvrnnum ");
        sb.append("where 1=1 ");
        sb.append("and vrds.fvertype='1' ");
        if (MDSUtils.isNotBlank((CharSequence)materialIds)) {
            sb.append(" and ent.fmaterialid in (");
            sb.append(materialIds);
            sb.append(')');
        }
        if (MDSUtils.isNotBlank((CharSequence)vernumbersIds)) {
            sb.append(" and fc.ffcvrnnum in (");
            sb.append(vernumbersIds);
            sb.append(')');
        }
        if (MDSUtils.isNotBlank((CharSequence)fastphotover)) {
            sb.append(" and fc.fid in (");
            sb.append(fastphotover);
            sb.append(')');
        }
        if (MDSUtils.isNotBlank((CharSequence)inputpersonIds)) {
            sb.append(" and ent.fedituser in (");
            sb.append(inputpersonIds);
            sb.append(')');
        }
        Object[] params = null;
        if (startdate != null && enddate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String startStr = sdf.format(startdate).concat("001");
            String endStr = sdf.format(enddate).concat("999");
            if (StringUtils.isNumeric((String)startStr) && StringUtils.isNumeric((String)endStr)) {
                Long start = Long.valueOf(startStr);
                Long end = Long.valueOf(endStr);
                sb.append(" and fc.fid >= (?) ");
                sb.append(" and fc.fid <= (?) ");
                params = new Object[]{start, end};
            }
        }
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)MdsPlanDataRptConst.pur, (String)sb.toString(), params);
        DataSet requireTypeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mds_dmtp", (String)"id", null, null);
        String[] leftFields = (String[])Arrays.stream(dataSet.getRowMeta().getFieldNames()).filter(v -> !"fdtype".equalsIgnoreCase((String)v)).toArray(String[]::new);
        String[] rightFields = new String[]{"id as requiretype"};
        dataSet = dataSet.leftJoin(requireTypeDataSet).on("fdtype", "id").select(leftFields, rightFields).finish();
        JoinDataSet joinDataSet = dataSet.join(materialDataSet);
        joinDataSet.on("fmaterialid", "id");
        joinDataSet.select(this.fileds, this.qtycolumns);
        DataSet dataSetFinish = joinDataSet.finish();
        ArrayList<Field> fields = this.createFields(dataSetFinish.getRowMeta());
        Map<Long, Map<String, String>> dateentryMap = this.getTargetdateAndQtyrelations(dataSetFinish, fields);
        DataSet dataSetResult = this.buildData(dataSetFinish, fields, dateentryMap);
        return dataSetResult == null ? null : dataSetResult.orderBy(new String[]{"fpversion desc"});
    }

    private List<String> getExtFieldsAlias() {
        List<String> asList = Arrays.asList(fileds_init);
        List deskFieldsAlias = PlanDataFieldsSetter.getNewFieldsAlias((String)"1");
        List<String> extField = deskFieldsAlias.stream().filter(o -> !asList.contains(o)).collect(Collectors.toList());
        return extField;
    }

    private Map<String, String> getExtAliasRelFields() {
        return PlanDataFieldsSetter.getExtAliasRelFields((String)"1");
    }

    private DataSet buildData(DataSet dataSet, ArrayList<Field> fields, Map<Long, Map<String, String>> dateentryMap) {
        if (dataSet == null || fields == null || dateentryMap == null) {
            return null;
        }
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        Object[] values = null;
        Field[] field = metas.getFields();
        List<String> extFieldsAlias = this.getExtFieldsAlias();
        for (Row row : dataSet.copy()) {
            int n = 0;
            values = new Object[fields.size()];
            Long fpversion = row.getLong("fpversion");
            Long materialid = row.getLong("fmaterialid");
            String materialName = row.getString("name");
            Long fcvrnnum = row.getLong("ffcvrnnum");
            Long baseunit = row.getLong("fbaseunitid");
            Long offeringId = row.getLong("offeringcode.id");
            String category = row.getString("offeringcode.group.category");
            Long level4 = row.getLong("offeringcode.group");
            Long level3 = row.getLong("offeringcode.group.parent");
            Long level2 = row.getLong("offeringcode.group.parent.parent");
            Long level1 = row.getLong("offeringcode.group.parent.parent.parent");
            Long BG = row.getLong("offeringcode.group.parent.parent.parent.parent");
            Long fprodorg = row.getLong("fprodorg");
            String fofferingedit = row.getString("fofferingedit");
            String flevel1edit = row.getString("flevel1edit");
            Long fmdsuser = row.getLong("fmdsuser");
            String fspdt = row.getString("fspdt");
            Long fedituser = row.getLong("fedituser");
            Date feditcreatedate = row.getDate("feditcreatedate");
            Long fentrymodifier = row.getLong("fentrymodifier");
            Date feditdate = row.getDate("feditdate");
            String fremark = row.getString("fremark");
            values[n] = fpversion;
            values[++n] = fcvrnnum;
            values[++n] = materialid;
            values[++n] = materialName;
            values[++n] = baseunit;
            values[++n] = offeringId;
            Long value0 = null;
            Long value1 = null;
            Long value2 = null;
            Long value3 = null;
            Long value4 = null;
            if ("Product Series".equals(category)) {
                value0 = BG;
                value1 = level1;
                value2 = level2;
                value3 = level3;
                value4 = level4;
            } else if ("Product Family".equals(category)) {
                value0 = level1;
                value1 = level2;
                value2 = level3;
                value3 = level4;
            } else if ("Product Area".equals(category)) {
                value0 = level2;
                value1 = level3;
                value2 = level4;
            } else if ("Product Line".equals(category)) {
                value0 = level3;
                value1 = level4;
            } else if ("Consumers BUnit BG".equals(category)) {
                value0 = level4;
            }
            values[++n] = value0;
            values[++n] = value1;
            values[++n] = value2;
            values[++n] = value3;
            values[++n] = value4;
            values[++n] = fprodorg;
            values[++n] = flevel1edit;
            values[++n] = fofferingedit;
            values[++n] = fmdsuser;
            values[++n] = fspdt;
            values[++n] = fedituser;
            values[++n] = feditcreatedate;
            values[++n] = fentrymodifier;
            values[++n] = feditdate;
            values[++n] = fremark;
            if (this.materialType.getProperty("hihn_color") != null) {
                String color = row.getString("hihn_color");
                values[++n] = color;
            }
            if (extFieldsAlias != null && extFieldsAlias.size() > 0) {
                for (String filedAlias : extFieldsAlias) {
                    values[++n] = row.getString(filedAlias);
                }
            }
            int summaryNum = ++n;
            BigDecimal summary = BigDecimal.ZERO;
            Map<String, String> map = dateentryMap.get(fpversion);
            if (map == null || map.isEmpty()) continue;
            for (int i = ++n; i < field.length; ++i) {
                String name = field[i].getName();
                String value = map.get(name);
                if (StringUtils.isNotEmpty((String)value)) {
                    BigDecimal qty = row.getBigDecimal("f".concat(value));
                    if (qty == null) {
                        qty = BigDecimal.ZERO;
                    }
                    values[i] = qty;
                    summary = summary.add(qty);
                    continue;
                }
                values[i] = BigDecimal.ZERO;
            }
            values[summaryNum] = summary;
            builder.append(values);
        }
        return builder.build();
    }

    private ArrayList<Field> createFields(RowMeta rowMeta) {
        ArrayList<Field> fields = new ArrayList<Field>(16);
        fields.add(new Field("fpversion", (DataType)DateType.StringType, true));
        fields.add(new Field("fcvrnnumlist", (DataType)DateType.LongType, true));
        fields.add(new Field("material", (DataType)DateType.StringType, true));
        fields.add(new Field("materialname", (DataType)DateType.StringType, true));
        fields.add(new Field("unit", (DataType)DateType.LongType, true));
        fields.add(new Field("offering", (DataType)DateType.LongType, true));
        fields.add(new Field("productgroup", (DataType)DateType.LongType, true));
        fields.add(new Field("level1", (DataType)DateType.LongType, true));
        fields.add(new Field("level2", (DataType)DateType.LongType, true));
        fields.add(new Field("level3", (DataType)DateType.LongType, true));
        fields.add(new Field("level4", (DataType)DateType.LongType, true));
        fields.add(new Field("prodorg", (DataType)DateType.LongType, true));
        fields.add(new Field("level1edit", (DataType)DateType.StringType, true));
        fields.add(new Field("offeringedit", (DataType)DateType.StringType, true));
        fields.add(new Field("mdsuser", (DataType)DateType.LongType, true));
        fields.add(new Field("SPDT", (DataType)DateType.StringType, true));
        fields.add(new Field("edituser", (DataType)DateType.LongType, true));
        fields.add(new Field("editcreatedate", (DataType)DateType.DateType, true));
        fields.add(new Field("entrymodifier", (DataType)DateType.LongType, true));
        fields.add(new Field("editdate", (DataType)DateType.DateType, true));
        fields.add(new Field("remark", (DataType)DateType.StringType, true));
        if (this.materialType.getProperty("hihn_color") != null) {
            fields.add(new Field("hihn_color", (DataType)DateType.StringType, true));
        }
        List<String> extFieldsAlias = this.getExtFieldsAlias();
        Map<String, String> aliasRelFields = this.getExtAliasRelFields();
        for (String filed : extFieldsAlias) {
            String filedName = aliasRelFields.get(filed);
            fields.add(new Field(filedName, rowMeta.getField(filed).getDataType(), true));
        }
        fields.add(new Field("summary", (DataType)DateType.BigDecimalType, true));
        return fields;
    }

    private Map<Long, Map<String, String>> getTargetdateAndQtyrelations(DataSet dataSet, ArrayList<Field> fields) {
        HashSet<String> idSet = new HashSet<String>(16);
        for (Row row : dataSet.copy()) {
            String fpversion = row.getString("fpversion");
            idSet.add(fpversion);
        }
        HashMap<Long, Map<String, String>> dateentryMap = new HashMap<Long, Map<String, String>>(16);
        if (!idSet.isEmpty()) {
            String ids = idSet.stream().collect(Collectors.joining(","));
            StringBuilder sql = new StringBuilder();
            sql.append("select t.fid, t.ffieldkey, t.ftargetdate ");
            sql.append("from t_mds_dateentry_kz t ");
            sql.append("where t.fid in (");
            sql.append(ids);
            sql.append(')');
            DataSet dateentrySet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)MdsPlanDataRptConst.pur, (String)sql.toString()).orderBy(new String[]{"ftargetdate asc"});
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            ArrayList<String> dateList = new ArrayList<String>(16);
            for (Row entryRow : dateentrySet) {
                Map<String, String> map;
                Long id = entryRow.getLong("fid");
                String fieldkey = entryRow.getString("ffieldkey");
                Date targetdate = entryRow.getDate("ftargetdate");
                if (targetdate == null || !MDSUtils.isNotEmpty((CharSequence)fieldkey) || !fieldkey.contains("qty")) continue;
                String target = sdf.format(targetdate);
                if (!dateList.contains(target)) {
                    fields.add(new Field(target, (DataType)DateType.BigDecimalType, true));
                    dateList.add(target);
                }
                if (!dateentryMap.containsKey(id)) {
                    map = new HashMap<String, String>();
                    map.put(target, fieldkey);
                    dateentryMap.put(id, map);
                    continue;
                }
                map = (Map)dateentryMap.get(id);
                map.put(target, fieldkey);
            }
            threadLocalList.set(dateList);
        }
        return dateentryMap;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        ReportColumnGroup colg = null;
        List children = null;
        if (this.materialType.getProperty("hihn_color") != null) {
            AbstractReportColumn summaryReportColumn = (AbstractReportColumn)cols.get(cols.size() - 1);
            ReportColumn reportColumn = new ReportColumn();
            reportColumn.setFieldKey(this.materialType.getProperty("hihn_color").getName());
            reportColumn.setCaption(this.materialType.getProperty("hihn_color").getDisplayName());
            reportColumn.setFieldType("text");
            cols.set(cols.size() - 1, reportColumn);
            cols.add(summaryReportColumn);
        }
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("center");
        List<String> datelist = threadLocalList.get();
        HashSet<String> ymSet = new HashSet<String>(16);
        if (datelist != null && !datelist.isEmpty()) {
            for (String date : datelist) {
                if (StringUtils.isEmpty((String)date)) continue;
                String yearAndMonth = date.substring(0, 7);
                if (!ymSet.contains(yearAndMonth)) {
                    if (colg != null) {
                        this.setColumnGroupCaption(colg);
                        cols.add(colg);
                    }
                    colg = new ReportColumnGroup();
                    colg.setFieldKey(yearAndMonth);
                    colg.setCaption(new LocaleString(yearAndMonth));
                    colg.setTextAlign("center");
                    colg.setMerge(false);
                    children = colg.getChildren();
                }
                ReportColumn planvds = new ReportColumn();
                planvds.setCaption(new LocaleString(date));
                planvds.setWidth(new LocaleString("200px"));
                planvds.setFieldKey(date);
                planvds.setFieldType("qty");
                planvds.setMeasureUnitField("unit");
                planvds.setScale(0);
                planvds.setStyle(columnStyle);
                planvds.setHyperlink(false);
                planvds.setZeroShow(true);
                if (children != null) {
                    children.add(planvds);
                }
                ymSet.add(yearAndMonth);
            }
            if (colg != null) {
                this.setColumnGroupCaption(colg);
                cols.add(colg);
            }
        }
        threadLocalList.remove();
        return cols;
    }

    private void setColumnGroupCaption(ReportColumnGroup colg) {
        int size;
        if (colg == null) {
            return;
        }
        List children = colg.getChildren();
        if (children != null && (size = children.size()) == 1) {
            colg.setCaption(((AbstractReportColumn)children.get(0)).getCaption());
        }
    }

    private String getIds(DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return null;
        }
        String ids = dynamicObjectCollection.stream().map(p -> p.getPkValue().toString()).collect(Collectors.joining(","));
        return ids;
    }

    private Set<Object> getIdSet(DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return null;
        }
        Set<Object> idSet = dynamicObjectCollection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        return idSet;
    }
}

