/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.report.plancompare;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PlanCompareHelper {
    private static final Log logger = LogFactory.getLog(PlanCompareHelper.class);

    public static Date getMonthFirstDate(Date curdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curdate);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        cal.set(1, year);
        cal.set(2, month - 1);
        int day = 1;
        cal.set(5, day);
        return PlanCompareHelper.formatDate(cal.getTime());
    }

    public static Date getMonthEndDate(Date curdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curdate);
        int actualMaximum = cal.getActualMaximum(5);
        cal.set(5, actualMaximum);
        return PlanCompareHelper.formatDate(cal.getTime());
    }

    public static Date getWeekFirstDate(Date curdate) {
        return PlanCompareHelper.getDateWeekSeq(curdate, 2);
    }

    public static Date getWeekEndDate(Date curdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(PlanCompareHelper.getDateWeekSeq(curdate, 2));
        cal.add(5, 6);
        return PlanCompareHelper.formatDate(cal.getTime());
    }

    public static boolean isInAreaDate(Date sdate, Date edate, Date curdate) {
        return sdate.getTime() <= curdate.getTime() && edate.getTime() >= curdate.getTime();
    }

    public static Date stringToDate(String firstDay) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(firstDay);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return date;
    }

    public static Date getDateWeekSeq(Date fdate, int x) {
        int day;
        Calendar cal = Calendar.getInstance();
        cal.setTime(fdate);
        cal.setFirstDayOfWeek(1);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        day = (day = cal.get(7)) < x ? x - day - 7 : x - day;
        cal.add(5, day);
        return PlanCompareHelper.formatDate(cal.getTime());
    }

    public static Date formatDate(Date curdate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDay1 = sdf.format(curdate);
        Date date = null;
        try {
            date = sdf.parse(firstDay1);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return date;
    }

    public static String getDateString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }

    public static Map<String, String> sortMapByKey(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap<String, String> newmap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String obj1, String obj2) {
                return obj1.compareTo(obj2);
            }
        });
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            newmap.put(key, value);
        }
        return newmap;
    }

    public static Long getPhotoFidbyVerid(DynamicObject photoLogobj, Long verid) {
        Long res = 0L;
        DynamicObjectCollection entrys = photoLogobj.getDynamicObjectCollection("entryentity");
        if (entrys == null || entrys.isEmpty()) {
            return res;
        }
        for (DynamicObject item : entrys) {
            Long thisid;
            DynamicObject verobj = item.getDynamicObject("verid");
            if (verobj == null || !(thisid = (Long)verobj.getPkValue()).equals(verid)) continue;
            res = item.getLong("bkentryid");
            break;
        }
        return res;
    }
}

